/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.QueryDataAccess;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroValue;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtRptContentChecker;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.AloneBoxSelectedState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.statistics.dynamic.DefaultExtStatisticsRunner;
import com.kingdee.eas.rpts.tobi.domain.SuppliedValueProvider;
import com.kingdee.eas.rpts.tobi.param.CheckBoxValue;
import com.kingdee.eas.rpts.tobi.param.NumberStepperValue;
import com.kingdee.eas.rpts.tobi.util.BosContextUtil;
import com.kingdee.eas.rpts.web.filter.CtrlType;
import com.kingdee.eas.rpts.web.filter.DataType;
import com.kingdee.eas.rpts.web.filter.ReportParamDescription;
import com.kingdee.eas.rpts.web.filter.StateType;
import com.kingdee.eas.rpts.web.filter.impl.AbstractSimilarRowset;
import com.kingdee.eas.rpts.web.filter.impl.ParamSuppliedValueDefineBySQL;
import com.kingdee.eas.rpts.web.vo.Entry;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ExtFilterParamUtil {
    public static DataType translateDataType(DesignDataType dataType) throws BIReportException {
        switch (dataType.intValue()) {
            case 0: {
                return DataType.String;
            }
            case 1: {
                return DataType.Number;
            }
            case 2: {
                return DataType.Date;
            }
            case 3: {
                return DataType.Boolean;
            }
            case 4: {
                return DataType.DateTime;
            }
            case 5: {
                return DataType.Time;
            }
        }
        throw new BIReportException("unkown data type!");
    }

    public static StateType translateState(InputState state) throws BIReportException {
        switch (state.intValue()) {
            case 0: {
                return StateType.Standard;
            }
            case 1: {
                return StateType.ReadOnly;
            }
            case 2: {
                return StateType.Hidden;
            }
        }
        throw new BIReportException("unkown state type!");
    }

    public static void translateCtrlType(Context ctx, DesignParameter dp, ReportParamDescription param, String reportId, boolean parseDefinition, WebParamAdapter paramAdapter) throws BIReportException {
        InputType inputType = dp.getInputType();
        IInputCtrl unit = dp.getInputCtrl();
        switch (inputType.intValue()) {
            case 4: {
                if (unit == null) {
                    return;
                }
                param.setMultiSelectable(unit.isAllowMultipleSelected());
                param.setCtrlType(CtrlType.F7);
                ExtFilterParamUtil.setF7DefaultValue(dp, param);
                ExtFilterParamUtil.setSuppliedValueDescription(ctx, unit, param, reportId, paramAdapter);
                ExtFilterParamUtil.checkF7DefaultValue(ctx, reportId, param);
                break;
            }
            case 0: {
                param.setCtrlType(CtrlType.TextField);
                ExtFilterParamUtil.setParamDefaultValue(dp, param);
                break;
            }
            case 3: {
                param.setMultiSelectable(true);
                param.setCtrlType(CtrlType.CheckBoxGroup);
                ExtFilterParamUtil.setCheckBoxGroupDefaultValue(dp, param);
                ExtFilterParamUtil.setParamSuppliedValues(ctx, dp, param, reportId, paramAdapter);
                ExtFilterParamUtil.setSuppliedValueDescription(ctx, unit, param, reportId, paramAdapter);
                break;
            }
            case 1: {
                param.setCtrlType(CtrlType.ComboBox);
                ExtFilterParamUtil.setParamDefaultValue(dp, param);
                ExtFilterParamUtil.setParamSuppliedValues(ctx, dp, param, reportId, paramAdapter);
                ExtFilterParamUtil.setSuppliedValueDescription(ctx, unit, param, reportId, paramAdapter);
                break;
            }
            case 2: {
                param.setCtrlType(CtrlType.DateTime);
                String defaultValueString = CtrlReportUtil.getObjectString(dp.getDefaultValue());
                DesignDataType ddt = dp.getDesignDataType();
                defaultValueString = RunReportParam.getDateValue(ctx, ddt, defaultValueString);
                Date defaultValue = null;
                if (defaultValueString != null && !defaultValueString.trim().equals("")) {
                    try {
                        switch (ddt.intValue()) {
                            case 4: {
                                defaultValue = CtrlReportUtil.sdfDateTime.parse(defaultValueString);
                                break;
                            }
                            case 2: {
                                defaultValue = CtrlReportUtil.sdf_yyyy_MM_dd.parse(defaultValueString);
                                break;
                            }
                            case 5: {
                                defaultValue = CtrlReportUtil.sdfTime.parse(defaultValueString);
                            }
                        }
                    }
                    catch (ParseException e) {
                        defaultValue = null;
                    }
                }
                if (defaultValue == null) break;
                param.setDefaultValue(defaultValue.getTime());
                break;
            }
            case 6: {
                param.setCtrlType(CtrlType.CheckBox);
                Entry<String, String> checked = new Entry<String, String>();
                checked.setText(unit.getDefValue().getAlias());
                checked.setValue(unit.getDefValue().getName());
                Entry<String, String> unChecked = new Entry<String, String>();
                unChecked.setText(unit.getDefDisplay().getAlias());
                unChecked.setValue(unit.getDefDisplay().getName());
                CheckBoxValue aloneCheckBoxValue = new CheckBoxValue(checked, unChecked);
                param.setDefaultValue(String.valueOf(AloneBoxSelectedState.SELECTED.intValue()).equals(dp.getDefaultValue()) ? checked : unChecked);
                param.setSuppliedValue(aloneCheckBoxValue);
                break;
            }
            case 7: {
                if (unit == null) {
                    return;
                }
                param.setCtrlType(CtrlType.NumberStepper);
                String[] defines = unit.getDefValue().getFullName().substring(1).split(";");
                NumberStepperValue numberStepperValue = new NumberStepperValue(defines[1], defines[0], defines[2]);
                param.setDefaultValue(dp.getDefaultValue() == null ? Double.parseDouble(defines[1]) : Double.parseDouble(dp.getDefaultValue()));
                param.setSuppliedValue(numberStepperValue);
                break;
            }
            case 8: 
            case 9: {
                param.setCtrlType(CtrlType.UnKown);
                break;
            }
            case 10: {
                param.setCtrlType(CtrlType.LABEL);
                if (dp.getInputCtrl() == null || dp.getInputCtrl().getDefValue() == null) {
                    param.setDefaultValue("<div>     <p style=\"margin-top: 0\">\u3000</p>   </div>");
                    break;
                }
                param.setDefaultValue(dp.getInputCtrl().getDefValue().getAlias());
                break;
            }
            default: {
                throw new BIReportException("unkown ctrl type!");
            }
        }
    }

    private static void setSuppliedValueDescription(Context ctx, IInputCtrl unit, ReportParamDescription param, String reportId, WebParamAdapter paramAdapter) throws BIReportException {
        if (unit == null || unit.getDefDbsource() == null || "6".equals(unit.getDataSetType())) {
            return;
        }
        ParamSuppliedValueDefineBySQL suppliedValue = new ParamSuppliedValueDefineBySQL();
        ((AbstractSimilarRowset)suppliedValue).setReportId(reportId);
        String persisModel = unit.getDefDbsource().getName();
        switch (unit.getDataBind()) {
            case 0: 
            case 4: {
                CtrlDesignQueryModel model = null;
                try {
                    String systemid = CtrlReportUtil.getObjectString(unit.getDefDbsource().getProperty("systemID"));
                    String dsName = unit.getDefDbsource().getAlias();
                    String orgId = ExtFilterParamUtil.getOrgID(ctx, reportId, paramAdapter.getSourceRptId());
                    String innerLinkXml = paramAdapter == null ? null : (paramAdapter.getSqlDbMap() == null ? null : paramAdapter.getSqlDbMap().get(dsName + "#" + systemid));
                    model = KSQLReportBO.initModel(ctx, systemid, dsName, orgId, persisModel, innerLinkXml);
                }
                catch (CtrlReportException systemid) {
                    // empty catch block
                }
                if (model != null) {
                    persisModel = ExtFilterParamUtil.getModelXml(ctx, model);
                    List source = model.getCommonQuery().getParameters();
                    ArrayList<String> paramNames = new ArrayList<String>();
                    if (source != null && !source.isEmpty()) {
                        for (DesignParameter dp : source) {
                            paramNames.add(dp.getName());
                        }
                    }
                    param.setParamNames(paramNames);
                    ExtFilterParamUtil.setVariant(suppliedValue, unit, param, 4, persisModel);
                    try {
                        param.setSuppliedValueOrgRelated(ExtRptContentChecker.needMoreCopy(CtrlDesignQueryModel.makeSQL(ctx, model))[1]);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                String dbSourceName = unit.getDefDbsource().getAlias();
                String msg = "";
                String msg3 = "";
                switch (unit.getDataBind()) {
                    case 4: {
                        msg = "\u627e\u4e0d\u5230F7\u6570\u636e\u96c6";
                        msg3 = "3\u3001F7\u6570\u636e\u6e90\u4e0e\u5f53\u524d\u6570\u636e\u6e90\u521b\u5efa\u7ec4\u7ec7\u4e0d\u4e00\u81f4";
                        break;
                    }
                    default: {
                        msg = "\u627e\u4e0d\u5230\u6570\u636e\u96c6";
                        msg3 = "3\u3001\u6570\u636e\u6e90\u4e0e\u5f53\u524d\u6570\u636e\u6e90\u521b\u5efa\u7ec4\u7ec7\u4e0d\u4e00\u81f4";
                    }
                }
                String msg0 = MessageUtil.getMsgInfo("label277");
                String msg1 = MessageUtil.getMsgInfo("label272");
                String msg2 = MessageUtil.getMsgInfo("label273");
                String msg4 = MessageUtil.getMsgInfo("label275");
                String msg5 = MessageUtil.getMsgInfo("label282");
                String msge = "\u8bf7\u91cd\u65b0\u5728SQL\u8bbe\u8ba1\u5668\u8bbe\u7f6e\u6570\u636e\u6e90\uff01";
                StringBuffer sb = new StringBuffer();
                sb.append(msg).append("\uff1a").append(dbSourceName).append("\r\n").append(msg0).append("\r\n");
                sb.append(msg1).append("\r\n").append(msg2).append("\r\n").append(msg3).append("\r\n").append(msg4).append("\r\n").append(msg5).append("\r\n").append(msge);
                throw new BIReportException(sb.toString());
            }
            case 6: {
                param.setSuppliedValueOrgRelated(true);
                ExtFilterParamUtil.setVariant(suppliedValue, unit, param, 6, persisModel);
                break;
            }
            case 3: {
                ExtFilterParamUtil.setVariant(suppliedValue, unit, param, 3, persisModel);
                break;
            }
            case 5: {
                ExtFilterParamUtil.setVariant(suppliedValue, unit, param, 5, persisModel);
                break;
            }
            case 7: {
                ExtFilterParamUtil.setVariant(suppliedValue, unit, param, 7, persisModel);
            }
        }
    }

    private static String getModelXml(Context easCtx, CtrlDesignQueryModel model) {
        Element xml = CtrlDesignUtil.toXml(easCtx, model.getCommonQuery(), model.getQuery());
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        String xmlstr = outter.outputString(xml);
        return xmlstr;
    }

    private static void setVariant(AbstractSimilarRowset v, IInputCtrl unit, ReportParamDescription param, int type, String persisModel) {
        v.setPersistenceModel(persisModel);
        v.setDataSourceType(type);
        v.setTextFieldName(unit.getDefDisplay().getName());
        v.setValueFieldName(unit.getDefValue().getName());
        param.setSuppliedValueDescription(v);
    }

    public static void setParamSuppliedValues(Context ctx, DesignParameter dp, ReportParamDescription param, String reportId, WebParamAdapter paramAdapter) throws BIReportException {
        SuppliedValueProvider suppliedValueProvider;
        String orgId = paramAdapter.getSourceRptId();
        orgId = ExtFilterParamUtil.getOrgID(ctx, reportId, orgId);
        HashMap sqlDbMap = paramAdapter.getSqlDbMap();
        HashMap<String, DesignParameter> srcParams = new HashMap<String, DesignParameter>();
        ArrayList params = paramAdapter.getAllUnionParam();
        if (params != null) {
            for (Object p : params) {
                DesignParameter dp2 = (DesignParameter)((Object)p);
                srcParams.put(dp2.getName(), dp2);
            }
        }
        if ((suppliedValueProvider = new SuppliedValueProvider(ctx, dp, orgId, sqlDbMap, reportId, srcParams)) != null) {
            param.setSuppliedValue(suppliedValueProvider.getSuppliedValues());
        }
    }

    private static void setParamDefaultValue(DesignParameter dp, ReportParamDescription param) {
        Entry<String, String> defaultValue = new Entry<String, String>();
        defaultValue.setValue(dp.getDefaultValue());
        defaultValue.setText(dp.getDefaultAlias());
        param.setDefaultValue(defaultValue);
    }

    private static void setF7DefaultValue(DesignParameter dp, ReportParamDescription param) {
        ArrayList defaultValue = new ArrayList();
        if (dp.getDefaultValue() != null) {
            String[] arrValue = dp.getDefaultValue().split("0xx1xx");
            String[] arrAlias = dp.getDefaultAlias().split("0xx1xx");
            for (int i = 0; i < arrValue.length; ++i) {
                Entry<String, String> entry = new Entry<String, String>();
                entry.setValue(arrValue[i]);
                entry.setText(arrAlias[i]);
                defaultValue.add(entry);
            }
        }
        param.setDefaultValue(defaultValue);
    }

    private static void setCheckBoxGroupDefaultValue(DesignParameter dp, ReportParamDescription param) {
        ExtFilterParamUtil.setF7DefaultValue(dp, param);
    }

    public static ArrayList getF7SuppliedValue(Context ctx, String reportId, String xmlContent, String textName, String valueName, int dataSourceType, Map<String, Object> paramMap) throws BIReportException {
        CtrlDesignQueryModel ctrlDesignQueryModel = null;
        IRowSet rs = null;
        ArrayList lst = null;
        switch (dataSourceType) {
            case 4: {
                try {
                    ctrlDesignQueryModel = KSQLReportBO.initModelFromXml(xmlContent);
                    HashMap mapDesignParameter = RunReportParam.getParamDefalutValue(ctx, ctrlDesignQueryModel);
                    if (paramMap != null) {
                        for (String key : paramMap.keySet()) {
                            if (!mapDesignParameter.containsKey(key)) continue;
                            DesignParameter parameter = (DesignParameter)((Object)mapDesignParameter.get(key));
                            Object value = paramMap.get(key);
                            if (!(value instanceof String)) continue;
                            parameter.setCurentValue((String)value);
                        }
                    }
                    HashMap mapResult = CtrlDesignDataExecutor.execute(ctx, ctrlDesignQueryModel, mapDesignParameter, null, 0, -1, true, null);
                    rs = (IRowSet)mapResult.get("6xx8xxRowset");
                    lst = ExtDBUtil.setDataToList((ResultSet)rs);
                    break;
                }
                catch (Exception e) {
                    throw new BIReportException((Throwable)e);
                }
            }
            case 3: {
                MetaDataPK queryPK = MetaDataPK.create((String)xmlContent);
                try {
                    if (ctx != null) {
                        QueryExecuteOption option = new QueryExecuteOption();
                        option.isAutoIgnoreZero = false;
                        rs = new QueryDataAccess(ctx).getRowSet((IMetaDataPK)queryPK, new EntityViewInfo(), null, option, 0, Integer.MAX_VALUE);
                    } else {
                        IQueryExecutor queryExecutor = BosHelper.createQueryExecutor((MetaDataPK)queryPK, (Context)ctx);
                        queryExecutor.option().isAutoIgnoreZero = false;
                        rs = queryExecutor.executeQuery();
                    }
                    lst = ExtDBUtil.setDataToList((ResultSet)rs);
                    break;
                }
                catch (Exception e1) {
                    throw new BIReportException((Throwable)e1);
                }
            }
            case 6: {
                int systemVarType = Integer.valueOf(xmlContent);
                String userId = BosContextUtil.getCurrentUserId(ctx);
                lst = OrgRangeManage.getOrgRangeList(ctx, userId, systemVarType, reportId);
                break;
            }
            case 5: {
                throw new BIReportException("portal\u4e0d\u652f\u6301\u4ee3\u7801\u5b9a\u5236F7");
            }
            case 7: {
                MacroValue mv;
                try {
                    mv = ctx == null ? ExtRptMacroExecuteFacade.remoteExecute(DefaultExtStatisticsRunner.loadUsedMacros(ctx, reportId), xmlContent) : ExtRptMacroExecuteFacade.localExecute(ctx, DefaultExtStatisticsRunner.loadUsedMacros(ctx, reportId), xmlContent);
                }
                catch (MacroRuntimeException e) {
                    throw new BIReportException("\u6267\u884c\u5b8f\u5931\u8d25\u3010$" + xmlContent + "\u3011");
                }
                lst = new ArrayList();
                for (int i = 0; i < mv.getValues().length; ++i) {
                    HashMap<String, Variant> map = new HashMap<String, Variant>();
                    for (int j = 0; j < mv.getColums().length; ++j) {
                        map.put(mv.getColums()[j].toLowerCase(), mv.getValues()[i][j]);
                    }
                    lst.add(map);
                }
                break;
            }
        }
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst;
    }

    private static void checkF7DefaultValue(Context ctx, String reportId, ReportParamDescription param) throws BIReportException {
        AbstractSimilarRowset suppliedValueDesc = (AbstractSimilarRowset)param.getSuppliedValueDescription();
        String xmlContent = suppliedValueDesc.getPersistenceModel();
        String textName = suppliedValueDesc.getTextFieldName();
        String valueName = suppliedValueDesc.getValueFieldName();
        int dataSourceType = suppliedValueDesc.getDataSourceType();
        List defaultValueList = (List)param.getDefaultValue();
        if (defaultValueList.isEmpty()) {
            return;
        }
        ArrayList lst = ExtFilterParamUtil.getF7SuppliedValue(ctx, reportId, xmlContent, textName, valueName, dataSourceType, new HashMap<String, Object>());
        if (lst == null) {
            defaultValueList.clear();
            return;
        }
        ArrayList<Entry> defaultRemove = new ArrayList<Entry>();
        Iterator itDefault = defaultValueList.iterator();
        while (itDefault.hasNext()) {
            boolean isFindDefault = false;
            Entry defaultValue = (Entry)itDefault.next();
            for (HashMap mapitem : lst) {
                String itemValue = CtrlReportUtil.getObjectString(mapitem.get(valueName.toLowerCase()));
                if (!((String)defaultValue.getValue()).equals(itemValue)) continue;
                isFindDefault = true;
                defaultValue.setText(mapitem.get(textName.toLowerCase()).toString());
                break;
            }
            if (isFindDefault) continue;
            defaultRemove.add(defaultValue);
        }
        defaultValueList.removeAll(defaultRemove);
    }

    private static String getOrgID(Context ctx, String reportId, String orgId) throws BIReportException {
        if (StringUtil.isEmptyString((String)reportId) || !StringUtil.isEmptyString((String)orgId)) {
            return orgId;
        }
        DefineReportInfo info = null;
        String sourceReportOrgID = null;
        try {
            info = DefineReportBO.getReportInfo(ctx, reportId);
            if (info != null) {
                sourceReportOrgID = info.getOrgID().toString();
            }
        }
        catch (BOSException be) {
            be.printStackTrace();
        }
        return StringUtils.isEmpty(sourceReportOrgID) ? BosContextUtil.getClientCurrentOrgId() : sourceReportOrgID;
    }

    public static List<Map<String, String>> translateLongNumberTreeType(List<Map<String, String>> rowList, String longnumbeName, String nodeSeparator, String currentNodeIdName, String parentNodeIdName) {
        if (rowList == null) {
            return null;
        }
        longnumbeName = longnumbeName.toLowerCase();
        currentNodeIdName = currentNodeIdName.toLowerCase();
        parentNodeIdName = parentNodeIdName.toLowerCase();
        for (Map<String, String> map : rowList) {
            String longNumber = CtrlReportUtil.getObjectString(map.get(longnumbeName));
            map.put(currentNodeIdName, longNumber);
            int lastIndex = longNumber.lastIndexOf(nodeSeparator);
            if (longNumber.lastIndexOf(nodeSeparator) < 0) {
                map.put(parentNodeIdName, "");
                continue;
            }
            String parentLongNumber = longNumber.substring(0, lastIndex);
            map.put(parentNodeIdName, parentLongNumber);
        }
        return rowList;
    }
}

