/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.bhv;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.rpts.web.bhv.OutputSheetBhv;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.param.CreateSheet;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.util.ReportBookHelper;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import com.kingdee.eas.rpts.web.vo.SheetInfo;
import java.util.List;

public class OutputReportBhv {
    public ReportInfo behaviour(ReportImpl report) {
        int rate;
        Book book = report.getBook();
        String currentSheetName = report.getCurrentSheetName();
        OutputSheetBhv outPutSheetBhv = BeanFactory.outputSheetBhv();
        CreateSheet sheetJson = CreateSheet.instance();
        sheetJson.setSheetName(currentSheetName);
        SheetInfo sheetInfo = outPutSheetBhv.behaviour(report, sheetJson);
        ReportInfo reportInfo = new ReportInfo();
        List<String> sheetNameList = ReportBookHelper.collectSheetsInfo(book);
        reportInfo.setSheetNameList(sheetNameList);
        List<String> sheetColorList = ReportBookHelper.collectSheetsColor(book);
        reportInfo.setSheetColorList(sheetColorList);
        reportInfo.setPageId(report.getPageId());
        reportInfo.setCurrentSheet(sheetInfo);
        Object refreshRate = book.getUserObjectValue("PortalAutoRefresh");
        if (refreshRate != null && (rate = this.convertToMillisecond((String)refreshRate)) > 0) {
            reportInfo.setRefreshRate(rate);
        }
        if (report.isbMobile()) {
            for (int i = 0; i < sheetNameList.size(); ++i) {
                sheetJson.setSheetName(sheetNameList.get(i));
                sheetInfo = outPutSheetBhv.behaviour(report, sheetJson);
                reportInfo.addSheetInfo(sheetInfo);
            }
            reportInfo.setTreeDisplayMode((String)book.getUserObjectValue("MobileReportTreeDisplayMode"));
            Object oZoom = book.getUserObjectValue("MobileReportClickZoom");
            if (oZoom != null) {
                reportInfo.setClickZoom(Boolean.valueOf((String)oZoom));
            }
        }
        return reportInfo;
    }

    private int convertToMillisecond(String data) {
        if (StringUtil.isEmptyString((String)data)) {
            return 0;
        }
        char unit = data.charAt(data.length() - 1);
        switch (unit) {
            case 'H': {
                return (int)(Float.valueOf(data.substring(0, data.length() - 1)).floatValue() * 60.0f * 60.0f * 1000.0f);
            }
            case 'M': {
                return (int)(Float.valueOf(data.substring(0, data.length() - 1)).floatValue() * 60.0f * 1000.0f);
            }
            case 'S': {
                return (int)(Float.valueOf(data.substring(0, data.length() - 1)).floatValue() * 1000.0f);
            }
        }
        throw new RuntimeException("illegal time unit!");
    }
}

