/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.man;

import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.eas.rpts.web.man.ISheet;
import com.kingdee.eas.rpts.web.man.ITable;
import java.util.ArrayList;
import java.util.List;

public class SheetImpl
implements ITable,
ISheet {
    private String sheetName;
    private int startRow;
    private int endRow;
    private int perNum = 200;
    private int rowCount;
    private int colCount;
    private boolean isTree;
    private boolean isHor;
    private int treePos;
    private SortedAttributeSpanArray items;
    private String fileSavePath;
    private String filePrefixPath = "";
    private List<Cell> diagonalCells;
    public static final int NODETYPE_EXTEND = 0;
    public static final int NODETYPE_COLLAPSE = 1;

    public SheetImpl(Sheet sheet, int perNum) {
        UserObject colTreePos = sheet.getUserObject("COLUMN_INLINED_TREE_POSITION");
        UserObject rowTreePos = sheet.getUserObject("ROW_INLINED_TREE_POSITION");
        if (colTreePos != null ^ rowTreePos != null) {
            this.isTree = true;
            this.isHor = colTreePos == null;
            UserObject obj = colTreePos != null ? colTreePos : rowTreePos;
            this.treePos = Integer.parseInt(obj.getValue().toString());
            this.items = this.isHor ? sheet.getColSpans() : sheet.getRowSpans();
        }
        this.sheetName = sheet.getSheetName();
        this.perNum = perNum;
    }

    public boolean isTree() {
        return this.isTree;
    }

    public void setTree(boolean isTree) {
        this.isTree = isTree;
    }

    public boolean isHor() {
        return this.isHor;
    }

    public void setHor(boolean isHor) {
        this.isHor = isHor;
    }

    public void setFileSavePath(String fileSavePath) {
        this.fileSavePath = fileSavePath;
    }

    public String getFileSavePath() {
        return this.fileSavePath;
    }

    public void setFilePrefixPath(String filePrefixPath) {
        this.filePrefixPath = filePrefixPath;
    }

    public String getFilePrefixPath() {
        return this.filePrefixPath;
    }

    public int getTreePos() {
        return this.treePos;
    }

    public void setTreePos(int treePos) {
        this.treePos = treePos;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    @Override
    public int getStartRow() {
        return this.startRow;
    }

    @Override
    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    @Override
    public int getEndRow() {
        return this.endRow;
    }

    @Override
    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void setColCount(int colCount) {
        this.colCount = colCount;
    }

    @Override
    public int getColCount() {
        return this.colCount;
    }

    @Override
    public void setPerNum(int perNum) {
        this.perNum = perNum;
    }

    @Override
    public int getPerNum() {
        return this.perNum;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public List<Cell> getDiagonalCells() {
        return this.diagonalCells;
    }

    public void setDiagonalCells(List<Cell> diagonalCells) {
        this.diagonalCells = diagonalCells;
    }

    public void addDiagonalCell(Cell cell) {
        if (this.diagonalCells == null) {
            this.diagonalCells = new ArrayList<Cell>();
        }
        this.getDiagonalCells().add(cell);
    }

    public boolean isHorizonTree() {
        return this.isTree && this.isHor;
    }

    public int[] displayType(int position) {
        SortedAttributeSpanArray.AttributeSpan nextSpan;
        int nextIdx;
        int[] type = new int[3];
        int index = this.items.searchSpan(position);
        if (index < 0) {
            return type;
        }
        SortedAttributeSpanArray.AttributeSpan span = this.items.getAttributeSpan(index);
        if (null != span) {
            type[0] = span.isCollapse() ? 1 : 0;
            type[1] = span.getOutlineGroupLevel();
        }
        type[2] = (nextIdx = this.items.searchSpan(position + 1)) < 0 ? 0 : ((nextSpan = this.items.getAttributeSpan(nextIdx)) != null && !nextSpan.isVisible() && type[1] < nextSpan.getOutlineGroupLevel() ? 1 : 0);
        return type;
    }
}

