/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ext.Browser;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.immit.ReportProperties;
import com.kingdee.bos.ctrl.ext.rd.celltree.TreeCellUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.exec.ChartInnerLinkExec;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.bos.ctrl.kds.io.htm.serial.Variant2String;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Border;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureCollection;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureFactory;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureInfo;
import com.kingdee.bos.webframework.dynamic.IDynamicConfigure;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.tobi.HyperLinkHelper;
import com.kingdee.eas.rpts.web.filter.DataType;
import com.kingdee.eas.rpts.web.man.SheetImpl;
import com.kingdee.eas.rpts.web.model.BorderStyle;
import com.kingdee.eas.rpts.web.model.CellModel;
import com.kingdee.eas.rpts.web.model.CellTree;
import com.kingdee.eas.rpts.web.model.Diagonal;
import com.kingdee.eas.rpts.web.model.HyperLink;
import com.kingdee.eas.rpts.web.model.ParamValue;
import com.kingdee.eas.rpts.web.util.StyleToCss;
import com.kingdee.eas.rpts.web.vo.TableInfo;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportBookHelper {
    private static Logger log = LogUtil.getPackageLogger(ReportBookHelper.class);

    public static List<String> collectSheetsInfo(Book book) {
        Sheet sheet = null;
        int count = book.getSheetCount();
        ArrayList<String> sheetList = new ArrayList<String>(count);
        for (int index = 0; index < count; ++index) {
            sheet = book.getSheet(index);
            if (null == sheet || sheet.isHide()) continue;
            sheetList.add(sheet.getSheetName());
        }
        return sheetList;
    }

    public static List<String> collectSheetsColor(Book book) {
        Sheet sheet = null;
        int count = book.getSheetCount();
        ArrayList<String> colorList = new ArrayList<String>(count);
        for (int index = 0; index < count; ++index) {
            sheet = book.getSheet(index);
            if (null == sheet || sheet.isHide()) continue;
            Color color = sheet.getTabColor();
            if (color != null) {
                colorList.add(StyleParser.colorToHex((Color)color));
                continue;
            }
            colorList.add("");
        }
        return colorList;
    }

    public static HyperlinkCalculableProps getHyperLink(Cell cell) {
        ExtProps ep = cell.getExtProps(false);
        if (ep == null) {
            return null;
        }
        SortedExtPropFormulasArray formulas = ep.getFormulas(false);
        if (formulas == null) {
            return null;
        }
        ICalculableProps prop = formulas.get(ExtConst.FORMULA_HYPERLINK);
        if (prop == null) {
            return null;
        }
        return (HyperlinkCalculableProps)prop;
    }

    public static List<CellModel> buildCell(Row row, int colCount, SheetImpl sheetModel, TableInfo tableModel, Context ctx, Sheet sheet) {
        ArrayList<CellModel> cellList = new ArrayList<CellModel>();
        for (int i = 0; i < colCount; ++i) {
            DiagonalHeader dh;
            CellModel cell;
            Cell bookCell = row.getCell(i, false);
            if (bookCell == null) {
                cell = new CellModel();
                Style s = row.getSheet().getCellDisplayStyle(row.getRow(), i);
                if (s == null || s.isEmpty()) continue;
                cell.setStyle(StyleToCss.getCssStyle(s));
                cell.setBorder(StyleToCss.getCssBorder(s));
                cell.setCol(i);
                cellList.add(cell);
                cell.setValue("");
                continue;
            }
            cell = new CellModel();
            HyperlinkCalculableProps hyperLinkCalProps = ReportBookHelper.getHyperLink(bookCell);
            if (hyperLinkCalProps != null && bookCell.getStyle().isUnderline()) {
                InnerLinkTargets innerTars;
                ExternalTargets extTars;
                ArrayList names = new ArrayList();
                HashMap tars = hyperLinkCalProps.getTargets();
                ETTargets repTars = (ETTargets)tars.get("EXTRPT");
                if (repTars != null) {
                    ReportBookHelper.buildRptHyperlink(ctx, repTars, bookCell, cell);
                }
                if ((extTars = (ExternalTargets)tars.get("EASBILL")) != null) {
                    ReportBookHelper.buildExtHyperlink(extTars, bookCell, cell, ctx);
                }
                if ((innerTars = (InnerLinkTargets)tars.get("EXT_INNER")) != null) {
                    ReportBookHelper.buildInnerLink(innerTars, bookCell, cell);
                }
            } else if (bookCell.getHyperLink() != null) {
                String linkTo = bookCell.getHyperLink().getLinkTo();
                int start = linkTo.indexOf("#");
                int end = linkTo.indexOf("!");
                if (start >= 0 && end >= 0) {
                    String linkStr = linkTo.substring(start + 1, end);
                    if (null != linkStr && linkStr.startsWith("'")) {
                        linkStr = linkStr.replaceAll("'", "");
                    }
                    cell.setLinkTo(linkStr);
                } else if (start >= 0 && end < 0) {
                    String nameLink = ReportBookHelper.buildNameHyperlink(sheet, linkTo.substring(start + 1));
                    cell.setLinkTo(nameLink);
                }
                if (linkTo.startsWith("callTo:")) {
                    cell.setLinkTo(linkTo);
                }
            }
            if (sheetModel.isTree()) {
                CellTree cellTree = ReportBookHelper.buildCellTree(bookCell, sheetModel);
                cell.setCellTree(cellTree);
            }
            if ((dh = bookCell.getDiagonalHeader()) != null) {
                if (Browser.browserBelowIE9()) {
                    sheetModel.addDiagonalCell(bookCell);
                } else {
                    Diagonal dg = new Diagonal();
                    dg.setCrossColSum(dh.getCol2() - dh.getCol());
                    dg.setCrossRowSum(dh.getRow2() - dh.getRow());
                    dg.setLinkToCols(dh.getColOffs());
                    dg.setLinkToRows(dh.getRowOffs());
                    for (int j = 0; j < dh.size(); ++j) {
                        TriangleInfo tInfo = dh.getTriangleInfo(j);
                        Diagonal.Triangle ta = dg.new Diagonal.Triangle();
                        ta.setText(tInfo.getText());
                        ta.setLean(tInfo.isLean());
                        Style style = tInfo.getStyle();
                        if (style != null) {
                            ta.setStyle(StyleToCss.getCssStyle(style));
                            BorderStyle bStyle = StyleToCss.getCssBorder(style);
                            ta.setSlashStyle(bStyle.getLeft());
                        }
                        dg.addTriangle(ta);
                    }
                    cell.setDiagonal(dg);
                }
            } else {
                cell.setValue(bookCell.getText());
            }
            cell.setStyle(StyleToCss.getCssStyle(bookCell.getDisplayStyle()));
            CellBlock mergeBlock = bookCell.getMerge(true);
            if (mergeBlock != null && !bookCell.isExtendMerge()) {
                cell.setBorder(StyleToCss.getCssBorder(ReportBookHelper.getMergeBlockBorderStyle(bookCell, mergeBlock)));
            } else {
                cell.setBorder(StyleToCss.getCssBorder(bookCell.getStyle()));
            }
            cell.setCol(i);
            cellList.add(cell);
        }
        return cellList;
    }

    private static String buildNameHyperlink(Sheet sheet, String name) {
        Cell firstCell;
        StringBuilder rangeSite = new StringBuilder();
        SortedNamedObjectNodeArray sona = sheet.getNames();
        NamedObjectNode node = sona.searchByName(name);
        Range refersToRange = null;
        if (node != null) {
            refersToRange = node.getRefersToRange();
        } else {
            SortedNamedObjectNodeArray sn = sheet.getBook().getNames();
            node = sn.searchByName(name);
            if (node != null) {
                refersToRange = node.getRefersToRange();
            }
        }
        if (refersToRange != null && (firstCell = refersToRange.getFirstCell()) != null) {
            rangeSite.append(firstCell.getSheet().getSheetName());
        }
        return rangeSite.toString();
    }

    private static void buildRptHyperlink(Context ctx, ETTargets repTars, Cell bookCell, CellModel cell) {
        ChartDataItemInfo dataItemInfo = null;
        List<HyperLink> links = ReportBookHelper.buildRptHyperlink(ctx, repTars, bookCell, dataItemInfo);
        cell.addHyperLink(links);
    }

    public static List<HyperLink> buildRptHyperlink(Context ctx, ETTargets repTars, Cell bookCell, ChartDataItemInfo dataItemInfo) {
        ArrayList<HyperLink> links = new ArrayList<HyperLink>();
        List targets = repTars.getTargets();
        ExtProps ep = bookCell.getExtProps(false);
        for (ExtTransitionTarget target : targets) {
            Object obj = ep.executeCalculableProps(target.getReportProps().getCalculableProps());
            if (obj != null) {
                target.getReportProps().setAlias(obj.toString());
            }
            String reportId = target.getReportProps().getId();
            String reportName = target.getReportProps().getName();
            String systemId = target.getReportProps().getPath();
            String alias = target.getReportProps().getAlias();
            String domain = target.getReportProps().getDomain();
            boolean isDefault = repTars.getDefaultTarget() == target;
            ArrayList<ParamValue> paramValues = new ArrayList<ParamValue>();
            String snapshotHyperlink = (String)bookCell.getUserObjectValue("EXT_HYPERLINK_TARGET_VALUE");
            Map params = null;
            params = target.getParameters();
            if (!StringUtil.isEmptyString((String)snapshotHyperlink)) {
                params = (Map)params.get("path" + target.getReportProps().getPath() + "name" + target.getReportProps().getId());
            } else {
                ep.executeParams(params);
                ReportBookHelper.executeParamsDefaultValue(ctx, params, null, target.getReportProps());
                ChartInnerLinkExec.executeChartParams((Map)params, (ChartDataItemInfo)dataItemInfo);
            }
            Iterator paramIter = params.keySet().iterator();
            while (paramIter.hasNext()) {
                ParamValue paramValue = new ParamValue();
                String key = paramIter.next().toString();
                ParameterImpl param = (ParameterImpl)params.get(key);
                DataType dataTypeEnum = DataType.get(param.getDataType());
                String dataType = dataTypeEnum.name().toLowerCase();
                paramValue.setDataType(dataType);
                paramValue.setName(param.getName());
                paramValue.setAlias(param.getAlias());
                Variant vt = param.getValue();
                Date date = null;
                if (vt != null && vt.getVt() == 13) {
                    date = Variant.calendarToGMTDate((Calendar)((GregorianCalendar)vt.getValue()));
                } else if (vt != null && vt.getVt() == 12) {
                    date = (Date)vt.getValue();
                }
                if (date != null) {
                    switch (dataTypeEnum) {
                        case DateTime: {
                            paramValue.setValues(CtrlReportUtil.sdfDateTime.format(date));
                            break;
                        }
                        case Date: {
                            paramValue.setValues(CtrlReportUtil.sdf_yyyy_MM_dd.format(date));
                            break;
                        }
                        case Time: {
                            paramValue.setValues(CtrlReportUtil.sdfTime.format(date));
                        }
                    }
                } else {
                    paramValue.setValues(Variant2String.toString((Variant)vt));
                }
                paramValues.add(paramValue);
            }
            HyperLink hyperLink = new HyperLink();
            hyperLink.setReportId(reportId);
            hyperLink.setReportName(reportName);
            hyperLink.setReportAlias(alias);
            hyperLink.setSystemId(systemId);
            hyperLink.setDomain(domain);
            hyperLink.setDefaultLink(isDefault);
            hyperLink.setParamValues(paramValues);
            links.add(hyperLink);
        }
        return links;
    }

    private static List getAllUnionParam(Context ctx, ReportProperties rptpros) {
        if (rptpros == null) {
            return null;
        }
        String reportId = rptpros.getId();
        String reportName = rptpros.getName();
        String systemId = rptpros.getPath();
        String domain = rptpros.getDomain();
        WebParamAdapter adapter = null;
        adapter = systemId != null ? new WebParamAdapter(ctx, reportName, systemId, domain, reportId) : new WebParamAdapter(ctx, reportId);
        adapter.setHyperlink(true);
        adapter.setLicenseChecked(true);
        try {
            adapter.cacheDbSourceModel(true);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return adapter.getAllUnionParam();
    }

    public static void executeParamsDefaultValue(Context ctx, Map params, List allUnionParam, ReportProperties rptpros) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Object errorData;
            IParameter param = (IParameter)i.next().getValue();
            Variant var = param.getValue();
            if (var == null || var == Variant.nullVariant) continue;
            Object value = var.getValue();
            try {
                if (!var.isError() && value instanceof String && ((String)value).toUpperCase().indexOf("@OriginalDefaultValue".toUpperCase()) >= 0) {
                    SyntaxErrorException e = new SyntaxErrorException(131072L, (Object)"@OriginalDefaultValue");
                    var.setObject((Object)e, 16);
                    value = var.getValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!var.isError() || !((errorData = ((SyntaxErrorException)((Object)value)).getExtData()) instanceof String) || !"@OriginalDefaultValue".equalsIgnoreCase((String)errorData)) continue;
            if (allUnionParam == null && rptpros != null && ((allUnionParam = ReportBookHelper.getAllUnionParam(ctx, rptpros)) == null || allUnionParam.isEmpty())) {
                return;
            }
            DesignParameter dp2 = null;
            for (DesignParameter dp2 : allUnionParam) {
                if (dp2.getName().equals(param.getName())) {
                    var = RunReportParam.getVariant(dp2.getDefaultValue(), dp2.getDesignDataType().intValue());
                    param.setValue(var);
                    continue;
                }
                if (!(dp2.getName() + "_text").equals(param.getName())) continue;
                var = RunReportParam.getVariant(dp2.getDefaultAlias(), dp2.getDesignDataType().intValue());
                param.setValue(var);
            }
        }
    }

    private static void buildExtHyperlink(ExternalTargets extTars, Cell bookCell, CellModel cell, Context ctx) {
        ArrayList<HyperLink> links = new ArrayList<HyperLink>();
        String name = null;
        String url = null;
        String uiType = "easeditui";
        HyperLinkHelper linkHelper = new HyperLinkHelper(ctx);
        List targets = extTars.getAllAssembledTargets();
        Iterator iter = targets.iterator();
        ArrayList targetsParams = new ArrayList(targets.size());
        while (iter.hasNext()) {
            String operateState = OprtState.VIEW;
            ArrayList<String> idList = new ArrayList<String>();
            HashMap attributes = (HashMap)((HashMap)iter.next()).clone();
            String prefix = (String)attributes.get("HYPERLINK_PREFIX");
            if ("JAVA_JUMPER:".equals(prefix)) continue;
            if ("EAS_UI:".equals(prefix)) {
                ArrayList idListO = new ArrayList();
                CommonCalculableProps[] props = (CommonCalculableProps[])attributes.get("ID_LIST");
                int size = props.length;
                for (int i = 0; i < size; ++i) {
                    idListO.addAll(linkHelper.executeCalculableProps(bookCell, props[i]));
                }
                Iterator idIter = idListO.iterator();
                while (idIter.hasNext()) {
                    idList.add(idIter.next().toString());
                }
                if (idList.isEmpty()) continue;
                operateState = Boolean.TRUE.toString().equals(attributes.get("UI_READ_ONLY")) ? OprtState.VIEW : OprtState.EDIT;
                uiType = attributes.get("UI_TYPE").toString();
                url = ReportBookHelper.getDynamicUrl(ctx, uiType, (String)idList.get(0), operateState);
                if (StringUtil.isEmptyString((String)url)) {
                    Object[] results = linkHelper.getUrl(attributes, bookCell, idList);
                    url = (String)results[0];
                }
                if (StringUtil.isEmptyString((String)url)) continue;
            }
            name = (String)attributes.get("DISPLAY_NAME");
            uiType = uiType.equalsIgnoreCase("listui") ? "easlistui" : "easeditui";
            boolean isDefault = false;
            Object default_suggestion = attributes.get("DEFAULT_SUGGESTION");
            if (default_suggestion != null) {
                isDefault = "true".equalsIgnoreCase(default_suggestion.toString());
            }
            HyperLink hyperLink = new HyperLink();
            hyperLink.setReportName(name);
            hyperLink.setUrl(url);
            hyperLink.setUiType(uiType);
            hyperLink.setIdList(idList);
            hyperLink.setDefaultLink(isDefault);
            hyperLink.setOperateState(operateState);
            links.add(hyperLink);
        }
        cell.addExtHyperLink(links);
    }

    private static void buildInnerLink(InnerLinkTargets innerTars, Cell bookCell, CellModel cell) {
        List targets = innerTars.getTargets();
        if (targets != null && !targets.isEmpty()) {
            cell.addInnerLink(bookCell.getName(false, true));
        }
    }

    private static String getDynamicUrl(Context ctx, String uiType, String id, String operateState) {
        try {
            BOSObjectType bostype = BOSUuid.read((String)id).getType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entityInfo = loader.getEntity(bostype);
            String entityName = entityInfo.getFullName();
            String pageType = operateState;
            boolean isListUI = uiType.equalsIgnoreCase("listui");
            if (isListUI) {
                pageType = "list";
            }
            IDynamicConfigure iApp = DynamicConfigureFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("pageType", (Object)pageType.toLowerCase(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("entityObjectName", (Object)entityName, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)1, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            DynamicConfigureCollection appCollection = iApp.getDynamicConfigureCollection(entityViewInfo);
            DynamicConfigureInfo sInfo = appCollection.get(0);
            if (sInfo == null) {
                return null;
            }
            String uipk = sInfo.getWebUIObjectName();
            if (isListUI) {
                return "/dynamicList.do?event=initialize&method=initalize&uipk=" + uipk;
            }
            return "/dynamicForm.do?event=initialize&method=initalize&uipk=" + uipk;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static CellTree buildCellTree(Cell cell, SheetImpl sheet) {
        int[] type;
        CellTree cellTree = new CellTree();
        cellTree.setHorizontal(sheet.isHorizonTree());
        if (sheet.isHorizonTree() && cell.getRow() == sheet.getTreePos()) {
            type = sheet.displayType(cell.getCol());
        } else if (cell.getCol() == sheet.getTreePos() && TreeCellUtil.queryCellType((Cell)cell) != null) {
            type = sheet.displayType(cell.getRow());
        } else {
            return null;
        }
        cellTree.setLevel(type[1]);
        if (type[0] == 0) {
            cellTree.setExpanded(true);
        } else {
            cellTree.setExpanded(false);
        }
        if (type[2] == 1) {
            cellTree.setHaveHandler(true);
        } else {
            cellTree.setHaveHandler(false);
        }
        return cellTree;
    }

    private static Style getMergeBlockBorderStyle(Cell cell, CellBlock mergeBlock) {
        StyleAttributes sa = Styles.getEmptySA();
        Sheet sheet = cell.getSheet();
        Borders borders = sheet.getBorders();
        Border leftBorder = borders.getCellBorder(mergeBlock.getRow(), mergeBlock.getCol() - 1, true);
        boolean leftSame = true;
        for (int j = mergeBlock.getRow() + 1; j <= mergeBlock.getRow2(); ++j) {
            if (leftBorder == borders.getCellBorder(j, mergeBlock.getCol() - 1, true)) continue;
            leftSame = false;
            break;
        }
        if (leftSame) {
            ReportBookHelper.fillSA(sa, Styles.Position.LEFT, leftBorder);
        } else {
            ReportBookHelper.fillSA(sa, Styles.Position.LEFT, sheet.getDefaultBorder(true));
        }
        boolean topSame = true;
        Border topBorder = borders.getCellBorder(mergeBlock.getRow() - 1, mergeBlock.getCol(), false);
        for (int i = mergeBlock.getCol() + 1; i <= mergeBlock.getCol2(); ++i) {
            if (topBorder == borders.getCellBorder(mergeBlock.getRow() - 1, i, false)) continue;
            topSame = false;
            break;
        }
        if (topSame) {
            ReportBookHelper.fillSA(sa, Styles.Position.TOP, topBorder);
        } else {
            ReportBookHelper.fillSA(sa, Styles.Position.TOP, sheet.getDefaultBorder(false));
        }
        Border rightBorder = borders.getCellBorder(mergeBlock.getRow(), mergeBlock.getCol2(), true);
        boolean rightSame = true;
        for (int i = mergeBlock.getRow() + 1; i <= mergeBlock.getRow2(); ++i) {
            if (rightBorder == borders.getCellBorder(i, mergeBlock.getCol2(), true)) continue;
            rightSame = false;
            break;
        }
        if (rightSame) {
            ReportBookHelper.fillSA(sa, Styles.Position.RIGHT, rightBorder);
        } else {
            ReportBookHelper.fillSA(sa, Styles.Position.RIGHT, sheet.getDefaultBorder(true));
        }
        Border bottomBorder = borders.getCellBorder(mergeBlock.getRow2(), mergeBlock.getCol(), false);
        boolean bottomSame = true;
        for (int i = mergeBlock.getCol() + 1; i <= mergeBlock.getCol2(); ++i) {
            if (bottomBorder == borders.getCellBorder(mergeBlock.getRow2(), i, false)) continue;
            bottomSame = false;
            break;
        }
        if (bottomSame) {
            ReportBookHelper.fillSA(sa, Styles.Position.BOTTOM, bottomBorder);
        } else {
            ReportBookHelper.fillSA(sa, Styles.Position.BOTTOM, sheet.getDefaultBorder(false));
        }
        if (!sa.isFull() && !sa.isFull()) {
            int bitCount = ShareStyleAttributes.ATTRS_COUNT;
            sa.append(sheet.getRowSSA(cell.getRow()), false, bitCount);
            if (!sa.isFull()) {
                sa.append(sheet.getColSSA(cell.getCol()), false, bitCount);
                if (!sa.isFull()) {
                    sa.append(sheet.getSSA(), false, bitCount);
                }
            }
        }
        Style style = new Style((ShareStyleAttributes)sa);
        return style;
    }

    private static void fillSA(StyleAttributes sa, Styles.Position pos, Border bdr) {
        sa.setBorderColor(pos, bdr.getColor());
        sa.setBorderPenStyle(pos, bdr.getPenStyle());
        sa.setBorderLineStyle(pos, bdr.getLineStyle());
    }
}

