/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.console;

import com.kingdee.bos.tool.console.Console;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.console.Messages;
import com.kingdee.bos.tool.console.RemoveAllClosedStreamsAction;
import com.kingdee.bos.tool.console.ShowStreamAction;
import com.kingdee.bos.tool.console.UserStreamManager;
import com.kingdee.bos.tool.utils.IDEImages;
import com.kingdee.bos.tool.utils.ToolBaseImages;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ChooseStreamAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private Console fConsole;

    public ChooseStreamAction(Console console) {
        this.fConsole = console;
        this.setText(Messages.ChooseStreamAction_XianShiSuoXuanGuoChengDeShuChu);
        this.setToolTipText(Messages.ChooseStreamAction_XianShiSuoXuanGuoChengDeShuChu);
        IDEImages images = IDEImages.getInstance(ToolBaseImages.BASE_URL);
        this.setImageDescriptor(images.getImageDescriptor("obj16/osprc_obj.gif"));
        this.setMenuCreator(this);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        Collection userStreams = UserStreamManager.getUserStreamManager().getUserStreams();
        IUserStream currentStream = this.fConsole.getCurrentStream();
        boolean terminatedStreams = false;
        boolean hasStreams = false;
        for (IUserStream stream : userStreams) {
            ShowStreamAction showStreamAction = new ShowStreamAction(this.fConsole, stream);
            showStreamAction.setChecked(stream == currentStream);
            this.addActionToMenu(showStreamAction);
            if (stream.isClosed() && !terminatedStreams) {
                terminatedStreams = true;
            }
            hasStreams = true;
        }
        if (hasStreams && terminatedStreams) {
            new MenuItem(this.fMenu, 2);
            RemoveAllClosedStreamsAction removeAllAction = new RemoveAllClosedStreamsAction();
            this.addActionToMenu(removeAllAction);
        }
        return this.fMenu;
    }

    private void addActionToMenu(Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(this.fMenu, -1);
    }

    public Menu getMenu(Menu arg0) {
        return null;
    }
}

