/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.console;

import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.console.ChooseStreamAction;
import com.kingdee.bos.tool.console.ConsoleDocument;
import com.kingdee.bos.tool.console.ConsoleDocumentManager;
import com.kingdee.bos.tool.console.ConsoleViewer;
import com.kingdee.bos.tool.console.IHyperLink;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.console.IUserStreamListener;
import com.kingdee.bos.tool.console.Messages;
import com.kingdee.bos.tool.console.TextViewerAction;
import com.kingdee.bos.tool.console.UserStreamManager;
import com.kingdee.bos.tool.utils.IDEImages;
import com.kingdee.bos.tool.utils.ToolBaseImages;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class Console
extends ViewPart {
    private static Console fCurrentInstance;
    private ConsoleDocumentManager fDocumentManager = new ConsoleDocumentManager();
    private TextViewer fTextViewer;
    private boolean fAutoScroll;
    private String fTitlePrefix;
    private IUserStream fCurrentStream;
    private static boolean fOpen;
    private TextViewerAction fCopyAction;
    private TextViewerAction fSelectAllAction;
    private Action fChooseStreamAction;
    private Action fSaveAsFileAction;
    private Action fScrollLockAction;
    private Action fClearOutputAction;
    private static final int MAX_BUFFER_SIZE = 200;
    private static Vector fConsoleData;
    private static Runnable fASyncRunnable;
    private IDocumentListener fDocumentListener;
    private static IUserStreamListener fStreamListener;

    public Console() {
        fStreamListener = new UserStreamListener();
        UserStreamManager.getUserStreamManager().addStreamListener(fStreamListener);
    }

    private void refreshByDocument(ConsoleDocument doc) {
        if (this.fTextViewer != null) {
            this.fTextViewer.setDocument((IDocument)doc);
            this.fTextViewer.refresh();
        }
        this.refreshTitle();
    }

    private boolean isCurrentStream(String streamId) {
        return this.fCurrentStream != null && streamId.equals(this.fCurrentStream.getStreamId());
    }

    private void refreshTitle() {
        if (this.fCurrentStream != null) {
            String isCloseStr = this.fCurrentStream.isClosed() ? Messages.Console_YiZhongZhi : "";
            this.setPartName(this.fTitlePrefix + "[ " + isCloseStr + " " + this.fCurrentStream.getStreamId() + " ]");
        } else {
            this.setPartName(this.fTitlePrefix);
        }
    }

    private void shutdown() {
        if (fStreamListener != null) {
            UserStreamManager.getUserStreamManager().removeStreamListener(fStreamListener);
            fStreamListener = null;
        }
    }

    public static boolean isOpen() {
        return fOpen;
    }

    public void createPartControl(Composite parent) {
        fCurrentInstance = this;
        fOpen = true;
        this.fTitlePrefix = this.getTitle();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(272));
        this.fTextViewer = new ConsoleViewer(container);
        this.fTextViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fTextViewer.setEditable(false);
        this.fTextViewer.setDocument((IDocument)this.fDocumentManager.getCurrentDocument());
        this.fTextViewer.getTextWidget().setFont(JFaceResources.getFont((String)"pref_console_font"));
        this.createActions();
        this.addListeners();
        this.refreshTitle();
        this.flushConsoleBuffer();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fTextViewer.getControl(), "com.kingdee.bos.studio.context.studio_view_context");
    }

    public void dispose() {
        this.shutdown();
        if (this.fDocumentListener != null) {
            this.fDocumentManager.removeDocumentListener(this.fDocumentListener);
            this.fDocumentListener = null;
        }
        fOpen = false;
        super.dispose();
    }

    private void addListeners() {
        this.fTextViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Console.this.fCopyAction.update();
            }
        });
        this.fTextViewer.getTextWidget().addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                StyleRange style = new StyleRange(event.lineOffset, event.lineText.length(), Console.this.getConsoleLineColor(event.lineOffset), null);
                event.styles = new StyleRange[]{style};
            }
        });
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (Console.this.fTextViewer == null) {
                    return;
                }
                if (Console.this.isAutoScroll()) {
                    StyledText styledText = Console.this.fTextViewer.getTextWidget();
                    if (styledText.isDisposed()) {
                        return;
                    }
                    int lines = styledText.getLineCount();
                    styledText.setTopIndex(lines);
                    try {
                        styledText.setCaretOffset(event.getDocument().getLineOffset(lines - 1));
                    }
                    catch (BadLocationException e) {
                        ToolBasePlugin.log(e);
                    }
                }
            }
        };
        this.fDocumentManager.addDocumentListener(this.fDocumentListener);
    }

    private void createActions() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Console.this.fillContextMenu(mgr);
            }
        });
        Menu menu = mgr.createContextMenu(this.fTextViewer.getControl());
        this.fTextViewer.getControl().setMenu(menu);
        IDEImages images = IDEImages.getInstance(ToolBaseImages.BASE_URL);
        this.fChooseStreamAction = new ChooseStreamAction(this);
        final Shell shell = this.fTextViewer.getControl().getShell();
        this.fSaveAsFileAction = new Action(Messages.Console_LingCunWeiWenJian){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FileDialog dialog = new FileDialog(shell, 8192);
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                OutputStreamWriter fileWriter = null;
                try {
                    File saveFile = new File(fileName);
                    fileWriter = new FileWriter(saveFile);
                    String contents = Console.this.fDocumentManager.getCurrentDocument().get();
                    fileWriter.write(contents);
                }
                catch (IOException e) {
                    ToolBasePlugin.log(e);
                }
                finally {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException ex) {
                        ToolBasePlugin.log(ex);
                    }
                }
            }
        };
        this.fSaveAsFileAction.setToolTipText(Messages.Console_LingCunWeiWenJian);
        this.fSaveAsFileAction.setImageDescriptor(images.getImageDescriptor("elcl16/saveas_co.gif"));
        this.fSaveAsFileAction.setDisabledImageDescriptor(images.getImageDescriptor("dlcl16/saveas_co.gif"));
        this.fSaveAsFileAction.setHoverImageDescriptor(images.getImageDescriptor("clcl16/saveas_co.gif"));
        this.fScrollLockAction = new Action(Messages.Console_GunDongSuoDing){

            public void run() {
                Console.this.setAutoScroll(!this.isChecked());
            }
        };
        this.fScrollLockAction.setChecked(false);
        this.fScrollLockAction.setToolTipText(Messages.Console_GunDongSuoDing);
        this.fScrollLockAction.setImageDescriptor(images.getImageDescriptor("elcl16/lock_co.gif"));
        this.fScrollLockAction.setDisabledImageDescriptor(images.getImageDescriptor("dlcl16/lock_co.gif"));
        this.fScrollLockAction.setHoverImageDescriptor(images.getImageDescriptor("clcl16/lock_co.gif"));
        this.fClearOutputAction = new Action(Messages.Console_QingChu){

            public void run() {
                Console.this.fDocumentManager.getCurrentDocument().clear();
            }
        };
        this.fClearOutputAction.setToolTipText(Messages.Console_QingChu);
        this.fClearOutputAction.setImageDescriptor(images.getImageDescriptor("elcl16/clear_co.gif"));
        this.fClearOutputAction.setDisabledImageDescriptor(images.getImageDescriptor("dlcl16/clear_co.gif"));
        this.fClearOutputAction.setHoverImageDescriptor(images.getImageDescriptor("clcl16/clear_co.gif"));
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.fChooseStreamAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fSaveAsFileAction);
        tbm.add((IAction)this.fScrollLockAction);
        tbm.add((IAction)this.fClearOutputAction);
        tbm.update(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fCopyAction = new TextViewerAction((ITextViewer)this.fTextViewer, 4);
        this.fCopyAction.setText(Messages.Console_FuZhi);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.fCopyAction);
        this.fSelectAllAction = new TextViewerAction((ITextViewer)this.fTextViewer, 7);
        this.fSelectAllAction.setText(Messages.Console_QuanBuXuanZhong);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.fSelectAllAction);
        actionBars.updateActionBars();
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fCopyAction);
        manager.add((IAction)this.fSelectAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fClearOutputAction);
    }

    private Color getConsoleLineColor(int offset) {
        return this.fDocumentManager.getCurrentDocument().getLineColor(offset);
    }

    private void addConsoleLine(String streamId, String text, Color color, IHyperLink link) {
        fConsoleData.add(new ConsoleLine(streamId, text, color, link));
        if (!Console.isOpen()) {
            if (fConsoleData.size() > 200) {
                fConsoleData.remove(0);
            }
            return;
        }
        if (fASyncRunnable != null) {
            return;
        }
        this.flushConsoleBuffer();
    }

    private void flushConsoleBuffer() {
        if (!Console.isOpen()) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        fASyncRunnable = new Runnable(){

            @Override
            public void run() {
                while (!fConsoleData.isEmpty()) {
                    ConsoleLine consoleLine = (ConsoleLine)fConsoleData.remove(0);
                    ConsoleDocument doc = Console.this.fDocumentManager.getDocument(consoleLine.streamId);
                    doc.addLine(consoleLine.text, consoleLine.color, consoleLine.link);
                }
                fASyncRunnable = null;
            }
        };
        display.asyncExec(fASyncRunnable);
    }

    public IUserStream getCurrentStream() {
        return this.fCurrentStream;
    }

    public void setFocus() {
        this.fTextViewer.getTextWidget().setFocus();
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void setCurrentStream(IUserStream fStream) {
        this.fCurrentStream = fStream;
        if (this.fCurrentStream != null) {
            this.fDocumentManager.setCurrentDocment(fStream.getStreamId());
            this.fTextViewer.setDocument((IDocument)this.fDocumentManager.getCurrentDocument());
        } else {
            this.fTextViewer.setDocument((IDocument)new Document());
        }
        this.fTextViewer.refresh();
        this.refreshTitle();
    }

    static {
        fConsoleData = new Vector(400);
    }

    private class UserStreamListener
    implements IUserStreamListener {
        private UserStreamListener() {
        }

        @Override
        public void streamLineAdded(String streamId, String line, Color color, IHyperLink link) {
            Console.this.addConsoleLine(streamId, line, color, link);
        }

        @Override
        public void streamStopped(String streamId) {
            if (Console.this.isCurrentStream(streamId) && fCurrentInstance != null) {
                fCurrentInstance.refreshTitle();
            }
        }

        @Override
        public void streamCreated(String streamId) {
            ConsoleDocument document = Console.this.fDocumentManager.createDocument(streamId);
            Console.this.fCurrentStream = UserStreamManager.getUserStreamManager().getUserStream(streamId);
            if (fCurrentInstance != null) {
                fCurrentInstance.refreshByDocument(document);
            }
        }

        @Override
        public void streamRemoved(String streamId) {
            Console.this.fDocumentManager.removeDocument(streamId);
            if (Console.this.isCurrentStream(streamId)) {
                ConsoleDocument document = Console.this.fDocumentManager.getCurrentDocument();
                String currentId = document.getStreamId();
                Console.this.fCurrentStream = UserStreamManager.getUserStreamManager().getUserStream(currentId);
                if (fCurrentInstance != null) {
                    fCurrentInstance.refreshByDocument(document);
                }
            }
        }
    }

    private static class ConsoleLine {
        public String streamId;
        public String text;
        public Color color;
        public IHyperLink link;

        public ConsoleLine(String streamId, String text, Color color, IHyperLink link) {
            this.streamId = streamId;
            this.text = text;
            this.color = color;
            this.link = link;
        }
    }
}

