/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.validators;

import com.kingdee.bos.tool.validators.CommonValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class IntegerValidator
implements ICellEditorValidator {
    private boolean nullable;
    private boolean isRangeSet;
    private int minValidValue = Integer.MIN_VALUE;
    private int maxValidValue = Integer.MAX_VALUE;

    public IntegerValidator() {
        this(true);
    }

    public IntegerValidator(boolean isNullable) {
        this.nullable = isNullable;
    }

    public String isValid(Object value) {
        Integer[] rangs = null;
        if (this.isRangeSet) {
            rangs = new Integer[]{new Integer(this.minValidValue), new Integer(this.maxValidValue)};
        }
        return CommonValidator.isValid(value, this.nullable, 1, rangs);
    }

    public void setMinValidValue(int minValidValue) {
        this.isRangeSet = true;
        this.minValidValue = minValidValue;
    }

    public void setMaxValidValue(int maxValidValue) {
        this.isRangeSet = true;
        this.maxValidValue = maxValidValue;
    }

    public void setNullable(boolean isNullable) {
        this.nullable = isNullable;
    }
}

