/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.validators;

import com.kingdee.bos.tool.validators.CommonValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class LongValidator
implements ICellEditorValidator {
    private boolean nullable;
    private boolean isRangeSet;
    private long minValidValue = Long.MIN_VALUE;
    private long maxValidValue = Long.MAX_VALUE;

    public LongValidator() {
        this(true);
    }

    public LongValidator(boolean isNullable) {
        this.nullable = isNullable;
    }

    public String isValid(Object value) {
        Long[] ranges = null;
        if (this.isRangeSet) {
            ranges = new Long[]{new Long(this.minValidValue), new Long(this.maxValidValue)};
        }
        return CommonValidator.isValid(value, this.nullable, 2, ranges);
    }

    public void setNullable(boolean isNullable) {
        this.nullable = isNullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setMinValidValue(long minValidValue) {
        this.isRangeSet = true;
        this.minValidValue = minValidValue;
    }

    public long getMinValidValue() {
        return this.minValidValue;
    }

    public void setMaxValidValue(long maxValidValue) {
        this.isRangeSet = true;
        this.maxValidValue = maxValidValue;
    }

    public long getMaxValidValue() {
        return this.maxValidValue;
    }
}

