/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud;

import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;

public class LoginInfo {
    private final File propFile;
    private String serverUser;
    private String serverP;
    private String workflowUser;
    private String workflowP;
    private String reportUser;
    private String reportP;
    private boolean saveP;

    public LoginInfo(File file) {
        this.propFile = file;
        this.load();
    }

    public LoginInfo(String projectName) {
        String root = ".";
        try {
            root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() + "/" + projectName;
        }
        catch (Throwable t) {
            LogTool.debug("", t);
        }
        this.propFile = new File(root, ".remote");
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Properties prop = new Properties();
        if (this.propFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.propFile);
                prop.load(fileInputStream);
            }
            catch (Exception e) {
                try {
                    LogTool.logError("\u52a0\u8f7d\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519", e);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
        }
        this.serverUser = prop.getProperty("serverUser");
        this.serverP = prop.getProperty("serverPassword", "");
        this.workflowUser = prop.getProperty("workflowUser", "administrator");
        this.workflowP = prop.getProperty("workflowPassword", "");
        this.reportUser = prop.getProperty("reportUser", "user");
        this.reportP = prop.getProperty("reportPassword", "");
        this.saveP = !StringUtils.isEmpty((String)this.serverP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        Properties prop = new Properties();
        if (this.serverUser != null) {
            prop.put("serverUser", this.serverUser);
        }
        if (this.saveP && this.serverP != null) {
            prop.put("serverPassword", this.serverP);
        }
        if (this.workflowUser != null) {
            prop.put("workflowUser", this.workflowUser);
        }
        if (this.saveP && this.workflowP != null) {
            prop.put("appPassword", this.workflowP);
        }
        if (this.reportUser != null) {
            prop.put("appUser2", this.reportUser);
        }
        if (this.saveP && this.reportP != null) {
            prop.put("appPassword2", this.reportP);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.propFile);
            prop.store(fileOutputStream, "mic");
        }
        catch (Exception e) {
            try {
                LogTool.logError("\u4fdd\u5b58\u65f6\u51fa\u9519", e);
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
        }
        FileUtils.close(fileOutputStream);
    }

    public String getServerUser() {
        return this.serverUser;
    }

    public void setServerUser(String serverUser) {
        this.serverUser = serverUser;
    }

    public String getServerP() {
        return this.serverP;
    }

    public void setServerPassword(String serverP) {
        this.serverP = serverP;
    }

    public String getWorkflowUser() {
        return this.workflowUser;
    }

    public void setWorkflowUser(String workflowUser) {
        this.workflowUser = workflowUser;
    }

    public String getWorkflowP() {
        return this.workflowP;
    }

    public void setWorkflowPassword(String workflowP) {
        this.workflowP = workflowP;
    }

    public String getReportUser() {
        return this.reportUser;
    }

    public void setReportUser(String reportUser) {
        this.reportUser = reportUser;
    }

    public String getReportP() {
        return this.reportP;
    }

    public void setReportPassword(String reportP) {
        this.reportP = reportP;
    }

    public boolean isSaveP() {
        return this.saveP;
    }

    public void setSaveP(boolean saveP) {
        this.saveP = saveP;
    }
}

