/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.dialog;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.ui.MDSelectionComposite;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.UIHelper;
import com.kingdee.bos.util.BOSObjectType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectMDDialog
extends Dialog {
    private static Properties MDTYPENAMES = null;
    protected MDSelectionComposite mdSelector;
    private BOSObjectType[] types;
    private List selectedFiles;
    protected IMDProject project;
    private Properties properties;

    public SelectMDDialog(Shell shell, BOSObjectType[] types, IMDProject project) {
        super(shell);
        this.selectedFiles = new ArrayList();
        this.project = null;
        this.properties = new Properties();
        this.project = project;
        this.types = types;
    }

    public SelectMDDialog(Shell shell, BOSObjectType type, IMDProject project) {
        BOSObjectType[] bOSObjectTypeArray;
        if (type == null) {
            bOSObjectTypeArray = null;
        } else {
            BOSObjectType[] bOSObjectTypeArray2 = new BOSObjectType[1];
            bOSObjectTypeArray = bOSObjectTypeArray2;
            bOSObjectTypeArray2[0] = type;
        }
        this(shell, bOSObjectTypeArray, project);
    }

    public SelectMDDialog(Shell shell, String[] suffix, IMDProject project) {
        super(shell);
        this.selectedFiles = new ArrayList();
        this.project = null;
        this.properties = new Properties();
        this.project = project;
        if (suffix != null) {
            ArrayList<BOSObjectType> list = new ArrayList<BOSObjectType>();
            for (int i = 0; i < suffix.length; ++i) {
                BOSObjectType type = BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)suffix[i]));
                if (type == null || list.contains(type)) continue;
                list.add(type);
            }
            this.types = list.toArray(new BOSObjectType[list.size()]);
        }
    }

    protected Point getInitialSize() {
        return new Point(600, 400);
    }

    public IMDFile getSelectedFile() {
        if (this.selectedFiles.isEmpty()) {
            return null;
        }
        return (IMDFile)this.selectedFiles.get(0);
    }

    public IMDFile[] getAllSelected() {
        return this.selectedFiles.toArray(new IMDFile[this.selectedFiles.size()]);
    }

    public void setFilterProperty(String key, String value) {
        this.properties.put(key, value);
        if (this.mdSelector != null && !this.mdSelector.isDisposed()) {
            this.mdSelector.setFilterProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Control createDialogArea(Composite parent) {
        Composite composite = parent;
        synchronized (composite) {
            if (MDTYPENAMES == null) {
                MDTYPENAMES = new Properties();
                InputStream resourceAsStream = null;
                try {
                    resourceAsStream = SelectMDDialog.class.getResourceAsStream("mdtypename.properties");
                    MDTYPENAMES.load(resourceAsStream);
                }
                catch (IOException e1) {
                    LogTool.logError("\u88c5\u8f7d\u5143\u6570\u636e\u540d\u79f0\u65f6\u51fa\u9519", e1);
                }
                finally {
                    FileUtils.close(resourceAsStream);
                }
            }
        }
        String title = null;
        if (this.types != null && this.types.length > 0) {
            title = MDTYPENAMES.getProperty(Utils.getMetaDataSuffix((BOSObjectType)this.types[0]));
        }
        title = title == null ? "\u9009\u62e9\u5143\u6570\u636e" : "\u9009\u62e9" + title;
        this.getShell().setText(title);
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite panel = UIHelper.createPanel(container, 768, 1, 2);
        UIHelper.createLabel(panel, "\u641c\u7d22\u8303\u56f4(&P):");
        final Combo comboProject = UIHelper.createCombo(panel, 12, 1);
        if (this.project == null) {
            IMDProject[] projects = MDResourceUtil.listMDProject();
            String[] stringArray = new String[projects.length];
            for (int i = 0; i < projects.length; ++i) {
                stringArray[i] = projects[i].getName();
            }
            comboProject.setItems(stringArray);
            this.project = MDResourceUtil.getLatestProject();
            if (this.project == null && projects.length > 0) {
                this.project = projects[0];
            }
            if (this.project != null) {
                comboProject.setText(this.project.getName());
            }
            comboProject.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String name = comboProject.getText();
                    IMDProject[] projects = MDResourceUtil.listMDProject();
                    for (int i = 0; i < projects.length; ++i) {
                        if (!projects[i].getName().equals(name)) continue;
                        SelectMDDialog.this.project = projects[i];
                        IMDFile file = SelectMDDialog.this.mdSelector.getSelectedFile();
                        SelectMDDialog.this.mdSelector.setInput(SelectMDDialog.this.project);
                        if (file == null) break;
                        file = SelectMDDialog.this.project.getRoot().getChildFile(file.getPath());
                        SelectMDDialog.this.mdSelector.setSelectedResource(file);
                        break;
                    }
                }
            });
        } else {
            comboProject.setItems(new String[]{this.project.getName()});
            comboProject.setText(this.project.getName());
            comboProject.setEnabled(false);
        }
        this.mdSelector = new MDSelectionComposite(container, 0, null, ((Object)((Object)this)).getClass().getName());
        this.mdSelector.setLayoutData(new GridData(1808));
        this.mdSelector.addFileSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                SelectMDDialog.this.selectedFiles.clear();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    SelectMDDialog.this.selectedFiles.add(iter.next());
                }
                if (SelectMDDialog.this.getButton(0) != null) {
                    SelectMDDialog.this.getButton(0).setEnabled(!SelectMDDialog.this.selectedFiles.isEmpty());
                }
            }
        });
        this.mdSelector.addFileMouseListenerListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                SelectMDDialog.this.buttonPressed(0);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.mdSelector.setTypes(this.types);
        for (String string : this.properties.keySet()) {
            this.mdSelector.setFilterProperty(string, this.properties.getProperty(string));
        }
        this.mdSelector.setInput(this.project);
        return container;
    }

    public void setInitResource(IMDResource resource) {
    }

    public boolean close() {
        this.mdSelector.storeStatus();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public void create() {
        super.create();
    }

    public AbstractMetaDataValue getSelection() {
        IMDFile file = this.getSelectedFile();
        if (file == null) {
            return null;
        }
        try {
            return (AbstractMetaDataValue)MDORMUtil.load(file);
        }
        catch (MDNotFoundException e) {
            LogTool.logError("\u65e0\u6cd5\u627e\u5230\u5143\u6570\u636e" + file.getPath(), e);
            return null;
        }
    }
}

