/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.PFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class FileMD5Cache {
    private Properties prop = new Properties();
    private File cacheFile = null;

    public static void main(String[] args) {
    }

    public FileMD5Cache(File cacheFile) throws FileNotFoundException, IOException {
        this.cacheFile = cacheFile;
        if (cacheFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(cacheFile);
                this.prop.load(fileInputStream);
            }
            catch (Throwable throwable) {
                FileUtils.close(fileInputStream);
                throw throwable;
            }
            FileUtils.close(fileInputStream);
        }
    }

    public boolean isUpdate(File file, String md5) throws IOException {
        if (!file.exists()) {
            return true;
        }
        String key = file.getAbsolutePath();
        String value = this.prop.getProperty(key);
        if (value == null) {
            String localMd5 = PFileUtils.getMD5(file);
            if (localMd5.equals(md5)) {
                this.prop.put(key, file.lastModified() + ":" + localMd5);
                return false;
            }
            return true;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return true;
        }
        String cacheTS = value.substring(0, index);
        String localMd5 = value.substring(index + 1);
        long ts = file.lastModified();
        if (cacheTS.equals(String.valueOf(ts))) {
            return !localMd5.equals(md5);
        }
        localMd5 = PFileUtils.getMD5(file);
        if (localMd5.equals(md5)) {
            this.prop.put(key, ts + ":" + localMd5);
            return false;
        }
        return true;
    }

    public void update(File file) throws IOException {
        String key = file.getAbsolutePath();
        if (!file.exists()) {
            this.prop.remove(key);
            return;
        }
        String value = file.lastModified() + ":" + PFileUtils.getMD5(file);
        this.prop.setProperty(key, value);
    }

    public void store() throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.cacheFile);
            this.prop.store(fileOutputStream, "mic");
        }
        catch (Throwable throwable) {
            FileUtils.close(fileOutputStream);
            throw throwable;
        }
        FileUtils.close(fileOutputStream);
    }
}

