/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.util.BOSObjectType;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeleteFileCommand
implements ICommand {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dao.DeleteFileCommand");
    private IFile file;

    public DeleteFileCommand(IFile file) {
        this.file = file;
    }

    @Override
    public void exec(IProgressMonitor monitor) {
        try {
            if (this.file != null && this.file.exists()) {
                IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(this.file.getProject());
                BOSObjectType type = ORMStudioBridger.getBOSTypeByFileName(this.file.getName());
                IMetaDataPK pk = ORMStudioBridger.getFilePK((IResource)this.file);
                if (type != null && pk != null && loader.exist(type, pk)) {
                    loader.deleteMetadata(type, pk);
                } else {
                    this.file.delete(true, false, monitor);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Delete File error", (Throwable)e);
        }
    }
}

