/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao.tableimpexp;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.dao.tableimpexp.TableImpExpMap;
import com.kingdee.bos.tool.dbupdate.dbtools.DB2SchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.dbtools.ORACLESchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.SQLSERVERSchemaDAO;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class DBTableStore {
    private static int DB2CstrMaxLen = 18;
    private static int ORACLECstrMaxLen = 30;

    DBTableStore() {
    }

    public static void store(Connection cn, AbstractTableInfo table, String destTableName, SolutionInfo solution) throws SQLException {
        if (!DBTableStore.dbTableExisted(cn, destTableName)) {
            DBTableStore.createDBTable(cn, table, destTableName, solution);
        } else {
            DBTableStore.updateDBTable(cn, table, destTableName, solution);
        }
    }

    public static void store(AbstractTableInfo table, String destTableName, SolutionInfo solution, TableImpExpMap tableImpExpMap) throws SQLException {
        DBTableStore.updateDBTable(table, destTableName, solution, tableImpExpMap);
    }

    private static void createDBTable(Connection cn, AbstractTableInfo table, String destTableName, SolutionInfo solution) throws SQLException {
        int type = DBUtils.getDbType(cn);
        String sql = DBTableStore.getCreateTableSql(table, destTableName, type, solution);
        DBTableStore.executeSQL(cn, sql);
        DBTableStore.createDBIndex(cn, type, table, destTableName, solution);
    }

    private static void createDBTable(AbstractTableInfo table, String destTableName, SolutionInfo solution, TableImpExpMap tableImpExpMap) throws SQLException {
        int databaseType = DbType.getValue((String)tableImpExpMap.getDatabaseType());
        StringBuffer sqlScript = new StringBuffer();
        String sql = DBTableStore.getCreateTableSql(table, destTableName, databaseType, solution);
        sqlScript.append(sql + ";\n\n");
        tableImpExpMap.setCreateTableSql(sqlScript);
        DBTableStore.createDBIndex(databaseType, table, destTableName, tableImpExpMap, solution);
    }

    private static String getCreateTableSql(AbstractTableInfo table, String destTableName, int databaseType, SolutionInfo solution) throws SQLException {
        String sql = "Create Table " + destTableName + " ( ";
        String col_cstr = null;
        for (int i = 0; i < table.getColumns().size(); ++i) {
            sql = sql + DBTableStore.getColSQL(databaseType, table.getColumns().get(i), solution) + ",";
        }
        if (table.getPrimaryKey() != null) {
            int i;
            String pkname = DBTableStore.truncateName(databaseType, table.getPrimaryKey().getName());
            boolean isClusteredIndex = false;
            IndexCollection indexes = table.getIndexes();
            int inSize = indexes.size();
            for (i = 0; i < inSize; ++i) {
                IndexInfo index = indexes.get(i);
                int lSize = 1;
                int ccSize = index.getIndexColumns().size();
                for (int j = 0; j < ccSize; ++j) {
                    IndexColumnInfo idxCol = index.getIndexColumns().get(j);
                    if (!idxCol.getColumn().isMultilingual()) continue;
                    lSize = solution.getLanguages().size();
                    break;
                }
                if (!index.isClusteredIndex() || lSize >= 2) continue;
                isClusteredIndex = true;
                break;
            }
            for (i = 0; i < table.getPrimaryKey().getPKColumns().size(); ++i) {
                ColumnInfo col = table.getPrimaryKey().getPKColumns().get(i).getColumn();
                col_cstr = col_cstr == null ? "CONSTRAINT " + pkname + " PRIMARY KEY " + (isClusteredIndex ? " NONCLUSTERED " : "") + "(" + col.getName() : col_cstr + "," + col.getName();
            }
            if (col_cstr != null) {
                col_cstr = col_cstr + ")";
                sql = sql + col_cstr + ")";
            } else {
                sql = sql.substring(0, sql.length() - 1) + ")";
            }
        } else {
            sql = sql.substring(0, sql.length() - 1) + ")";
        }
        return sql;
    }

    private static void createDBIndex(Connection cn, int databaseType, AbstractTableInfo table, String destTableName, SolutionInfo solution) throws SQLException {
        for (int i = 0; i < table.getIndexes().size(); ++i) {
            IndexInfo idx = table.getIndexes().get(i);
            String sql = DBTableStore.getCreateDBIndexSqlNew(databaseType, idx, destTableName, solution);
            DBTableStore.executeSQL(cn, sql);
        }
    }

    private static void createDBIndex(int databaseType, AbstractTableInfo table, String destTableName, TableImpExpMap tableImpExpMap, SolutionInfo solution) throws SQLException {
        StringBuffer sqlScript = new StringBuffer();
        for (int i = 0; i < table.getIndexes().size(); ++i) {
            IndexInfo idx = table.getIndexes().get(i);
            String sql = DBTableStore.getCreateDBIndexSqlNew(databaseType, idx, destTableName, solution);
            sqlScript.append(sql + ";\n\n");
        }
        tableImpExpMap.setTableIndexSql(sqlScript);
    }

    private static String getCreateDBIndexSqlNew(int databaseType, IndexInfo idx, String destTableName, SolutionInfo solution) throws SQLException {
        int i;
        StringBuffer ret = new StringBuffer();
        String idxname = DBTableStore.truncateName(databaseType, idx.getName());
        boolean isClusteredIndex = false;
        if (idx.isClusteredIndex()) {
            isClusteredIndex = true;
        }
        int lSize = 1;
        int ccSize = idx.getIndexColumns().size();
        for (i = 0; i < ccSize; ++i) {
            IndexColumnInfo idxCol = idx.getIndexColumns().get(i);
            if (!idxCol.getColumn().isMultilingual()) continue;
            lSize = solution.getLanguages().size();
            break;
        }
        if (lSize == 1) {
            String sql = "CREATE " + (idx.isUnique() ? "UNIQUE" : "") + (isClusteredIndex ? " CLUSTERED" : "") + " INDEX " + idxname + " ON " + destTableName + "(";
            if (idx.isUnique()) {
                sql = "ALTER TABLE " + destTableName + " ADD CONSTRAINT " + (idxname.startsWith("UK_") || idxname.startsWith("UX_") ? "" : " UK_") + idxname + " UNIQUE" + (isClusteredIndex ? " CLUSTERED " : "") + "(";
            }
            for (int j = 0; j < idx.getIndexColumns().size(); ++j) {
                IndexColumnInfo idxcol = idx.getIndexColumns().get(j);
                sql = sql + idxcol.getColumn().getName() + " " + (idx.isUnique() ? "" : idxcol.getSortType().getName()) + ",";
            }
            sql = sql.substring(0, sql.length() - 1) + ")";
            ret.append(sql);
        } else {
            for (i = 0; i < lSize; ++i) {
                LanguageInfo lang = solution.getLanguages().get(i);
                String sql = "CREATE " + (idx.isUnique() ? "UNIQUE" : "") + " INDEX " + idxname + "_" + lang.getPostfix() + " ON " + destTableName + "(";
                if (idx.isUnique()) {
                    sql = "ALTER TABLE " + destTableName + " ADD CONSTRAINT UK_" + idxname + "_" + lang.getPostfix() + " UNIQUE(";
                }
                int cSize = idx.getIndexColumns().size();
                for (int j = 0; j < cSize; ++j) {
                    IndexColumnInfo idxCol = idx.getIndexColumns().get(j);
                    sql = sql + idxCol.getColumn().getName();
                    if (idxCol.getColumn().isMultilingual()) {
                        sql = sql + "_" + lang.getPostfix();
                    }
                    sql = idx.isUnique() ? sql + "," : sql + " " + idxCol.getSortType().getName() + ",";
                }
                sql = sql.substring(0, sql.length() - 1) + ")";
                ret.append(sql);
                if (i >= lSize - 1) continue;
                ret.append(";\n\n");
            }
        }
        return ret.toString();
    }

    private static String getColSQL(int databaseType, ColumnInfo col, SolutionInfo solution) throws SQLException {
        String strdef;
        String sql = "";
        String sqlpost = DBTableStore.getColDataType(databaseType, col);
        if (col.getDefaultValue() != null && !col.getDefaultValue().equals("") && !StringUtils.isEmpty((String)(strdef = DBTableStore.getColDefaultValue(databaseType, col)))) {
            sqlpost = sqlpost + " DEFAULT " + strdef;
        }
        if (!col.isNullable()) {
            sqlpost = sqlpost + " NOT NULL ";
        }
        int lSize = solution.getLanguages().size();
        if (col.isMultilingual() && lSize > 1) {
            for (int i = 0; i < solution.getLanguages().size(); ++i) {
                LanguageInfo lang = solution.getLanguages().get(i);
                sql = sql + col.getName() + "_" + lang.getPostfix() + " " + sqlpost;
                if (i >= solution.getLanguages().size() - 1) continue;
                sql = sql + ",";
            }
        } else {
            sql = col.getName() + " " + sqlpost;
        }
        return sql;
    }

    private static String getColDataType(int databaseType, ColumnInfo col) throws SQLException {
        String sql = col.getTypeName().getName();
        int dataLength = col.getLength();
        if (col.getTypeName().equals((Object)SQLType.CHAR) || col.getTypeName().equals((Object)SQLType.VARCHAR) || col.getTypeName().equals((Object)SQLType.NCHAR) || col.getTypeName().equals((Object)SQLType.NVARCHAR) || col.getTypeName().equals((Object)SQLType.CLOB) || col.getTypeName().equals((Object)SQLType.BLOB) || col.getTypeName().equals((Object)SQLType.NCLOB) || col.getTypeName().equals((Object)SQLType.BINARY) || col.getTypeName().equals((Object)SQLType.VARBINARY)) {
            sql = sql + "(" + dataLength + ")";
        } else if (col.getTypeName().equals((Object)SQLType.NUMERIC)) {
            sql = sql + "(" + col.getPrecision() + "," + col.getScale() + ")";
        } else if (!col.getTypeName().equals((Object)SQLType.INT)) {
            if (col.getTypeName().equals((Object)SQLType.DATETIME)) {
                sql = "DateTime";
            } else {
                throw new SQLException("invalid col.DataType", col.getTypeName().getName());
            }
        }
        return sql;
    }

    private static String getColDefaultValue(int type, ColumnInfo col) throws SQLException {
        if (col.getDefaultValue().equals("")) {
            return "";
        }
        String sql = null;
        if (col.getTypeName().equals((Object)SQLType.NCHAR) || col.getTypeName().equals((Object)SQLType.NVARCHAR) || col.getTypeName().equals((Object)SQLType.NCLOB)) {
            if (col.getDefaultValue().startsWith("('") && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue();
                sql = sql.length() - 4 == 0 ? "" : StringUtils.replace((String)sql.substring(2, sql.length() - 4), (String)"'", (String)"''");
                sql = DBUtils.isOracle(type) ? "N'" + sql + "'" : "'" + sql + "'";
            } else if ((col.getDefaultValue().startsWith("(N'") || col.getDefaultValue().startsWith("(n'")) && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue();
                sql = sql.length() - 5 == 0 ? "" : StringUtils.replace((String)sql.substring(3, sql.length() - 5), (String)"'", (String)"''");
                sql = DBUtils.isOracle(type) ? "N'" + sql + "'" : "'" + sql + "'";
            } else if (col.getDefaultValue().startsWith("'") && col.getDefaultValue().endsWith("'")) {
                sql = col.getDefaultValue();
                sql = sql.length() - 2 == 0 ? "" : StringUtils.replace((String)sql.substring(1, sql.length() - 2), (String)"'", (String)"''");
                sql = DBUtils.isOracle(type) ? "N'" + sql + "'" : "'" + sql + "'";
            } else if ((col.getDefaultValue().startsWith("N'") || col.getDefaultValue().startsWith("n'")) && col.getDefaultValue().endsWith("'")) {
                sql = col.getDefaultValue();
                sql = sql.length() - 3 == 0 ? "" : StringUtils.replace((String)sql.substring(2, sql.length() - 3), (String)"'", (String)"''");
                sql = DBUtils.isOracle(type) ? "N'" + sql + "'" : "'" + sql + "'";
            } else {
                sql = DBUtils.isOracle(type) ? "N'" + StringUtils.replace((String)col.getDefaultValue(), (String)"'", (String)"''") + "'" : "'" + StringUtils.replace((String)col.getDefaultValue(), (String)"'", (String)"''") + "'";
            }
        } else if (col.getTypeName().equals((Object)SQLType.CHAR) || col.getTypeName().equals((Object)SQLType.VARCHAR) || col.getTypeName().equals((Object)SQLType.CLOB) || col.getTypeName().equals((Object)SQLType.DATETIME)) {
            if (col.getDefaultValue().startsWith("('") && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue();
                sql = sql.length() - 4 == 0 ? "" : StringUtils.replace((String)sql.substring(2, sql.length() - 4), (String)"'", (String)"''");
                sql = "'" + sql + "'";
            } else if ((col.getDefaultValue().startsWith("(N'") || col.getDefaultValue().startsWith("(n'")) && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue();
                sql = sql.length() - 5 == 0 ? "" : StringUtils.replace((String)sql.substring(3, sql.length() - 5), (String)"'", (String)"''");
                sql = "'" + sql + "'";
            } else if (col.getDefaultValue().startsWith("'") && col.getDefaultValue().endsWith("'")) {
                sql = col.getDefaultValue();
                sql = sql.length() - 2 == 0 ? "" : StringUtils.replace((String)sql.substring(1, sql.length() - 1), (String)"'", (String)"''");
                sql = "'" + sql + "'";
            } else if ((col.getDefaultValue().startsWith("N'") || col.getDefaultValue().startsWith("n'")) && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue();
                sql = sql.length() - 3 == 0 ? "" : StringUtils.replace((String)sql.substring(2, sql.length() - 3), (String)"'", (String)"''");
                sql = "'" + sql + "'";
            } else {
                sql = "'" + StringUtils.replace((String)col.getDefaultValue(), (String)"'", (String)"''") + "'";
            }
        } else if (col.getTypeName().equals((Object)SQLType.BLOB) || col.getTypeName().equals((Object)SQLType.BINARY) || col.getTypeName().equals((Object)SQLType.VARBINARY) || col.getTypeName().equals((Object)SQLType.NUMERIC) || col.getTypeName().equals((Object)SQLType.INT)) {
            sql = col.getDefaultValue().startsWith("(") && col.getDefaultValue().endsWith(")") ? ((sql = col.getDefaultValue().trim()).length() - 2 == 0 ? "" : sql.substring(1, sql.length() - 2)) : col.getDefaultValue().trim();
        } else {
            throw new SQLException("invalid col.DataType", col.getTypeName().getName());
        }
        return sql;
    }

    private static void updateDBTable(Connection cn, AbstractTableInfo table, String destTableName, SolutionInfo solution) throws SQLException {
        ForeignKeyCollection fkList = DBTableStore.getRefFKList(cn, destTableName);
        DBTableStore.dropRefForeignKey(cn, fkList, destTableName);
        DBTableStore.deleteDBTable(cn, destTableName);
        DBTableStore.createDBTable(cn, table, destTableName, solution);
    }

    private static void updateDBTable(AbstractTableInfo table, String destTableName, SolutionInfo solution, TableImpExpMap tableImpExpMap) throws SQLException {
        DBTableStore.deleteDBTable(destTableName, tableImpExpMap);
        DBTableStore.createDBTable(table, destTableName, solution, tableImpExpMap);
    }

    private static void deleteDBTable(Connection cn, String tableName) throws SQLException {
        String sql = "DROP Table " + tableName;
        DBTableStore.executeSQL(cn, sql);
    }

    private static void deleteDBTable(String tableName, TableImpExpMap tableImpExpMap) throws SQLException {
        StringBuffer sqlScript = new StringBuffer();
        String sql = "DROP Table " + tableName;
        sqlScript.append(sql + ";\n\n");
        tableImpExpMap.setDropTableSql(sqlScript);
    }

    private static ForeignKeyCollection getRefFKList(Connection cn, String tableName) throws SQLException {
        ForeignKeyCollection fkList = new ForeignKeyCollection();
        int type = DBUtils.getDbType(cn);
        if (cn instanceof KDConnection) {
            KDConnection kdCon = (KDConnection)cn;
            cn = kdCon.getNativeConnection();
        }
        AbstractTableInfo tableInfo = null;
        tableInfo = DBUtils.isDB2(type) ? DB2SchemaDAO.getTable(cn, tableName) : (DBUtils.isOracle(type) ? ORACLESchemaDAO.getTable(cn, tableName) : (DBUtils.isMSSQL(type) ? SQLSERVERSchemaDAO.getTable(cn, tableName) : SQLSERVERSchemaDAO.getTable(cn, tableName)));
        if (tableInfo != null) {
            fkList = tableInfo.getForeignKeys();
        }
        return fkList;
    }

    private static void dropRefForeignKey(Connection cn, ForeignKeyCollection fkList, String destTableName) throws SQLException {
        for (int i = 0; i < fkList.size(); ++i) {
            ForeignKeyInfo fkey = fkList.get(i);
            String sql = "ALTER TABLE " + destTableName + " DROP CONSTRAINT " + fkey.getName();
            DBTableStore.executeSQL(cn, sql);
        }
    }

    public static void createFK(Connection cn, AbstractTableInfo table, String destTableName) throws SQLException {
        int databaseType = DBUtils.getDbType(cn);
        for (int i = 0; i < table.getForeignKeys().size(); ++i) {
            ForeignKeyInfo fkey = table.getForeignKeys().get(i);
            String sql = DBTableStore.getCreateFKSql(databaseType, destTableName, fkey);
            DBTableStore.executeSQL(cn, sql);
        }
    }

    public static void createFK(AbstractTableInfo table, String destTableName, TableImpExpMap tableImpExpMap) throws SQLException {
        int databaseType = DbType.getValue((String)tableImpExpMap.getDatabaseType());
        StringBuffer sqlScript = new StringBuffer();
        for (int i = 0; i < table.getForeignKeys().size(); ++i) {
            ForeignKeyInfo fkey = table.getForeignKeys().get(i);
            String sql = DBTableStore.getCreateFKSql(databaseType, destTableName, fkey);
            sqlScript.append(sql + ";\n\n");
        }
        tableImpExpMap.setTableFKSql(sqlScript);
    }

    private static String getCreateFKSql(int databaseType, String destTableName, ForeignKeyInfo fkey) throws SQLException {
        String sqlfk = "";
        String sqlpk = "";
        for (int j = 0; j < fkey.getFKColumnPairs().size(); ++j) {
            FKColumnPairInfo fkpair = fkey.getFKColumnPairs().get(j);
            sqlfk = sqlfk + fkpair.getForeignKeyColumn().getName() + ",";
            sqlpk = sqlpk + fkpair.getPrimaryKeyColumn().getName() + ",";
        }
        sqlfk = "(" + sqlfk.substring(0, sqlfk.length() - 1) + ")";
        sqlpk = "(" + sqlpk.substring(0, sqlpk.length() - 1) + ")";
        String fkeyname = DBTableStore.truncateName(databaseType, fkey.getName());
        String sql = "ALTER TABLE " + destTableName + " ADD CONSTRAINT " + fkeyname + " FOREIGN KEY " + sqlfk + " REFERENCES " + fkey.getRefTable().getName() + " " + sqlpk;
        return sql;
    }

    public static void dropFK(AbstractTableInfo table, String destTableName, TableImpExpMap tableImpExpMap) throws SQLException {
        int databaseType = DbType.getValue((String)tableImpExpMap.getDatabaseType());
        StringBuffer sqlScript = new StringBuffer();
        for (int i = 0; i < table.getForeignKeys().size(); ++i) {
            ForeignKeyInfo fkey = table.getForeignKeys().get(i);
            String fkeyname = DBTableStore.truncateName(databaseType, fkey.getName());
            String sql = "ALTER TABLE " + destTableName + " DROP CONSTRAINT " + fkeyname;
            sqlScript.append(sql + ";\n\n");
        }
        tableImpExpMap.setDropFKSql(sqlScript);
    }

    private static boolean dbTableExisted(Connection cn, String tableName) throws SQLException {
        boolean existed = false;
        ResultSet rs = cn.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
        existed = rs.next();
        SQLUtils.cleanup((ResultSet)rs);
        return existed;
    }

    private static void executeSQL(Connection cn, String sql) throws SQLException {
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.execute();
        stmt.close();
    }

    private static String truncateName(int databaseType, String name) throws SQLException {
        String newName = name;
        if (DBUtils.isDB2(databaseType) && name.length() > DB2CstrMaxLen) {
            newName = name.substring(0, DB2CstrMaxLen);
        } else if (DBUtils.isOracle(databaseType) && name.length() > ORACLECstrMaxLen) {
            newName = name.substring(0, ORACLECstrMaxLen);
        }
        return newName;
    }
}

