/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.dbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataViewCollection;
import com.kingdee.bos.metadata.data.DataViewInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.IndexScriptCollection;
import com.kingdee.bos.metadata.data.IndexScriptInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DB2SchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.dbtools.ORACLESchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.SQLSERVERSchemaDAO;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportItem;
import com.kingdee.bos.tool.dbupdate.report.ForeignKeyReportCollection;
import com.kingdee.bos.tool.dbupdate.report.ForeignKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.IndexReportCollection;
import com.kingdee.bos.tool.dbupdate.report.IndexReportItem;
import com.kingdee.bos.tool.dbupdate.report.PrimaryKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class DBSchemaDAO {
    protected static final int DB2CstrMaxLen = 18;
    protected static final int ORACLECstrMaxLen = 30;
    protected static final int maxDataLength = 0x40000000;
    protected static final String SEI = ";";
    protected static final String NEWLINE = "\n\n";

    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        ResultSet rs = null;
        AbstractTableInfo table = new AbstractTableInfo();
        table.setName(tableName);
        try {
            String fkName;
            if (!DBUtils.dbTableExisted(cn, tableName)) {
                AbstractTableInfo abstractTableInfo = null;
                return abstractTableInfo;
            }
            rs = cn.getMetaData().getColumns(null, null, tableName, null);
            while (rs.next()) {
                ColumnInfo col = new ColumnInfo();
                col.setName(rs.getString("COLUMN_NAME"));
                short dataType = rs.getShort("DATA_TYPE");
                SQLType sqlType = DBUtils.getSQLType(dataType);
                if (sqlType == null) {
                    throw new SQLException("unexcept data type:" + rs.getString("TYPE_NAME") + " in col:" + col.getName());
                }
                col.setTypeName(sqlType);
                String def = rs.getString("COLUMN_DEF");
                if (def != null && def.startsWith("(") && def.endsWith(")")) {
                    def = def.substring(1, def.length() - 1);
                }
                col.setDefaultValue(def);
                if (rs.getInt("COLUMN_SIZE") > 0x40000000) {
                    col.setLength(0x40000000);
                } else {
                    col.setLength(rs.getInt("COLUMN_SIZE"));
                }
                col.setNullable(rs.getInt("NULLABLE") == 1);
                if (rs.getInt("COLUMN_SIZE") > 0x40000000) {
                    col.setPrecision(0x40000000);
                } else {
                    col.setPrecision(rs.getInt("COLUMN_SIZE"));
                }
                col.setScale(rs.getInt("DECIMAL_DIGITS"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getPrimaryKeys(null, null, tableName);
            if (rs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(rs.getString("PK_NAME"));
                table.setPrimaryKey(pk);
                ColumnInfo col = DBUtils.getColumnByName(table, rs.getString("COLUMN_NAME"));
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
                while (rs.next()) {
                    col = DBUtils.getColumnByName(table, rs.getString("COLUMN_NAME"));
                    pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getIndexInfo(null, null, tableName, false, true);
            DBUtils.fillIndex(rs, table);
            SQLUtils.cleanup((ResultSet)rs);
            rs = cn.getMetaData().getImportedKeys(null, null, tableName);
            while (rs.next()) {
                fkName = rs.getString("FK_NAME");
                ForeignKeyInfo fk = null;
                for (int i = 0; i < table.getForeignKeys().size(); ++i) {
                    if (!table.getForeignKeys().get(i).getName().equals(fkName)) continue;
                    fk = table.getForeignKeys().get(i);
                    break;
                }
                if (fk == null) {
                    fk = new ForeignKeyInfo();
                    AbstractTableInfo refTable = new AbstractTableInfo();
                    refTable.setName(rs.getString("PKTABLE_NAME"));
                    fk.setRefTable(refTable);
                    fk.setName(fkName);
                    table.getForeignKeys().add(fk);
                }
                FKColumnPairInfo fkcol = new FKColumnPairInfo();
                fkcol.setForeignKeyColumn(DBUtils.getColumnByName(table, rs.getString("FKCOLUMN_NAME")));
                ColumnInfo pkcolumn = new ColumnInfo();
                pkcolumn.setName(rs.getString("PKCOLUMN_NAME"));
                fkcol.setPrimaryKeyColumn(pkcolumn);
                fk.getFKColumnPairs().add(fkcol);
            }
            SQLUtils.cleanup((ResultSet)rs);
            fkName = table;
            SQLUtils.cleanup((ResultSet)rs);
            return fkName;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            SQLUtils.cleanup(rs);
        }
    }

    public static void renameDBTable(Connection cn, String oldTableName, String newTableName, DBUpdateList dbUpdateList) throws SQLException {
        String databaseType = cn.getMetaData().getDatabaseProductName();
        int type = DbType.getValue((String)databaseType);
        if (type == 1) {
            DB2SchemaDAO.renameTable(oldTableName, newTableName, dbUpdateList);
        } else if (type == 2 || type == 8 || type == 7) {
            ORACLESchemaDAO.renameTable(oldTableName, newTableName, dbUpdateList);
        } else if (type == 3) {
            SQLSERVERSchemaDAO.renameTable(oldTableName, newTableName, dbUpdateList);
        } else {
            String sql = "/*dialect*/ALTER TABLE " + oldTableName + " RENAME " + newTableName;
            SQLSERVERSchemaDAO.addSQLToList(9, newTableName, sql, dbUpdateList);
        }
    }

    public static void createDBTable(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DBSchemaDAO.createDBTable(DBUtils.getDbType(cn), table, dbUpdateList);
    }

    public static void createDBTable(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        StringBuffer sqlStr = new StringBuffer("Create Table " + table.getName() + " ( ");
        for (int i = 0; i < table.getColumns().size(); ++i) {
            sqlStr.append(DBUtils.getColSQL(dbType, table.getColumns().get(i)) + ",");
        }
        String sql = sqlStr.toString();
        sql = sql.substring(0, sql.length() - 1) + " )";
        DBSchemaDAO.addSQLToList(10, table.getName(), table.getName(), sql.toString(), dbUpdateList);
        DataViewCollection dataViews = table.getDataViews();
        if (dataViews != null && dataViews.size() > 0) {
            for (int i = 0; i < dataViews.size(); ++i) {
                DataViewInfo dataView = dataViews.get(i);
                String viewSql = dataView.getScript();
                if (StringUtils.isEmpty((String)viewSql)) continue;
                DBSchemaDAO.addSQLToList(18, table.getName(), dataView.getName(), viewSql, dbUpdateList);
            }
        }
    }

    public static void dropDBTable(Connection cn, String tableName, DBUpdateList dbUpdateList) throws SQLException {
        String sql = "DROP Table " + tableName;
        DBSchemaDAO.addSQLToList(8, tableName, sql, dbUpdateList);
    }

    public static void addColumnExists(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList, ColumnInfo column) throws SQLException {
        String sql = "";
        if (column != null) {
            sql = "IF Not Exists(Select * From KSQL_USERCOLUMNS Where KSQL_COL_TABNAME='" + table.getName() + "' AND KSQL_COL_NAME='" + column.getName() + "') \n";
            sql = sql + " ALTER Table " + table.getName();
            sql = sql + " ADD " + DBUtils.getColSQL(dbType, column);
            DBSchemaDAO.addSQLToList(11, table.getName(), column.getName(), sql, dbUpdateList);
        }
    }

    public static void alterColumnExists(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList, ColumnInfo oldColumn, ColumnInfo newColumn, TableReportItem rptitem) throws SQLException {
        String sql = "";
        if (newColumn != null && (newColumn.getLength() >= oldColumn.getLength() || newColumn.getPrecision() >= oldColumn.getPrecision())) {
            sql = "IF Exists(Select * From KSQL_USERCOLUMNS Where KSQL_COL_TABNAME='" + table.getName() + "' AND KSQL_COL_NAME='" + newColumn.getName() + "') \n";
            sql = sql + " ALTER Table " + table.getName();
            if (!DBUtils.isMSSQL(dbType)) {
                sql = sql + " ALTER COLUMN " + DBUtils.getColSQL(dbType, newColumn);
            } else {
                String strdef;
                sql = sql + " ALTER COLUMN " + newColumn.getName() + " " + DBUtils.getColDataType(dbType, newColumn) + "";
                if (!newColumn.isNullable()) {
                    sql = sql + " NOT NULL ";
                }
                String defConstraint = "";
                defConstraint = oldColumn.getExtendedProperty("defaultName");
                if (!StringUtils.isEmpty((String)defConstraint)) {
                    sql = " IF Exists(Select * From KSQL_CONSTRAINTS Where KSQL_CONS_TABNAME='" + table.getName() + "' And KSQL_CONS_NAME='" + defConstraint + "') \n";
                    sql = sql + " ALTER TABLE " + table.getName() + " DROP CONSTRAINT \"" + defConstraint + "\"";
                    DBSchemaDAO.addSQLToList(3, defConstraint, sql, dbUpdateList);
                }
                if (newColumn.getDefaultValue() != null && !newColumn.getDefaultValue().equals("") && !(strdef = DBUtils.getColDefaultValue(dbType, newColumn)).equals("")) {
                    if (StringUtils.isEmpty((String)defConstraint)) {
                        defConstraint = "def_" + table.getName() + "_" + newColumn.getName();
                    }
                    sql = "IF NOT Exists(Select t1.* From sysobjects t1 Inner join sysobjects t2 on t2.id=t1.parent_obj Where t2.name='" + table.getName() + "' And t1.Name='" + defConstraint + "' And and t1.xtype='D') \n";
                    sql = sql + " ALTER TABLE " + table.getName() + " ADD CONSTRAINT \"" + defConstraint + "\"";
                    sql = sql + " DEFAULT " + strdef + " For " + newColumn.getName();
                    sql = "/*dialect*/" + sql;
                    DBSchemaDAO.addSQLToList(16, defConstraint, sql, dbUpdateList);
                }
                block0: for (int i = 0; i < table.getIndexes().size(); ++i) {
                    IndexInfo idx = table.getIndexes().get(i);
                    if (idx.getIndexColumns() == null) continue;
                    for (int j = 0; j < idx.getIndexColumns().size(); ++j) {
                        IndexColumnInfo idxcol = idx.getIndexColumns().get(j);
                        if (idxcol.getColumn() == null || !idxcol.getColumn().getName().equalsIgnoreCase(newColumn.getName())) continue;
                        boolean idxupdate = false;
                        IndexReportCollection indexrpts = rptitem.getIndexReportCollection();
                        for (int k = 0; k < indexrpts.size(); ++k) {
                            IndexReportItem indexItem = indexrpts.get(k);
                            if (2 != indexItem.getReportState() || indexItem.getNewIndex() == null || !indexItem.getNewIndex().getName().equalsIgnoreCase(idx.getName())) continue;
                            idxupdate = true;
                            break;
                        }
                        if (idxupdate) continue block0;
                        DBSchemaDAO.dropDBIndexExists(dbType, table, dbUpdateList, idx);
                        DBSchemaDAO.createDBIndexExists(dbType, table, dbUpdateList, idx);
                        continue block0;
                    }
                }
            }
            DBSchemaDAO.addSQLToList(12, table.getName(), newColumn.getName(), sql, dbUpdateList);
        }
    }

    public static void createPK(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DBSchemaDAO.createPK(DBUtils.getDbType(cn), table, dbUpdateList);
    }

    public static void createPKExists(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        String sql = "";
        StringBuffer col_cstr = null;
        if (table.getPrimaryKey() != null) {
            String pkname = DBSchemaDAO.truncateName(dbType, table.getPrimaryKey().getName());
            sql = "IF Not Exists(Select * From KSQL_CONSTRAINTS Where KSQL_CONS_TABNAME='" + table.getName() + "' AND KSQL_CONS_NAME='" + pkname + "') \n";
            sql = sql + "ALTER TABLE " + table.getName() + " ADD ";
            for (int i = 0; i < table.getPrimaryKey().getPKColumns().size(); ++i) {
                ColumnInfo col = table.getPrimaryKey().getPKColumns().get(i).getColumn();
                if (col_cstr == null) {
                    col_cstr = new StringBuffer("CONSTRAINT " + pkname + " PRIMARY KEY (" + col.getName());
                    continue;
                }
                col_cstr.append("," + col.getName());
            }
            if (col_cstr == null) {
                return;
            }
            col_cstr.append(")");
            sql = sql + col_cstr.toString();
            DBSchemaDAO.addSQLToList(13, table.getName(), pkname, sql, dbUpdateList);
        }
    }

    public static void createPK(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        String sql = "";
        StringBuffer col_cstr = null;
        if (table.getPrimaryKey() != null) {
            sql = "ALTER TABLE " + table.getName() + " ADD ";
            String pkname = DBSchemaDAO.truncateName(dbType, table.getPrimaryKey().getName());
            for (int i = 0; i < table.getPrimaryKey().getPKColumns().size(); ++i) {
                ColumnInfo col = table.getPrimaryKey().getPKColumns().get(i).getColumn();
                if (col_cstr == null) {
                    col_cstr = new StringBuffer("CONSTRAINT " + pkname + " PRIMARY KEY (" + col.getName());
                    continue;
                }
                col_cstr.append("," + col.getName());
            }
            if (col_cstr == null) {
                return;
            }
            col_cstr.append(")");
            sql = sql + col_cstr.toString();
            DBSchemaDAO.addSQLToList(13, table.getName(), pkname, sql, dbUpdateList);
        }
    }

    public static void dropPK(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DBSchemaDAO.dropPK(DBUtils.getDbType(cn), table, dbUpdateList);
    }

    public static void dropPKExists(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        if (table.getPrimaryKey() != null) {
            String pkname = DBSchemaDAO.truncateName(dbType, table.getPrimaryKey().getName());
            String sql = "IF Exists(Select * From KSQL_CONSTRAINTS Where KSQL_CONS_TABNAME='" + table.getName() + "' AND KSQL_CONS_NAME='" + pkname + "') \n";
            sql = sql + " ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + pkname;
            DBSchemaDAO.addSQLToList(1, pkname, sql, dbUpdateList);
        }
    }

    public static void dropPK(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        if (table.getPrimaryKey() != null) {
            String pkname = DBSchemaDAO.truncateName(dbType, table.getPrimaryKey().getName());
            String sql = "ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + pkname;
            DBSchemaDAO.addSQLToList(1, pkname, sql, dbUpdateList);
        }
    }

    public static void createDBIndex(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DBSchemaDAO.createDBIndex(DBUtils.getDbType(cn), table, dbUpdateList);
    }

    public static void createDBIndex(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        for (int i = 0; i < table.getIndexes().size(); ++i) {
            IndexInfo idx = table.getIndexes().get(i);
            DBSchemaDAO.createDBIndex(dbType, table, dbUpdateList, idx);
        }
    }

    public static void createDBIndexExists(int databaseType, AbstractTableInfo table, DBUpdateList dbUpdateList, IndexInfo idx) throws SQLException {
        String idxname = DBSchemaDAO.truncateName(databaseType, idx.getName());
        String existSql = "IF Not Exists(Select * From KSQL_INDEXES Where KSQL_INDNAME='" + idxname + "') \n";
        String idxsql = "";
        StringBuffer sqlStr = new StringBuffer(existSql);
        sqlStr.append(" CREATE " + (idx.isUnique() ? "UNIQUE" : "") + " INDEX " + idxname + " ON " + table.getName() + "(");
        if (idx.getIndexColumns() == null) {
            return;
        }
        boolean skipIndex = false;
        for (int j = 0; j < idx.getIndexColumns().size(); ++j) {
            IndexColumnInfo idxcol = idx.getIndexColumns().get(j);
            if (idxcol == null || idxcol.getColumn() == null) {
                skipIndex = true;
                break;
            }
            sqlStr.append(idxcol.getColumn().getName() + " " + idxcol.getSortType().getName() + ",");
        }
        boolean bHasAccentIndex = false;
        IndexScriptCollection idxscripts = idx.getScripts();
        if (idxscripts != null && idxscripts.size() > 0) {
            for (int k = 0; k < idxscripts.size(); ++k) {
                IndexScriptInfo idxScriptInfo = idxscripts.get(k);
                if (idxScriptInfo == null || !idxScriptInfo.isManual() || StringUtils.isEmpty((String)idxScriptInfo.getScript()) || databaseType != DbType.getValue((String)idxScriptInfo.getDBType().toString())) continue;
                idxsql = "";
                idxsql = existSql + idxScriptInfo.getScript();
                DBSchemaDAO.addSQLToList(15, table.getName(), idxname, idxsql, dbUpdateList, databaseType);
                bHasAccentIndex = true;
            }
        }
        if (!skipIndex && !bHasAccentIndex) {
            String sql = sqlStr.toString();
            sql = sql.substring(0, sql.length() - 1) + ")";
            DBSchemaDAO.addSQLToList(15, table.getName(), idxname, sql, dbUpdateList);
        }
    }

    public static void createDBIndex(int databaseType, AbstractTableInfo table, DBUpdateList dbUpdateList, IndexInfo idx) throws SQLException {
        String idxname = DBSchemaDAO.truncateName(databaseType, idx.getName());
        StringBuffer sqlStr = new StringBuffer("CREATE " + (idx.isUnique() ? "UNIQUE" : "") + " INDEX " + idxname + " ON " + table.getName() + "(");
        if (idx.getIndexColumns() == null) {
            return;
        }
        boolean skipIndex = false;
        for (int j = 0; j < idx.getIndexColumns().size(); ++j) {
            IndexColumnInfo idxcol = idx.getIndexColumns().get(j);
            if (idxcol == null || idxcol.getColumn() == null) {
                skipIndex = true;
                break;
            }
            sqlStr.append(idxcol.getColumn().getName() + " " + idxcol.getSortType().getName() + ",");
        }
        boolean bHasAccentIndex = false;
        IndexScriptCollection idxscripts = idx.getScripts();
        if (idxscripts != null && idxscripts.size() > 0) {
            for (int k = 0; k < idxscripts.size(); ++k) {
                IndexScriptInfo idxScriptInfo = idxscripts.get(k);
                if (idxScriptInfo == null || !idxScriptInfo.isManual() || StringUtils.isEmpty((String)idxScriptInfo.getScript()) || databaseType != DbType.getValue((String)idxScriptInfo.getDBType().toString())) continue;
                DBSchemaDAO.addSQLToList(15, table.getName(), idxname, idxScriptInfo.getScript(), dbUpdateList, databaseType);
                bHasAccentIndex = true;
            }
        }
        if (!skipIndex && !bHasAccentIndex) {
            String sql = sqlStr.toString();
            sql = sql.substring(0, sql.length() - 1) + ")";
            DBSchemaDAO.addSQLToList(15, table.getName(), idxname, sql, dbUpdateList);
        }
    }

    public static void dropDBIndex(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DBSchemaDAO.dropDBIndex(DBUtils.getDbType(cn), table, dbUpdateList);
    }

    public static void dropDBIndex(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        int n = table.getIndexes().size();
        for (int i = 0; i < n; ++i) {
            IndexInfo idx = table.getIndexes().get(i);
            DBSchemaDAO.dropDBIndex(dbType, table, dbUpdateList, idx);
        }
    }

    public static void dropDBIndexExists(int databaseType, AbstractTableInfo table, DBUpdateList dbUpdateList, IndexInfo idx) throws SQLException {
        String idxname = DBSchemaDAO.truncateName(databaseType, idx.getName());
        String sql = "";
        if (idx.isClusteredIndex() || idx.isUnique()) {
            sql = " IF Exists(Select * From KSQL_CONSTRAINTS Where KSQL_CONS_TABNAME='" + table.getName() + "' And KSQL_CONS_NAME='" + idxname + "') \n";
            sql = sql + " ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + idxname;
            DBSchemaDAO.addSQLToList(2, idxname, sql, dbUpdateList);
        }
        sql = "IF Exists(Select * From KSQL_INDEXES Where KSQL_INDNAME='" + idxname + "') \n";
        sql = sql + " Drop INDEX " + table.getName() + "." + idxname;
        DBSchemaDAO.addSQLToList(2, table.getName(), idxname, sql, dbUpdateList);
    }

    public static void dropDBIndex(int databaseType, AbstractTableInfo table, DBUpdateList dbUpdateList, IndexInfo idx) throws SQLException {
        String idxname = DBSchemaDAO.truncateName(databaseType, idx.getName());
        String sql = "";
        if (idx.isClusteredIndex() && idx.isUnique()) {
            sql = "ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + idxname;
        } else {
            if (idx.isUnique() && DBUtils.isOracle(databaseType)) {
                sql = " IF Exists(Select * From KSQL_CONSTRAINTS Where KSQL_CONS_TABNAME='" + table.getName() + "' And KSQL_CONS_NAME='" + idxname + "')   ALTER TABLE " + table.getName() + " DROP CONSTRAINT \"" + idxname + "\"";
                DBSchemaDAO.addSQLToList(2, idxname, sql, dbUpdateList);
            }
            sql = " Drop INDEX " + table.getName() + "." + idxname;
        }
        DBSchemaDAO.addSQLToList(2, table.getName(), idxname, sql, dbUpdateList);
    }

    public static void createDBView(String dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DataViewCollection dataViews = table.getDataViews();
        if (dataViews != null && dataViews.size() > 0) {
            for (int i = 0; i < dataViews.size(); ++i) {
                DataViewInfo dataView = dataViews.get(i);
                String viewSql = dataView.getScript();
                if (StringUtils.isEmpty((String)viewSql)) continue;
                DBSchemaDAO.addSQLToList(18, table.getName(), dataView.getName(), viewSql, dbUpdateList);
            }
        }
    }

    public static void dropDBView(String dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DataViewCollection dataViews = table.getDataViews();
        if (dataViews != null && dataViews.size() > 0) {
            for (int i = 0; i < dataViews.size(); ++i) {
                DataViewInfo dataView = dataViews.get(i);
                String viewName = dataView.getName();
                if (StringUtils.isEmpty((String)viewName)) continue;
                String viewSql = "drop view " + viewName;
                DBSchemaDAO.addSQLToList(7, table.getName(), dataView.getName(), viewSql, dbUpdateList);
            }
        }
    }

    public static void createFK(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DBSchemaDAO.createFK(DBUtils.getDbType(cn), table, dbUpdateList);
    }

    public static void createFK(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
    }

    public static void dropFK(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DBSchemaDAO.dropFK(DBUtils.getDbType(cn), table, dbUpdateList);
    }

    public static void dropFK(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        for (int i = 0; i < table.getForeignKeys().size(); ++i) {
            ForeignKeyInfo fkey = table.getForeignKeys().get(i);
            String fkeyname = DBSchemaDAO.truncateName(dbType, fkey.getName());
            String sql = "ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + fkeyname;
            DBSchemaDAO.addSQLToList(0, fkeyname, sql, dbUpdateList);
        }
    }

    public static void dropRefForeignKey(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        int type = DBUtils.getDbType(cn);
        if (DBUtils.isOracle(type)) {
            ORACLESchemaDAO.dropRefForeignKey(cn, table, dbUpdateList);
        } else if (3 == type) {
            SQLSERVERSchemaDAO.dropRefForeignKey(cn, table, dbUpdateList);
        }
    }

    public static void createRefForeignKey(Connection cn, AbstractTableInfo oldTable, AbstractTableInfo newTable, DBUpdateList dbUpdateList) throws SQLException {
        int type = DBUtils.getDbType(cn);
        if (DBUtils.isOracle(type)) {
            ORACLESchemaDAO.createRefForeignKey(cn, oldTable, newTable, dbUpdateList);
        } else if (3 == type) {
            SQLSERVERSchemaDAO.createRefForeignKey(cn, oldTable, newTable, dbUpdateList);
        }
    }

    protected static String getValueString(int sqlType, Object value) {
        if (sqlType == 1 || sqlType == 12) {
            if (value instanceof String && !StringUtils.isEmpty((String)((String)value)) && !"''".equals(value)) {
                return "'" + value + "'";
            }
            return "''";
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected static Object getDefaultValue(int sqlType) {
        switch (sqlType) {
            case -7: {
                return false;
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(0);
            }
            case -5: {
                return new Long(0L);
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(0.0);
            }
            case 2: 
            case 3: {
                return new BigDecimal(0.0);
            }
            case -1: 
            case 1: 
            case 12: {
                return "''";
            }
            case -3: 
            case -2: 
            case 2004: {
                return new byte[]{-128};
            }
            case 91: {
                return new Date(System.currentTimeMillis());
            }
            case 92: {
                Date date = new Date(System.currentTimeMillis());
                return new Time(date.getTime());
            }
            case 93: {
                Date timestamp = new Date(System.currentTimeMillis());
                return new Timestamp(timestamp.getTime());
            }
        }
        return null;
    }

    public static void copyDataToTempTable(Connection cn, TableReportItem tableReportItem, DBUpdateList dbUpdateList) throws SQLException {
        String databaseType = cn.getMetaData().getDatabaseProductName();
        if (databaseType == null) {
            return;
        }
        int type = DbType.getValue((String)databaseType);
        AbstractTableInfo newTable = tableReportItem.getNewTable();
        String oldTableName = tableReportItem.getOldTable().getName();
        String newTableName = newTable.getName();
        String tempTableName = tableReportItem.getTempTableName();
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("Create Table " + tempTableName + " ( ");
        for (int i = 0; i < newTable.getColumns().size(); ++i) {
            sqlStr.append(DBUtils.getColSQL(type, newTable.getColumns().get(i)) + ",");
        }
        String sqlTemp = sqlStr.toString();
        sqlTemp = sqlTemp.substring(0, sqlTemp.length() - 1) + " )";
        DBSchemaDAO.addSQLToList(5, tempTableName, sqlTemp, dbUpdateList);
        StringBuffer sqlIns = new StringBuffer("INSERT INTO " + tempTableName + "(");
        StringBuffer sqlSel = new StringBuffer(" SELECT ");
        int n = tableReportItem.getColumnReportCollection().size();
        for (int i = 0; i < n; ++i) {
            String columnName;
            ColumnReportItem item = tableReportItem.getColumnReportCollection().get(i);
            ColumnInfo newColumn = item.getNewColumn();
            if (item.getReportState() == 3) {
                columnName = newColumn.getName();
                sqlIns.append(columnName + ",");
                sqlSel.append(columnName + ",");
                continue;
            }
            if (item.getReportState() != 2) continue;
            columnName = newColumn.getName();
            sqlIns.append(columnName + ",");
            String sqlSelTemp = "";
            sqlSelTemp = item.isNull2NotNull() ? "ISNULL(" + columnName + "," + (newColumn.getDefaultValue() != null ? DBSchemaDAO.getValueString(newColumn.getSQLType(), newColumn.getDefaultValue()) : DBSchemaDAO.getValueString(newColumn.getSQLType(), DBSchemaDAO.getDefaultValue(newColumn.getSQLType()))) + ")" : columnName;
            if (item.getTypeConvertState() == 1 || item.getTypeConvertState() == 2 || item.getTypeConvertState() == 3) {
                sqlSelTemp = "TO_NUMBER(" + sqlSelTemp + ")";
            } else if (item.getTypeConvertState() == 4 || item.getTypeConvertState() == 5 || item.getTypeConvertState() == 6) {
                sqlSelTemp = "TO_INTEGER(" + sqlSelTemp + ")";
            } else if (item.getTypeConvertState() == 7 || item.getTypeConvertState() == 8 || item.getTypeConvertState() == 9) {
                sqlSelTemp = "TO_CHAR(" + sqlSelTemp + ")";
            } else if (item.getTypeConvertState() == 10 || item.getTypeConvertState() == 11 || item.getTypeConvertState() == 12) {
                sqlSelTemp = "TO_CHAR(" + sqlSelTemp + ")";
            }
            if (item.isLengthSub() && (newColumn.getTypeName() == SQLType.CHAR || newColumn.getTypeName() == SQLType.VARCHAR || newColumn.getTypeName() == SQLType.BINARY || newColumn.getTypeName() == SQLType.BLOB || newColumn.getTypeName() == SQLType.CLOB)) {
                int newLength = item.getNewColumn().getLength();
                sqlSelTemp = "SUBSTRING(" + sqlSelTemp + ",0," + (newLength - 1) + ")";
            }
            sqlSel.append(sqlSelTemp + ",");
        }
        String sqlI = sqlIns.toString();
        sqlI = sqlI.substring(0, sqlI.length() - 1) + ") ";
        String sqlS = sqlSel.toString();
        sqlS = sqlS.substring(0, sqlS.length() - 1) + " FROM " + oldTableName;
        String sql = sqlI + sqlS;
        DBSchemaDAO.addSQLToList(6, newTableName, sql, dbUpdateList);
    }

    public static void copyDataFromTempTable(Connection cn, TableReportItem tableReportItem, DBUpdateList dbUpdateList) throws SQLException {
        AbstractTableInfo newTable = tableReportItem.getNewTable();
        String newTableName = newTable.getName();
        String tempTableName = tableReportItem.getTempTableName();
        StringBuffer sqlIns = new StringBuffer("INSERT INTO " + newTableName + "(");
        StringBuffer sqlSel = new StringBuffer(" SELECT ");
        int n = tableReportItem.getColumnReportCollection().size();
        for (int i = 0; i < n; ++i) {
            ColumnReportItem item = tableReportItem.getColumnReportCollection().get(i);
            if (item.getReportState() != 3 && item.getReportState() != 2) continue;
            sqlIns.append(item.getNewColumn().getName() + ",");
            sqlSel.append(item.getNewColumn().getName() + ",");
        }
        String sqlI = sqlIns.toString();
        sqlI = sqlI.substring(0, sqlI.length() - 1) + ") ";
        String sqlS = sqlSel.toString();
        sqlS = sqlS.substring(0, sqlS.length() - 1) + " FROM " + tempTableName;
        String sql = sqlI + sqlS;
        String sqlTemp = "DROP Table " + tempTableName;
        sql = sql + SEI + NEWLINE + sqlTemp;
        DBSchemaDAO.addSQLToList(14, newTableName, sql, dbUpdateList);
    }

    protected static void addSQLToList(int type, String name, String sql, DBUpdateList dbUpdateList) throws SQLException {
        DBSchemaDAO.addSQLToList(type, "", name, sql, dbUpdateList);
    }

    protected static void addSQLToList(int type, String tableName, String name, String sql, DBUpdateList dbUpdateList, int databaseType) throws SQLException {
        DBUpdateInfo info = new DBUpdateInfo(type, tableName, name, sql, type);
        if (!dbUpdateList.containsInfo(info)) {
            dbUpdateList.addInfo(info);
        }
    }

    protected static void addSQLToList(int type, String tableName, String name, String sql, DBUpdateList dbUpdateList) throws SQLException {
        DBUpdateInfo info = new DBUpdateInfo(type, tableName, name, sql);
        if (!dbUpdateList.containsInfo(info)) {
            dbUpdateList.addInfo(info);
        }
    }

    private static String truncateName(int databaseType, String name) throws SQLException {
        String newName = name;
        if (databaseType == 1 && name.length() > 18) {
            newName = name.substring(0, 18);
        } else if (DBUtils.isOracle(databaseType) && name.length() > 30) {
            newName = name.substring(0, 30);
        }
        return newName;
    }

    public static void checkColumnChangeValid(Connection cn, TableReportItem tableReportItem) throws SQLException {
        int n = tableReportItem.getColumnReportCollection().size();
        for (int i = 0; i < n; ++i) {
            ColumnReportItem item = tableReportItem.getColumnReportCollection().get(i);
            if (item.getReportState() != 2 || DBUtils.isColumnChangeValid(cn, tableReportItem.getNewTable().getName(), item)) continue;
            item.setReportState(4);
            tableReportItem.setReportState(4);
        }
    }

    public static void checkKeyValid(Connection cn, TableReportItem tableReportItem) {
        ForeignKeyReportCollection fks;
        IndexReportCollection indexes;
        PrimaryKeyReportItem primaryKeyReportItem = tableReportItem.getPrimaryKeyReportItem();
        if (primaryKeyReportItem != null && primaryKeyReportItem.getNewPK() != null && primaryKeyReportItem.getNewPK().getName() != null && primaryKeyReportItem.getNewPK().getName().length() > 18) {
            primaryKeyReportItem.setReportState(4);
            tableReportItem.setReportState(4);
        }
        if ((indexes = tableReportItem.getIndexReportCollection()) != null) {
            int n = indexes.size();
            for (int i = 0; i < n; ++i) {
                IndexReportItem indexReportItem = indexes.get(i);
                if (indexReportItem == null || indexReportItem.getNewIndex() == null || indexReportItem.getNewIndex().getName() == null || indexReportItem.getNewIndex().getName().length() <= 18) continue;
                indexReportItem.setReportState(4);
                tableReportItem.setReportState(4);
            }
        }
        if ((fks = tableReportItem.getForeignKeyReportCollection()) != null) {
            int n = fks.size();
            for (int i = 0; i < n; ++i) {
                ForeignKeyReportItem fk = fks.get(i);
                if (fk == null || fk.getNewFK() == null || fk.getNewFK().getName() == null || fk.getNewFK().getName().length() <= 18) continue;
                fk.setReportState(4);
                tableReportItem.setReportState(4);
            }
        }
    }
}

