/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SqlServerDAOUtil {
    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        String sql = "/*dialect*/EXECUTE sp_tables ?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            return null;
        }
        String owner = rs.getString("TABLE_OWNER");
        AbstractTableInfo table = new AbstractTableInfo();
        table.setName(tableName);
        SqlServerDAOUtil.fillColumnInfo(cn, table, owner);
        SqlServerDAOUtil.fillPKInfo(cn, table, owner);
        SqlServerDAOUtil.fillIndexInfo(cn, table);
        SqlServerDAOUtil.fillFKInfo(cn, table, owner);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return table;
    }

    private static void fillColumnInfo(Connection cn, AbstractTableInfo table, String owner) throws SQLException {
        String tableName = table.getName();
        String sql = "/*dialect*/EXECUTE sp_columns ?,?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, owner});
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ColumnInfo col = new ColumnInfo();
            col.setName(rs.getString("Column_Name"));
            String typeName = StringUtils.replace((String)rs.getString("Type_Name"), (String)"identity", (String)"");
            SQLType dataType = SqlServerDAOUtil.getSQLType(typeName);
            if (dataType == null) {
                sql = "select t1.name from systypes t1,systypes t2 where t1.xusertype = t2.xtype and t2.name = ?";
                PreparedStatement substmt = DBUtils.createPreparedStatement(cn, sql, typeName);
                ResultSet subrs = substmt.executeQuery();
                if (subrs.next()) {
                    typeName = subrs.getString("name");
                    dataType = SqlServerDAOUtil.getSQLType(typeName);
                }
                SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            }
            if (dataType == null) {
                throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
            }
            col.setTypeName(dataType);
            if (typeName.equalsIgnoreCase("nchar") || typeName.equalsIgnoreCase("nvarchar")) {
                col.setLength(rs.getInt("Precision"));
            } else {
                col.setLength(rs.getInt("Length"));
            }
            String strDef = rs.getString("Column_Def");
            col.setDefaultValue(strDef);
            if (!StringUtils.isEmpty((String)strDef)) {
                sql = "/*dialect*/ Select t1.name From sysobjects t1 Inner join sysobjects t2 on t2.id=t1.parent_obj Inner join syscolumns t3 on t3.id =t2.id And t1.id =t3.cdefault\tWhere t3.name=? and t1.xtype='D' and t2.name=?";
                PreparedStatement substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{col.getName(), tableName});
                ResultSet subrs = substmt.executeQuery();
                if (subrs.next()) {
                    col.setExtendedProperty("defaultName", subrs.getString("name"));
                }
                SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            }
            col.setNullable(rs.getInt("Nullable") == 1);
            col.setPrecision(rs.getInt("Precision"));
            col.setScale(rs.getInt("Scale"));
            table.getColumns().add(col);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillPKInfo(Connection cn, AbstractTableInfo table, String owner) throws SQLException {
        String sql = "/*dialect*/EXECUTE sp_pkeys ?,?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, new String[]{table.getName(), owner});
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
            PrimaryKeyInfo pk = new PrimaryKeyInfo();
            pk.setName(rs.getString("PK_Name"));
            table.setPrimaryKey(pk);
            ColumnInfo col = DBUtils.getColumnByName(table, rs.getString("Column_Name"));
            PKColumnInfo pkcol = new PKColumnInfo();
            pkcol.setColumn(col);
            pk.getPKColumns().add(pkcol);
            while (rs.next()) {
                col = DBUtils.getColumnByName(table, rs.getString("Column_Name"));
                pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillIndexInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String sql = "/*dialect*/EXECUTE sp_helpindex ?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, table.getName());
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
        }
        catch (Exception ex) {
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return;
        }
        while (rs.next()) {
            String indexName = rs.getString("Index_Name");
            if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = new IndexInfo();
            index.setName(rs.getString("Index_Name"));
            index.setUnique(rs.getString("index_description").toUpperCase().indexOf("UNIQUE") > 0);
            String[] indexColumns = StringUtils.split((String)rs.getString("Index_Keys"), (String)",");
            for (int i = 0; i < indexColumns.length; ++i) {
                IndexColumnInfo indexColumn = new IndexColumnInfo();
                String columnName = StringUtils.replace((String)indexColumns[i], (String)"(-)", (String)"");
                indexColumn.setColumn(DBUtils.getColumnByName(table, columnName.trim()));
                if (!columnName.equals(indexColumns[i])) {
                    indexColumn.setSortType(SortType.DESCEND);
                }
                index.getIndexColumns().add(indexColumn);
            }
            table.getIndexes().add(index);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillFKInfo(Connection cn, AbstractTableInfo table, String owner) throws SQLException {
        String sql = "/*dialect*/EXECUTE sp_fkeys @fktable_name = ? ,@fktable_owner=?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, new String[]{table.getName(), owner});
        ResultSet rs = stmt.executeQuery();
        ForeignKeyInfo prevFK = null;
        while (rs.next()) {
            String fkName = rs.getString("FK_Name");
            FKColumnPairInfo fkcol = new FKColumnPairInfo();
            fkcol.setForeignKeyColumn(DBUtils.getColumnByName(table, rs.getString("FKColumn_Name")));
            ColumnInfo pkcolumn = new ColumnInfo();
            pkcolumn.setName(rs.getString("PKColumn_Name"));
            fkcol.setPrimaryKeyColumn(pkcolumn);
            if (prevFK != null && prevFK.getName().equals(fkName)) {
                prevFK.getFKColumnPairs().add(fkcol);
                continue;
            }
            prevFK = new ForeignKeyInfo();
            AbstractTableInfo refTable = new AbstractTableInfo();
            refTable.setName(rs.getString("PKTable_Name"));
            prevFK.setRefTable(refTable);
            prevFK.setName(fkName);
            prevFK.getFKColumnPairs().add(fkcol);
            table.getForeignKeys().add(prevFK);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    protected static SQLType getSQLType(String typeName) {
        if (typeName.equals("char")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("nchar")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("varchar")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("nvarchar")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("text")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("ntext")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("sysname")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("binary")) {
            return SQLType.BINARY;
        }
        if (typeName.equals("varbinary")) {
            return SQLType.VARBINARY;
        }
        if (typeName.equals("image")) {
            return SQLType.BLOB;
        }
        if (typeName.equals("bigint")) {
            return SQLType.INT;
        }
        if (typeName.equals("int")) {
            return SQLType.INT;
        }
        if (typeName.equals("smallint")) {
            return SQLType.INT;
        }
        if (typeName.equals("tinyint")) {
            return SQLType.INT;
        }
        if (typeName.equals("bit")) {
            return SQLType.INT;
        }
        if (typeName.equals("real")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("float")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("money")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("smallmoney")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("numeric")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("decimal")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("datetime")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("smalldatetime")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("timestamp")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("GUID")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("uniqueidentifier")) {
            return SQLType.CHAR;
        }
        LogTool.logError("Unknown SQL TYPE:" + typeName + ", Treat as NVARCHAR", new Exception("Unknown SQL TYPE"));
        return SQLType.NVARCHAR;
    }

    public static void adjustTables(Connection cn, AbstractTableInfo[] tables) throws SQLException {
        for (int i = 0; i < tables.length; ++i) {
            SqlServerDAOUtil.adjustTable(cn, tables[i]);
        }
    }

    public static void adjustTable(Connection cn, AbstractTableInfo table) throws SQLException {
    }
}

