/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dialog.mutillang;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.stconvert.STConverter;
import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.common.TranslateUtil;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.console.UserStreamManager;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.tool.dialog.internal.PackageContentProvider;
import com.kingdee.bos.tool.dialog.internal.PackageLabelProvider;
import com.kingdee.bos.tool.dialog.mutillang.Messages;
import com.kingdee.bos.tool.dialog.mutillang.MultiLangPanel;
import com.kingdee.bos.tool.filters.MetaDataTypeFilter;
import com.kingdee.bos.tool.sorters.MetaDataTypeSorter;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class MultiLangManageDialog
extends TitleAreaDialog {
    private Tree tree;
    private TreeViewer treeViewer;
    private Combo typeCombo;
    private MultiLangPanel panel;
    private IFile file;
    private Map map = new HashMap();
    private LanguageCollection languages;
    private IMDObject resource;
    private MetaDataTypeFilter filter;
    private int currentSelection;
    private List fileList = new ArrayList();
    private List failMessages = new ArrayList();
    private boolean override = false;
    private StructuredSelection sele;
    private static final String[] TYPE_NAME = new String[]{TranslateUtil.ALL_METADATA, TranslateUtil.BUSINESS_EXCEPTION, TranslateUtil.ENUMERATE_OBJECT, TranslateUtil.ENTITY_OBJECT, TranslateUtil.DATA_OBJECT, TranslateUtil.JOIN_QUERY_OBJECT, TranslateUtil.MDQUERY_OBJECT, TranslateUtil.FACADE_OBJECT, TranslateUtil.RELATION_DEFINE, TranslateUtil.RULE_DEFINE, TranslateUtil.BIZDATA_TYPE, TranslateUtil.BUSINESS_WORKING, TranslateUtil.PACKAGE_NAME, "UI", Messages.MultiLangManageDialog_QuanBuBuHanUI};
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dialog.mutillang.MultiLangManageDialog");

    public MultiLangManageDialog(Shell shell, IMDObject resource) {
        super(shell);
        this.resource = resource;
    }

    protected void okPressed() {
        if (this.file != null) {
            this.save(this.file);
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        Composite composite = new Composite(container, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 540;
        gd.widthHint = 900;
        composite.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        SashForm form = new SashForm(composite, 256);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        form.setLayoutData((Object)gd);
        Group group = new Group((Composite)form, 0);
        group.setText(Messages.MultiLangManageDialog_YuanShuJu);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.MultiLangManageDialog_GuoLv);
        this.typeCombo = new Combo((Composite)group, 12);
        this.typeCombo.setLayoutData((Object)new GridData(768));
        this.tree = new Tree((Composite)group, 2820);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.tree.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        PackageContentProvider contentProvider = new PackageContentProvider();
        contentProvider.setProject(MDResourceUtil.toIProject(this.resource.getMDProject()));
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        String[] suffixes = new String[MetaDataTypeFilter.getAllSuffixes().length];
        int index = 0;
        for (int i = 0; i < MetaDataTypeFilter.getAllSuffixes().length; ++i) {
            suffixes[index++] = MetaDataTypeFilter.getAllSuffixes()[i];
        }
        this.filter = new MetaDataTypeFilter(suffixes);
        this.treeViewer.addFilter((ViewerFilter)this.filter);
        this.treeViewer.setSorter((ViewerSorter)new MetaDataTypeSorter());
        this.initModle();
        this.panel = new MultiLangPanel((Composite)form, 0, this.languages);
        this.panel.setDefaultProviderAndCellModifier();
        this.panel.setDefaultViewerSorter();
        form.setWeights(new int[]{28, 72});
        this.typeCombo.addSelectionListener((SelectionListener)new ItemSelectionListener());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeViewerSelectionChangedAdapter());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.resource));
        form.setFocus();
        this.panel.getViewer().getTableTree().setFocus();
        return container;
    }

    private void initModle() {
        this.typeCombo.setItems(TYPE_NAME);
        this.typeCombo.select(0);
        this.currentSelection = 0;
        SolutionInfo solution = this.getSolution();
        if (solution == null) {
            return;
        }
        this.languages = solution.getLanguages();
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.filter.setSuffixes(MetaDataTypeFilter.getAllSuffixes());
        this.treeViewer.refresh();
    }

    private SolutionInfo getSolution() {
        return this.resource.getMDProject().getSolutionInfo();
    }

    private void initTable(IFile f) {
        if (f == null) {
            return;
        }
        this.checkEditorDirty(f);
        try {
            BOSObjectType type = BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)f.getFileExtension()));
            IFolder folder = ORMStudioBridger.getFolder((IResource)f);
            IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(folder);
            IMetaDataPK pk = ORMStudioBridger.getFilePK((IResource)f);
            this.map = loader.loadResource(type, pk);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MultiLangManageDialog_CuoWu, (String)Messages.MultiLangManageDialog_WuFaZhuangZaiXuanZeDeYuanShuJu);
        }
        this.panel.setInput(this.map);
    }

    private void checkEditorDirty(IFile file) {
        IEditorPart part = EditorHelper.findEditor(MDResourceUtil.toMDFile(file));
        if (part != null) {
            boolean save;
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (part.isDirty() && (save = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MultiLangManageDialog_QueRen, (String)Messages.MultiLangManageDialog_DuiXiangYiJingZaiBianJiQiZhongBeiXiuGaiShiFouXianBaoCun))) {
                part.doSave(null);
            }
            workbenchPage.closeEditor(part, false);
        }
    }

    private void save(IFile f) {
        try {
            IFolder folder = ORMStudioBridger.getFolder((IResource)f);
            IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(folder);
            BOSObjectType type = BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)f.getFileExtension()));
            IMetaDataPK pk = ORMStudioBridger.getFilePK((IResource)f);
            loader.saveResource(type, pk, this.map);
            IEditorPart part = EditorHelper.findEditor(MDResourceUtil.toMDFile(f));
            if (part != null && part instanceof IMDSourceEditor) {
                ((IMDSourceEditor)part).refreshPages();
            }
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MultiLangManageDialog_CuoWu, (String)Messages.MultiLangManageDialog_BaoCunDuoYuYanXinXiShiBai);
        }
    }

    private void setTWChineseAuto(IProgressMonitor monitor) {
        final long time1 = System.currentTimeMillis();
        this.fileList.clear();
        this.initFileList(this.sele);
        int laSize = this.languages.size();
        String cnPostFix = null;
        String hkPostFix = null;
        String twPostFix = null;
        String enPostFix = null;
        for (int j = 0; j < laSize; ++j) {
            LanguageInfo lInfo = this.languages.get(j);
            String localStr = lInfo.getLocaleString();
            if (localStr.equals("zh_CN")) {
                cnPostFix = localStr;
                continue;
            }
            if (localStr.equals("zh_TW")) {
                twPostFix = localStr;
                continue;
            }
            if (localStr.equals("zh_HK")) {
                hkPostFix = localStr;
                continue;
            }
            if (!localStr.equals("en_US")) continue;
            enPostFix = localStr;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        int fileSize = this.fileList.size();
        boolean everBeenOne = false;
        IFile everBeenOneFile = null;
        if (fileSize == 1) {
            everBeenOne = true;
            everBeenOneFile = (IFile)this.fileList.get(0);
            final IFolder con = (IFolder)everBeenOneFile.getParent();
            this.fileList.clear();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MultiLangManageDialog.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)con));
                }
            });
            this.initFileList(new StructuredSelection((Object)con));
            fileSize = this.fileList.size();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int div = fileSize / 10;
        if (fileSize <= 10) {
            div = 1;
        } else if (fileSize >= 200) {
            div = fileSize / 100;
        }
        monitor.beginTask(Messages.MultiLangManageDialog_ZhengZaiZhuanHuan, 100);
        monitor.worked(0);
        this.failMessages.clear();
        for (int i = 0; i < fileSize && !monitor.isCanceled(); ++i) {
            final IFile f = (IFile)this.fileList.get(i);
            if (everBeenOne && !f.equals(everBeenOneFile)) continue;
            Map<String, HashMap> tempmap = new HashMap();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MultiLangManageDialog.this.checkEditorDirty(f);
                }
            });
            try {
                BOSObjectType type = BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)f.getFileExtension()));
                IFolder folder = ORMStudioBridger.getFolder((IResource)f);
                IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(folder);
                IMetaDataPK pk = ORMStudioBridger.getFilePK((IResource)f);
                tempmap = loader.loadResource(type, pk);
                Set keys = tempmap.keySet();
                for (String key : keys) {
                    if (key.indexOf("extendedProperty") != -1) continue;
                    HashMap values = (HashMap)tempmap.get(key);
                    String sc = (String)values.get(cnPostFix);
                    String hk = (String)values.get(hkPostFix);
                    String tw = (String)values.get(twPostFix);
                    String en = (String)values.get(enPostFix);
                    if (sc != null && !sc.equals("")) {
                        String tc = STConverter.sc2tc((String)sc);
                        if (hkPostFix != null && (hk == null || hk.equals("") || this.override)) {
                            values.put(hkPostFix, tc);
                        }
                        if (twPostFix != null && (tw == null || tw.equals("") || this.override)) {
                            values.put(twPostFix, tc);
                        }
                        if (enPostFix != null && (en == null || en.equals("")) && !this.chineseCheck(sc) && f.getFileExtension().equals("ui")) {
                            values.put(enPostFix, sc);
                        }
                    }
                    tempmap.put(key, values);
                }
            }
            catch (Exception e) {
                logger.debug((Object)"", (Throwable)e);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)MultiLangManageDialog.this.getShell(), (String)Messages.MultiLangManageDialog_CuoWu, (String)Messages.MultiLangManageDialog_WuFaZhuangZaiXuanZeDeYuanShuJu);
                    }
                });
            }
            if (!everBeenOne) {
                this.savenew(f, tempmap);
            } else if (f.equals(everBeenOneFile)) {
                this.savenew(f, tempmap);
            }
            if (fileSize <= 200 && i % div == 0 && i != 0) {
                monitor.worked(10);
                continue;
            }
            if (fileSize <= 200 || i % div != 0 || i == 0) continue;
            monitor.worked(1);
        }
        if (everBeenOne) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MultiLangManageDialog.this.treeViewer.setSelection((ISelection)MultiLangManageDialog.this.sele);
                }
            });
        }
        final int size = this.failMessages.size();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ToolCommonPlugin.showConsole();
                ConsoleMsgPrinter printer = new ConsoleMsgPrinter(Messages.MultiLangManageDialog_ZiDongSheZhiFanTiZhongWen);
                for (int i = 0; i < size; ++i) {
                    String msg = (String)MultiLangManageDialog.this.failMessages.get(i);
                    printer.printError(msg);
                }
                long time2 = System.currentTimeMillis();
                long time3 = time2 - time1;
                printer.printInfo(Messages.MultiLangManageDialog_HaoShi + time3 + Messages.MultiLangManageDialog_HaoMiao);
                printer.close();
            }
        });
        monitor.worked(5);
        monitor.done();
    }

    private void initFileList(StructuredSelection selection) {
        if (selection == null) {
            return;
        }
        try {
            IResource resource = (IResource)selection.getFirstElement();
            if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IResource[] members = folder.members();
                for (int i = 0; i < members.length; ++i) {
                    IResource temp = members[i];
                    this.initFileList(new StructuredSelection((Object)temp));
                }
            } else if (resource instanceof IFile) {
                if (resource.getFileExtension() != null) {
                    Collection col;
                    String sType = Utils.getBOSTypeBySuffix((String)resource.getFileExtension());
                    BOSObjectType type = null;
                    if (sType != null) {
                        type = BOSObjectType.create((String)sType);
                    }
                    if (type != null && (col = this.filter.getSuffixes()).contains(resource.getFileExtension())) {
                        this.fileList.add(resource);
                    }
                }
            } else if (resource instanceof IProject) {
                IProject pro = (IProject)resource;
                IResource[] members = pro.members();
                for (int i = 0; i < members.length; ++i) {
                    IResource temp = members[i];
                    this.initFileList(new StructuredSelection((Object)temp));
                }
            }
        }
        catch (CoreException e) {
            logger.debug((Object)"error", (Throwable)e);
        }
    }

    private boolean chineseCheck(String str) {
        byte[] bytes = str.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] > 0) continue;
            return true;
        }
        return false;
    }

    private void savenew(final IFile f, Map _map) {
        try {
            IFolder folder = ORMStudioBridger.getFolder((IResource)f);
            IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(folder);
            BOSObjectType type = BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)f.getFileExtension()));
            IMetaDataPK pk = ORMStudioBridger.getFilePK((IResource)f);
            loader.saveResource(type, pk, _map);
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IEditorPart part = EditorHelper.findEditor(MDResourceUtil.toMDFile(f));
                    if (part != null && part instanceof IMDSourceEditor) {
                        ((IMDSourceEditor)part).refreshPages();
                    }
                }
            });
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            this.failMessages.add(Messages.MultiLangManageDialog_BaoCunDuoYuYanXinXiShiBaiWenJian + f.getFullPath());
        }
    }

    class InternalJob
    extends Job {
        public InternalJob() {
            super("");
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            MultiLangManageDialog.this.setTWChineseAuto(monitor);
            return Status.OK_STATUS;
        }
    }

    class ConsoleMsgPrinter {
        IUserStream stream = null;

        public ConsoleMsgPrinter(String s) {
            String id = s + " (" + DateTimeUtils.format((Date)new Date(System.currentTimeMillis())) + ")";
            this.stream = ToolBasePlugin.getDefault().getUserStream(id);
        }

        public void printInfo(String s) {
            Color c = UserStreamManager.NORMAL_COLOR;
            this.stream.println(s, c);
        }

        public void printError(String s) {
            Color c = UserStreamManager.ERROR_COLOR;
            this.stream.println(s, c);
        }

        public void close() {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    private class TreeViewerSelectionChangedAdapter
    implements ISelectionChangedListener {
        private TreeViewerSelectionChangedAdapter() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (MultiLangManageDialog.this.file != null) {
                MultiLangManageDialog.this.save(MultiLangManageDialog.this.file);
            }
            if ((selection = (IStructuredSelection)MultiLangManageDialog.this.treeViewer.getSelection()).isEmpty() || !(selection.getFirstElement() instanceof IFile)) {
                MultiLangManageDialog.this.file = null;
                MultiLangManageDialog.this.panel.setInput(new HashMap());
            } else {
                MultiLangManageDialog.this.file = (IFile)selection.getFirstElement();
                MultiLangManageDialog.this.initTable(MultiLangManageDialog.this.file);
            }
        }
    }

    private class ItemSelectionListener
    extends SelectionAdapter {
        private ItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (MultiLangManageDialog.this.typeCombo.getSelectionIndex() != -1 && MultiLangManageDialog.this.typeCombo.getSelectionIndex() != MultiLangManageDialog.this.currentSelection) {
                MultiLangManageDialog.this.currentSelection = MultiLangManageDialog.this.typeCombo.getSelectionIndex();
                switch (MultiLangManageDialog.this.currentSelection) {
                    case 0: {
                        MultiLangManageDialog.this.filter.setSuffixes(MetaDataTypeFilter.getAllSuffixes());
                        break;
                    }
                    case 1: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"exception"});
                        break;
                    }
                    case 2: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"enum"});
                        break;
                    }
                    case 3: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"entity"});
                        break;
                    }
                    case 4: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"table"});
                        break;
                    }
                    case 5: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"query"});
                        break;
                    }
                    case 6: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"mdquery"});
                        break;
                    }
                    case 7: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"facade"});
                        break;
                    }
                    case 8: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"relation"});
                        break;
                    }
                    case 9: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"rule"});
                        break;
                    }
                    case 10: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"bizdatatype"});
                        break;
                    }
                    case 11: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"bizunit"});
                        break;
                    }
                    case 12: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"package"});
                        break;
                    }
                    case 13: {
                        MultiLangManageDialog.this.filter.setSuffixes(new String[]{"ui"});
                        break;
                    }
                    default: {
                        MultiLangManageDialog.this.filter.setSuffixes(MetaDataTypeFilter.getAllWithoutUISuffixes());
                    }
                }
                MultiLangManageDialog.this.treeViewer.refresh();
            }
        }
    }
}

