/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.multipageeditor.IMDFileEditorInput;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.multipageeditor.ExceptionHandler;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.tool.xmleditor.XMLPartitionScanner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class MEditorDocumentProvider
extends FileDocumentProvider {
    IMDSourceEditor editor;
    IDocument document;

    public MEditorDocumentProvider(IMDSourceEditor editor) {
        this.editor = editor;
    }

    public void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        this.editor.doSave(monitor);
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            document.addDocumentListener(this.editor.getDocumentListener());
        }
        this.document = document;
        return document;
    }

    public void setDocumentContent(IEditorInput input) {
        try {
            IDocument document = super.getDocument((Object)input);
            document.set(this.getString(this.editor.getModel()));
        }
        catch (Exception ce) {
            ExceptionHandler.showException(ce);
        }
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void refresh() {
        try {
            String xml = this.getString(this.editor.getModel());
            if (this.document != null) {
                this.document.set(xml);
            }
        }
        catch (Exception e) {
            LogTool.logError("", e);
        }
    }

    public boolean canSaveDocument(Object element) {
        return this.editor.isDirty();
    }

    public boolean isModifiable(Object element) {
        return !this.editor.isReadOnly();
    }

    public boolean isReadOnly(Object arg0) {
        return this.editor.isReadOnly();
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (editorInput instanceof IMDFileEditorInput) {
            IMDFile file = ((IMDFileEditorInput)editorInput).getFile();
            InputStream contentStream = null;
            try {
                contentStream = file.getContent();
                this.setDocumentContent(document, contentStream, encoding);
            }
            catch (IOException ex) {
                String message = ex.getMessage() != null ? ex.getMessage() : "";
                Status s = new Status(4, "org.eclipse.ui", 0, message, (Throwable)ex);
                throw new CoreException((IStatus)s);
            }
            finally {
                try {
                    contentStream.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    private String getString(IObjectValue model) throws IDEException {
        IDevMetadataLoader loader = this.editor.getMDProject().getMetadataLoader();
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        try {
            loader.export2Stream(model.getBOSType(), (IMetaDataPK)this.editor.getMDFile().getMetaDataPK(), (OutputStream)out);
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            throw new IDEException("", (Throwable)e);
        }
    }

    protected String getPersistedEncoding(Object element) {
        IMDFileEditorInput input;
        if (element instanceof IEditorInput && (input = EditorHelper.transEditor((IEditorInput)element)) != null && input.getFile().getBOSType() != null) {
            return "UTF-8";
        }
        return super.getPersistedEncoding(element);
    }
}

