/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.tool.dao.ObjectValueHelper;
import com.kingdee.bos.tool.multipageeditor.BasePage;
import com.kingdee.bos.tool.multipageeditor.BasePageSection;
import com.kingdee.bos.tool.multipageeditor.Messages;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class TableWithButtonsSection
extends BasePageSection {
    protected Table table;
    protected TableViewer tableViewer;
    protected int tableStyle = 66304;
    protected Hashtable buttons = new Hashtable();
    protected String[] buttonNames;
    protected int sectionHeightSpan = 1;
    protected String[] columnNames;
    protected String[] keyNames;
    protected boolean fixColumn;
    protected int[] columnWidth;
    protected String elementName;
    protected SelectionListener btnListener = new InnerSelectionAdapter();
    protected ITableLabelProvider labProvider = new InnerLabelProvider();
    protected IStructuredContentProvider contentProvider = new InnerContentProvider();
    protected int tableHeightHint = -1;
    protected int buttonWidthHint = 80;
    protected int type = 256;
    public final String ADD = Messages.TableWithButtonsSection_ZengJia;
    public final String REMOVE = Messages.TableWithButtonsSection_ShanChu;
    public final String EDIT = Messages.TableWithButtonsSection_BianJi;
    public final String UP = Messages.TableWithButtonsSection_XiangShang;
    public final String DOWN = Messages.TableWithButtonsSection_XiangXia;
    public final String SEARCH = Messages.TableWithButtonsSection_SouSuo;
    public final String FILTER = "\u5b9a\u4f4d";

    public TableWithButtonsSection(BasePage page, String title, String desc) {
        super(page, title, desc);
    }

    public void setTableHeithtHint(int i) {
        this.tableHeightHint = i;
    }

    public int getTableHeithtHint() {
        return this.tableHeightHint;
    }

    public void setSectionHeightSpan(int i) {
        this.sectionHeightSpan = i;
    }

    public int getSectionHeightSpan() {
        return this.sectionHeightSpan;
    }

    public void setType(int type) {
        if (type == 256 || type != 512) {
            // empty if block
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setButtonWidthHint(int i) {
        this.buttonWidthHint = i;
    }

    public int getButtonWidthHint() {
        return this.buttonWidthHint;
    }

    public void setButtonNames(String[] buttonNames) {
        this.buttonNames = new String[buttonNames.length];
        System.arraycopy(buttonNames, 0, this.buttonNames, 0, buttonNames.length);
    }

    public String[] getButtonNames() {
        return this.buttonNames;
    }

    public Button getButtonBy(String buttonName) {
        return (Button)this.buttons.get(buttonName);
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = new String[columnNames.length];
        System.arraycopy(columnNames, 0, this.columnNames, 0, columnNames.length);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnWidth(int[] columnWidth) {
        this.columnWidth = new int[columnWidth.length];
        System.arraycopy(columnWidth, 0, this.columnWidth, 0, columnWidth.length);
    }

    public int[] getColumnWidth() {
        return this.columnWidth;
    }

    public void setKeyNames(String[] keyNames) {
        this.keyNames = new String[keyNames.length];
        System.arraycopy(keyNames, 0, this.keyNames, 0, keyNames.length);
    }

    public String[] getKeyNames() {
        return this.keyNames;
    }

    public void setTableStyle(int i) {
        this.tableStyle = i;
    }

    public int getTableStyle() {
        return this.tableStyle;
    }

    public boolean isFixColumn() {
        return this.fixColumn;
    }

    public void setFixColumn(boolean needFixColumn) {
        this.fixColumn = needFixColumn;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected abstract void handleButtonClicked(String var1, Button var2, SelectionEvent var3);

    protected abstract void beforeCreateWidgets(Composite var1);

    protected abstract void afterCreateWidgets(Composite var1);

    protected Image getColumnImage(IObjectValue element, String key) {
        return null;
    }

    protected String getColumnText(IObjectValue value, String key) {
        String result = value.getString(key);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    protected Composite createClient(Composite parent) {
        super.createClient(parent);
        Composite container = this.widgetFactory.createComposite(parent);
        GridData griddata = new GridData(1808);
        griddata.widthHint = 200;
        container.setLayoutData((Object)griddata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.beforeCreateWidgets(container);
        this.setHSpan(this.sectionHeightSpan);
        Composite tableArea = this.widgetFactory.createComposite(container);
        griddata = new GridData(1808);
        tableArea.setLayoutData((Object)griddata);
        layout = new GridLayout();
        layout.numColumns = this.type == 256 ? 2 : 1;
        tableArea.setLayout((Layout)layout);
        this.createTable(tableArea);
        this.createButtons(tableArea);
        this.afterCreateWidgets(container);
        this.widgetFactory.paintBordersFor(container);
        return container;
    }

    protected Composite createTable(Composite container) {
        int j = 1;
        if (this.columnNames.length != 1) {
            j = this.columnNames.length * 2 + 1;
        }
        Composite composite = this.widgetFactory.createComposite(container);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 1;
        gl.marginWidth = 1;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.table = this.widgetFactory.createTable(composite, 68352);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout tablelayout = new TableLayout();
        boolean resizable = true;
        for (int k = 0; k < this.columnNames.length; ++k) {
            TableColumn tablecolumn = new TableColumn(this.table, 0);
            tablecolumn.setText(this.columnNames[k]);
            tablecolumn.setWidth(this.columnNames[k].length() * 24);
            tablecolumn.setResizable(resizable);
            ColumnWeightData obj = new ColumnWeightData(100, this.columnNames.length * 100, resizable);
            tablelayout.addColumnData((ColumnLayoutData)obj);
        }
        gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.keyNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
            editors[i] = textEditor;
        }
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labProvider);
        this.tableViewer.setInput((Object)this.getInputElement());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)new InnerSelectionChangedListener());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableWithButtonsSection.this.handleTableDoubleClicked(event);
            }
        });
        return composite;
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
    }

    protected void handleTableDoubleClicked(DoubleClickEvent event) {
    }

    protected void createButtons(Composite container) {
        Composite btnContainer = this.widgetFactory.createComposite(container);
        GridData data = new GridData();
        if (this.type == 256) {
            data.widthHint = this.buttonWidthHint;
        }
        btnContainer.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        if (this.type == 256) {
            layout.numColumns = 1;
            layout.marginWidth = 2;
            layout.marginHeight = 2;
        } else {
            layout.numColumns = this.buttonNames.length;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        btnContainer.setLayout((Layout)layout);
        GridData buttonAreaGD = new GridData(1040);
        btnContainer.setLayoutData((Object)buttonAreaGD);
        for (int i = 0; i < this.buttonNames.length; ++i) {
            Button btn = this.widgetFactory.createButton(btnContainer, this.buttonNames[i], 8);
            this.buttons.put(this.buttonNames[i], btn);
            data = new GridData();
            if (this.type == 256) {
                data.horizontalAlignment = 4;
            } else {
                data.widthHint = this.buttonWidthHint;
            }
            btn.setLayoutData((Object)data);
            btn.addSelectionListener(this.btnListener);
        }
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        if (this.isReadOnly()) {
            return;
        }
        if (this.contextContainer != null) {
            if (this.contextContainer.getObjectValue() == null) {
                for (int i = 0; i < this.buttonNames.length; ++i) {
                    this.getButtonBy(this.buttonNames[i]).setEnabled(false);
                }
            } else {
                for (int i = 0; i < this.buttonNames.length; ++i) {
                    this.getButtonBy(this.buttonNames[i]).setEnabled(true);
                }
            }
        }
        this.refreshTable();
    }

    protected void refreshTable() {
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)this.getInputElement());
        }
    }

    protected IObjectCollection getInputElement() {
        IObjectValue ov = this.getModel();
        if (this.contextContainer != null) {
            ov = this.contextContainer.getObjectValue();
        }
        if (ov == null) {
            return null;
        }
        try {
            return (IObjectCollection)ObjectValueHelper.getObjectFromModel(ov, this.elementName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected IObjectValue[] getSelectedObjects() {
        return (IObjectValue[])((StructuredSelection)this.tableViewer.getSelection()).toArray();
    }

    protected IObjectValue getSelectedObject() {
        return (IObjectValue)((StructuredSelection)this.tableViewer.getSelection()).getFirstElement();
    }

    private class InnerSelectionChangedListener
    implements ISelectionChangedListener {
        private InnerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TableWithButtonsSection.this.handleSelectionChanged(event);
        }
    }

    private class InnerSelectionAdapter
    extends SelectionAdapter {
        private InnerSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button btn = (Button)e.getSource();
            Enumeration enu = TableWithButtonsSection.this.buttons.keys();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                if (btn != TableWithButtonsSection.this.buttons.get(key)) continue;
                TableWithButtonsSection.this.handleButtonClicked(key, btn, e);
                break;
            }
        }
    }

    private class InnerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private InnerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return TableWithButtonsSection.this.getColumnImage((IObjectValue)element, TableWithButtonsSection.this.keyNames[columnIndex]);
        }

        public String getColumnText(Object element, int columnIndex) {
            return TableWithButtonsSection.this.getColumnText((IObjectValue)element, TableWithButtonsSection.this.keyNames[columnIndex]);
        }
    }

    private class InnerContentProvider
    implements IStructuredContentProvider {
        private InnerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            IObjectCollection obj = (IObjectCollection)inputElement;
            Object[] objs = new Object[obj.size()];
            for (int i = 0; i < obj.size(); ++i) {
                objs[i] = obj.getObject(i);
            }
            return objs;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

