/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.views.verify;

import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.tool.views.verify.VerifyMessageEntry;
import com.kingdee.bos.util.BOSObjectType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CheckReport
implements ICheckReport {
    private Collection items = new LinkedList();
    private HashMap itemFolderMap = new HashMap();
    private List checkReportChangeListeners = new ArrayList();

    public Collection getItems() {
        return this.items;
    }

    public void addItem(CheckReportItem item) {
        if (!this.itemExist(item)) {
            this.items.add(item);
        }
        this.fireCheckReportChange();
    }

    public void clearItems() {
        this.items.clear();
        this.itemFolderMap.clear();
        this.fireCheckReportChange();
    }

    public void addCheckReportChangeListener(PropertyChangeListener listener) {
        if (!this.checkReportChangeListeners.contains(listener)) {
            this.checkReportChangeListeners.add(listener);
        }
    }

    public void removeCheckReportChangeListener(PropertyChangeListener listener) {
        if (this.checkReportChangeListeners.contains(listener)) {
            this.checkReportChangeListeners.remove(listener);
        }
    }

    private void fireCheckReportChange() {
        int size = this.checkReportChangeListeners.size();
        for (int i = 0; i < size; ++i) {
            PropertyChangeListener listener = (PropertyChangeListener)this.checkReportChangeListeners.get(i);
            PropertyChangeEvent event = new PropertyChangeEvent(this.items, "itemchange", this.items, this.items);
            listener.propertyChange(event);
        }
    }

    private boolean itemExist(CheckReportItem item) {
        if (item == null) {
            return false;
        }
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            boolean keyflag = false;
            boolean stateflag = false;
            boolean strflag = false;
            boolean nameflag = false;
            boolean mdTypeflag = false;
            boolean levelflag = false;
            CheckReportItem temp = (CheckReportItem)it.next();
            if (temp == null) continue;
            if (item.getKey() != null && temp.getKey() != null && item.getKey().equals(temp.getKey())) {
                keyflag = true;
            } else if (item.getKey() == null && temp.getKey() == null) {
                keyflag = true;
            }
            if (item.getState() == temp.getState()) {
                stateflag = true;
            }
            String[] itemStr = item.getMessages();
            String[] tempStr = temp.getMessages();
            if (itemStr != null && tempStr != null && tempStr.length == itemStr.length) {
                boolean hasBreak = false;
                for (int i = 0; i < tempStr.length; ++i) {
                    if (tempStr[i].equals(itemStr[i])) continue;
                    hasBreak = true;
                    break;
                }
                strflag = !hasBreak;
            }
            IMetaDataPK itemMDPK = item.getMetaDataPK();
            IMetaDataPK tempMDPK = temp.getMetaDataPK();
            if (itemMDPK != null && tempMDPK != null) {
                String itemMDPKName = itemMDPK.getFullName();
                String tempMDPKName = tempMDPK.getFullName();
                if (itemMDPKName != null && tempMDPKName != null && tempMDPKName.equals(itemMDPKName)) {
                    nameflag = true;
                }
            }
            BOSObjectType itemType = item.getMetaDataType();
            BOSObjectType tempType = temp.getMetaDataType();
            if (itemType != null && tempType != null && itemType.toString() != null && tempType.toString() != null && itemType.toString().equals(tempType.toString())) {
                mdTypeflag = true;
            }
            if (item.getLevel() == temp.getLevel()) {
                levelflag = true;
            }
            if (!keyflag || !stateflag || !strflag || !nameflag || !mdTypeflag || !levelflag) continue;
            return true;
        }
        return false;
    }

    public void addItemFolder(CheckReportItem item, IMDProject project) {
        if (!this.itemFolderMap.containsKey(item)) {
            this.itemFolderMap.put(item, project);
        }
    }

    public IMDProject getItemFolder(VerifyMessageEntry item) {
        String estr = item.getMessage();
        MetaDataInfo pk = item.getTarget();
        String packageName = pk.getPackage();
        String pkname = pk.getName();
        int level = item.getLevel();
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            boolean strflag = false;
            boolean nameflag = false;
            boolean packageflag = false;
            boolean levelflag = false;
            CheckReportItem temp = (CheckReportItem)it.next();
            StringBuffer msg = new StringBuffer("");
            int size = temp.getMessages().length;
            for (int k = 0; k < size; ++k) {
                msg.append(temp.getMessages()[k]);
                msg.append("\n");
            }
            if (estr.equals(msg.toString())) {
                strflag = true;
            }
            if (packageName.equals(temp.getMetaDataPK().getPackage())) {
                packageflag = true;
            }
            if (pkname.equals(temp.getMetaDataPK().getName())) {
                nameflag = true;
            }
            if (level == temp.getLevel()) {
                levelflag = true;
            }
            if (!strflag || !packageflag || !nameflag || !levelflag) continue;
            return (IMDProject)this.itemFolderMap.get(temp);
        }
        return null;
    }
}

