/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard;

import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.wizard.BaseMDWizardPage;
import com.kingdee.bos.tool.UIHelper;
import com.kingdee.bos.tool.check.VerifyReport;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.wizard.AbstractMetaDataWizard;
import com.kingdee.bos.tool.wizard.ISelectionWizard;
import com.kingdee.bos.tool.wizard.Messages;
import com.kingdee.bos.tool.wizard.WizardCreateVerifyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class AbstractMetaDataWizardPage
extends BaseMDWizardPage {
    protected Combo fSourceFolder;
    protected Text fName;
    protected Text fAlias;
    protected Text fDesc;
    protected Text fPKName;
    protected Button fBrowse;
    protected VerifyReport report = new VerifyReport();
    protected WizardCreateVerifyListener listener = new WizardCreateVerifyListener();
    protected FocusListener focusListener;
    private boolean inited = false;

    public AbstractMetaDataWizardPage(String name) {
        super(name);
        this.report.registerListener(this.listener);
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof Text) {
                    Text t = (Text)e.getSource();
                    t.selectAll();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        };
    }

    protected Composite layoutChildContainer(Composite parent, int numColumns) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 10;
        container.setLayout((Layout)layout);
        return container;
    }

    protected void layoutSeparator(Composite container) {
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)gridData);
    }

    protected void layoutBasicRoot(Composite container) {
        UIHelper.createLabel(container, Messages.AbstractMetaDataWizardPage_YuanWenJianJiaD);
        this.fSourceFolder = UIHelper.createCombo(container, 2060, 768);
        this.fSourceFolder.setItems(ToolContextManager.getAllSolution());
        this.fSourceFolder.setEnabled(false);
        String str = this.getSelectedFolderName();
        if (str != null) {
            List<String> v = Arrays.asList(ToolContextManager.getAllSolution());
            if (!v.contains(str)) {
                this.fSourceFolder.add(str);
            }
            this.fSourceFolder.setText(str);
        } else if (this.fSourceFolder.getItemCount() > 0) {
            this.fSourceFolder.setText(this.fSourceFolder.getItem(0));
        }
        Button button = UIHelper.createButton(container, Messages.AbstractMetaDataWizardPage_LanO);
        button.setVisible(false);
    }

    protected void layoutPackage(Composite container) {
        this.layoutBasicRoot(container);
        UIHelper.createLabel(container, Messages.AbstractMetaDataWizardPage_BaoMingP);
        this.fPKName = UIHelper.createText(container);
        this.fPKName.addFocusListener(this.focusListener);
        this.fBrowse = UIHelper.createButton(container, Messages.AbstractMetaDataWizardPage_LanO);
        this.fBrowse.addSelectionListener((SelectionListener)new BrowseSelectionListener());
    }

    protected void layoutName(Composite container) {
        UIHelper.createLabel(container, Messages.AbstractMetaDataWizardPage_MingChengN);
        this.fName = UIHelper.createText(container);
        this.fName.addFocusListener(this.focusListener);
        UIHelper.createLabel(container, "").setVisible(false);
    }

    protected void layoutAlias(Composite container) {
        UIHelper.createLabel(container, Messages.AbstractMetaDataWizardPage_BieMingA);
        this.fAlias = UIHelper.createText(container);
        this.fAlias.addFocusListener(this.focusListener);
        UIHelper.createLabel(container, "").setVisible(false);
    }

    protected void addTextModifyListener(ModifyListener listener) {
        this.fPKName.addModifyListener(listener);
        this.fName.addModifyListener(listener);
        this.fAlias.addModifyListener(listener);
        this.fDesc.addModifyListener(listener);
    }

    protected void layoutDescription(Composite container) {
        UIHelper.createLabel(container, Messages.AbstractMetaDataWizardPage_MiaoShuC);
        this.fDesc = UIHelper.createText(container, 2882, 1808);
        this.fDesc.addFocusListener(this.focusListener);
        new Label(container, 0).setVisible(false);
    }

    protected void layoutCommonData(Composite container) {
        this.layoutName(container);
        this.layoutAlias(container);
        this.layoutDescription(container);
    }

    public void setVisible(boolean visible) {
        if (visible && !this.inited) {
            this.init();
            this.inited = true;
        }
        super.setVisible(visible);
    }

    protected void init() {
        if (this.fPKName != null) {
            String currentpk = this.currentPackage();
            this.fPKName.setText(currentpk);
        }
    }

    protected void setErrorMsg(String msg) {
        this.setErrorMessage(msg);
        if (msg == null) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    protected String getSourceFolder() {
        return this.getMDProject().getName() + "/" + "metadata";
    }

    protected IResource getFirstSelection() {
        Object obj;
        IStructuredSelection fSelection;
        if (this.getWizard() instanceof ISelectionWizard && (fSelection = ((ISelectionWizard)this.getWizard()).getSelection()) != null && !fSelection.isEmpty() && (obj = fSelection.getFirstElement()) instanceof IResource) {
            return (IResource)obj;
        }
        return null;
    }

    protected String getSelectedFolderName() {
        return this.getSourceFolder();
    }

    protected String currentPackage() {
        if (this.getWizard() instanceof AbstractMetaDataWizard) {
            IMDFolder folder = ((AbstractMetaDataWizard)this.getWizard()).getSelectedFolder();
            return folder.getPackageName();
        }
        return "";
    }

    protected void iterator(String parentPackage, File f, List list) {
        File[] fs = f.listFiles();
        if (f.getName().equalsIgnoreCase("CVS")) {
            return;
        }
        String childPackage = null;
        childPackage = "".equals(parentPackage) ? f.getName() : parentPackage + "." + f.getName();
        list.add(childPackage);
        for (int i = 0; i < fs.length; ++i) {
            if (!fs[i].isDirectory()) continue;
            this.iterator(childPackage, fs[i], list);
        }
    }

    public List getAllPackagesByCommonWay() {
        ArrayList<String> list = new ArrayList<String>();
        IResource res = this.getFirstSelection();
        if (res == null) {
            return list;
        }
        IProject project = res.getProject();
        IToolContext ctx = ToolContextManager.getContext(project);
        File file = project.getFolder(ctx.getSrcName()).getLocation().toFile();
        list.add(Messages.AbstractMetaDataWizardPage_QueShengBao);
        if (ctx.isExtSolution()) {
            Vector stdV = ctx.getStdDirs();
            int size = stdV.size();
            for (int i = 0; i < size; ++i) {
                file = project.getFolder((String)stdV.get(i)).getLocation().toFile();
                File[] fs = file.listFiles();
                for (int j = 0; j < fs.length; ++j) {
                    if (!fs[j].isDirectory()) continue;
                    this.iterator("", fs[j], list);
                }
            }
            Vector extV = ctx.getExtDirs();
            size = extV.size();
            for (int i = 0; i < size; ++i) {
                file = project.getFolder((String)extV.get(i)).getLocation().toFile();
                File[] fs = file.listFiles();
                for (int j = 0; j < fs.length; ++j) {
                    if (!fs[j].isDirectory()) continue;
                    this.iterator("", fs[j], list);
                }
            }
        } else {
            File[] fs = file.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                if (!fs[i].isDirectory()) continue;
                this.iterator("", fs[i], list);
            }
        }
        Collections.sort(list);
        return list;
    }

    protected List getAllPackages() {
        ArrayList<String> list = new ArrayList<String>();
        IMDProject project = this.getMDProject();
        list.add(Messages.AbstractMetaDataWizardPage_QueShengBao);
        IMDFolder[] folders = project.getRoot().listAllFolder();
        for (int i = 0; i < folders.length; ++i) {
            list.add(folders[i].getPackageName());
        }
        Collections.sort(list);
        return list;
    }

    private class BrowseSelectionListener
    extends SelectionAdapter {
        private BrowseSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(AbstractMetaDataWizardPage.this.getShell(), (ILabelProvider)new LabelProvider());
            dialog.setIgnoreCase(false);
            dialog.setTitle(Messages.AbstractMetaDataWizardPage_BaoXuanZe);
            dialog.setMessage(Messages.AbstractMetaDataWizardPage_XuanZeWenJianJia);
            dialog.setEmptyListMessage("");
            dialog.setElements(AbstractMetaDataWizardPage.this.getAllPackages().toArray());
            String path = AbstractMetaDataWizardPage.this.currentPackage();
            if (path != null) {
                dialog.setInitialSelections(new Object[]{path});
            }
            if (dialog.open() == 0) {
                if (Messages.AbstractMetaDataWizardPage_QueShengBao.equals(dialog.getFirstResult())) {
                    AbstractMetaDataWizardPage.this.fPKName.setText("");
                } else {
                    AbstractMetaDataWizardPage.this.fPKName.setText((String)dialog.getFirstResult());
                }
            }
        }
    }
}

