/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.utils;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.utils.FileAccessFactory;
import com.kingdee.bos.utils.IFileAccessInfo;
import com.kingdee.bos.utils.ProjectContext;
import java.util.HashMap;

public class FileAccessSupport {
    private ProjectContext _context_ = new ProjectContext();
    private IFileAccessInfo fileAccessInfo;
    private static HashMap<IMDProject, FileAccessSupport> cache = new HashMap();
    private static IUserDefinedAdapter _UserDefinedAdapter_True = new IUserDefinedAdapter(){

        @Override
        public boolean isUserDefined() {
            return true;
        }
    };
    private static IUserDefinedAdapter _UserDefinedAdapter_False = new IUserDefinedAdapter(){

        @Override
        public boolean isUserDefined() {
            return false;
        }
    };

    public static FileAccessSupport getInstance(IMDProject project) {
        if (!cache.containsKey(project)) {
            cache.put(project, new FileAccessSupport(project, ToolCommonPlugin.isDevelopVersion() ? ProjectContext.DevModel.DEV_MODEL : ProjectContext.DevModel.CUST_MODEL));
        }
        return cache.get(project);
    }

    public static void clearCache(IMDProject project) {
        cache.remove(project);
    }

    public static boolean getActiveEditFileAccessInfo(FLAG flag, Object field) {
        boolean result = false;
        IMDFile mdfile = ToolCommonPlugin.getActiveEditFile();
        if (mdfile != null && mdfile.getMDProject() != null) {
            FileAccessSupport support = FileAccessSupport.getInstance(mdfile.getMDProject());
            switch (flag) {
                case ADD: {
                    result = support.canAddField(mdfile);
                    break;
                }
                case DELETE: {
                    result = support.canDeleteField(mdfile, field);
                    break;
                }
                case MODIFY: {
                    result = support.canModifyField(mdfile, field);
                    break;
                }
                case READ: {
                    result = support.canRead(mdfile);
                    break;
                }
                case WRITE: {
                    result = support.canWrite(mdfile);
                }
            }
        }
        return result;
    }

    private FileAccessSupport(IMDProject project, ProjectContext.DevModel devModel) {
        this._context_.setDevModel(devModel);
        this._context_.setProject(project);
        this.fileAccessInfo = FileAccessFactory.getDefault().getFileAccessRule().getAccessInfo();
    }

    public ProjectContext getProjectContext() {
        return this._context_;
    }

    public boolean canRead(IMDFile mdFile) {
        return this._context_.getProject() != null && this.fileAccessInfo.canRead(this._context_, mdFile);
    }

    public boolean canWrite(IMDFile mdFile) {
        return this._context_.getProject() != null && this.fileAccessInfo.canWrite(this._context_, mdFile);
    }

    public boolean canAddField(IMDFile mdFile) {
        return this._context_.getProject() != null && this.fileAccessInfo.canAddField(this._context_, mdFile);
    }

    public boolean canModifyField(IMDFile mdFile, Object field) {
        return this._context_.getProject() != null && this.fileAccessInfo.canModifyField(this._context_, mdFile, field);
    }

    public boolean canDeleteField(IMDFile mdFile, Object field) {
        return this._context_.getProject() != null && this.fileAccessInfo.canDeleteField(this._context_, mdFile, field);
    }

    public static IUserDefinedAdapter makeUserDefinedAdapterWithTrue() {
        return _UserDefinedAdapter_True;
    }

    public static IUserDefinedAdapter makeUserDefinedAdapterWithFalse() {
        return _UserDefinedAdapter_False;
    }

    public static interface IUserDefinedAdapter {
        public boolean isUserDefined();
    }

    public static enum FLAG {
        ADD,
        DELETE,
        MODIFY,
        READ,
        WRITE;

    }
}

