/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor;

import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.workflow.monitor.BillDigestEnum;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SummaryInfo
implements Serializable,
Comparable {
    private static final long serialVersionUID = -743163995654305072L;
    private String metadataPK;
    private boolean isOABill;
    private String name = "";
    private Map<Locale, String> alias = new HashMap<Locale, String>();
    private List<SummaryInfo> entrys = new ArrayList<SummaryInfo>();
    private List<SummaryItemInfo> summaryItems = new ArrayList<SummaryItemInfo>();
    private boolean isdefault;
    private int previewNum;
    private boolean isMobileApprove;
    private String shcemaId;
    private boolean hasUserDefineField;
    private boolean isEditConfig;
    private BillDigestEnum digType;
    private int index;
    private boolean needValidate;
    private String sortedType;

    public SummaryInfo() {
        this.setPreviewNum(3);
        this.setIsMobileApprove(true);
        this.setDigType(BillDigestEnum.all);
    }

    public List<SummaryInfo> getEntrys() {
        return this.entrys;
    }

    public boolean getNeedValidate() {
        return this.needValidate;
    }

    public void setNeedValidate(boolean needValidate) {
        this.needValidate = needValidate;
    }

    public SummaryInfo getEntry(String group) {
        for (SummaryInfo entry : this.entrys) {
            if (entry.getName().equals(group)) {
                return entry;
            }
            SummaryInfo subEntry = entry.getEntry(group);
            if (subEntry == null) continue;
            return subEntry;
        }
        return null;
    }

    public List<SummaryItemInfo> getSummaryItems() {
        return this.summaryItems;
    }

    public String getMetadataPK() {
        return this.metadataPK;
    }

    public void setMetadataPK(String metadataPK) {
        this.metadataPK = metadataPK;
    }

    public void addSummaryItem(SummaryItemInfo item) {
        String group = item.getGroup();
        if (StringUtils.isEmpty((String)group) || group.equals(this.getName())) {
            this.summaryItems.add(item);
            return;
        }
        SummaryInfo entry = this.getEntry(group);
        if (entry != null) {
            entry.addSummaryItem(item);
        }
    }

    public void addEntry(SummaryInfo entry) {
        this.entrys.add(entry);
    }

    public boolean contains(Object item) {
        if (this.summaryItems.contains(item)) {
            return true;
        }
        for (int i = 0; i < this.entrys.size(); ++i) {
            if (!this.entrys.get(i).contains(item)) continue;
            return true;
        }
        return false;
    }

    public void remove(Object item) {
        this.summaryItems.remove(item);
        for (int i = 0; i < this.entrys.size(); ++i) {
            this.entrys.get(i).remove(item);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias.get(ContextUtils.getLocaleFromEnv());
    }

    public Map<Locale, String> getAllAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias.put(ContextUtils.getLocaleFromEnv(), alias);
    }

    public void setAlias(Locale local, String alias) {
        this.alias.put(local, alias);
    }

    public void setAlias(Map<Locale, String> alias) {
        this.alias = alias;
    }

    public boolean isdefault() {
        return this.isdefault;
    }

    public void setdefault(boolean isdefault) {
        this.isdefault = isdefault;
    }

    public int getPreviewNum() {
        return this.previewNum;
    }

    public void setPreviewNum(int previewNum) {
        this.previewNum = previewNum;
    }

    public boolean isOABill() {
        return this.isOABill;
    }

    public void setOABill(boolean isOABill) {
        this.isOABill = isOABill;
    }

    public Boolean getIsMobileApprove() {
        return this.isMobileApprove;
    }

    public void setIsMobileApprove(Boolean isMobileApprove) {
        this.isMobileApprove = isMobileApprove;
    }

    public String getShcemaId() {
        return this.shcemaId;
    }

    public void setShcemaId(String shcemaId) {
        this.shcemaId = shcemaId;
    }

    public boolean isHasUserDefineField() {
        return this.hasUserDefineField;
    }

    public void setHasUserDefineField(boolean hasUserDefineField) {
        this.hasUserDefineField = hasUserDefineField;
    }

    public boolean isEditConfig() {
        return this.isEditConfig;
    }

    public void setEditConfig(boolean isEditConfig) {
        this.isEditConfig = isEditConfig;
    }

    public BillDigestEnum getDigType() {
        return this.digType;
    }

    public void setDigType(BillDigestEnum digType) {
        this.digType = digType;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int compareTo(Object o) {
        return this.getIndex() - ((SummaryInfo)o).getIndex();
    }

    public boolean isEmpty() {
        boolean result = true;
        if (this.summaryItems.size() > 0) {
            result = false;
        } else if (this.entrys.size() == 0) {
            result = true;
        } else {
            for (int i = 0; i < this.entrys.size(); ++i) {
                if (this.entrys.get(i).isEmpty()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public void setSortedType(String sortedType) {
        this.sortedType = sortedType;
    }

    public String getSortedType() {
        return this.sortedType;
    }
}

