/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.IExecuteObject;
import com.kingdee.bos.workflow.define.JoinType;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.SplitType;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.diagram.ActivityNode;
import com.kingdee.bos.workflow.define.diagram.Coordinate;
import com.kingdee.bos.workflow.define.diagram.Line;
import com.kingdee.bos.workflow.define.diagram.NodeCollection;
import com.kingdee.bos.workflow.define.diagram.NodeType;
import com.kingdee.bos.workflow.define.enhanced.EMessage;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.monitor.DynamicOperationInfo;
import com.kingdee.bos.workflow.monitor.DynamicOperationServiceFactory;
import com.kingdee.bos.workflow.monitor.IDynamicOperationService;
import com.kingdee.bos.workflow.monitor.WfFacadeUtilFactory;
import com.kingdee.bos.workflow.service.IDynamicWfService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.MultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.ParticipantUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;

public class DynamicWfService
implements IDynamicWfService {
    Context ctx;
    IEnactmentService svc;
    Locale locale;
    private static final int DEFAULT_INTERVAL = 70;

    public DynamicWfService(Context ctx) throws Exception {
        this.ctx = ctx;
        this.locale = ctx.getLocale();
        this.svc = EnactmentServiceFactory.createEnactService((Context)ctx);
    }

    private boolean isCheckPermission() {
        try {
            String value = ParamManager.getParamValue((Context)this.ctx, null, (String)"isKickbackAll");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public IDynamicWfService.JumpTarget[] getKickBackTargets(String assignmentId) throws Exception {
        AssignmentInfo assign = this.svc.getAssignmentById(assignmentId);
        String actInstId = assign.getActInstId();
        ActivityInstInfo actInstInfo = this.svc.getActivityInstByActInstId(actInstId);
        String[] priorActInstIds = actInstInfo.getPreActInstList();
        Locale l = this.ctx.getLocale();
        ProcessDef processDef = this.svc.getProcessDefByDefineHashValue(actInstInfo.getProcDefHashValue());
        ArrayList targets = new ArrayList();
        HashSet<String> exists = new HashSet<String>();
        exists.add(actInstInfo.getActDefId());
        IUser user = null;
        this.findKickBackTargets(actInstInfo, user, l, targets, assign, priorActInstIds, exists, processDef);
        this.removeBehindIds(this.ctx, targets, actInstInfo.getProcInstId(), assign.getActDefId());
        return targets.toArray(new IDynamicWfService.JumpTarget[targets.size()]);
    }

    private void removeBehindIds(Context ctx, ArrayList targets, String procinstId, String currentActDefId) throws Exception {
        String sql = "SELECT FACTDEFID FROM t_wfr_actinst where FPROCINSTID  = ? and FSTATE <> 'open.not_running.not_started' order by FLASTSTATETIME";
        try {
            String id;
            IRowSet rw = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{procinstId});
            if (rw.size() == 0) {
                return;
            }
            ArrayList<String> priors = new ArrayList<String>();
            while (rw.next() && !(id = rw.getString("FACTDEFID")).equals(currentActDefId)) {
                priors.add(id);
            }
            ArrayList temp = new ArrayList();
            for (Object obj : targets) {
                String id2 = ((IDynamicWfService.JumpTarget)obj).actDefId;
                if (priors.contains(id2)) continue;
                temp.add(obj);
            }
            targets.removeAll(temp);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void findKickBackTargets(ActivityInstInfo current, IUser user, Locale l, ArrayList targets, AssignmentInfo assign, String[] priorActInstIds, HashSet exists, ProcessDef processDef) throws Exception {
        ActivityDef act;
        JoinType join;
        Boolean isKickbackAll = this.isCheckPermission();
        if (priorActInstIds == null) {
            return;
        }
        if (!isKickbackAll.booleanValue() && priorActInstIds.length > 1 && !JoinType.OR.equals((Object)(join = (act = processDef.getActivityDef(current.getActDefId())).getActivityHeader().getJoinType()))) {
            int count = priorActInstIds.length;
            for (int index = 0; index < priorActInstIds.length; ++index) {
                String actinstId = priorActInstIds[index];
                ActivityInstInfo actinstInfo = this.svc.getActivityInstByActInstId(actinstId);
                if (actinstInfo.getParentActInstId() == null) continue;
                --count;
            }
            if (count > 1) {
                return;
            }
        }
        for (int i = 0; i < priorActInstIds.length; ++i) {
            String prior = priorActInstIds[i];
            this.findKickBackTargets(user, l, targets, assign, exists, processDef, prior);
        }
    }

    private void findKickBackTargets(IUser user, Locale l, ArrayList targets, AssignmentInfo assign, HashSet exists, ProcessDef processDef, String prior) throws WfException, BOSException, EASBizException, Exception {
        String[] priorActInstIds;
        Boolean isKickbackAll = this.isCheckPermission();
        ActivityInstInfo current = this.svc.getActivityInstByActInstId(prior);
        String[] nextActInstIds = current.getPostActInstList();
        if (nextActInstIds == null) {
            nextActInstIds = new String[]{current.getParentActInstId()};
        }
        if (!isKickbackAll.booleanValue() && nextActInstIds == null) {
            return;
        }
        if (!isKickbackAll.booleanValue() && nextActInstIds.length > 1) {
            int count = nextActInstIds.length;
            for (int index = 0; index < nextActInstIds.length; ++index) {
                String actinstId = nextActInstIds[index];
                ActivityInstInfo actinstInfo = this.svc.getActivityInstByActInstId(actinstId);
                if (actinstInfo.getParentActInstId() == null) continue;
                --count;
            }
            if (count > 1) {
                return;
            }
        }
        if ((priorActInstIds = current.getPreActInstList()) == null) {
            return;
        }
        String actDefId = current.getActDefId();
        ActivityDef aDef = processDef.getActivityDef(actDefId);
        if (aDef instanceof RouterActivityDef) {
            this.findKickBackTargets(current, user, l, targets, assign, priorActInstIds, exists, processDef);
            return;
        }
        if (aDef instanceof MessageActivityDef) {
            this.findKickBackTargets(current, user, l, targets, assign, priorActInstIds, exists, processDef);
            return;
        }
        if (!isKickbackAll.booleanValue() && !(aDef instanceof ManpowerActivityDef)) {
            return;
        }
        if (!(aDef instanceof ApproveActivityDef || aDef instanceof ManualDecisionActivityDef || isKickbackAll.booleanValue() && aDef instanceof ManpowerActivityDef)) {
            ActivityCollection ac = aDef.getPreviousActivities();
            boolean isFirst = false;
            for (int j = 0; j < ac.size(); ++j) {
                if (!(ac.get(j) instanceof StartActivityDef)) continue;
                isFirst = true;
                break;
            }
            if (!isFirst) {
                if (isKickbackAll.booleanValue()) {
                    this.findKickBackTargets(current, user, l, targets, assign, priorActInstIds, exists, processDef);
                }
                return;
            }
        }
        if (!exists.contains(actDefId)) {
            user = this.addKickbackTarget(user, l, targets, assign, processDef, current, actDefId, aDef);
        }
        exists.add(actDefId);
        this.findKickBackTargets(current, user, l, targets, assign, priorActInstIds, exists, processDef);
    }

    private IUser addKickbackTarget(IUser user, Locale l, ArrayList targets, AssignmentInfo assign, ProcessDef processDef, ActivityInstInfo current, String actDefId, ActivityDef aDef) throws WfException, BOSException, EASBizException, Exception {
        IDynamicWfService.JumpTarget target = new IDynamicWfService.JumpTarget();
        targets.add(target);
        target.assignment = assign;
        target.actDefId = actDefId;
        target.actDefName = aDef.getName(l);
        if (target.actDefName == null) {
            target.actDefName = aDef.getName();
        }
        target.completeTime = current.getCompleteTime();
        AssignmentInfo[] assigns = this.svc.getAssignmentByActInstId(current.getActInstId(), WfAssignmentState.COMPLETED);
        if (assigns != null && assigns.length > 0) {
            StringBuffer ids = new StringBuffer();
            StringBuffer names = new StringBuffer();
            for (int i = 0; i < assigns.length; ++i) {
                String name;
                if (StringUtils.isEmpty((String)assigns[i].getEmployeeId())) {
                    if (ids.indexOf(assigns[i].getUserId()) >= 0) continue;
                    ids.append(assigns[i].getUserId());
                } else {
                    if (ids.indexOf(assigns[i].getEmployeeId()) >= 0) continue;
                    ids.append(assigns[i].getEmployeeId());
                }
                if (ids.length() > 0) {
                    ids.append(";");
                }
                if (names.length() > 0) {
                    names.append(";");
                }
                if ((name = assigns[i].getUserName(l)) == null) {
                    if (user == null) {
                        user = UserFactory.getLocalInstance((Context)this.ctx);
                    }
                    UserInfo u = user.getUserInfo("select name where id='" + assigns[i].getUserId() + "'");
                    name = u.getName(l);
                }
                names.append(name);
            }
            target.performerPersonIds = ids.toString();
            target.performerPersonNames = names.toString();
        } else {
            ProcessInstInfo pInfo = this.svc.getProcessInstInfo(current.getProcInstId());
            target.performerPersonNames = pInfo.getInitiatorName(l);
            target.performerPersonIds = null;
        }
        target.participants = this.getParticipants(processDef.getActivityDef(actDefId), processDef, l);
        return user;
    }

    public void kickBack(IDynamicWfService.JumpTarget target) throws Exception {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)this.ctx, (WorkflowLogItem)WorkflowLogItem.TO_DO_LIST_BEAT_BACK, (Object)(target.assignment.getProcInstId() + "&" + target.actDefName));
        this.svc.setProcessContext(target.assignment.getProcInstId(), "$isKickBack", (Object)"true");
        this.saveDynamicOperationInfo("kick-back", target);
        this.jumpTo(target, ApproveResult.NOT_PASS);
        WorkflowLogUtil.endLogByLocal((Context)this.ctx, (IObjectPK)logPk);
    }

    private void saveDynamicOperationInfo(String operType, IDynamicWfService.JumpTarget target) throws BOSException {
        IDynamicOperationService serivce = DynamicOperationServiceFactory.getLocalInstance(this.ctx);
        DynamicOperationInfo info = new DynamicOperationInfo();
        info.setType(operType);
        AssignmentInfo assignInfo = target.assignment;
        if (assignInfo != null) {
            info.setBillId(assignInfo.getBizObjectIds());
            info.setProcInstId(assignInfo.getProcInstId());
            info.setActInstId(assignInfo.getActInstId());
            info.setActName(assignInfo.getActDefName(this.ctx.getLocale()));
        }
        info.setTargetActId(target.actDefId);
        info.setTargetActName(target.actDefName);
        info.setComment(target.comment, new Locale("l1"));
        info.setComment(target.comment, new Locale("l2"));
        info.setComment(target.comment, new Locale("l3"));
        info.setCreatorId(assignInfo.getUserId());
        info.setCreatorName(assignInfo.getUserName(this.ctx.getLocale()));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        serivce.addNewDynamicOperationInfo(info);
    }

    public void jumpTo(IDynamicWfService.JumpTarget target) throws Exception {
        this.saveDynamicOperationInfo("jump-to", target);
        this.jumpTo(target, ApproveResult.PASS);
    }

    public void setJumpToTarget(String procInstId, String assignId, String targetActDefId) throws WfException {
        this.svc.setProcessContext(procInstId, assignId, (Object)targetActDefId);
    }

    private void jumpTo(IDynamicWfService.JumpTarget target, ApproveResult result) throws Exception {
        String assignmentId = target.assignment.getAssignmentId();
        this.check(assignmentId);
        this.setJumpToTarget(target.assignment.getProcInstId(), assignmentId, target.actDefId);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(target.sendMail);
        info.setIsMobelNotifyNext(target.sendSMS);
        info.setOpinion(target.comment);
        info.setIsPass(result);
        info.setHandlerOpinion(target.handlerOpinion);
        info.setHandlerContent(target.handlerContent);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        info.setId(null);
        info.setAssignment(assignmentId);
        String billId = target.assignment.getBizObjectIds();
        info.setBillId(BOSUuid.read((String)billId));
        info.setExtendedProperty("businuessObjectId", billId);
        info.setExtendedProperty("assignmentID", assignmentId);
        new MultiApprove(this.ctx).submit((CoreBaseInfo)info);
    }

    public IDynamicWfService.JumpTarget[] getJumpToTargets(String assignmentId) throws Exception {
        AssignmentInfo assign = this.svc.getAssignmentById(assignmentId);
        String actInstId = assign.getActInstId();
        ActivityInstInfo actInstInfo = this.svc.getActivityInstByActInstId(actInstId);
        Locale l = this.ctx.getLocale();
        ProcessDef processDef = this.svc.getProcessDefByDefineHashValue(actInstInfo.getProcDefHashValue());
        ArrayList targets = new ArrayList();
        HashSet<String> exists = new HashSet<String>();
        String actDefId = actInstInfo.getActDefId();
        exists.add(actDefId);
        ActivityDef from = processDef.getActivityDef(actDefId);
        if (SplitType.XOR.equals((Object)from.getActivityHeader().getSplitType()) || from.getPostActivities().size() == 1) {
            this.findJumpToTargets(processDef, assign, from.getPostActivities(), targets, exists, l);
        }
        return targets.toArray(new IDynamicWfService.JumpTarget[targets.size()]);
    }

    private void findJumpToTargets(ProcessDef pDef, AssignmentInfo assign, ActivityCollection to, ArrayList targets, HashSet exists, Locale l) throws Exception {
        if (to == null) {
            return;
        }
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        for (int i = 0; i < to.size(); ++i) {
            ActivityCollection next;
            ActivityDef actDef = to.get(i);
            String actDefId = actDef.getID();
            if (exists.contains(actDefId)) continue;
            exists.add(actDefId);
            ActivityCollection prior = actDef.getPreviousActivities();
            if (prior.size() > 1 && JoinType.AND.equals((Object)actDef.getActivityHeader().getJoinType())) continue;
            boolean isSync = JoinType.OR.equals((Object)actDef.getActivityHeader().getJoinType());
            if ((actDef instanceof ManpowerActivityDef || actDef instanceof SubflowActivityDef || actDef instanceof ToolActivityDef || actDef instanceof RouterActivityDef && isSync) && svc.canJump(assign.getProcInstId(), actDef)) {
                IDynamicWfService.JumpTarget target = new IDynamicWfService.JumpTarget();
                targets.add(target);
                target.assignment = assign;
                target.actDefId = actDefId;
                target.actDefName = actDef.getName(l);
                if (target.actDefName == null) {
                    target.actDefName = actDef.getName();
                }
                target.participants = this.getParticipants(actDef, pDef, l);
            }
            if (isSync || actDef instanceof ToolActivityDef && !(actDef instanceof MessageActivityDef) || actDef instanceof ManpowerActivityDef && !(actDef instanceof ApproveActivityDef) && !(actDef instanceof ManualDecisionActivityDef) || (next = actDef.getPostActivities()).size() != 1 && !SplitType.XOR.equals((Object)actDef.getActivityHeader().getSplitType())) continue;
            this.findJumpToTargets(pDef, assign, next, targets, exists, l);
        }
    }

    private String getParticipants(ActivityDef actDef, ProcessDef pDef, Locale l) throws Exception {
        if (actDef instanceof ManpowerActivityDef) {
            ParticipantCollection pars = ((ManpowerActivityDef)actDef).getParticipants();
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < pars.size(); ++j) {
                if (j > 0) {
                    sb.append(";");
                }
                String name = ParticipantUtils.getParticipantName((ParticipantDef)pars.get(j), (ProcessDef)pDef, (Locale)l, (Context)this.ctx);
                sb.append(name);
            }
            return sb.toString();
        }
        return "";
    }

    private void check(String assignmentId) throws Exception {
        AssignmentInfo assignmentInfo = this.svc.getAssignmentById(assignmentId);
        this.check(assignmentInfo);
    }

    private void check(AssignmentInfo assignmentInfo) throws Exception {
        String l = this.ctx.getLocale().getLanguage();
        String tip1 = "\u4efb\u52a1\u5df2\u53d6\u6d88\uff01\u53ef\u80fd\u662f\u5176\u4ed6\u7528\u6237\u5df2\u5904\u7406\u4e86\u672c\u4efb\u52a1\u3002";
        String tip2 = "\u4efb\u52a1\u5df2\u5b8c\u6210\uff01";
        String tip3 = "\u4efb\u52a1\u5df2\u62d2\u7edd\uff01";
        if ("l1".equals(l)) {
            tip1 = "The task have been cancelled,it could be handled by other users";
            tip2 = "The task have been finished";
            tip3 = "The task have been rejected";
        } else if ("l3".equals(l)) {
            tip1 = "\u4efb\u52d9\u5df2\u53d6\u6d88\uff01\u53ef\u80fd\u662f\u5176\u4ed6\u7528\u6236\u5df2\u8655\u7406\u4e86\u672c\u4efb\u52d9\u3002";
            tip2 = "\u4efb\u52d9\u5df2\u5b8c\u6210\uff01";
            tip3 = "\u4efb\u52d9\u5df2\u62d2\u7d55\uff01";
        }
        if (assignmentInfo.getState().equals((Object)WfAssignmentState.CANCELED)) {
            throw new Exception(tip1);
        }
        if (assignmentInfo.getState().equals((Object)WfAssignmentState.COMPLETED)) {
            throw new Exception(tip2);
        }
        if (assignmentInfo.getState().equals((Object)WfAssignmentState.REJECTED)) {
            throw new Exception(tip3);
        }
    }

    public IEnactmentService getWfService() {
        return this.svc;
    }

    public void appendActivity(String assignmentId, IDynamicWfService.DynamicActivityDef[] actDefs, String appendMode, String routeMode, boolean abortCurrentActivity) throws Exception {
        AssignmentInfo aInfo = this.svc.getAssignmentById(assignmentId);
        this.check(aInfo);
        WfEngine engine = WfEngine.getEngine((Context)this.ctx);
        if (engine.getProcessInst(aInfo.getProcInstId()).getProcessContext().isPvmMode()) {
            this.svc.appendActivity(aInfo, actDefs, "2".equals(appendMode), "1".equals(routeMode), abortCurrentActivity);
        } else {
            this.innerAppend(assignmentId, actDefs, appendMode, routeMode, abortCurrentActivity, aInfo);
        }
    }

    private void innerAppend(String assignmentId, IDynamicWfService.DynamicActivityDef[] actDefs, String appendMode, String routeMode, boolean abortCurrentActivity, AssignmentInfo aInfo) throws WfException, CloneNotSupportedException, BOSException, Exception {
        String hash = aInfo.getProcDefHashValue();
        ProcessDef pDef = this.svc.getProcessDefByDefineHashValue(hash);
        pDef = (ProcessDef)ObjectUtils.createCopy((Object)pDef);
        ApproveActivityDef aaDef = (ApproveActivityDef)pDef.getActivityDef(aInfo.getActDefId());
        if (actDefs.length == 1) {
            routeMode = "1";
        }
        int offsetY = "1".equals(routeMode) ? this.calcHeightForSerial(actDefs, appendMode) : this.calcHeightForParallel(actDefs, aaDef, appendMode, abortCurrentActivity);
        this.adjustNodes(pDef, aaDef, offsetY);
        ApproveActivityDef[] aaDefs = this.createApproveActivityDefs(pDef, aaDef, actDefs);
        for (int i = 0; i < aaDefs.length; ++i) {
            this.addAppendedFlag((ActivityDef)aaDefs[i]);
        }
        ActivityDef target = "1".equals(routeMode) ? this.addLinesForSerial(aaDefs, aaDef, pDef, appendMode) : this.addLinesForParallel(aaDefs, aaDef, pDef, appendMode, abortCurrentActivity);
        this.svc.updateDynamicFlowDef(this.ctx.getCaller().toString(), aInfo.getProcInstId(), hash, pDef);
        String procInstId = aInfo.getProcInstId();
        if (abortCurrentActivity) {
            String sql = "update t_wfr_assign set fstate=16 where FASSIGNID='" + assignmentId + "'";
            SQL.executeUpdate((Context)this.ctx, (String)sql);
            HashSet<String> set = new HashSet<String>();
            set.add(assignmentId);
            WfFacadeUtilFactory.getDynamicWfService(this.ctx).dumpAssignment(set);
            try {
                this.svc.jump(procInstId, target, actDefs[0].option);
            }
            catch (Throwable t) {
                throw new Exception("\u65b0\u589e\u5ba1\u6279\u6d3b\u52a8\u5df2\u52a0\u5165\u5230\u6d41\u7a0b\u4e2d\uff0c\u4f46\u64a4\u6d88\u5f53\u524d\u5ba1\u6279\u6d3b\u52a8\u5931\u8d25\uff01\r\n\r\n\u8bf7\u4e0d\u8981\u518d\u6b21\u52a0\u7b7e\uff0c\u4f7f\u7528\u6d41\u7a0b\u56fe\u7684\u201c\u8df3\u8f6c\u201d\u529f\u80fd\u5c06\u6d41\u7a0b\u8f6c\u5411\u52a0\u7b7e\u7684\u6d3b\u52a8\uff0c\u6216\u901a\u77e5\u7ba1\u7406\u5458\u5904\u7406!", t);
            }
        } else if ("2".equals(appendMode) && this.svc.getProcessContext(procInstId, assignmentId) == null) {
            this.setJumpToTarget(procInstId, assignmentId, target.getID());
        }
    }

    private void adjustNodes(ProcessDef pDef, ApproveActivityDef aaDef, int offsetY) throws WfException {
        int y = aaDef.getRelatedNode().getCoordinate().y;
        NodeCollection nodes = pDef.getDiagram().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Coordinate c = nodes.get(i).getCoordinate();
            if ((c.y >= y || offsetY >= 0) && (c.y <= y || offsetY <= 0)) continue;
            c.y += offsetY;
        }
    }

    private int calcHeightForParallel(IDynamicWfService.DynamicActivityDef[] aaDefs, ApproveActivityDef aaDef, String appendMode, boolean abortCurrentActivity) throws WfException {
        int offsetY = "1".equals(appendMode) ? 70 * (abortCurrentActivity ? 3 : 2) : -140;
        return offsetY;
    }

    private void addLine(ActivityDef from, ActivityDef to, ProcessDef pDef) throws WfException {
        Line line = new Line(pDef.getDiagram());
        line.getRefTransition().setFrom(from);
        line.setToPort("p2");
        line.setFromPort("p1");
        line.getRefTransition().setTo(to);
    }

    private void addAppendedFlag(ActivityDef act) {
        ExtendedAttributeDef attr = new ExtendedAttributeDef();
        attr.setName("isAppended");
        attr.setValue("true");
        act.getActivityHeader().getExtendedAttributes().add("isAppended", attr);
    }

    private ActivityDef addLinesForParallel(ApproveActivityDef[] aaDefs, ApproveActivityDef aaDef, ProcessDef pDef, String appendMode, boolean abortCurrentActivity) throws WfException {
        ActivityNode routeNode = new ActivityNode(pDef.getDiagram(), NodeType.ROUTER);
        RouterActivityDef router = (RouterActivityDef)routeNode.getRefActivity();
        router.setName(this.locale, "\u8def\u7531");
        this.addAppendedFlag((ActivityDef)router);
        if ("1".equals(appendMode)) {
            int i;
            ApproveActivityDef header;
            router.getActivityHeader().setJoinType(JoinType.AND);
            router.getActivityHeader().setSplitType(aaDef.getActivityHeader().getSplitType());
            if (abortCurrentActivity) {
                ActivityNode headNode = new ActivityNode(pDef.getDiagram(), NodeType.ROUTER);
                header = headNode.getRefActivity();
                this.addAppendedFlag((ActivityDef)header);
                header.setName(this.locale, "\u8def\u7531");
                headNode.getCoordinate().x = aaDef.getRelatedNode().getCoordinate().x;
                headNode.getCoordinate().y = aaDef.getRelatedNode().getCoordinate().y + 70;
            } else {
                header = aaDef;
            }
            header.getActivityHeader().setSplitType(SplitType.AND);
            routeNode.getCoordinate().x = header.getRelatedNode().getCoordinate().x;
            routeNode.getCoordinate().y = header.getRelatedNode().getCoordinate().y + 140;
            int x = header.getRelatedNode().getCoordinate().x - 45 * (aaDefs.length - 1);
            int y = header.getRelatedNode().getCoordinate().y + 70;
            for (int i2 = 0; i2 < aaDefs.length; ++i2) {
                aaDefs[i2].getRelatedNode().getCoordinate().x = x + 90 * i2;
                aaDefs[i2].getRelatedNode().getCoordinate().y = y;
            }
            TransitionCollection tc = aaDef.getOutgoingTransitions();
            for (i = 0; i < tc.size(); ++i) {
                tc.get(i).setFrom((ActivityDef)router);
            }
            if (header != aaDef) {
                this.addLine((ActivityDef)aaDef, (ActivityDef)header, pDef);
            }
            for (i = 0; i < aaDefs.length; ++i) {
                this.addLine((ActivityDef)aaDefs[i], (ActivityDef)router, pDef);
                this.addLine((ActivityDef)header, (ActivityDef)aaDefs[i], pDef);
            }
            if (abortCurrentActivity) {
                return header;
            }
        } else {
            int i;
            router.getActivityHeader().setSplitType(SplitType.AND);
            router.getActivityHeader().setJoinType(aaDef.getActivityHeader().getJoinType());
            aaDef.getActivityHeader().setJoinType(JoinType.AND);
            routeNode.getCoordinate().x = aaDef.getRelatedNode().getCoordinate().x;
            routeNode.getCoordinate().y = aaDef.getRelatedNode().getCoordinate().y - 140;
            int x = (90 * aaDefs.length - 34) / 2 + 28;
            int y = aaDef.getRelatedNode().getCoordinate().y - 70;
            for (int i3 = 0; i3 < aaDefs.length; ++i3) {
                aaDefs[i3].getRelatedNode().getCoordinate().x = x + 90 * i3;
                aaDefs[i3].getRelatedNode().getCoordinate().y = y;
            }
            TransitionCollection tc = aaDef.getIncomingTransitions();
            for (i = 0; i < tc.size(); ++i) {
                tc.get(i).setTo((ActivityDef)router);
            }
            for (i = 0; i < aaDefs.length; ++i) {
                this.addLine((ActivityDef)router, (ActivityDef)aaDefs[i], pDef);
                this.addLine((ActivityDef)aaDefs[i], (ActivityDef)aaDef, pDef);
            }
        }
        return router;
    }

    private int calcHeightForSerial(IDynamicWfService.DynamicActivityDef[] aaDefs, String appendMode) throws WfException {
        int offsetY = "1".equals(appendMode) ? 70 * aaDefs.length : -70 * aaDefs.length;
        return offsetY;
    }

    private ActivityDef addLinesForSerial(ApproveActivityDef[] aaDefs, ApproveActivityDef aaDef, ProcessDef pDef, String appendMode) throws WfException {
        int i;
        Coordinate ct = aaDef.getRelatedNode().getCoordinate();
        int x = ct.x;
        int y = "1".equals(appendMode) ? ct.y + 70 : ct.y - 70 * aaDefs.length;
        for (i = 0; i < aaDefs.length; ++i) {
            Coordinate ca = aaDefs[i].getRelatedNode().getCoordinate();
            ca.x = x;
            ca.y = y + 70 * i;
        }
        for (i = 0; i < aaDefs.length - 1; ++i) {
            this.addLine((ActivityDef)aaDefs[i], (ActivityDef)aaDefs[i + 1], pDef);
        }
        if ("1".equals(appendMode)) {
            aaDefs[aaDefs.length - 1].getActivityHeader().setSplitType(aaDef.getActivityHeader().getSplitType());
            TransitionCollection tc = aaDef.getOutgoingTransitions();
            ApproveActivityDef last = aaDefs[aaDefs.length - 1];
            for (int i2 = 0; i2 < tc.size(); ++i2) {
                tc.get(i2).setFrom((ActivityDef)last);
            }
            this.addLine((ActivityDef)aaDef, (ActivityDef)aaDefs[0], pDef);
        } else {
            aaDefs[aaDefs.length - 1].getActivityHeader().setJoinType(aaDef.getActivityHeader().getJoinType());
            TransitionCollection tc = aaDef.getIncomingTransitions();
            ApproveActivityDef first = aaDefs[0];
            for (int i3 = 0; i3 < tc.size(); ++i3) {
                tc.get(i3).setTo((ActivityDef)first);
            }
            ApproveActivityDef last = aaDefs[aaDefs.length - 1];
            this.addLine((ActivityDef)last, (ActivityDef)aaDef, pDef);
        }
        return aaDefs[0];
    }

    private ApproveActivityDef[] createApproveActivityDefs(ProcessDef pDef, ApproveActivityDef template, IDynamicWfService.DynamicActivityDef[] actDefs) throws WfException {
        ApproveActivityDef[] defs = new ApproveActivityDef[actDefs.length];
        for (int i = 0; i < defs.length; ++i) {
            defs[i] = this.createApproveActivityDef(pDef, template, actDefs[i]);
        }
        return defs;
    }

    private void setExtendAttribute(ActivityDef actDef, String name, String value) {
        ExtendedAttributeDef ead = new ExtendedAttributeDef();
        ead.setName(name);
        ead.setValue(value);
        actDef.getActivityHeader().getExtendedAttributes().setObject(name, (Object)ead);
    }

    private void setManulDecisionItems(ApproveActivityDef source, ApproveActivityDef target, ExtendedAttributeCollection attrs) throws WfException {
        ExtendedAttributeDef ead = attrs.get("manualDecisionItems");
        if (ead != null) {
            this.setExtendAttribute((ActivityDef)target, ead.getName(), ead.getValue());
        }
        Locale l1 = new Locale("l1");
        Locale l2 = new Locale("l2");
        Locale l3 = new Locale("l3");
        String manualIems_l1 = source.getManualDecisionItems(l1);
        String manualIems_l2 = source.getManualDecisionItems(l2);
        String manualIems_l3 = source.getManualDecisionItems(l3);
        if (!StringUtils.isEmpty((String)manualIems_l1)) {
            target.setManualDecisionItems(l1, manualIems_l1);
        }
        if (!StringUtils.isEmpty((String)manualIems_l2)) {
            target.setManualDecisionItems(l2, manualIems_l2);
        }
        if (!StringUtils.isEmpty((String)manualIems_l3)) {
            target.setManualDecisionItems(l3, manualIems_l3);
        }
    }

    private ApproveActivityDef createApproveActivityDef(ProcessDef pDef, ApproveActivityDef template, IDynamicWfService.DynamicActivityDef actDef) throws WfException {
        ActivityNode approveNode = new ActivityNode(pDef.getDiagram(), NodeType.APPROVEACTIVITY);
        ApproveActivityDef approveDef = (ApproveActivityDef)approveNode.getRefActivity();
        approveDef.setName(this.locale, actDef.actName);
        ExtendedAttributeCollection attrs = template.getActivityHeader().getExtendedAttributes();
        AssignmentMessage message = new AssignmentMessage((AbstractKpdlElement)approveDef);
        message.setSendMail(actDef.isSendMail);
        if (actDef.isSendSMS) {
            EMessage emessage = template.getEMessage();
            if (emessage == null) {
                emessage = new EMessage((AbstractKpdlElement)approveDef);
            }
            emessage.setType(0);
            emessage.setContent(this.locale, actDef.message);
            emessage.setEnable(true);
            approveDef.setEMessage(emessage);
        }
        message.setBody(this.locale, template.getMessage().getBody(this.locale));
        message.setTitle(this.locale, actDef.message);
        approveDef.setMessage(message);
        this.setManulDecisionItems(template, approveDef, attrs);
        approveDef.setAllowAssignNextPerformer(template.getAllowAssignNextPerformer());
        approveDef.setShowAllEmptyManpowerActivites(template.isShowAllEmptyManpowerActivites());
        approveDef.setAllowCancelSubmit(template.getAllowCancelSubmit());
        approveDef.setAllPersonAsPerformer(template.isAllPersonAsPerformer());
        approveDef.setKeepUsedDynamicPerformers(template.isKeepUsedDynamicPerformers());
        approveDef.setSendMutexAssignMsg(template.isSendMutexAssignMsg());
        approveDef.setSendMsg(template.isSendMsg());
        approveDef.setMustShowParticipantsCheckList(template.isMustShowParticipantsCheckList());
        approveDef.setShowAllManpowerActivities(template.isShowAllManpowerActivities());
        approveDef.setCanSpecifyNextActivityPerformer(template.canSpecifyNextActivityPerformer());
        ExtendedAttributeDef ead = attrs.get("nextPerson");
        if (ead != null) {
            this.setExtendAttribute((ActivityDef)approveDef, ead.getName(), ead.getValue());
        }
        if ((ead = attrs.get("MultiapproveWebConf")) != null) {
            this.setExtendAttribute((ActivityDef)approveDef, ead.getName(), ead.getValue());
        }
        if ((ead = attrs.get("MultiapproveWebConfDynPk")) != null) {
            this.setExtendAttribute((ActivityDef)approveDef, ead.getName(), ead.getValue());
        }
        if ((ead = attrs.get("isWebBillApprove")) != null) {
            this.setExtendAttribute((ActivityDef)approveDef, ead.getName(), ead.getValue());
        }
        if ((ead = attrs.get("WebBillApproveUrl")) != null) {
            this.setExtendAttribute((ActivityDef)approveDef, ead.getName(), ead.getValue());
        }
        approveDef.setKeepUsedDynamicPerformers(template.isKeepUsedDynamicPerformers());
        for (int i = 0; i < actDef.performers.length; ++i) {
            IDynamicWfService.Performer p = actDef.performers[i];
            ParticipantDef partDef = new ParticipantDef((ActivityDef)approveDef);
            partDef.setParticipantType(ParticipantType.HUMAN);
            partDef.setName(p.personName);
            partDef.setParticipantValue(p.personId);
            approveDef.getParticipants().add(partDef.getID(), partDef);
        }
        if (!"1".equals(actDef.acceptMode)) {
            this.setExtendAttribute((ActivityDef)approveDef, "Signable", "true");
            if ("2".equals(actDef.acceptMode)) {
                this.setExtendAttribute((ActivityDef)approveDef, "DynamicSignMode", "false");
            } else {
                this.setExtendAttribute((ActivityDef)approveDef, "DynamicSignMode", "true");
            }
        }
        this.setExtendAttribute((ActivityDef)approveDef, "appendActivity", String.valueOf(actDef.allowAppend));
        this.setExtendAttribute((ActivityDef)approveDef, "jumpTo", String.valueOf(actDef.allowJumpTo));
        this.setExtendAttribute((ActivityDef)approveDef, "kickBack", String.valueOf(actDef.allowKickBack));
        this.setExtendAttribute((ActivityDef)approveDef, "assignnextparticipantActivity", String.valueOf(actDef.allowSubmitNextPerformer));
        this.setExtendAttribute((ActivityDef)approveDef, "attachMode", String.valueOf(actDef.attachmentMode));
        FunctionDef fDef = new FunctionDef();
        fDef.setName("MultiApproveUIFunction");
        fDef.setOperation("ActionSubmit");
        fDef.setPackageName("com.kingdee.eas.base.multiapprove.client");
        FormalParameterCollection formalParams = new FormalParameterCollection((AbstractKpdlElement)pDef);
        ActualParameterCollection actualParams = approveDef.getActualParameters();
        FormalParameterCollection formalParamsTmp = template.getRelatedApplication().getFormalParameters();
        ActualParameterCollection actualParamsTmp = template.getActualParameters();
        for (int i = 0; i < formalParamsTmp.size(); ++i) {
            String type;
            String propertyName;
            String boName;
            FormalParameterDef fpTmp = formalParamsTmp.get(i);
            FormalParameterDef formalParam = new FormalParameterDef((AbstractKpdlElement)pDef);
            formalParam.setIndex(i);
            formalParam.setID(fpTmp.getID());
            String dataFieldId = actualParamsTmp.get(formalParam.getIndex()).getExpr();
            formalParam.setDataField(pDef, pDef.getDataFields().get(dataFieldId));
            formalParam.setDataType(fpTmp.getDataType());
            formalParam.setMode(fpTmp.getMode());
            String boid = fpTmp.getBoId();
            if (boid != null) {
                formalParam.setBoId(boid);
            }
            if ((boName = fpTmp.getBoName()) != null) {
                formalParam.setBoName(boName);
            }
            if ((propertyName = fpTmp.getPropertyName()) != null) {
                formalParam.setPropertyName(propertyName);
            }
            if ((type = fpTmp.getType()) != null) {
                formalParam.setType(type);
            }
            formalParams.add(formalParam.getID(), formalParam);
            ActualParameterDef actualParam = new ActualParameterDef((IExecuteObject)pDef);
            actualParam.setIndex(i);
            actualParam.setExpr(dataFieldId);
            actualParam.setProp(actualParamsTmp.get(formalParam.getIndex()).getProp());
            actualParams.add(actualParam);
        }
        ApplicationDef application = new ApplicationDef(pDef);
        application.setFunction(fDef);
        application.setType(ApplicationType.MANPOWER);
        application.setFormalParameters(formalParams);
        ExtendedAttributeCollection aeac = template.getRelatedApplication().getExtendedAttributes();
        if (aeac.get("RefBOIDDatafield") != null) {
            ExtendedAttributeDef extendAttrDef = new ExtendedAttributeDef();
            extendAttrDef.setName("RefBOIDDatafield");
            extendAttrDef.setValue(aeac.get("RefBOIDDatafield").getValue());
            application.getExtendedAttributes().add("RefBOIDDatafield", extendAttrDef);
        }
        pDef.getApplications().add(application.getID(), application);
        approveDef.setRelatedApplication(application);
        return approveDef;
    }
}

