/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheService;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.workflow.monitor.SummaryInfo;
import com.kingdee.bos.workflow.monitor.SummaryItemInfo;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class SelectorBuilder {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.monitor.app.SummaryCache");
    private static final String BILLDIGESTSELECTORCACHE = "billdigestselectorcache";

    public static SelectorItemCollection getSelector(SummaryInfo summary, int digType) {
        if (1 != digType) {
            return SelectorBuilder.buildSelector(summary);
        }
        String pk = summary.getShcemaId() + "&" + summary.getMetadataPK();
        SelectorItemCollection col = SelectorBuilder.getFromCache(pk);
        if (col == null) {
            col = SelectorBuilder.buildSelector(summary);
            SelectorBuilder.storeToCache(pk, col);
        }
        return col;
    }

    private static SelectorItemCollection buildSelector(SummaryInfo summary) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        String name = summary.getName();
        if (StringUtils.isEmpty((String)name)) {
            List<SummaryItemInfo> items = summary.getSummaryItems();
            for (SummaryItemInfo summaryItemInfo : items) {
                SelectorItemInfo selector = new SelectorItemInfo();
                selector.setPropertyName(summaryItemInfo.getName());
                selectors.add(selector);
            }
        } else {
            SelectorItemInfo selector = new SelectorItemInfo();
            selector.setPropertyName(name + ".id");
            selectors.add(selector);
            List<SummaryItemInfo> items = summary.getSummaryItems();
            for (SummaryItemInfo item : items) {
                selector = new SelectorItemInfo();
                selector.setPropertyName(name + "." + item.getName());
                selectors.add(selector);
            }
        }
        List<SummaryInfo> entrys = summary.getEntrys();
        for (SummaryInfo summaryInfo : entrys) {
            SelectorItemCollection subcol = SelectorBuilder.buildSelector(summaryInfo);
            selectors.addObjectCollection((IObjectCollection)subcol);
        }
        return selectors;
    }

    public static SelectorItemCollection getSelector(SummaryInfo summary, String group, int digType) {
        if (1 != digType) {
            return SelectorBuilder.buildSelector(summary, group);
        }
        String pk = summary.getShcemaId() + "&" + summary.getMetadataPK() + "&" + group;
        SelectorItemCollection col = SelectorBuilder.getFromCache(pk);
        if (col == null) {
            col = SelectorBuilder.buildSelector(summary, group);
            SelectorBuilder.storeToCache(pk, col);
        }
        return col;
    }

    private static SelectorItemCollection buildSelector(SummaryInfo summary, String group) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        SummaryInfo entry = summary.getEntry(group);
        List<SummaryItemInfo> items = entry.getSummaryItems();
        for (SummaryItemInfo item : items) {
            SelectorItemInfo selector = new SelectorItemInfo();
            selector.setPropertyName(group + "." + item.getName());
            selectors.add(selector);
        }
        List<SummaryInfo> subentrys = entry.getEntrys();
        for (SummaryInfo subentry : subentrys) {
            String GroupName = subentry.getName();
            SelectorItemCollection subcol = SelectorBuilder.buildSelector(entry, GroupName);
            selectors.addObjectCollection((IObjectCollection)subcol);
        }
        return selectors;
    }

    private static synchronized SelectorItemCollection getFromCache(String pk) {
        Object obj;
        EhcacheService ehcacheService = EhcacheService.getInstance();
        if (ehcacheService != null && (obj = ehcacheService.getCache(BILLDIGESTSELECTORCACHE, pk, true)) instanceof SelectorItemCollection) {
            return (SelectorItemCollection)obj;
        }
        return null;
    }

    private static synchronized void storeToCache(String key, SelectorItemCollection value) {
        EhcacheService ehcacheService = EhcacheService.getInstance();
        if (ehcacheService != null && value != null) {
            ehcacheService.putCache(BILLDIGESTSELECTORCACHE, key, (Object)value, 0L);
        } else {
            logger.error((Object)"can't store to cache because Ehcache not available");
        }
    }

    public static synchronized void clear() {
        EhcacheService ehcacheService = EhcacheService.getInstance();
        if (ehcacheService != null) {
            ehcacheService.removeCacheRegion(BILLDIGESTSELECTORCACHE);
        } else {
            logger.error((Object)"can't store to cache because Ehcache not available");
        }
    }
}

