/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.TimerIntermediateEventActivityDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IWfUserAdapter;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.PostParticipantUtil;
import com.kingdee.bos.workflow.monitor.app.AbstractWfMonitorImageUIFacade;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfMonitorImageUIFacade
extends AbstractWfMonitorImageUIFacade {
    protected static final Logger logger = Logger.getLogger(WfMonitorImageUIFacade.class);
    protected Context ctx;
    private Locale locale;

    public WfMonitorImageUIFacade(Context ctx) {
        this.ctx = ctx;
        this.locale = ctx.getLocale();
    }

    @Override
    public final String getActTips(String procInstId, String actDefId, String actInstIds) throws Exception {
        String[] ids = actInstIds == null || actInstIds.length() == 0 ? null : actInstIds.split(";");
        String s = this.getActTips(procInstId, actDefId, ids);
        if (s.indexOf("<") >= 0) {
            s = s.replaceAll("12pt", "9pt");
        }
        return s;
    }

    @Override
    public String getActTips(String procInstId, String actDefId, String[] actInstIds) throws Exception {
        if (procInstId == null || procInstId.length() == 0 || actDefId == null || actDefId.length() == 0) {
            return "";
        }
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        if (actInstIds != null) {
            Map personmap = this.getPerson(svc, procInstId, actDefId);
            if (personmap.containsKey("EventTimerInvoke")) {
                return (String)personmap.get("EventTimerInvoke");
            }
            return this.getActivityPerformers(svc, actInstIds, personmap);
        }
        return this.getParticipants(svc, procInstId, actDefId);
    }

    private Map getTimeWaitActTips(IEnactmentService svc, String procInstId, String actDefId) throws WfException {
        String key = "EventTimerInvoke:" + actDefId;
        Object raw = svc.getProcessContext(procInstId, key);
        HashMap<String, String> map = new HashMap<String, String>();
        if (raw == null) {
            map.put("EventTimerInvoke", "\u5df2\u7ecf\u6267\u884c0\u6b21");
            return map;
        }
        String[] val = (String[])raw;
        String tips = "\u5df2\u7ecf\u6267\u884c" + val[0] + "\u6b21,\u4e0a\u6b21\u6267\u884c\u8017\u65f6" + val[1] + "ms";
        map.put("EventTimerInvoke", tips);
        return map;
    }

    protected final Map getPerson(IEnactmentService svc, String procInstId, String actDefId) throws Exception {
        ArrayList designatedPersons;
        String key;
        Object o;
        ProcessInstInfo pInfo = null;
        ProcessDefInfo pdInfo = null;
        if (!procInstId.endsWith("WFPRCDEF")) {
            pInfo = svc.getProcessInstInfo(procInstId);
        } else {
            pdInfo = svc.getProcessDefInfo(procInstId);
        }
        ProcessDef pDef = svc.getProcessDefByDefineHashValue(pInfo == null ? pdInfo.getMd5HashValue() : pInfo.getProcDefHashValue());
        ActivityDef aDef = pDef.getActivityDef(actDefId);
        if (aDef instanceof TimerIntermediateEventActivityDef) {
            return this.getTimeWaitActTips(svc, procInstId, actDefId);
        }
        if (!(aDef instanceof ManpowerActivityDef) && !(aDef instanceof MessageActivityDef)) {
            return null;
        }
        if (pInfo != null && (o = svc.getProcessContext(procInstId, key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)aDef))) instanceof ArrayList && (designatedPersons = (ArrayList)o).size() > 0) {
            ArrayList persons = PostParticipantUtil.queryPerson("id", "id,number,name", designatedPersons, "com.kingdee.eas.basedata.person.app.F7PersonQuery", "name", this.ctx);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < persons.size(); ++i) {
                Object name = ((HashMap)persons.get(i)).get("name");
                if (name == null) continue;
                map.put(name.toString(), name.toString());
            }
            return map;
        }
        ArrayList<String> pList = new ArrayList<String>();
        ParticipantCollection participants = aDef instanceof ManpowerActivityDef ? ((ManpowerActivityDef)aDef).getParticipants() : ((MessageActivityDef)aDef).getReceivers();
        for (int i = 0; i < participants.size(); ++i) {
            pList.add(participants.get(i).getID());
        }
        List persons = new ArrayList();
        try {
            persons = pInfo == null ? svc.getPersonsByDefParticipants(pdInfo.getMd5HashValue(), actDefId, pList, this.ctx.getCaller().toString()) : svc.getPersonsByParticipants(procInstId, actDefId, pList);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Locale l = this.ctx.getLocale();
        Locale l2 = new Locale("l2");
        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
        for (Person person : persons) {
            String name = person.getUserName(l);
            if (name == null) {
                name = person.getUserName(l2);
            }
            if (name == null) {
                name = person.getEmployeeId();
            }
            if (name == null) continue;
            map1.put(name.toString(), name.toString());
        }
        return map1;
    }

    protected final String getParticipants(IEnactmentService svc, String procInstId, String actDefId) throws Exception {
        ArrayList designatedPersons;
        String key;
        Object o;
        ProcessInstInfo pInfo = null;
        ProcessDefInfo pdInfo = null;
        if (!procInstId.endsWith("WFPRCDEF")) {
            pInfo = svc.getProcessInstInfo(procInstId);
        } else {
            pdInfo = svc.getProcessDefInfo(procInstId);
        }
        ProcessDef pDef = svc.getProcessDefByDefineHashValue(pInfo == null ? pdInfo.getMd5HashValue() : pInfo.getProcDefHashValue());
        ActivityDef aDef = pDef.getActivityDef(actDefId);
        if (!(aDef instanceof ManpowerActivityDef) && !(aDef instanceof MessageActivityDef)) {
            return null;
        }
        HashSet<Object> s = new HashSet<Object>();
        if (pInfo != null && (o = svc.getProcessContext(procInstId, key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)aDef))) instanceof ArrayList && (designatedPersons = (ArrayList)o).size() > 0) {
            ArrayList persons = PostParticipantUtil.queryPerson("id", "id,number,name", designatedPersons, "com.kingdee.eas.basedata.person.app.F7PersonQuery", "name", this.ctx);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < persons.size(); ++i) {
                Object name = ((HashMap)persons.get(i)).get("name");
                if (s.contains(name)) continue;
                s.add(name);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(name);
            }
            String designatedParticipants = "";
            designatedParticipants = this.locale.equals(new Locale("L1")) ? "Designated Participants:" : (this.locale.equals(new Locale("L3")) ? "\u6307\u5b9a\u7684\u53c3\u8207\u4eba:" : "\u6307\u5b9a\u7684\u53c2\u4e0e\u4eba:");
            return designatedParticipants + sb.toString();
        }
        ArrayList<String> pList = new ArrayList<String>();
        ParticipantCollection participants = aDef instanceof ManpowerActivityDef ? ((ManpowerActivityDef)aDef).getParticipants() : ((MessageActivityDef)aDef).getReceivers();
        for (int i = 0; i < participants.size(); ++i) {
            pList.add(participants.get(i).getID());
        }
        List persons = pInfo == null ? svc.getPersonsByDefParticipants(pdInfo.getMd5HashValue(), actDefId, pList, this.ctx.getCaller().toString()) : svc.getPersonsByParticipantsNew(procInstId, aDef, pList);
        StringBuffer sb = new StringBuffer();
        Locale l = this.ctx.getLocale();
        Locale l2 = new Locale("l2");
        int count = 0;
        for (Person person : persons) {
            String name = person.getUserName(l);
            if (name == null) {
                name = person.getUserName(l2);
            }
            if (name == null) {
                name = person.getEmployeeId();
            }
            if (s.contains(name)) continue;
            s.add(name);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(name);
            if (++count <= 50) continue;
            String tips0 = "";
            tips0 = this.locale.equals(new Locale("L1")) ? "and so on... " : (this.locale.equals(new Locale("L3")) ? ", \u7b49..." : ", \u7b49...");
            sb.append(tips0);
            break;
        }
        String estimatedParticipants = "";
        estimatedParticipants = this.locale.equals(new Locale("L1")) ? "Estimated Participants:" : (this.locale.equals(new Locale("L3")) ? "\u4f30\u7b97\u7684\u53c3\u8207\u4eba:" : "\u4f30\u7b97\u7684\u53c2\u4e0e\u4eba:");
        return estimatedParticipants + sb.toString();
    }

    protected final String getActivityPerformers(IEnactmentService svc, String[] actInstIds, Map personmap) throws Exception {
        ProcessInstInfo procInstInfo = null;
        ActivityDef aDef = null;
        StringBuffer sb = new StringBuffer();
        String activityLabel1 = "";
        activityLabel1 = this.locale.equals(new Locale("L1")) ? "This activity has " : (this.locale.equals(new Locale("L3")) ? "\u8a72\u6d3b\u52d5\u5b58\u5728" : "\u8be5\u6d3b\u52a8\u5b58\u5728");
        String instanceCount = "";
        instanceCount = this.locale.equals(new Locale("L1")) ? "Instances. " : (this.locale.equals(new Locale("L3")) ? "\u6b21\u5be6\u4f8b\u3002" : "\u6b21\u5b9e\u4f8b\u3002");
        sb.append(activityLabel1 + actInstIds.length + instanceCount);
        for (int i = 0; i < actInstIds.length; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            String tips1 = "";
            tips1 = this.locale.equals(new Locale("L1")) ? "The " : (this.locale.equals(new Locale("L3")) ? "\u7b2c" : "\u7b2c");
            String tips2 = "";
            tips2 = this.locale.equals(new Locale("L1")) ? "time Participants:" : (this.locale.equals(new Locale("L3")) ? "\u6b21\u5be6\u4f8b\u57f7\u884c\u4eba:" : "\u6b21\u5b9e\u4f8b\u6267\u884c\u4eba:");
            sb.append("\r\n" + tips1).append(i + 1).append(tips2);
            AssignmentInfo[] assignments = svc.getAllAssignmentByActInstId(actInstIds[i]);
            if (assignments.length == 0) {
                if (procInstInfo == null) {
                    ActivityInstInfo aInfo = svc.getActivityInstByActInstId(actInstIds[i]);
                    procInstInfo = svc.getProcessInstInfo(aInfo.getProcInstId());
                    aDef = svc.getProcessDefByDefineHashValue(procInstInfo.getProcDefHashValue()).getActivityDef(aInfo.getActDefId());
                }
                StringBuffer usernames = new StringBuffer();
                if (procInstInfo.getParentProcInstId() == null) {
                    boolean isFirst = false;
                    ActivityCollection acts = aDef.getPreviousActivities();
                    for (int j = 0; j < acts.size(); ++j) {
                        if (!(acts.get(j) instanceof StartActivityDef)) continue;
                        isFirst = true;
                    }
                    if (isFirst) {
                        usernames.append(procInstInfo.getInitiatorName(this.ctx.getLocale()));
                    }
                }
                if (aDef instanceof MessageActivityDef) {
                    String messageActUserIdsSql = "select number,name where id in (select freceiver from t_bas_message where ftype = 0 AND fbizType = 0 and fsourceid ='" + actInstIds[i] + "') ";
                    UserCollection users = UserFactory.getLocalInstance((Context)this.ctx).getUserCollection(messageActUserIdsSql);
                    for (int t = 0; t < users.size(); ++t) {
                        String name = users.get(t).getName(this.ctx.getLocale());
                        if (usernames.indexOf(name) > -1) continue;
                        if (t > 0) {
                            usernames.append(",");
                        }
                        usernames.append(name);
                    }
                }
                sb.append(usernames.toString());
                continue;
            }
            String s = this.getPerformerNames(assignments, WfAssignmentState.COMPLETED, personmap);
            if (s.length() > 0) {
                sb.append("{" + WfAssignmentState.COMPLETED.getAlias(this.locale) + "- ").append(s).append("}");
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.ASSIGNED, personmap)).length() > 0) {
                sb.append("{" + WfAssignmentState.ASSIGNED.getAlias(this.locale) + "- ").append(s).append("}");
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.CANCELED, personmap)).length() > 0) {
                sb.append("{" + WfAssignmentState.CANCELED.getAlias(this.locale) + "- ").append(s).append("}");
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.REJECTED, personmap)).length() > 0) {
                sb.append("{" + WfAssignmentState.REJECTED.getAlias(this.locale) + "- ").append(s).append("}");
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.NOT_ASSIGNED, personmap)).length() > 0) {
                if ("l1".equalsIgnoreCase(this.locale.getLanguage())) {
                    sb.append("{Not Assigned - ").append(s).append("}");
                } else {
                    sb.append("{\u672a\u5206\u914d- ").append(s).append("}");
                }
            }
            if ((s = this.getPerformerNames(assignments, WfAssignmentState.PROCESSING, personmap)).length() == 0) {
                s = this.getPerformerNames(assignments, WfAssignmentState.ACCEPTED, personmap);
            }
            if (s.length() <= 0) continue;
            sb.append("{" + WfAssignmentState.PROCESSING.getAlias(this.locale) + "- ").append(s).append("}");
        }
        return sb.toString();
    }

    protected final String getPerformerNames(AssignmentInfo[] assignments, WfAssignmentState state, Map personmap) throws Exception {
        IWfUserAdapter uf = null;
        StringBuffer usernames = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int j = 0; j < assignments.length; ++j) {
            AssignmentInfo assignment = assignments[j];
            if (!state.equals((Object)assignment.getState())) continue;
            String agentUserId = assignment.getUserId();
            String agentUserName = assignment.getUserName(this.ctx.getLocale());
            String name = this.handleResponsible(assignment.getAssignmentId(), agentUserId, agentUserName);
            if (name == null) {
                if (uf == null) {
                    uf = ConfigLoader.getConfig4Server().getUserAdapter(this.ctx);
                }
                if ((name = uf.getUser((String)assignment.getUserId()).name) == null) {
                    name = assignment.getUserId();
                }
            }
            if (name != null) {
                map.put(name, name);
            }
            if (usernames.indexOf(name) > -1) continue;
            if (usernames.length() > 0) {
                usernames.append(",");
            }
            usernames.append(name);
        }
        StringBuffer newusernames = new StringBuffer();
        for (Map.Entry entry : personmap.entrySet()) {
            String key = entry.getKey().toString();
            if (newusernames.length() > 0 && map.containsKey(key)) {
                newusernames.append(",");
            }
            if (!map.containsKey(key)) continue;
            newusernames.append(key);
            map.remove(key);
        }
        if (newusernames.length() > 0) {
            if (map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    String key = entry.getKey().toString();
                    if (newusernames.length() > 0) {
                        newusernames.append(",");
                    }
                    newusernames.append(key);
                }
            }
            return newusernames.toString();
        }
        return usernames.toString();
    }

    private String handleResponsible(String assignmentId, String agentUserId, String agentUserName) throws BOSException, EASBizException {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo assign = svc.getAssignmentById(assignmentId);
        String personId = assign.getResponsibleEmpId();
        String str = "";
        if (personId != null) {
            PersonCollection pc = PersonFactory.getLocalInstance((Context)this.ctx).getPersonCollection("where id='" + personId + "'");
            if (pc.size() > 0 && !personId.equals(agentUserId)) {
                String responsibleName = pc.get(0).getName(this.ctx.getLocale());
                str = "l1".equalsIgnoreCase(this.locale.getLanguage()) ? "(" + agentUserName + " agent for " + responsibleName + ")" : "(" + agentUserName + " \u4ee3\u7406 " + responsibleName + ")";
            }
        } else {
            str = agentUserName;
        }
        return str;
    }
}

