/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.monitor.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.monitor.app.WfMonitorImageUIFacade;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.List;

public class WfMonitorImageUIFacade2
extends WfMonitorImageUIFacade {
    public WfMonitorImageUIFacade2(Context ctx) {
        super(ctx);
    }

    private String getPersonInfos(ArrayList personIds) throws Exception {
        StringBuffer oql = new StringBuffer();
        for (int i = 0; i < personIds.size(); ++i) {
            Object o = personIds.get(i);
            if (o == null) continue;
            if (oql.length() > 0) {
                oql.append(",");
            }
            oql.append("'").append(o).append("'");
        }
        if (oql.length() == 0) {
            return "";
        }
        IPerson p = PersonFactory.getLocalInstance((Context)this.ctx);
        CoreBaseCollection pc = p.getCollection("select name, cell where id in(" + oql + ")");
        StringBuffer infos = new StringBuffer();
        for (int i = 0; i < pc.size(); ++i) {
            if (infos.length() > 0) {
                infos.append(",");
            }
            CoreBaseInfo cb = pc.get(i);
            String name = cb.getString("name");
            infos.append(name);
            String cell = cb.getString("cell");
            if (cell == null) continue;
            infos.append("[").append(cell).append("]");
        }
        return infos.toString();
    }

    @Override
    public String getActTips(String procInstId, String actDefId, String[] actInstIds) throws Exception {
        ArrayList designatedPersons;
        String key;
        Object o;
        if (procInstId == null || procInstId.length() == 0 || actDefId == null || actDefId.length() == 0) {
            return "";
        }
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        if (actInstIds != null) {
            return this.getActivityPerformers2(svc, actInstIds);
        }
        ProcessInstInfo pInfo = null;
        ProcessDefInfo pdInfo = null;
        if (!procInstId.endsWith("WFPRCDEF")) {
            pInfo = svc.getProcessInstInfo(procInstId);
        } else {
            pdInfo = svc.getProcessDefInfo(procInstId);
        }
        ProcessDef pDef = svc.getProcessDefByDefineHashValue(pInfo == null ? pdInfo.getMd5HashValue() : pInfo.getProcDefHashValue());
        ActivityDef aDef = pDef.getActivityDef(actDefId);
        if (!(aDef instanceof ManpowerActivityDef)) {
            return null;
        }
        if (pInfo != null && (o = svc.getProcessContext(procInstId, key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)aDef))) instanceof ArrayList && (designatedPersons = (ArrayList)o).size() > 0) {
            return "\u6307\u5b9a\u7684\u53c2\u4e0e\u4eba: " + this.getPersonInfos(designatedPersons);
        }
        ArrayList<String> pList = new ArrayList<String>();
        ParticipantCollection participants = ((ManpowerActivityDef)aDef).getParticipants();
        for (int i = 0; i < participants.size(); ++i) {
            pList.add(participants.get(i).getID());
        }
        List persons = pInfo == null ? svc.getPersonsByDefParticipants(pdInfo.getMd5HashValue(), actDefId, pList, this.ctx.getCaller().toString()) : svc.getPersonsByParticipants(procInstId, actDefId, pList);
        ArrayList<String> personIds = new ArrayList<String>();
        for (Person person : persons) {
            personIds.add(person.getEmployeeId());
            if (personIds.size() != 50) continue;
            break;
        }
        return "\u4f30\u7b97\u7684\u53c2\u4e0e\u4eba: " + this.getPersonInfos(personIds) + (persons.size() > 50 ? ",\u7b49..." : "");
    }

    private String getActivityPerformers2(IEnactmentService svc, String[] actInstIds) throws Exception {
        ProcessInstInfo procInstInfo = null;
        ActivityDef aDef = null;
        StringBuffer sb = new StringBuffer();
        sb.append("\u8be5\u6d3b\u52a8\u5b58\u5728" + actInstIds.length + "\u6b21\u5b9e\u4f8b");
        IUser user = null;
        for (int i = 0; i < actInstIds.length; ++i) {
            ArrayList<String> personIds;
            block6: {
                AssignmentInfo[] assignments;
                block5: {
                    personIds = new ArrayList<String>();
                    assignments = svc.getAssignmentByActInstId(actInstIds[i]);
                    if (assignments.length != 0) break block5;
                    if (procInstInfo == null) {
                        ActivityInstInfo aInfo = svc.getActivityInstByActInstId(actInstIds[i]);
                        procInstInfo = svc.getProcessInstInfo(aInfo.getProcInstId());
                        aDef = svc.getProcessDefByDefineHashValue(procInstInfo.getProcDefHashValue()).getActivityDef(aInfo.getActDefId());
                    }
                    if (procInstInfo.getParentProcInstId() != null) break block6;
                    boolean isFirst = false;
                    ActivityCollection acts = aDef.getPreviousActivities();
                    for (int j = 0; j < acts.size(); ++j) {
                        if (!(acts.get(j) instanceof StartActivityDef)) continue;
                        isFirst = true;
                        break;
                    }
                    if (!isFirst) break block6;
                    if (user == null) {
                        user = UserFactory.getLocalInstance((Context)this.ctx);
                    }
                    String personId = user.getUserInfo("where id='" + procInstInfo.getInitiatorId() + "'").getPerson().getId().toString();
                    personIds.add(personId);
                    break block6;
                }
                for (int j = 0; j < assignments.length; ++j) {
                    AssignmentInfo assignment = assignments[j];
                    String personId = assignment.getEmployeeId();
                    personIds.add(personId);
                }
            }
            sb.append(";\r\n\u7b2c").append(i + 1).append("\u6b21\u5b9e\u4f8b\u6267\u884c\u4eba: ");
            sb.append(this.getPersonInfos(personIds));
        }
        return sb.toString();
    }
}

