/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.metas.IInvokeMethodDelegate;
import com.kingdee.bos.workflow.metas.InvokeMethodDelegateFactory;
import com.kingdee.bos.workflow.statsa.syn.SAProcessDATASync;
import com.kingdee.bos.workflow.statsa.util.SAUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SAProcessDATASyncMange {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.statsa.syn.SAProcessDATASync");
    private int days = 0;
    private int batchCount = 0;
    public static int maxNumber = 10000;
    private Context ctx;
    public static boolean syncSwitch = true;
    public static boolean logIsClose = true;

    public SAProcessDATASyncMange(Context ctx, int batchCount, int days) {
        this.batchCount = batchCount;
        this.ctx = ctx;
        this.days = days;
    }

    public static void setMaxNumber(int number) {
        maxNumber = number;
    }

    public static void setOn() {
        logIsClose = false;
    }

    public static void setStop() {
        syncSwitch = false;
    }

    public synchronized int sync() throws BOSException {
        int procinstCount = 0;
        syncSwitch = true;
        try {
            List<String> procinstIdList = this.getProcInstList();
            IInvokeMethodDelegate delegate = InvokeMethodDelegateFactory.getLocalInstance((Context)this.ctx);
            for (int number = 0; procinstIdList.size() > 0 && number < maxNumber && syncSwitch; ++number) {
                procinstCount += procinstIdList.size();
                String tWhereSql = SAUtil.coverListToInWhereSql(procinstIdList);
                delegate.invokeRequiresNew(this.getClass().getName(), (Object)this, "syncRequiresNew", new Class[]{String.class}, new Object[]{tWhereSql});
                procinstIdList = this.getProcInstList();
            }
            return procinstCount;
        }
        catch (Exception e) {
            log.error((Object)"\u7edf\u8ba1\u6570\u636e\u540c\u6b65\u51fa\u9519", (Throwable)e);
            throw new BOSException("\u7edf\u8ba1\u6570\u636e\u540c\u6b65\u51fa\u9519", (Throwable)e);
        }
    }

    public void syncRequiresNew(String procinstInsql) throws BOSException, SQLException {
        SAProcessDATASync processSyn = new SAProcessDATASync(this.ctx);
        processSyn.sync(procinstInsql);
    }

    private List<String> getProcInstList() throws SQLException, BOSException {
        ArrayList<String> procInstList = new ArrayList<String>();
        StringBuffer tSql = new StringBuffer();
        tSql.append("select top ").append(this.batchCount);
        tSql.append(" a.fprocinstid from t_wfr_procinstview a where ");
        tSql.append(" a.FSTATE = 'closed.completed' and a.FCOMLETETIME is not null");
        tSql.append(" and not exists (select 1 from T_WFR_SAProcInst where a.fprocinstid = fprocinstid ) ");
        tSql.append(" and not exists (select 1 from T_WFR_SARecordProc where a.fprocinstid = fprocinstid )");
        tSql.append(" AND (DATEDIFF(Day,a.FCOMLETETIME,GETDATE()) <= " + this.days + ")");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)tSql.toString());
        while (rowSet.next()) {
            String procinstId = rowSet.getString("fprocinstid");
            procInstList.add(procinstId);
        }
        return procInstList;
    }
}

