/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.IProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.workflow.metas.ExecutorAnalysisFactory;
import com.kingdee.bos.workflow.metas.ExecutorAnalysisInfo;
import com.kingdee.bos.workflow.metas.HandleWay;
import com.kingdee.bos.workflow.metas.IExecutorAnalysis;
import com.kingdee.bos.workflow.metas.IInvokeMethodDelegate;
import com.kingdee.bos.workflow.metas.InvokeMethodDelegateFactory;
import com.kingdee.bos.workflow.statsa.caldate.SAWorkCalendarUtil;
import com.kingdee.bos.workflow.statsa.service.SAProcessDATASyncMange;
import com.kingdee.bos.workflow.statsa.syn.SAActinstDATASync;
import com.kingdee.bos.workflow.statsa.syn.SARecoredDeal;
import com.kingdee.bos.workflow.statsa.util.SAUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SAProcessDATASyncService {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.statsa.service.SAProcessDATASyncService");
    private int minDay = 180;
    private int batchCount = 100;
    private static Map<String, String> entityMap = new HashMap<String, String>();
    private Map<String, Long> procdefOvertime = new HashMap<String, Long>();

    public boolean saSync(Context ctx, boolean isReExtract, int day) throws BOSException {
        log.error((Object)"SAProcessDATASyncService saSync start-------------------");
        Timestamp synStartTime = SAUtil.getTime();
        String errorStack = "";
        int procinstCount = 0;
        boolean isSuccess = false;
        try {
            SAWorkCalendarUtil.existWorkCalendar(ctx, day);
            if (isReExtract) {
                SAProcessDATASyncService.truncateSAData(ctx);
            }
            if (day < this.minDay) {
                day = this.minDay;
            }
            SAWorkCalendarUtil.clearWorkCalender();
            SAProcessDATASyncMange tSAProcessDATASyncMange = new SAProcessDATASyncMange(ctx, this.batchCount, day);
            procinstCount = tSAProcessDATASyncMange.sync();
            IInvokeMethodDelegate delegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
            delegate.invokeRequiresNew(this.getClass().getName(), (Object)this, "syncExecutorAnalysisData", new Class[]{Integer.TYPE, Context.class}, new Object[]{day, ctx});
            isSuccess = true;
        }
        catch (BOSException e) {
            log.error((Object)e);
            errorStack = SARecoredDeal.exceptionToString((Exception)((Object)e));
            throw e;
        }
        finally {
            SARecoredDeal tSARecoredDeal = new SARecoredDeal();
            tSARecoredDeal.saveRecordInNewTransaction(ctx, isSuccess, synStartTime, isReExtract, day, procinstCount, errorStack);
            SAActinstDATASync.clearMap();
        }
        log.error((Object)"SAProcessDATASyncService saSync end-------------------");
        return isSuccess;
    }

    public static synchronized void truncateSAData(Context ctx) throws BOSException {
        try {
            String sqlProcinst = "truncate table T_WFR_SAProcInst";
            DbUtil.execute((Context)ctx, (String)sqlProcinst);
            String sqlActInst = "truncate table T_WFR_SAActInst";
            DbUtil.execute((Context)ctx, (String)sqlActInst);
            String sqlAssign = "truncate table T_WFR_SAAssign";
            DbUtil.execute((Context)ctx, (String)sqlAssign);
            String sqlMulti = "truncate table T_WFR_SAMultiApprove";
            DbUtil.execute((Context)ctx, (String)sqlMulti);
            String sqlOperate = "truncate table T_WFR_SAOperate";
            DbUtil.execute((Context)ctx, (String)sqlOperate);
            String sqlRecoredProc = "truncate table T_WFR_SARecordProc";
            DbUtil.execute((Context)ctx, (String)sqlRecoredProc);
            String sqlExecutorAnalysis = "truncate table T_WFR_ExecutorAnalysis";
            DbUtil.execute((Context)ctx, (String)sqlExecutorAnalysis);
        }
        catch (Exception e) {
            log.error((Object)"\u6e05\u7406\u540c\u6b65\u6570\u636e\u8868\u51fa\u9519", (Throwable)e);
            throw new BOSException("\u6e05\u7406\u540c\u6b65\u6570\u636e\u8868\u51fa\u9519", (Throwable)e);
        }
    }

    public void syncExecutorAnalysisData(int day, Context ctx) throws BOSException {
        try {
            StringBuffer tSql = new StringBuffer();
            tSql.append("SELECT a.FASSIGNID as assignid,a.FPERSONEMPID as personid,b.FCONTROLUNITID as userorgid,a.FBIZFUNCTION as bizfunction,c.FISPASS as ispass,a.FBILLENTITY as billentity,a.FCREATEDTIME as createtime,a.FENDTIME as endtime,a.FPERSONUSERID as userid,a.FPROCDEFID as procdefid,d.FOvertimeSecond as overtime FROM T_wfr_assigndetail a INNER JOIN T_pm_user b on a.FPERSONUSERID =b.fid LEFT OUTER JOIN T_bas_multiapprove c on a.FASSIGNID =c.FASSIGNMENTID LEFT OUTER JOIN T_WFR_ProcOverTimeConfig d on a.FPROCDEFID =d.FPROCDEFID where a.FSTATE =16 and c.FINPUTTYPE!=5 and a.FPERSONEMPID is not null and not exists (select 1 from T_WFR_ExecutorAnalysis where a.fassignid = fassignid ) and DATEDIFF(Day,a.FENDTIME ,GETDATE()) <= ");
            tSql.append(day);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)tSql.toString());
            IExecutorAnalysis executorAnalysis = ExecutorAnalysisFactory.getLocalInstance((Context)ctx);
            while (rowSet.next()) {
                ExecutorAnalysisInfo info = new ExecutorAnalysisInfo();
                String assignID = rowSet.getString("assignid");
                String personID = rowSet.getString("personid");
                String userOrgID = rowSet.getString("userorgid");
                String function = rowSet.getString("bizfunction");
                String isPass = rowSet.getString("ispass");
                String billEntity = rowSet.getString("billentity");
                Timestamp createTime = rowSet.getTimestamp("createtime");
                Timestamp endTime = rowSet.getTimestamp("endtime");
                String userID = rowSet.getString("userid");
                String procdefID = rowSet.getString("procdefid");
                BigDecimal approvalTime = new BigDecimal(SAWorkCalendarUtil.calExecuteTime(ctx, createTime, endTime, null).doubleValue() * 60.0);
                info.setApprovalTime(approvalTime);
                BigDecimal overtime = rowSet.getBigDecimal("overtime");
                if (overtime == null) {
                    overtime = new BigDecimal(86400);
                }
                this.calcOvertime(info, overtime.longValue(), procdefID);
                info.setAssignID(assignID);
                info.setPersonID(personID);
                info.setUserOrgID(userOrgID);
                info.setUserID(userID);
                info.setBillType(this.getEntityAlias(billEntity, ctx));
                info.setHandleWay(this.getHandlerWay(function, isPass));
                executorAnalysis.addnew(info);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u7edf\u8ba1\u6570\u636e\u540c\u6b65\u51fa\u9519", (Throwable)e);
            throw new BOSException("\u7edf\u8ba1\u6570\u636e\u540c\u6b65\u51fa\u9519", (Throwable)e);
        }
    }

    private void calcOvertime(ExecutorAnalysisInfo info, long overtime, String procdefID) {
        long overtimeL = 0L;
        if (this.procdefOvertime.containsKey(procdefID)) {
            overtimeL = this.procdefOvertime.get(procdefID);
        } else {
            overtimeL = overtime;
            this.procdefOvertime.put(procdefID, overtime);
        }
        long approvalTime = info.getApprovalTime().longValue();
        if (overtimeL < approvalTime) {
            info.setOverTime(new BigDecimal(approvalTime - overtimeL));
            info.setIsOver(1);
        } else {
            info.setOverTime(new BigDecimal(0));
            info.setIsOver(0);
        }
    }

    private HandleWay getHandlerWay(String function, String isPass) {
        HandleWay handleWay = null;
        handleWay = StringUtils.isEmpty((String)function) ? HandleWay.OTHER : ("MultiApproveUIFunction".equals(function) ? ("true".equals(isPass) ? HandleWay.AGREE : HandleWay.DISAGREE) : ("ManualDecisionUIFunction".equals(function) ? HandleWay.DECISION : HandleWay.BILLOPERATE));
        return handleWay;
    }

    private String getEntityAlias(String billentity, Context ctx) {
        if (entityMap.containsKey(billentity)) {
            return entityMap.get(billentity);
        }
        String alias = "";
        EntityObjectInfo info = this.loadEntity(ctx, billentity);
        if (info != null) {
            alias = info.getAlias();
        } else {
            String otherBill = "";
            otherBill = "l1".equals(ctx.getLocale().getLanguage()) ? "Other Doc" : ("l2".equals(ctx.getLocale().getLanguage()) ? "\u5176\u4ed6\u5355\u636e" : "\u5176\u4ed6\u55ae\u64da");
            alias = otherBill;
        }
        entityMap.put(billentity, alias);
        return alias;
    }

    private EntityObjectInfo loadEntity(Context ctx, String pk) {
        MetaDataPK mdpk;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)(mdpk = MetaDataPK.create((String)pk)));
        if (this.isEmptyMD((AbstractMDValue)entity)) {
            log.error((Object)("loadEntity by pk \uff1a " + pk + " Error "));
            return null;
        }
        return entity;
    }

    private boolean isEmptyMD(AbstractMDValue amd) {
        if (amd == null) {
            return true;
        }
        IStateManager sm = amd.getStateManager();
        if (sm == null) {
            return true;
        }
        if (sm instanceof IProxyStateManager) {
            sm = ((IProxyStateManager)sm).getNoProxyDelegate();
        }
        return sm instanceof DynamicStateManager && ((DynamicStateManager)sm).isNull();
    }

    public static void clearEntityMap() {
        entityMap = new HashMap<String, String>();
    }
}

