/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.axis;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.axis.RequestKeyGenerater;
import com.kingdee.bos.workflow.axis.WSDLEmitter;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TaskServiceReceiveActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.CorrelationMatchCollection;
import com.kingdee.bos.workflow.metas.CorrelationMatchInfo;
import com.kingdee.bos.workflow.metas.CorrelationMatchTypeEnum;
import com.kingdee.bos.workflow.metas.ProcImportObjInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.CorrelationMatchStorer;
import com.kingdee.bos.workflow.store.ProcImportObjStorer;
import com.kingdee.bos.workflow.util.XMLHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.BasicProvider;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.transform.JDOMSource;
import org.xml.sax.InputSource;

public class ProcessProvider
extends BasicProvider {
    private static final long serialVersionUID = -1701467744964489531L;
    private static final Logger log = Logger.getLogger(ProcessProvider.class);

    public void initServiceDesc(SOAPService service, MessageContext messageContext) throws AxisFault {
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            Message requestMessage = msgContext.getRequestMessage();
            SOAPEnvelope requestEnvelope = requestMessage.getSOAPEnvelope();
            String reqeustKey = RequestKeyGenerater.generateWSRequestKey(msgContext);
            QName serviceQName = new QName(msgContext.getService().getName());
            WSDDDeployment deployment = this.getWSDDDeployment(msgContext);
            WSDDService service = deployment.getWSDDService(serviceQName);
            String aisName = service.getParameter("aisName");
            String solutionName = service.getParameter("eas");
            WfEngine engine = WfEngine.getEngine(aisName, solutionName);
            CorrelationMatchStorer storer = engine.getStoreManager().getCorrelationMatchStorer();
            CorrelationMatchCollection collection = storer.findCorrelationMatches(reqeustKey);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                CorrelationMatchInfo correlationMatchInfo = collection.get(i);
                if (CorrelationMatchTypeEnum.PROCESS.equals((Object)correlationMatchInfo.getType())) {
                    this.createProcess(engine, correlationMatchInfo, requestEnvelope);
                    continue;
                }
                if (!CorrelationMatchTypeEnum.ACTIVITY.equals((Object)correlationMatchInfo.getType())) continue;
                this.completeActivity(engine, correlationMatchInfo, requestEnvelope);
            }
            log.info((Object)"ProcessServiceProvider.invoke");
            Message responseMessage = new Message((Object)requestEnvelope);
            msgContext.setResponseMessage(responseMessage);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private WSDDDeployment getWSDDDeployment(MessageContext msgContext) {
        WSDDEngineConfiguration engineConfiguration = (WSDDEngineConfiguration)msgContext.getAxisEngine().getConfig();
        return engineConfiguration.getDeployment();
    }

    private Map createInvokeContext(TaskServiceReceiveActivityDef activityDef, SOAPEnvelope requestEnvelope) throws Exception {
        HashMap<String, String> invokeContext = new HashMap<String, String>();
        ApplicationDef applicationDef = activityDef.getRelatedApplication();
        FormalParameterCollection formalParameters = applicationDef.getFormalParameters();
        ProcessDef processDef = activityDef.getProcessDef();
        DataFieldCollection dataFields = processDef.getDataFields();
        ActualParameterCollection actualParameters = activityDef.getActualParameters();
        int size = formalParameters.size();
        for (int i = 0; i < size; ++i) {
            FormalParameterDef formalParameterDef = formalParameters.get(i);
            ActualParameterDef actualParameterDef = actualParameters.get(i);
            DataFieldDef dataFieldDef = dataFields.get(actualParameterDef.getExpr());
            String dataFieldName = dataFieldDef.getName();
            if (!StringUtils.isEmpty((String)actualParameterDef.getProp())) {
                dataFieldName = dataFieldName + "." + actualParameterDef.getProp();
            }
            SOAPBody body = (SOAPBody)requestEnvelope.getBody();
            SOAPBodyElement element = (SOAPBodyElement)body.getChildElements().next();
            MessageElement messageElement = (MessageElement)element.getChildElements((Name)new PrefixedQName(null, formalParameterDef.getName(), null)).next();
            invokeContext.put(dataFieldName, messageElement.getValue());
        }
        return invokeContext;
    }

    private void createProcess(WfEngine engine, CorrelationMatchInfo correlationMatchInfo, SOAPEnvelope requestEnvelope) throws Exception {
        String procDefHash = correlationMatchInfo.getProcDefHash();
        ProcessDef processDef = engine.getProcessDef(procDefHash);
        Context context = engine.context();
        TaskServiceReceiveActivityDef activityDef = (TaskServiceReceiveActivityDef)processDef.getStartupActivities().get(0);
        Map invokeContext = this.createInvokeContext(activityDef, requestEnvelope);
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
        service.createAndCompleteFiristActivity(processDef.getID(), invokeContext);
    }

    private void completeActivity(WfEngine engine, CorrelationMatchInfo correlationMatchInfo, SOAPEnvelope requestEnvelope) throws Exception {
        String actInstId = correlationMatchInfo.getActInstId().toString();
        TaskServiceReceiveActivityDef activityDef = (TaskServiceReceiveActivityDef)engine.getActivityInst(actInstId).getDefinition();
        Context context = engine.context();
        Map invokeContext = this.createInvokeContext(activityDef, requestEnvelope);
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
        service.completeActivity(actInstId, invokeContext);
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        try {
            String locationUrl = msgContext.getStrProp("transport.url");
            WSDLEmitter emitter = new WSDLEmitter();
            emitter.setLocationUrl(locationUrl);
            QName serviceQName = new QName(msgContext.getService().getName());
            WSDDDeployment deployment = this.getWSDDDeployment(msgContext);
            WSDDService service = deployment.getWSDDService(serviceQName);
            String aisName = service.getParameter("aisName");
            String solutionName = service.getParameter("eas");
            String procDefId = service.getParameter("procDefId");
            String namspace = service.getParameter("namespace");
            WfEngine engine = WfEngine.getEngine(aisName, solutionName);
            ProcImportObjStorer storer = engine.getStoreManager().getProcImportObjStorer();
            ProcImportObjInfo procImportObjInfo = storer.getProcImportObjInfo(procDefId, namspace);
            Document document = XMLHelper.toDocument((String)procImportObjInfo.getContent());
            InputSource inputSource = new JDOMSource(document).getInputSource();
            Definition intefaceDefinition = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, inputSource);
            emitter.setIntefaceDefinition(intefaceDefinition);
            org.w3c.dom.Document doc = emitter.emit();
            msgContext.setProperty("WSDL", (Object)doc);
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.toString(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }
}

