/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizEventMap;
import com.kingdee.bos.workflow.biz.IWfBiz;
import com.kingdee.bos.workflow.biz.WfBizEvent;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.thread.WfBizEventHandler;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfBiz
implements IWfBiz {
    private final Context ctx;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.biz.WfBiz");

    public WfBiz(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    @Override
    public WfBizEvent checkBizEvent(Object returnValue, BizEventMap.EventStructEntry[] eventStructEntries, String boId, String userId) throws BOSException {
        String procInstId;
        WfProcess procInst;
        long time = System.currentTimeMillis();
        BizEventMap.EventStructEntry currentEventEntry = eventStructEntries[0];
        WfEngine engine = WfEngine.getEngine(this.ctx);
        String[] selector = new String[]{"bizFunction", "bizOperation", "procInstID"};
        AssignmentInfo[] assignments = engine.checkAssignmentInfos(boId, userId, selector);
        if (logger.isDebugEnabled() && System.currentTimeMillis() - time > 50L) {
            logger.debug((Object)("_checkBizEvent (1) checkAssign cost:" + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        AssignmentInfo assign = null;
        block2: for (int i = 0; i < assignments.length; ++i) {
            for (int j = 0; j < eventStructEntries.length; ++j) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Find more eventMapEntry, function:" + eventStructEntries[j].getFunction() + " operation:" + eventStructEntries[j].getOperation() + " event:" + eventStructEntries[j].getEvent().getName()));
                }
                if (!assignments[i].getBizOperation().equalsIgnoreCase(eventStructEntries[j].getOperation()) || eventStructEntries[j].getFunction().indexOf("." + assignments[i].getBizFunction()) <= 0) continue;
                assign = assignments[i];
                currentEventEntry = eventStructEntries[j];
                continue block2;
            }
        }
        if (assignments.length == 0) {
            ProcessInstInfo[] procInsts = engine.getProcessInstanceByHoldedObjectId(boId);
            if (logger.isDebugEnabled() && System.currentTimeMillis() - time > 50L) {
                logger.debug((Object)("_checkBizEvent (2) getProcess cost:" + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            if (procInsts != null && procInsts.length > 0) {
                boolean isBindProc = false;
                for (int i = 0; i < procInsts.length; ++i) {
                    if (procInsts[i].getState().startsWith("closed")) {
                        engine.unregistProcessBizObj(boId);
                        if (!logger.isDebugEnabled() || System.currentTimeMillis() - time <= 50L) continue;
                        logger.debug((Object)("Release process relation.boId:" + boId));
                        logger.debug((Object)("_checkBizEvent (3) unregistProcessBizObj cost:" + (System.currentTimeMillis() - time)));
                        time = System.currentTimeMillis();
                        continue;
                    }
                    isBindProc = true;
                }
                if (isBindProc) {
                    String msg = "BizObject[" + boId + "] already bind process instance";
                    try {
                        msg = "\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\uff0c\u5355\u636e\u7f16\u7801\uff1a" + this.getBizObjNumber(this.ctx, boId) + ",\u5f53\u524d\u7528\u6237:" + this.getUserName(this.ctx, userId);
                    }
                    catch (Exception e) {
                        msg = "\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d";
                    }
                    throw new MissMatchParticipantException(msg);
                }
            }
        } else if (assign == null) {
            int i;
            String expectOP = "";
            StringBuffer msg = new StringBuffer();
            msg.append("assignment match failed! userid=").append(userId).append("; boid=").append(boId);
            msg.append("\r\ncurrent assignments' list:");
            for (i = 0; i < assignments.length; ++i) {
                AssignmentInfo a = assignments[i];
                msg.append("\r\nfunction: ").append(a.getBizFunction()).append('#').append(a.getBizOperation()).append('@').append(a.getAssignmentId());
                expectOP = expectOP + a.getBizOperation() + ";";
            }
            msg.append("\r\ncurrent events' list:");
            for (i = 0; i < eventStructEntries.length; ++i) {
                BizEventMap.EventStructEntry e = eventStructEntries[i];
                msg.append("\r\nevent:").append(e.getFunction()).append('#').append(e.getOperation());
            }
            logger.warn((Object)msg.toString());
            throw new MatchAssignmentException("\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d,\u4f46\u662f\u5f53\u524d\u64cd\u4f5c(" + currentEventEntry.getOperation() + ")\u4e0e\u6d41\u7a0b\u4efb\u52a1\u6240\u9884\u671f\u7684\u64cd\u4f5c(" + expectOP + ")\u4e0d\u5339\u914d");
        }
        if (assign != null && !(procInst = engine.getProcessInst(procInstId = assign.getProcInstId())).getData().getState().equals("open.running") && !procInst.getData().getState().equals("open.running.rollbacked")) {
            throw new MatchAssignmentException("\u6d41\u7a0b\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u662f\u5426\u6b63\u5e38\u8fd0\u884c\uff01");
        }
        WfBizEvent wfEvent = new WfBizEvent();
        wfEvent.setId(BOSUuid.create((String)"WFBIZEVT").toString());
        wfEvent.setBoId(boId);
        wfEvent.setAssignmentId(assign != null ? assign.getAssignmentId() : null);
        wfEvent.setMethodReturnValue(returnValue);
        wfEvent.setUserId(userId);
        wfEvent.setOperationName(currentEventEntry.getOperation());
        String methodPK = currentEventEntry.getMethod();
        wfEvent.getExtendProperties().put("methodPK", currentEventEntry.getMethod());
        wfEvent.setFuncName(currentEventEntry.getFunction());
        wfEvent.setEventName(currentEventEntry.getEvent().getName());
        if (logger.isDebugEnabled() && System.currentTimeMillis() - time > 50L) {
            logger.debug((Object)("_checkBizEvent (4) newBizEvent cost:" + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        return wfEvent;
    }

    @Override
    public void checkIsInQueue(BizEventMap.EventStructEntry[] eventStructEntries, EventInfo eventInfo, String boId) throws WfException {
    }

    @Override
    public void directPutEventQueue(WfBizEvent event) throws WfException {
        WfBizEventHandler.enqueue(this.getContext(), event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBizObjNumber(Context ctx, String billId) {
        BOSUuid boUuid = BOSUuid.read((String)billId);
        EntityViewInfo entity = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("number"));
        entity.setSelector(selectors);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo fii = new FilterItemInfo("id", (Object)billId, CompareType.EQUALS);
        filter.getFilterItems().add(fii);
        entity.setFilter(filter);
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        String number = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)boUuid.getType(), (Context)ctx, (Connection)cn);
            model = dao.getValue(entity);
            number = (String)model.get("number");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (DataAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        return number;
    }

    private String getUserName(Context ctx, String userId) {
        String sql = "select fname_" + ctx.getLocale() + " as fname from t_pm_user where fid='" + userId + "'";
        String name = null;
        try {
            ArrayList list = SQL.executeQuery((Context)ctx, (String)sql);
            if (list.size() == 0) {
                return null;
            }
            Map item = (Map)list.get(0);
            name = (String)item.get("fname");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return name;
    }
}

