/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz.event;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.event.IEventExecutor;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.thread.CommonEventReceiver;
import com.kingdee.bos.workflow.exception.CannotCompleteException;
import com.kingdee.bos.workflow.exception.NotRunningException;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.util.CommonEventUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ActivityEventExecutor
implements IEventExecutor {
    private static final Logger logger = Logger.getLogger(ActivityEventExecutor.class);

    @Override
    public boolean execute(ICommonEvent event, EventProcMetaInfo info, WfEngine wfEngine) throws WfException {
        if (event == null || info == null || wfEngine == null || info.getProcInstId() == null || info.getActInstId() == null) {
            logger.warn((Object)"ActivityEventExecutor.execute args is null");
            return false;
        }
        ActivityEventExecutor.getProcess(info, wfEngine);
        ActivityEventExecutor.getActivity(info, wfEngine);
        this.removeEventProcRelation(info, wfEngine);
        CommonEventReceiver.enqueue(wfEngine.context(), event, info);
        return true;
    }

    private void removeEventProcRelation(EventProcMetaInfo info, WfEngine wfEngine) throws WfException {
        try {
            boolean deleted = wfEngine.getStoreManager().getEventStorer().deleteEventProcRelation(info.getEventProcId().toString());
            if (!deleted) {
                throw new WfException("event ref {" + info.getEventProcId() + "} not exits!");
            }
        }
        catch (SQLException e) {
            throw new WfException((Throwable)e, true);
        }
    }

    public static void innerExecute(ICommonEvent event, EventProcMetaInfo info, WfEngine wfEngine) throws WfException, NotRunningException, CannotCompleteException {
        WfProcess wfProcess = ActivityEventExecutor.getProcess(info, wfEngine);
        WfActivity eventActivity = ActivityEventExecutor.getActivity(info, wfEngine);
        ProcessContext processContext = wfProcess.getProcessContext();
        CommonEventUtils.outputEventContentToContext(eventActivity.getDefinition(), event, processContext);
        eventActivity.complete(BOSUuid.create((String)"WFBIZEVT").toString());
    }

    private static WfActivity getActivity(EventProcMetaInfo info, WfEngine wfEngine) throws WfException, NotRunningException {
        String actInstId = info.getActInstId().toString();
        WfActivity eventActivity = wfEngine.getActivityInst(actInstId);
        if (!ActivityEventExecutor.checkActivityIsRunning(eventActivity)) {
            throw new NotRunningException(eventActivity.getId() + "not running,please check!");
        }
        return eventActivity;
    }

    private static WfProcess getProcess(EventProcMetaInfo info, WfEngine wfEngine) throws WfException, NotRunningException {
        WfProcess wfProcess = wfEngine.getProcessInst(info.getProcInstId().toString());
        if (!wfProcess.state().equals("open.running")) {
            throw new NotRunningException(wfProcess.getId() + "not running,please check!");
        }
        return wfProcess;
    }

    static boolean checkActivityIsRunning(WfActivity wfActivity) {
        return !wfActivity.state().startsWith(WfState.CLOSED.getValue()) && !wfActivity.state().equals("open.not_running.suspended") && !wfActivity.state().equals("open.not_running");
    }
}

