/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.workflow.define.ActivityEvent;
import com.kingdee.bos.workflow.define.AssignmentEvent;
import com.kingdee.bos.workflow.define.ProcessEvent;
import com.kingdee.bos.workflow.enactment.IWfActivity;
import com.kingdee.bos.workflow.enactment.IWfAssignment;
import com.kingdee.bos.workflow.enactment.IWfProcess;
import com.kingdee.bos.workflow.enactment.handler.IActivityEventHandler;
import com.kingdee.bos.workflow.enactment.handler.IAssignmentEventHandler;
import com.kingdee.bos.workflow.enactment.handler.IProcessEventHandler;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WfEventService {
    private static Logger log = Logger.getLogger(WfEventService.class);
    private HashMap wfEventHandlers = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerEventHandler(String event, Object handler) {
        if (event.equals("OnInit")) {
            event = ActivityEvent.OnActivitiyInit.getName();
        } else if (event.equals("OnSuspended")) {
            event = ActivityEvent.OnActivitySuspended.getName();
        } else if (event.equals("OnResumed")) {
            event = ActivityEvent.OnActivityResumed.getName();
        } else if (event.equals("OnComplete")) {
            event = ActivityEvent.OnActivityComplete.getName();
        } else if (event.equals("OnAborted")) {
            event = ActivityEvent.OnActivityAborted.getName();
        }
        AssignmentEvent e = AssignmentEvent.getEvent((String)event);
        if (e != null) {
            if (!(handler instanceof IAssignmentEventHandler)) {
                return false;
            }
        } else {
            ActivityEvent ae = ActivityEvent.getEvent((String)event);
            if (ae != null) {
                if (!(handler instanceof IActivityEventHandler)) {
                    return false;
                }
            } else {
                ProcessEvent pe = ProcessEvent.getEvent((String)event);
                if (pe == null) {
                    return false;
                }
                if (!(handler instanceof IProcessEventHandler)) {
                    return false;
                }
            }
        }
        HashMap hashMap = this.wfEventHandlers;
        synchronized (hashMap) {
            ArrayList<Object> handlers = (ArrayList<Object>)this.wfEventHandlers.get(event);
            if (handlers == null) {
                handlers = new ArrayList<Object>();
                this.wfEventHandlers.put(event, handlers);
            }
            handlers.add(handler);
            log.info((Object)("event-handler: " + event + ", " + handler.getClass().getName()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseAssignmentEvent(AssignmentEvent e, IWfAssignment assignment, IAssignmentEventHandler[] otherHandlers) {
        if (otherHandlers != null) {
            for (int i = 0; i < otherHandlers.length; ++i) {
                otherHandlers[i].execute(e, assignment);
            }
        }
        ArrayList list = null;
        HashMap hashMap = this.wfEventHandlers;
        synchronized (hashMap) {
            list = (ArrayList)this.wfEventHandlers.get(e.getName());
        }
        if (list == null || list.size() == 0) {
            return;
        }
        IAssignmentEventHandler[] handlers = null;
        ArrayList arrayList = list;
        synchronized (arrayList) {
            handlers = list.toArray(new IAssignmentEventHandler[list.size()]);
        }
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].execute(e, assignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseProcessEvent(ProcessEvent e, IWfProcess process, IProcessEventHandler[] otherHandlers) {
        if (otherHandlers != null) {
            for (int i = 0; i < otherHandlers.length; ++i) {
                otherHandlers[i].execute(e, process);
            }
        }
        ArrayList list = null;
        HashMap hashMap = this.wfEventHandlers;
        synchronized (hashMap) {
            list = (ArrayList)this.wfEventHandlers.get(e.getName());
        }
        if (list == null || list.size() == 0) {
            return;
        }
        IProcessEventHandler[] handlers = null;
        ArrayList arrayList = list;
        synchronized (arrayList) {
            handlers = list.toArray(new IProcessEventHandler[list.size()]);
        }
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].execute(e, process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseActivityEvent(ActivityEvent e, IWfActivity Activity, IActivityEventHandler[] otherHandlers) {
        if (otherHandlers != null) {
            this.raise(e, Activity, otherHandlers);
        }
        ArrayList list = null;
        HashMap hashMap = this.wfEventHandlers;
        synchronized (hashMap) {
            list = (ArrayList)this.wfEventHandlers.get(e.getName());
        }
        if (list == null || list.size() == 0) {
            return;
        }
        IActivityEventHandler[] handlers = null;
        ArrayList arrayList = list;
        synchronized (arrayList) {
            handlers = list.toArray(new IActivityEventHandler[list.size()]);
        }
        this.raise(e, Activity, handlers);
    }

    private void raise(ActivityEvent e, IWfActivity Activity, IActivityEventHandler[] handlers) {
        for (int i = 0; i < handlers.length; ++i) {
            try {
                handlers[i].execute(e, Activity);
                continue;
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException("exec activityEventHandler failed! handler=" + handlers[i].getClass().getName() + "; event=" + e, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventHandler(String event, Object handler) {
        HashMap hashMap = this.wfEventHandlers;
        synchronized (hashMap) {
            ArrayList handlers = (ArrayList)this.wfEventHandlers.get(event);
            if (handlers == null) {
                return;
            }
            handlers.remove(handler);
        }
    }

    public boolean haveRegisterEventHandler(String eventName, String handlerClazzName) {
        if (StringUtils.isEmpty((String)eventName) || StringUtils.isEmpty((String)handlerClazzName)) {
            return false;
        }
        ArrayList handlers = (ArrayList)this.wfEventHandlers.get(eventName);
        if (handlers != null) {
            for (Object handler : handlers) {
                if (!handlerClazzName.equals(handler.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }
}

