/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cluster;

import com.kingdee.bos.jcache.Event;
import com.kingdee.bos.jcache.EventListener;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.cluster.WfClusterFunctionSynEvent;
import com.kingdee.bos.workflow.util.EngineConfig;

public class WfClusterEventListener
implements EventListener {
    private long lastBizEventNotifyTime;
    private final WfEngine engine;

    public WfClusterEventListener(WfEngine engine) {
        this.engine = engine;
    }

    public void onEvent(Event event) {
        WfClusterFunctionSynEvent functionSynEvent;
        if (event instanceof WfClusterFunctionSynEvent && "FUNCTION_SYN_EVENT".equals((functionSynEvent = (WfClusterFunctionSynEvent)event).getName()) && !this.filterEvent(functionSynEvent, this.lastBizEventNotifyTime)) {
            this.lastBizEventNotifyTime = System.currentTimeMillis();
        }
    }

    private boolean filterEvent(WfClusterFunctionSynEvent queueEvent, long lastTime) {
        String solutionName = this.engine.getEngineSolution();
        String dataCenterName = this.engine.getEngineAis();
        if (!solutionName.equals(queueEvent.getSolutionName()) && !dataCenterName.equals(queueEvent.getDataCenterName())) {
            return true;
        }
        if (queueEvent.getServerKey().equals(this.engine.getServerKey())) {
            return true;
        }
        return System.currentTimeMillis() - this.lastBizEventNotifyTime < (long)EngineConfig.getInstance().getQueueIdleTimeGroupMode();
    }
}

