/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.message.AssignListenerFactory;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.bos.workflow.message.AssignmentDeletionEvent;
import com.kingdee.bos.workflow.message.IAssignmentListener;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AssignmentFireEventRunner
implements IJobHandler {
    private static final long serialVersionUID = 3648349050295222198L;
    private static final Logger logger = Logger.getLogger(AssignmentFireEventRunner.class);
    private final Context context;
    private final Object[] events;
    private final IAssignmentListener listener;
    private int count = 0;

    public AssignmentFireEventRunner(Context context, Object[] events) {
        this.context = context;
        this.events = events;
        this.listener = AssignListenerFactory.getListener();
    }

    public Object execute(Job job) throws Exception {
        try {
            this.run();
            return null;
        }
        catch (Exception e) {
            if (this.count < 5) {
                ++this.count;
                return new Delay(20 * this.count);
            }
            throw e;
        }
    }

    public void run() throws WfException {
        if (this.events instanceof AssignmentCreationEvent[]) {
            this.fireAssignmentBatchCreated((AssignmentCreationEvent[])this.events);
        } else if (this.events instanceof AssignmentDeletionEvent[]) {
            this.fireAssignmentBatchDeleted((AssignmentDeletionEvent[])this.events);
        }
    }

    private void fireAssignmentBatchDeleted(AssignmentDeletionEvent[] events) throws WfException {
        LowTimer lowTimer = new LowTimer();
        Connection cn = null;
        PreparedStatement ps = null;
        try {
            cn = WfDbUtil.getConnection((Context)this.context);
            ps = cn.prepareStatement("DELETE FROM T_WFR_Assign WHERE FASSIGNID = ?");
            int size = events.length;
            for (int i = 0; i < size; ++i) {
                ps.setString(1, events[i].assignmentId);
                ps.addBatch();
            }
            ps.executeBatch();
            if (this.listener != null) {
                this.listener.assignmentBatchDeleted(events);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u4eceT_WFR_Assign\u4e2d\u5220\u9664\u4efb\u52a1\u5931\u8d25!", (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AssignmentFireEventRunner.fireAssignmentBatchDeleted cost:" + lowTimer.msValue()));
        }
    }

    private void fireAssignmentBatchCreated(AssignmentCreationEvent[] events) throws WfException {
        LowTimer lowTimer = new LowTimer();
        try {
            if (this.listener != null) {
                this.listener.assignmentBatchCreated(events);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25!", (Throwable)e);
            throw new WfException((Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AssignmentFireEventRunner.fireAssignmentBatchCreated cost:" + lowTimer.msValue()));
        }
    }
}

