/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.thread;

import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.thread.IWfDaemonPolicy;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResumeSuspendedProcessPolicy
implements IWfDaemonPolicy {
    private static final String DATEPOSTFIX = "date";
    private static final String LOCKPOSTFIX = "lock";
    private static final int TIMEUTIL = 1000;
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.thread.ResumeSuspendedProcessPolicy");
    private static ThreadLocal threadLocal;
    private static ResumeSuspendedProcessPolicy instance;

    @Override
    public void executePolicy(WfEngine engine) {
        String[] time;
        if (!this.isLock(engine.getEngineKey()) && (time = EngineConfig.getInstance().getResumeSuspendedProcessPolicyTime()) != null && time.length > 0) {
            if (time.length == 1 && time[0] != null && time[0].indexOf(":") <= 0) {
                this.timesliceResume(engine, time[0]);
            } else {
                this.timestampResume(engine, time);
            }
        }
    }

    private void timesliceResume(WfEngine engine, String timeStr) {
        Date lastDate = this.getLastExecuteDate(engine.getEngineKey());
        int time = 0;
        if (timeStr.trim().length() > 0) {
            try {
                time = Integer.parseInt(timeStr);
                if (time < 5) {
                    time = 5;
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)("parse time error:" + timeStr));
            }
            if (lastDate == null || time > 0 && System.currentTimeMillis() - lastDate.getTime() > (long)(time * 1000 * 60)) {
                this.autoResumeProcInst(engine, new Date());
            }
        }
    }

    private void timestampResume(WfEngine engine, String[] time) {
        Date defineDate = new Date();
        for (int i = 0; i < time.length; ++i) {
            if (time[i] == null || time[i].trim().length() <= 0 || (defineDate = this.getDefineDate(defineDate, time[i])) == null) continue;
            Date lastDate = this.getLastExecuteDate(engine.getEngineKey());
            if (lastDate == null) {
                lastDate = new Date();
                lastDate.setYear(1979);
            }
            if (!defineDate.before(new Date()) || !defineDate.after(lastDate)) continue;
            this.autoResumeProcInst(engine, defineDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoResumeProcInst(WfEngine engine, Date defineDate) {
        this.setLock(engine.getEngineKey(), true);
        try {
            ProcessInstInfo[] procInsts = engine.getAllProcessInstances(50, "open.not_running.suspended");
            WfProcess wfProcess = null;
            for (int j = 0; j < procInsts.length; ++j) {
                if (DateTimeUtils.dateDiff((String)"d", (Date)procInsts[j].getCreatedTime(), (Date)new Date()) >= 40L || (wfProcess = engine.getProcessInst(procInsts[j].getProcInstId())) == null) continue;
                try {
                    wfProcess.resume();
                    continue;
                }
                catch (WfException e) {
                    log.error((Object)"auto resume process instance error.", (Throwable)e);
                }
            }
        }
        catch (WfException e) {
            log.error((Object)"get process instance error.", (Throwable)e);
        }
        finally {
            this.setLastExecuteDates(engine.getEngineKey(), defineDate);
            this.setLock(engine.getEngineKey(), false);
        }
    }

    private Date getDefineDate(Date date, String string) {
        String[] timeStr;
        if (string != null && string.trim().length() > 0 && (timeStr = StringUtils.split((String)string, (String)":")) != null && timeStr.length > 0) {
            try {
                date.setHours(Integer.parseInt(timeStr[0]));
                if (timeStr.length > 1) {
                    date.setMinutes(Integer.parseInt(timeStr[1]));
                    if (timeStr.length > 2) {
                        date.setSeconds(Integer.parseInt(timeStr[2]));
                    }
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)("parse time def error:" + string));
                date = null;
            }
        }
        return date;
    }

    private synchronized Date getLastExecuteDate(String engineKey) {
        Map localData = (Map)threadLocal.get();
        return (Date)localData.get(engineKey + DATEPOSTFIX);
    }

    private synchronized void setLastExecuteDates(String engineKey, Date date) {
        Map localData = (Map)threadLocal.get();
        localData.put(engineKey + DATEPOSTFIX, date);
        threadLocal.set(localData);
    }

    private synchronized boolean isLock(String engineKey) {
        Map localData = (Map)threadLocal.get();
        Boolean isLock = (Boolean)localData.get(engineKey + LOCKPOSTFIX);
        return isLock != null ? isLock : false;
    }

    private synchronized void setLock(String engineKey, boolean isLock) {
        Map localData = (Map)threadLocal.get();
        localData.put(engineKey + LOCKPOSTFIX, isLock);
        threadLocal.set(localData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IWfDaemonPolicy getInstance() {
        if (instance != null) return instance;
        Class<ResumeSuspendedProcessPolicy> clazz = ResumeSuspendedProcessPolicy.class;
        synchronized (ResumeSuspendedProcessPolicy.class) {
            if (instance != null) return instance;
            instance = new ResumeSuspendedProcessPolicy();
            threadLocal = new ThreadLocal();
            threadLocal.set(new HashMap());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

