/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.SQL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class FlowContextLoader {
    private final Context ctx;

    public FlowContextLoader(Context ctx) {
        this.ctx = ctx;
        String sql = "select KSQL_TABNAME as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_WFR_RUNTIME'";
        try {
            if (SQL.executeQuery((Context)ctx, (String)sql).size() == 0) {
                sql = "CREATE TABLE T_WFR_RUNTIME(fprocInstId varchar(44) not null, fcontext clob(1000000) not null, fclosed char(1) not null, flastupdatedtime datetime not null, CONSTRAINT PK_WFR_RUNTIME PRIMARY KEY(fprocInstId))";
                SQL.executeUpdate((Context)ctx, (String)sql);
            }
        }
        catch (BOSException e) {
            throw new RuntimeException("check or create table {T_WFR_RUNTIME} failed!", e);
        }
        Job job = new Job(ctx, (IJobHandler)new FlowContextDisposer(this), null, false);
        job.setScheduledTime((Date)new Timestamp(System.currentTimeMillis() + 5000L));
        JobManager.instance().add(job);
    }

    public void insert(String procInstId, String runtime) {
        String sql = "insert into T_WFR_RUNTIME(fprocInstId, fcontext, fclosed, flastupdatedtime)values(?,?, 'N', ?)";
        int[] types = new int[]{12, 12, 93};
        Object[] values = new Object[]{procInstId, runtime, ClusterStateManager.get((Context)this.ctx).dbNow()};
        try {
            SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
        }
        catch (BOSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void save(String procInstId, String runtime, boolean closed) {
        String sql = "update T_WFR_RUNTIME set fcontext=?, fclosed=?, flastupdatedtime=? where fprocInstId= ? ";
        int[] types = new int[]{12, 1, 93, 12};
        Object[] values = new Object[]{runtime, closed ? "Y" : "N", ClusterStateManager.get((Context)this.ctx).dbNow(), procInstId};
        try {
            SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
        }
        catch (BOSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void deleteClosed() {
        String sql = "delete from T_WFR_RUNTIME where fclosed='Y' and flastupdatedtime<?";
        int[] types = new int[]{93};
        long offset = 1296000000L;
        Object[] values = new Object[]{new Timestamp(System.currentTimeMillis() - offset)};
        try {
            SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String get(String procInstId) {
        String sql = "select fcontext from T_WFR_RUNTIME where fprocInstId= ? ";
        try {
            ArrayList result = SQL.executeQuery((Context)this.ctx, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{procInstId});
            if (result.size() == 0) {
                return null;
            }
            return (String)((Map)result.get(0)).get("fcontext");
        }
        catch (BOSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static class FlowContextDisposer
    implements IJobHandler {
        private static final long serialVersionUID = -8867606922534984404L;
        private final FlowContextLoader loader;

        public FlowContextDisposer(FlowContextLoader loader) {
            this.loader = loader;
        }

        public Object execute(Job job) {
            this.loader.deleteClosed();
            return new Delay(36000);
        }
    }
}

