/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.Returns;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.returns.Destroy;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.Util;
import com.kingdee.bos.workflow.engine.core.thread.WfEventTimerHandler;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.timeliness.EventTimerWaiter;
import com.kingdee.bos.workflow.util.ScriptUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;

public class WfEventTimerRaiser
implements IJobHandler {
    private static final long serialVersionUID = -2680648882600350091L;
    protected static final Logger logger = Logger.getLogger(WfEventTimerRaiser.class);
    private JobDataMap jbDataMap;

    public static void remove(Context ctx, String id) {
        String title = "~EventTimer:" + id;
        Util.deleteJob(ctx, title);
    }

    public static void add(Context ctx, EventTimerWaiter waiter) {
        JobDataMap jbDataMap = new JobDataMap();
        jbDataMap.put("actDefId", waiter.getActivityDefId());
        jbDataMap.put("actInstId", waiter.getActivityId());
        jbDataMap.put("wfEngine_key", waiter.getWfEngine().getEngineKey());
        jbDataMap.put("procInstId", waiter.getProcInstId());
        jbDataMap.put("procDefId", waiter.getProcDefId());
        jbDataMap.put("endCondition", waiter.getEndCondition());
        jbDataMap.put("timerMode", waiter.getTimeMode());
        jbDataMap.put("waiteTimes", waiter.getWaiteTimes());
        Date fireTime = waiter.getFireTime();
        String id = waiter.getId();
        WfEventTimerRaiser.enqueue(ctx, jbDataMap, fireTime, id);
    }

    public static void enqueue(Context ctx, JobDataMap jbDataMap, Date fireTime, String id) {
        WfEventTimerHandler h;
        if (new Date().after(fireTime) && WfJobHandler.join(h = new WfEventTimerHandler(jbDataMap, ctx.getCaller().toString()))) {
            return;
        }
        WfEventTimerRaiser raiser = new WfEventTimerRaiser(jbDataMap);
        String title = "~EventTimer:" + id;
        Job job = new Job(ctx, title, (IJobHandler)raiser, null, true, false);
        String timeMode = jbDataMap.getString("timerMode");
        String endCondition = jbDataMap.getString("endCondition");
        if ("relative".equalsIgnoreCase(timeMode) && endCondition != null && endCondition.length() > 0) {
            job.setScheduledTime(WfEventTimerRaiser.getNowDateADD30s());
        } else {
            job.setScheduledTime(fireTime);
        }
        JobManager.instance().add(job);
    }

    private static Date getNowDateADD30s() {
        Calendar calender = Calendar.getInstance();
        calender.add(13, 30);
        return calender.getTime();
    }

    private WfEventTimerRaiser(JobDataMap jbDataMap) {
        this.jbDataMap = jbDataMap;
    }

    public Returns execute(Job job) throws Exception {
        Context ctx = job.getContext();
        String procInstId = this.jbDataMap.getString("procInstId");
        String actInstId = this.jbDataMap.getString("actInstId");
        String endCondition = this.jbDataMap.getString("endCondition");
        WfEngine engine = WfEngine.getEngine(ctx);
        WfProcess process = engine.getProcessInst(procInstId);
        String actState = engine.getActivityInst(actInstId).getMeta().getState();
        if (!process.state().startsWith("open.") || !actState.startsWith("open.")) {
            return Destroy.instance();
        }
        String timeMode = this.jbDataMap.getString("timerMode");
        if ("relative".equalsIgnoreCase(timeMode)) {
            String actDefId = this.jbDataMap.getString("actDefId");
            try {
                if (!this.evalEndCondition(endCondition, process, actDefId, ctx, procInstId)) {
                    long waitTimes = this.jbDataMap.getLong("waiteTimes");
                    if (waitTimes < 30L) {
                        waitTimes = 30L;
                    }
                    if (!(actState = engine.getActivityInst(actInstId).getMeta().getState()).startsWith("open.")) {
                        return Destroy.instance();
                    }
                    return new Delay(waitTimes * 1000L);
                }
            }
            catch (AlreadyInProcessQueueException e) {
                return new Delay(30000);
            }
        }
        String jobId = Mutex.getMutex(ctx, procInstId);
        int priority = process.getDefinition().getProcessHeader().getPriority();
        String title = "~EventWaiterHandler:" + actInstId;
        try {
            logger.info((Object)(title + " will be added to BOSSchedulerService...GOOD LUCK!"));
            JobDispatcher.dispatch(jobId, ctx, title, new WfEventTimerHandler(this.jbDataMap, ctx.getCaller().toString()), true, WfPriority.getEnum((int)priority));
            return Destroy.instance();
        }
        catch (AlreadyInProcessQueueException e) {
            return new Delay((long)RND.nextInt(1000) + 300L);
        }
    }

    private boolean evalEndCondition(String endCondtion, WfProcess process, String actDefId, Context ctx, String procInstId) throws BOSException {
        if (endCondtion == null || endCondtion.length() == 0) {
            return true;
        }
        HashMap parameterMap = (HashMap)process.getProcessContext().getDataCopy();
        WfActivity activity = null;
        try {
            activity = process.getActInstByDefId(actDefId);
        }
        catch (CacheException e) {
            throw new AlreadyInProcessQueueException((Throwable)e);
        }
        long begin = System.currentTimeMillis();
        Object returnValue = ScriptUtil.executeScriptReturnValue(endCondtion, activity, parameterMap);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        this.updateInvokeTimes(process, parameterMap, activity, begin);
        boolean boolVal = false;
        if (returnValue == null) {
            svc.setProcessContext(procInstId, (Map)parameterMap);
            return false;
        }
        if (!(returnValue instanceof Boolean)) {
            if (returnValue instanceof String) {
                boolVal = Boolean.parseBoolean(returnValue.toString());
            }
            throw new WfException("\u5224\u65ad\u811a\u672c\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u662fboolean\u7c7b\u578b    returnValue:" + returnValue);
        }
        boolVal = (Boolean)returnValue;
        if (boolVal) {
            this.clearInvokeTimes(process, parameterMap, activity);
        }
        svc.setProcessContext(procInstId, (Map)parameterMap);
        return boolVal;
    }

    private void updateInvokeTimes(WfProcess process, Map parameterMap, WfActivity activity, long begin) {
        String key = "EventTimerInvoke:" + activity.getDefinition().getID();
        Object obj = parameterMap.get(key);
        long cost = System.currentTimeMillis() - begin;
        if (obj == null) {
            String[] val = new String[]{"1", String.valueOf(cost)};
            parameterMap.put(key, val);
            try {
                process.getProcessContext().putDataFieldValue(key, val);
            }
            catch (WfException e) {
                e.printStackTrace();
            }
        } else {
            String val0;
            String[] val = (String[])obj;
            val[0] = val0 = String.valueOf(Integer.parseInt(val[0]) + 1);
            val[1] = String.valueOf(cost);
            parameterMap.put(key, val);
        }
    }

    private void clearInvokeTimes(WfProcess process, Map parameterMap, WfActivity activity) {
        String key = "EventTimerInvoke:" + activity.getDefinition().getID();
        Object obj = parameterMap.get(key);
        if (obj != null) {
            parameterMap.put(key, new String[]{"0", "0"});
        }
    }
}

