/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.mailApprove.microsoft;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.ApproveNidInfo;
import com.kingdee.bos.workflow.extscheme.mailApprove.microsoft.MailAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import java.util.List;
import org.apache.log4j.Logger;

public class AttachmentWorker {
    protected static final Logger logger = Logger.getLogger(AttachmentWorker.class);
    private Context ctx;
    private ApproveNidInfo nidInfo;
    private List<MailAttachment> attachments;

    public AttachmentWorker(Context ctx, ApproveNidInfo nidInfo, List<MailAttachment> attachments) {
        this.ctx = ctx;
        this.nidInfo = nidInfo;
        this.attachments = attachments;
    }

    public void work() {
        AttachmentServerManager manager = AttachmentManagerFactory.getServerManager((Context)this.ctx);
        for (MailAttachment ma : this.attachments) {
            SimpleAttachmentInfo simple = new SimpleAttachmentInfo();
            simple.setContent(ma.getContentBytes());
            String mainName = StringUtil4File.getMainFileName((String)ma.getName());
            String extName = StringUtil4File.getExtendedFileName((String)ma.getName());
            simple.setMainName(mainName);
            simple.setExtName(extName);
            simple.setAttachType(this.nidInfo.getAssignId());
            simple.setAttachTypeEnum("1");
            try {
                manager.addNewAttachmentContainCtx(this.ctx, this.nidInfo.getBillId(), simple);
            }
            catch (Exception e) {
                logger.error((Object)"AttachmentWorker work error", (Throwable)e);
            }
        }
    }
}

