/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.procdiagram.cal;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.extscheme.procdiagram.util.ProcDiagramUtil;
import com.kingdee.cbos.process.vm.model.Flow;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalLongestPath {
    private WfEngine engine;
    private static Logger logger = Logger.getLogger(CalLongestPath.class);

    public CalLongestPath(WfEngine engine) {
        this.engine = engine;
    }

    public Map<String, Integer> getToEndMaxPachMap(Flow flow, ProcessDef processDef) throws WfException {
        Map<String, Integer> actDistMap = (Map<String, Integer>)flow.getAttribute("ToEndMaxPachMap");
        if (actDistMap == null || actDistMap.isEmpty()) {
            actDistMap = this.calLongestPath(processDef, flow);
        }
        return actDistMap;
    }

    private Map<String, Integer> calLongestPath(ProcessDef processDef, Flow flow) throws WfException {
        HashMap<String, Integer> actDistMap = new HashMap<String, Integer>();
        HashSet transPatchSet = new HashSet();
        LinkedList<Object> nextDealActNode = new LinkedList<Object>();
        try {
            EndActivityDef endActDef = processDef.getEndActivity();
            nextDealActNode.add(endActDef);
            ActivityCollection activitys = processDef.getActivitys();
            for (int index = 0; index < activitys.size(); ++index) {
                actDistMap.put(activitys.get(index).getID(), 0);
            }
            for (int count = 0; nextDealActNode.size() > 0 && count < 1000; ++count) {
                int subDist;
                ActivityDef actDef = (ActivityDef)nextDealActNode.remove();
                int dist = (Integer)actDistMap.get(actDef.getID());
                if (actDef instanceof SubflowActivityDef && (subDist = this.getSubFlowDist(actDef)) > 0) {
                    actDistMap.put(actDef.getID(), dist += subDist);
                }
                TransitionCollection inTrans = actDef.getIncomingTransitions();
                for (int index = 0; index < inTrans.size(); ++index) {
                    int actCount;
                    TransitionDef tranDef = inTrans.get(index);
                    if (tranDef.getFrom() == null || ProcDiagramUtil.isBackTransition(tranDef, flow) || this.isRepeatPatch(tranDef, flow, transPatchSet) || (actCount = ((Integer)actDistMap.get(tranDef.getFrom().getID())).intValue()) >= dist + 1) continue;
                    actDistMap.put(tranDef.getFrom().getID(), dist + 1);
                    nextDealActNode.add(tranDef.getFrom());
                }
            }
            flow.setAttribute("ToEndMaxPachMap", actDistMap);
        }
        catch (Exception e) {
            logger.error((Object)"\u8ba1\u7b97\u8282\u70b9\u5230\u7ed3\u675f\u8282\u70b9\u7684\u6700\u5927\u8ddd\u79bb\u51fa\u9519", (Throwable)e);
        }
        return actDistMap;
    }

    private boolean isRepeatPatch(TransitionDef transitionDef, Flow flow, Set transPatchSet) {
        if (transitionDef.getFrom() == null || transitionDef.getTo() == null) {
            return false;
        }
        String transitionPatch = transitionDef.getFrom().getID() + "->" + transitionDef.getTo().getID();
        if (transPatchSet.contains(transitionPatch)) {
            return true;
        }
        transPatchSet.add(transitionPatch);
        return false;
    }

    private int getSubFlowDist(ActivityDef actDef) throws WfException {
        int subFlowDist = 0;
        SubflowActivityDef tSubflowActivityDef = (SubflowActivityDef)actDef;
        String subProcDefId = tSubflowActivityDef.getSubflowId();
        WfProcessMgr processMgr = this.engine.getProcessMgr(subProcDefId);
        ProcessDef processDef = processMgr.getProcessDef();
        StartActivityDef startActDef = processDef.getStartActivity();
        Flow flow = this.engine.getFlow(processDef.getHashValue());
        Map<String, Integer> actDistMap = (Map<String, Integer>)flow.getAttribute("ToEndMaxPachMap");
        if (actDistMap == null || actDistMap.isEmpty()) {
            actDistMap = this.calLongestPath(processDef, flow);
        }
        if (actDistMap != null && !actDistMap.isEmpty()) {
            subFlowDist = actDistMap.get(startActDef.getID());
        }
        return subFlowDist;
    }
}

