/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.procdiagram.cal;

import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.workflow.ActivityInstInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortAppendActivity {
    private ActivityInstInfo root;
    private int recurveCount = 0;
    private Map<String, List<ActivityInstInfo>> activityGroupMap = new HashMap<String, List<ActivityInstInfo>>();

    public List<ActivityInstInfo> calAppendActivitys(ActivityInstInfo[] activities) {
        ArrayList<ActivityInstInfo> sorActivityList = new ArrayList<ActivityInstInfo>();
        this.createGroupList(activities);
        for (String key : this.activityGroupMap.keySet()) {
            List<ActivityInstInfo> groupList = this.activityGroupMap.get(key);
            ArrayList<ActivityInstInfo> newGroupList = new ArrayList<ActivityInstInfo>();
            newGroupList.addAll(newGroupList);
            groupList = SortAppendActivity.getSequenceActivitysForGroup(newGroupList);
        }
        sorActivityList.add(this.root);
        List<ActivityInstInfo> groupList = this.activityGroupMap.get(this.root.getActInstId());
        this.dlr(sorActivityList, groupList);
        return sorActivityList;
    }

    private void dlr(List<ActivityInstInfo> sorActivityList, List<ActivityInstInfo> groupList) {
        for (int index = 0; index < groupList.size(); ++index) {
            ActivityInstInfo actInstInfo = groupList.get(index);
            sorActivityList.add(actInstInfo);
            if (this.activityGroupMap.get(actInstInfo.getActInstId()) == null) continue;
            this.dlr(sorActivityList, groupList);
        }
    }

    private void createGroupList(ActivityInstInfo[] activities) {
        for (int index = 0; index < activities.length; ++index) {
            ActivityInstInfo activityInfo = activities[index];
            String parentId = activityInfo.getParentActInstId();
            if (parentId == null) {
                this.root = activityInfo;
                continue;
            }
            List<ActivityInstInfo> groupList = this.activityGroupMap.get(parentId);
            if (groupList == null) {
                groupList = new ArrayList<ActivityInstInfo>();
                groupList.add(activityInfo);
                this.activityGroupMap.put(parentId, groupList);
                continue;
            }
            groupList.add(activityInfo);
        }
    }

    public static List<ActivityInstInfo> getSequenceActivitysForGroup(List<ActivityInstInfo> groupList) {
        ArrayList<ActivityInstInfo> sequenceList = new ArrayList<ActivityInstInfo>();
        List<ActivityInstInfo> noPriorActivityList = SortAppendActivity.getNoPriorActivity(groupList);
        SortAppendActivity.sortByActEndtime(noPriorActivityList);
        sequenceList.addAll(noPriorActivityList);
        groupList.removeAll(noPriorActivityList);
        SortAppendActivity.sortActivity(groupList, sequenceList, 0);
        return sequenceList;
    }

    public static void sortByActEndtime(List<ActivityInstInfo> actList) {
        Object[] acts = actList.toArray(new ActivityInstInfo[actList.size()]);
        Arrays.sort((Object[])acts, (Comparator)new Comparator<ActivityInstInfo>(){

            @Override
            public int compare(ActivityInstInfo o1, ActivityInstInfo o2) {
                Timestamp time1 = o1.getLastStateTime();
                Timestamp time2 = o2.getLastStateTime();
                return time1.compareTo(time2);
            }
        });
        actList.clear();
        for (int index = 0; index < acts.length; ++index) {
            actList.add((ActivityInstInfo)acts[index]);
        }
    }

    private static void sortActivity(List<ActivityInstInfo> groupList, List<ActivityInstInfo> sequenceList, int recurveCount) {
        if (++recurveCount > 100) {
            return;
        }
        ArrayList<ActivityInstInfo> printList = new ArrayList<ActivityInstInfo>();
        for (int index = 0; index < groupList.size(); ++index) {
            ActivityInstInfo activityInfo = groupList.get(index);
            if (!SortAppendActivity.priorActsInSeq(sequenceList, activityInfo)) continue;
            printList.add(activityInfo);
        }
        if (printList.size() > 0) {
            sequenceList.addAll(printList);
            groupList.removeAll(printList);
        }
        if (groupList.size() > 0) {
            SortAppendActivity.sortActivity(groupList, sequenceList, recurveCount);
        }
    }

    private static boolean priorActsInSeq(List<ActivityInstInfo> seqList, ActivityInstInfo activityInfo) {
        String[] priorActIds = activityInfo.getPreActInstList();
        if (priorActIds != null) {
            for (String actId : priorActIds) {
                for (int index = 0; index < seqList.size(); ++index) {
                    ActivityInstInfo seqActivityInfo = seqList.get(index);
                    if (!actId.equals(seqActivityInfo.getActInstId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ActivityInstInfo> getNoPriorActivity(List<ActivityInstInfo> groupList) {
        ArrayList<ActivityInstInfo> noPriorActivityList = new ArrayList<ActivityInstInfo>();
        block0: for (int index = 0; index < groupList.size(); ++index) {
            ActivityInstInfo activityInfo = groupList.get(index);
            String[] priorActIds = activityInfo.getPreActInstList();
            if (priorActIds == null) {
                noPriorActivityList.add(activityInfo);
                continue;
            }
            for (String actId : priorActIds) {
                if (!activityInfo.getParentActInstId().equals(actId)) continue;
                noPriorActivityList.add(activityInfo);
                continue block0;
            }
        }
        return noPriorActivityList;
    }
}

