/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.participant;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.util.PermissionUtil;
import com.kingdee.bos.workflow.util.WorkflowUtils;

public class ParticipantHelper {
    public static String getOrgIdByNumber(Context ctx, String orgNumber) throws WfException {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (orgNumber == null || orgNumber.length() <= 0) {
            throw new IllegalArgumentException();
        }
        try {
            Object adminOrgUnit = null;
            String className = "com.kingdee.eas.basedata.org.AdminOrgUnitFactory";
            String methodName = "getLocalInstance";
            Class[] parameterTypes = new Class[]{Context.class};
            Object obj = null;
            Object[] args = new Object[]{ctx};
            adminOrgUnit = WorkflowUtils.invoke(className, obj, methodName, parameterTypes, args);
            if (adminOrgUnit == null) {
                throw new IllegalArgumentException();
            }
            Object collection = null;
            String className2 = "com.kingdee.eas.basedata.org.IAdminOrgUnit";
            Object obj2 = adminOrgUnit;
            String methodName2 = "getAdminOrgUnitCollection";
            Class[] parameterTypes2 = new Class[]{String.class};
            Object[] args2 = new Object[]{"where number='" + orgNumber + "'"};
            collection = WorkflowUtils.invoke(className2, obj2, methodName2, parameterTypes2, args2);
            if (collection == null) {
                return "";
            }
            Object org = null;
            String className3 = "com.kingdee.eas.basedata.org.AdminOrgUnitCollection";
            Object obj3 = collection;
            String methodName3 = "get";
            Class[] parameterTypes3 = new Class[]{Integer.TYPE};
            Object[] args3 = new Object[]{new Integer(0)};
            org = WorkflowUtils.invoke(className3, obj3, methodName3, parameterTypes3, args3);
            if (org == null) {
                return "";
            }
            Object id = null;
            String className4 = "com.kingdee.eas.basedata.org.AdminOrgUnitInfo";
            Object obj4 = org;
            String methodName4 = "getId";
            Class[] parameterTypes4 = new Class[0];
            Object[] args4 = new Object[0];
            id = WorkflowUtils.invoke(className4, obj4, methodName4, parameterTypes4, args4);
            if (id == null) {
                return "";
            }
            return ((BOSUuid)id).toString();
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
    }

    public static boolean isOrgPrincipalByOrgNumber(Context ctx, String userId, String orgNumber) throws WfException {
        return ParticipantHelper.isOrgPrincipal(ctx, userId, ParticipantHelper.getOrgIdByNumber(ctx, orgNumber));
    }

    public static boolean isOrgPrincipal(Context ctx, String userId, String orgId) throws WfException {
        if (ctx == null) {
            String msg = "\"ctx\" is null!";
            throw new IllegalArgumentException(msg);
        }
        if (userId == null || userId.length() == 0) {
            String msg = "\"userId\" is null!";
            throw new IllegalArgumentException(msg);
        }
        if (orgId == null || orgId.length() == 0) {
            String msg = "\"orgId\" is null!";
            throw new IllegalArgumentException(msg);
        }
        IParticipantProvider provider = WfEngine.getEngine(ctx).getPariticipantProvider();
        Person[] persons = provider.getOrgPrincipal(ctx, orgId);
        if (persons == null || persons.length == 0) {
            return false;
        }
        for (int i = 0; i < persons.length; ++i) {
            String localUserId = persons[i].getUserId();
            if (localUserId == null || localUserId.length() == 0 || !localUserId.equals(userId)) continue;
            return true;
        }
        return false;
    }

    public static String[] getPermissionOwners(Context ctx, String orgId, String permItemName) throws WfException {
        try {
            PermissionItemInfo permItem = PermissionUtil.findPermission(ctx, permItemName);
            return WfEngine.getEngine(ctx).getPermissionProvider().getPermissionOwners(ctx, 0, orgId, permItem);
        }
        catch (BOSException e) {
            if (e instanceof WfException) {
                throw (WfException)((Object)e);
            }
            throw new WfException((Throwable)e);
        }
    }
}

