/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.participant;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.Group;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.JobInfo;
import com.kingdee.bos.workflow.participant.OrgUnitInfo;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import java.util.Locale;
import java.util.Set;

class ParticipantProviderContextWrapper
implements IParticipantProvider {
    private static final long serialVersionUID = -6123312925293829379L;
    private final IParticipantProvider impl;
    private static final Locale DEF_LOCALE = new Locale("l2");

    ParticipantProviderContextWrapper(IParticipantProvider impl) {
        this.impl = impl;
    }

    private Context copyContext(Context context) {
        Context fakeContext = new Context(context.getCaller(), context.getSolution(), context.getAIS(), DEF_LOCALE);
        return fakeContext;
    }

    public Person[] getPersonByUserIds(Context context, String[] userIds) throws WfParticipantException {
        return this.impl.getPersonByUserIds(context, userIds);
    }

    public Person[] getAdminOrgUnitJobHolders(Context context, String adminOrgUnitID, String jobID) throws WfParticipantException {
        return this.impl.getAdminOrgUnitJobHolders(this.copyContext(context), adminOrgUnitID, jobID);
    }

    public String getAdminOrgUnitNamebyPositionID(Context context, String posittonID) throws WfParticipantException {
        return this.impl.getAdminOrgUnitNamebyPositionID(this.copyContext(context), posittonID);
    }

    public Group[] getAllGroups(Context context) throws WfParticipantException {
        return this.impl.getAllGroups(this.copyContext(context));
    }

    public OrgUnitInfo[] getAllOrgUnitArray(Context context) throws WfParticipantException {
        return this.impl.getAllOrgUnitArray(this.copyContext(context));
    }

    public OrgUnitInfo[] getAllOrgUnitByType(Context context, int orgType) throws WfParticipantException {
        return this.impl.getAllOrgUnitByType(this.copyContext(context), orgType);
    }

    public Person[] getAllPosFellow(Context ctx, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.impl.getAllPosFellow(this.copyContext(ctx), personId, positionId, hierarchyId);
    }

    public String getCurrentOrgIdByUser(Context context, String userId, int orgType) throws WfParticipantException {
        return this.impl.getCurrentOrgIdByUser(this.copyContext(context), userId, orgType);
    }

    public Person[] getFellow(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.impl.getFellow(this.copyContext(context), personId, positionId, hierarchyId);
    }

    public Group[] getGroupArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        return this.impl.getGroupArrayByEmployeeId(this.copyContext(context), employeeId);
    }

    public String[] getHierarchyByOrgType(Context context, int orgType) throws WfParticipantException {
        return this.impl.getHierarchyByOrgType(this.copyContext(context), orgType);
    }

    public String getHierarchyNameByID(Context context, String id) throws WfParticipantException {
        return this.impl.getHierarchyNameByID(this.copyContext(context), id);
    }

    public Person[] getIndirectSupervisor(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.impl.getIndirectSupervisor(this.copyContext(context), personId, positionId, hierarchyId);
    }

    public JobInfo[] getJobArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        return this.impl.getJobArrayByEmployeeId(this.copyContext(context), employeeId);
    }

    public JobInfo[] getJobArrayByOrgUnitId(Context context, String orgUnitId) throws WfParticipantException {
        return this.impl.getJobArrayByOrgUnitId(this.copyContext(context), orgUnitId);
    }

    public JobInfo[] getJobsArray(Context context) throws WfParticipantException {
        return this.impl.getJobsArray(this.copyContext(context));
    }

    public Person[] getOrgAllMember(Context context, String orgId) throws WfParticipantException {
        return this.impl.getOrgAllMember(this.copyContext(context), orgId);
    }

    public Person[] getOrgMember(Context context, String orgId) throws WfParticipantException {
        return this.impl.getOrgMember(this.copyContext(context), orgId);
    }

    public Person[] getOrgPrincipal(Context context, String orgId) throws WfParticipantException {
        return this.impl.getOrgPrincipal(this.copyContext(context), orgId);
    }

    public OrgUnitInfo[] getOrgUnitArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        return this.impl.getOrgUnitArrayByEmployeeId(this.copyContext(context), employeeId);
    }

    public OrgUnitInfo[] getOrgUnitArrayByUserId(Context context, String userId) throws WfParticipantException {
        return this.impl.getOrgUnitArrayByUserId(this.copyContext(context), userId);
    }

    public Person[] getOtherPosFellow(Context ctx, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.impl.getOtherPosFellow(this.copyContext(ctx), personId, positionId, hierarchyId);
    }

    public OrgUnitInfo getParentOrgUnit(Context context, String orgUintId) throws WfParticipantException {
        return this.impl.getParentOrgUnit(this.copyContext(context), orgUintId);
    }

    public Person[] getPersonByEmployeeId(Context context, String personId) throws WfParticipantException {
        return this.impl.getPersonByEmployeeId(this.copyContext(context), personId);
    }

    public Person getPersonByUserId(Context context, String personId) throws WfParticipantException {
        return this.impl.getPersonByUserId(this.copyContext(context), personId);
    }

    public Person[] getPersonsByUserId(Context context, String personId) throws WfParticipantException {
        return this.impl.getPersonsByUserId(this.copyContext(context), personId);
    }

    public Person[] getPersonsFromGroup(Context context, String groupId) throws WfParticipantException {
        return this.impl.getPersonsFromGroup(this.copyContext(context), groupId);
    }

    public PositionInfo[] getPositionArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        return this.impl.getPositionArrayByEmployeeId(this.copyContext(context), employeeId);
    }

    public PositionInfo[] getPositionArrayByOrgUnitId(Context context, String orgUnitId) throws WfParticipantException {
        return this.impl.getPositionArrayByOrgUnitId(this.copyContext(context), orgUnitId);
    }

    public PositionInfo[] getPositionArrayByUserId(Context context, String userId) throws WfParticipantException {
        return this.impl.getPositionArrayByUserId(this.copyContext(context), userId);
    }

    public PositionInfo[] getPositionByPersonAndHierarchy(Context context, String personID, String hierarchyID) throws WfParticipantException {
        return this.impl.getPositionByPersonAndHierarchy(this.copyContext(context), personID, hierarchyID);
    }

    public Person[] getPositionHolders(Context context, String positionId) throws WfParticipantException {
        return this.impl.getPositionHolders(this.copyContext(context), positionId);
    }

    public Person[] getRoleMember(Context context, String personUserId, String roleId) throws WfParticipantException {
        return this.impl.getRoleMember(this.copyContext(context), personUserId, roleId);
    }

    public OrgUnitInfo getRootUnit(Context ctx, int orgType) throws WfParticipantException {
        return this.impl.getRootUnit(this.copyContext(ctx), orgType);
    }

    public Person[] getSameJobGradePersonFellow(Context ctx, String personId) throws WfParticipantException {
        return this.impl.getSameJobGradePersonFellow(this.copyContext(ctx), personId);
    }

    public OrgUnitInfo[] getSubOrgUnit(Context context, String parantOrgUnitId) throws WfParticipantException {
        return this.impl.getSubOrgUnit(this.copyContext(context), parantOrgUnitId);
    }

    public Person[] getSubordinate(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.impl.getSubordinate(this.copyContext(context), personId, positionId, hierarchyId);
    }

    public Person[] getSupervisor(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        return this.impl.getSupervisor(this.copyContext(context), personId, positionId, hierarchyId);
    }

    public boolean isPersonInOrg(Context context, String personId, String OrgId) throws WfParticipantException {
        return this.impl.isPersonInOrg(this.copyContext(context), personId, OrgId);
    }

    public void cleanCache() throws WfException {
        this.impl.cleanCache();
    }

    public Set<String> getVoidedEmployees(Context context) {
        return null;
    }
}

