/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.participant;

import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.participant.EASParticipantCacheProviderWrapper;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.ParticipantProviderContextWrapper;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.util.profile.ObjectProfileInterceptor;
import com.kingdee.util.profile.ProfileConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;

public class ParticipantProviderFactory {
    private static final Logger logger = Logger.getLogger(ParticipantProviderFactory.class);

    private ParticipantProviderFactory() {
    }

    public static IParticipantProvider getParticipantProvider(WfEngine engine) {
        IParticipantProvider impl = ParticipantProviderFactory.getImpl();
        if (ProfileConfig.getInstance().logWfEngine) {
            return (IParticipantProvider)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{IParticipantProvider.class}, (InvocationHandler)new ObjectProfileInterceptor((Object)new EASParticipantCacheProviderWrapper(engine, new ParticipantProviderContextWrapper(impl))));
        }
        return new EASParticipantCacheProviderWrapper(engine, new ParticipantProviderContextWrapper(impl));
    }

    private static IParticipantProvider getImpl() {
        try {
            Class<?> clazz = Class.forName(EngineConfig.getInstance().getParticipantProvider());
            return (IParticipantProvider)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"PraticipantProvider init error", (Throwable)e);
            throw new RuntimeException("PraticipantProvider init error", e);
        }
        catch (InstantiationException e) {
            logger.error((Object)"PraticipantProvider init error", (Throwable)e);
            throw new RuntimeException("PraticipantProvider init error", e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"PraticipantProvider init error", (Throwable)e);
            throw new RuntimeException("PraticipantProvider init error", e);
        }
    }
}

