/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.ActivityDefPartialInfo;
import com.kingdee.bos.workflow.biz.trans.WfActivityTableData;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IActiviyMonitorService;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActiviyMonitorService
extends AbstractBOSObject
implements IActiviyMonitorService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFACTMOS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.ActiviyMonitorService");

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public static IActiviyMonitorService getService(Context ctx) {
        return new ActiviyMonitorService(ctx);
    }

    public ActiviyMonitorService(Context ctx) {
        super(ctx);
        this.registerInterface(IActiviyMonitorService.class, (Object)this);
    }

    public ActivityInstInfo createActivityInst(String procInstId, String actDefId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ActiviyMonitorService Method:createActivityInst been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procInstId=\"");
            buffer.append(procInstId);
            buffer.append("\" actDefId=\"");
            buffer.append(actDefId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        String actInstId = procInst.createActivityInst(actDefId, null, null, false);
        return wfEngine.getActivityInst(actInstId).getMeta();
    }

    public ActivityInstInfo[] getActInstMetaArrayByProcInstId(String procInstId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ActiviyMonitorService Method:getActInstMetaArrayByProcInstId been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getActInstMetaArrayByProcInstId(procInstId);
    }

    public ActivityInstInfo[] getActInstMetaArrayByProcInstIdAndActInstState(String procInstId, String actInstState) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ActiviyMonitorService Method:getActInstMetaArrayByProcInstIdAndActInstState been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            buffer.append(" actInstSate=\"");
            buffer.append(actInstState);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getActInstMetaArrayByProcInstIdAndActInstState(procInstId, actInstState);
    }

    public ActivityInstInfo[] getRelatedActInstsByProcInstID(String procInstId) throws WfException {
        String ancestorProcInstID = WorkflowUtils.getAncestorProcInstID(this.getContext(), procInstId);
        List actInsts = this.getActinstsIncludeAllSubProc(ancestorProcInstID);
        return actInsts.toArray(new ActivityInstInfo[actInsts.size()]);
    }

    private List getActinstsIncludeAllSubProc(String procInstId) throws WfException {
        ArrayList<ActivityInstInfo> retVal = new ArrayList<ActivityInstInfo>();
        for (ActivityInstInfo activityInstInfo : this.getActInstMetaArrayByProcInstId(procInstId)) {
            retVal.add(activityInstInfo);
            String subProcInstID = activityInstInfo.getActInstInfo().getSubProcInstID();
            if (StringUtils.isEmpty((String)subProcInstID)) continue;
            retVal.addAll(this.getActinstsIncludeAllSubProc(subProcInstID));
        }
        return retVal;
    }

    public List getRelatedActInstsByProcInstID(String procInstId, Set states) throws WfException {
        if (procInstId == null || procInstId.trim().length() == 0) {
            throw new IllegalArgumentException("procInstId must not be null!");
        }
        ActivityInstInfo[] actInstInfos = this.getRelatedActInstsByProcInstID(procInstId);
        if (states == null || states.size() <= 0) {
            return Arrays.asList(actInstInfos);
        }
        WfEngine engine = WfEngine.getEngine(this.getContext());
        HashMap<String, String> subProcInstInfos = new HashMap<String, String>();
        int size = actInstInfos.length;
        for (int i = 0; i < size; ++i) {
            String subProcInstID;
            if (!states.contains(actInstInfos[i].getState()) || (subProcInstID = actInstInfos[i].getSubProcInstId()) == null || subProcInstID.equals("")) continue;
            String subProcDefName = engine.getProcessInst(subProcInstID).getProcessMeta().getProcDefName(this.getContext().getLocale());
            subProcInstInfos.put(subProcInstID, subProcDefName);
        }
        ArrayList<ActivityInstInfo> retVal = new ArrayList<ActivityInstInfo>();
        int size2 = actInstInfos.length;
        for (int i = 0; i < size2; ++i) {
            ActivityInstInfo info;
            if (!states.contains(actInstInfos[i].getState()) || (info = actInstInfos[i]).getSubProcInstId() != null) continue;
            String porcInstID = info.getProcInstId();
            if (subProcInstInfos.containsKey(porcInstID)) {
                info.setActDefName(this.getContext().getLocale(), info.getActDefName(this.getContext().getLocale()) + " - " + subProcInstInfos.get(porcInstID));
            }
            retVal.add(info);
        }
        return retVal;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public WfActivityTableData getWfActivityTableDataByProcInstID(String processInstId) throws WfException {
        if (StringUtils.isEmpty((String)processInstId)) {
            throw new WfException("Service:ActiviyMonitorService.getWfActivityTableDataByProcInstID Args can't be null");
        }
        WfActivityTableData data = new WfActivityTableData();
        ActivityInstInfo[] actInstInfos = this.getRelatedActInstsByProcInstID(processInstId);
        data.setAllActivitys(actInstInfos);
        data.setAllActivityDefPartialInfos(this.getActivityDefPartialInfos(actInstInfos));
        data.setAllAssigments(this.getAssignments(actInstInfos));
        return data;
    }

    private Map getAssignments(ActivityInstInfo[] activitys) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        HashMap retVal = new HashMap();
        HashSet<String> procInstIDs = new HashSet<String>();
        for (ActivityInstInfo activityInstInfo : activitys) {
            procInstIDs.add(activityInstInfo.getProcInstId());
            if (StringUtils.isEmpty((String)activityInstInfo.getSubProcInstId())) continue;
            procInstIDs.add(activityInstInfo.getSubProcInstId());
        }
        for (String procInstID : procInstIDs) {
            AssignmentInfo[] assignmentInfos = wfEngine.getAssignmentAllByProcInstId(procInstID);
            int size = assignmentInfos.length;
            for (int i = 0; i < size; ++i) {
                Map<String, AssignmentInfo> assignments;
                String actInstId = assignmentInfos[i].getActInstId();
                if (retVal.containsKey(actInstId)) {
                    assignments = (Map)retVal.get(actInstId);
                    assignments.put(assignmentInfos[i].getAssignmentId(), assignmentInfos[i]);
                    continue;
                }
                assignments = new HashMap();
                assignments.put(assignmentInfos[i].getAssignmentId(), assignmentInfos[i]);
                retVal.put(actInstId, assignments);
            }
        }
        return retVal;
    }

    private Map getActivityDefPartialInfos(ActivityInstInfo[] activitys) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        HashMap<String, ActivityDefPartialInfo> retVal = new HashMap<String, ActivityDefPartialInfo>();
        HashSet<String> procDefHashValues = new HashSet<String>();
        for (ActivityInstInfo activityInstInfo : activitys) {
            procDefHashValues.add(activityInstInfo.getProcDefHashValue());
            if (StringUtils.isEmpty((String)activityInstInfo.getSubProcInstId())) continue;
            procDefHashValues.add(activityInstInfo.getProcDefHashValue());
        }
        for (String procDefHashValue : procDefHashValues) {
            ProcessDef processDef = wfEngine.getProcessDef(procDefHashValue);
            ActivityCollection activityCollection = processDef.getActivitys();
            int size = activityCollection.size();
            for (int i = 0; i < size; ++i) {
                ActivityDef activityDef = activityCollection.get(i);
                retVal.put(activityDef.getID(), this.constructActDefPartialInfo(activityDef));
            }
        }
        return retVal;
    }

    private ActivityDefPartialInfo constructActDefPartialInfo(ActivityDef actDef) throws WfException {
        boolean isApproveAct = false;
        boolean isFirstAct = false;
        if (actDef instanceof ApproveActivityDef) {
            isApproveAct = true;
        }
        ActivityCollection preActCol = actDef.getPreviousActivities();
        for (int i = 0; i < preActCol.size(); ++i) {
            if (!(preActCol.get(i) instanceof StartActivityDef)) continue;
            isFirstAct = true;
            break;
        }
        ActivityDefPartialInfo partialInfo = new ActivityDefPartialInfo();
        partialInfo.setActDefId(actDef.getID());
        partialInfo.setActDefName(actDef.getName());
        partialInfo.setActDefTypeName(actDef.getType().getName());
        partialInfo.setApproveActDef(isApproveAct);
        partialInfo.setFirstActivity(isFirstAct);
        return partialInfo;
    }
}

