/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.enhanced.IEMessageActivity;
import com.kingdee.bos.workflow.define.enhanced.IMessageActivity;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IProcessMonitorService;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProcessMonitorService
extends AbstractBOSObject
implements IProcessMonitorService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFPOSMOS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.ProcessMonitorService");

    public static IProcessMonitorService getService(Context ctx) {
        return new ProcessMonitorService(ctx);
    }

    public ProcessMonitorService(Context ctx) {
        super(ctx);
        this.registerInterface(IProcessMonitorService.class, (Object)this);
    }

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public ProcessInstInfo getProcessInstInfo(String procInstId) throws WfException {
        AssignmentMessage msg;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessInstInfo been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        ProcessDef def = wfEngine.getProcessDef(procInst.getProcessMeta().getProcDefHashValue());
        ProcessInstInfo data = procInst.getData();
        if (def instanceof IMessageActivity) {
            IMessageActivity msgAct = (IMessageActivity)def;
            msg = msgAct.getMessage();
            data.setSendMail(msg != null && msg.isSendMail());
        }
        if (def instanceof IEMessageActivity) {
            IEMessageActivity emsgAct = (IEMessageActivity)def;
            msg = emsgAct.getEMessage();
            data.setSendMobileMsg(msg != null && msg.isEnable());
        }
        return procInst.getData();
    }

    public ProcessInstInfo[] getAllProcessInstances() throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getAllProcessInstances been called.");
            String desc = buffer.toString();
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAllProcessInstances(-1, null);
    }

    public ProcessInstInfo[] getAllProcessInstances(int maxReturn) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getAllProcessInstances been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: maxReturn=");
            buffer.append(maxReturn);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAllProcessInstances(maxReturn, null);
    }

    public ProcessInstInfo[] getAllProcessInstances(String procInstState) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getAllProcessInstances been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procInstState=\"");
            buffer.append(procInstState);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAllProcessInstances(-1, procInstState);
    }

    public ProcessInstInfo[] getAllProcessInstances(int maxReturn, String procInstState) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getAllProcessInstances been called.");
            String desc = buffer.toString();
            buffer.append("parameters: maxReturn=");
            buffer.append(maxReturn);
            buffer.append(" procInstState=\"");
            buffer.append(procInstState);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getAllProcessInstances(maxReturn, procInstState);
    }

    public ProcessInstInfo[] getProcessInstancesByProcDefId(String procDefId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessInstancesByProcDefId been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procDefId=\"");
            buffer.append(procDefId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getProcessInstancesByProcDefId(procDefId);
    }

    public ProcessInstInfo[] getProcessInstanceByHoldedObjectId(String bizObjId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessInstanceByHoldedObjectId been called.");
            String desc = buffer.toString();
            buffer.append("parameter: bizObjId=\"");
            buffer.append(bizObjId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfe = EngineUtil.getEngine(this.getContext());
        return wfe.getProcessInstanceByHoldedObjectId(bizObjId);
    }

    public ProcessInstInfo[] getProcessInstInfoByInitiator(String initiatorUserID) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessInstInfoByInitiator been called.");
            String desc = buffer.toString();
            buffer.append("parameter: initiatorUserID=\"");
            buffer.append(initiatorUserID);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine workFlowEngine = EngineUtil.getEngine(this.getContext());
        ProcessInstInfo[] processInstInfoArray = workFlowEngine.getProcessInstInfoByInitiator(initiatorUserID);
        return processInstInfoArray;
    }

    public Map getProcessContext(String procInstId) throws WfException {
        return this.getProcessContext(procInstId, false);
    }

    public Map getProcessContext(String procInstId, boolean refresh) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessContext been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        Map rtnValue = new HashMap();
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        ProcessContext procCtx = procInst.getProcessContext();
        rtnValue = refresh ? procCtx.getDataCopy(true, true) : procCtx.getDataCopy();
        return rtnValue;
    }

    public void setProcessContext(String procInstId, Map context) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessContext been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            buffer.append(" context=");
            buffer.append(context);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        ProcessContext procCtx = procInst.getProcessContext();
        procCtx.setDataFieldValues(context);
        procCtx.storeToDb();
    }

    public Object getProcessContext(String procInstId, String key) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessContext been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            buffer.append(" key=\"");
            buffer.append(key);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        ProcessContext procCtx = procInst.getProcessContext();
        return procCtx.getDataFieldValue(key);
    }

    public void setProcessContext(String procInstId, String key, Object value) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessContext been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            buffer.append(" key=\"");
            buffer.append(key);
            buffer.append('\"');
            buffer.append(" value=");
            buffer.append(value);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        ProcessContext procCtx = procInst.getProcessContext();
        procCtx.putDataFieldValue(key, value);
        procCtx.storeToDb();
        if (key.indexOf("DP_") >= 0 && key.indexOf("WFACTDEF") >= 0) {
            String caller = this.getContext().getCaller().toString();
            IObjectPK logPk = null;
            JSONObject jsonInfo = new JSONObject();
            AssignmentInfo[] assignmentInfoArr = wfEngine.getAssignmentByProcInstAndOwner(procInstId, caller, WfAssignmentState.ASSIGNED);
            if (null != assignmentInfoArr && assignmentInfoArr.length > 0) {
                AssignmentInfo assign = assignmentInfoArr[0];
                jsonInfo.put("assign", (Object)assign);
                jsonInfo.put("caller", (Object)this.getContext().getCaller());
                jsonInfo.put("actKey", (Object)key);
                jsonInfo.put("persons", value);
                logPk = WorkflowLogUtil.beginLogByLocal(this.getContext(), WorkflowLogItem.TO_DO_LIST_NEXTACTS, jsonInfo);
                WorkflowLogUtil.endLogByLocal(this.getContext(), logPk);
            }
        }
    }

    public String[] getPassedTransDefArray(String procInstId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessContext been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procInstId=\"");
            buffer.append(procInstId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        if (procInst == null) {
            return new String[0];
        }
        return procInst.getPassedTransDefArray();
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public ProcessInstInfo getProcessInstInfo(String procInstId, String[] selectors) throws WfException {
        throw new RuntimeException("TODO");
    }

    public ProcessInstInfo[] getProcessInstancesByProcDefId(String procDefId, String[] selectors) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessInstancesByProcDefId been called.");
            String desc = buffer.toString();
            buffer.append("parameter: procDefId=\"");
            buffer.append(procDefId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getProcessInstancesByProcDefId(procDefId, selectors);
    }

    public ProcessInstInfo getProcessInstInfoByAssign(String assignmentId) throws WfException {
        if (StringUtils.isEmpty((String)assignmentId)) {
            throw new WfException("ProcessMonitorService.getProcessInstInfoByAssign args assignmentid can't be null");
        }
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:ProcessMonitorService Method:getProcessInstInfoByAssign been called.");
            String desc = buffer.toString();
            buffer.append("parameter: assignmentId=\"");
            buffer.append(assignmentId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfAssignment assign = wfEngine.getAssignment(assignmentId);
        String processInstId = assign.getProcInstId();
        return this.getProcessInstInfo(processInstId);
    }

    public ProcessInstInfo[] getProcessInstancesByParentProcInstId(String parentProcInstId) throws WfException {
        if (StringUtils.isEmpty((String)parentProcInstId)) {
            throw new WfException("ProcessMonitorService.getProcessInstancesByParentProcInstId args parentProcInstId can't be null");
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        return wfEngine.getProcessInstancesByParentProcInstId(parentProcInstId);
    }

    public ProcessInstInfo[] getProcessInstInfos(String[] procInstIds) throws WfException {
        if (procInstIds == null || procInstIds.length <= 0) {
            return new ProcessInstInfo[0];
        }
        ProcessInstInfo[] processInstInfos = new ProcessInstInfo[procInstIds.length];
        for (int i = 0; i < procInstIds.length; ++i) {
            processInstInfos[i] = this.getProcessInstInfo(procInstIds[i]);
        }
        return processInstInfos;
    }
}

