/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.cust.IWFRole;
import com.kingdee.bos.workflow.cust.IWFRoleGroup;
import com.kingdee.bos.workflow.cust.WFRoleFactory;
import com.kingdee.bos.workflow.cust.WFRoleGroupFactory;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IWFLogProcessor;
import com.kingdee.bos.workflow.service.IWorkflowLogService;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class WorkflowLogService
extends AbstractBOSObject
implements IWorkflowLogService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"BOSWFLOG");
    private static Map<String, String> logMap = new ConcurrentHashMap<String, String>();
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.WorkflowLogService");
    private final String LOG_ITEM_NAME = "Bos_Workflow_Option";
    Context ctx;

    public WorkflowLogService() {
        this.ctx = this.getContext();
    }

    public WorkflowLogService(Context ctx) {
        super(ctx);
        this.ctx = ctx;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public IObjectPK beginLogByLocal(WorkflowLogItem wfItem, String opContent) throws WfException {
        IObjectPK pk = null;
        try {
            CoreBaseInfo wfRoleInfo;
            String[] pkArr;
            IAppLog appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
            String opObject = new String(opContent);
            String[] opContentArr = new String[2];
            if ((wfItem.getName().startsWith("FLOW_CHART") || wfItem == WorkflowLogItem.ALREADY_DONE_RETRACT || wfItem == WorkflowLogItem.DOING_STOP) && wfItem != WorkflowLogItem.FLOW_CHART_JUMP) {
                opObject = this.getProcInstName(wfItem, opObject, opContent);
            } else if (wfItem == WorkflowLogItem.TO_DO_LIST_HANDLE || wfItem == WorkflowLogItem.TO_DO_LIST_DELIVER || wfItem == WorkflowLogItem.TO_DO_LIST_QUICK_APPROVAL || wfItem == WorkflowLogItem.TO_DO_LIST_BATCH_APPROVAL) {
                String assigSubject;
                WfProcess procInst = null;
                WfAssignment assig = null;
                if (wfItem == WorkflowLogItem.TO_DO_LIST_QUICK_APPROVAL) {
                    opObject = "";
                    try {
                        String assigId = opContent;
                        if (!StringUtils.isEmpty((String)assigId) && assigId.endsWith("WFWKITEM")) {
                            assig = EngineUtil.getEngine(this.ctx).getAssignment(assigId);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("\u5de5\u4f5c\u6d41\u4e0a\u673a\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a\u83b7\u53d6\u4efb\u52a1\u5931\u8d25\uff1a\u5b9e\u4f8bID\uff1a" + opContent + ",\u64cd\u4f5c\uff1a" + wfItem.getAlias() + wfItem.getValue()), (Throwable)e);
                    }
                    if (null != assig) {
                        procInst = EngineUtil.getEngine(this.ctx).getProcessInst(assig.getProcInstId());
                        assigSubject = assig.getMeta().getSubject(this.ctx.getLocale());
                        if ("null".equals(assigSubject)) {
                            assigSubject = "";
                        }
                        opObject = opObject + procInst.getProcessMeta().getInstTopic() + ":" + assigSubject;
                    }
                } else {
                    opContentArr = opContent.split(",");
                    try {
                        assig = EngineUtil.getEngine(this.ctx).getAssignment(opContentArr[0]);
                    }
                    catch (Exception e) {
                        log.error((Object)("\u5de5\u4f5c\u6d41\u4e0a\u673a\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a\u83b7\u53d6\u4efb\u52a1\u5931\u8d25\uff1a\u5b9e\u4f8bID\uff1a" + opContent + ",\u64cd\u4f5c\uff1a" + wfItem.getAlias() + wfItem.getValue()), (Throwable)e);
                    }
                    if (null != assig) {
                        procInst = EngineUtil.getEngine(this.ctx).getProcessInst(assig.getProcInstId());
                        assigSubject = assig.getMeta().getSubject(this.ctx.getLocale());
                        if (StringUtils.isEmpty((String)assigSubject)) {
                            assigSubject = "";
                        }
                        opObject = procInst.getProcessMeta().getInstTopic() + ":" + assigSubject;
                    }
                }
            } else if (wfItem == WorkflowLogItem.WF_ROLE_DEL || wfItem == WorkflowLogItem.WF_ROLE_DISABLE || wfItem == WorkflowLogItem.WF_ROLE_ENABLE || wfItem == WorkflowLogItem.WF_ROLE_UPDATE) {
                try {
                    IWFRole wfRole = WFRoleFactory.getLocalInstance((Context)this.ctx);
                    pkArr = opContent.split(";");
                    opObject = "";
                    for (int i = 0; i < pkArr.length; ++i) {
                        wfRoleInfo = wfRole.getValue((IObjectPK)new ObjectUuidPK(pkArr[i]));
                        opObject = opObject + wfRoleInfo.getString("rolename");
                        opObject = opObject + ";";
                    }
                }
                catch (Exception e) {
                    opObject = opContent;
                    log.error((Object)("\u5de5\u4f5c\u6d41\u4e0a\u673a\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a\u83b7\u53d6\u5de5\u4f5c\u6d41\u89d2\u8272\u5931\u8d25\uff1a\u5b9e\u4f8bID\uff1a" + opContent + ",\u64cd\u4f5c\uff1a" + wfItem.getAlias() + wfItem.getValue()), (Throwable)e);
                }
            } else if (wfItem == WorkflowLogItem.WF_ROLE_GROUB_DEL) {
                try {
                    IWFRoleGroup wfRoleGroup = WFRoleGroupFactory.getLocalInstance((Context)this.ctx);
                    pkArr = opContent.split(";");
                    opObject = "";
                    for (int i = 0; i < pkArr.length; ++i) {
                        wfRoleInfo = wfRoleGroup.getValue((IObjectPK)new ObjectUuidPK(pkArr[i]));
                        opObject = opObject + wfRoleInfo.getString("name");
                        opObject = opObject + ";";
                    }
                }
                catch (EASBizException e) {
                    log.error((Object)("\u5de5\u4f5c\u6d41\u4e0a\u673a\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a\u83b7\u53d6\u5de5\u4f5c\u6d41\u89d2\u8272\u7ec4\u5931\u8d25\uff1a\u5b9e\u4f8bID\uff1a" + opContent + ",\u64cd\u4f5c\uff1a" + wfItem.getAlias() + wfItem.getValue()), (Throwable)e);
                }
            } else if (wfItem.getName().startsWith("ENTRUST_") && "[]".equals(opContent)) {
                opObject = "[\u5168\u90e8\u6d41\u7a0b]";
            }
            String op = wfItem.getAlias() + wfItem.getValue();
            if (wfItem == WorkflowLogItem.TO_DO_LIST_HANDLE || wfItem == WorkflowLogItem.TO_DO_LIST_BATCH_APPROVAL) {
                op = op + ",\u5904\u7406\u7ed3\u679c:" + ("true".equals(opContentArr[1]) ? "\u540c\u610f" : "\u4e0d\u540c\u610f");
            }
            if (opObject.endsWith("WFPCINST")) {
                WfProcess procInst = EngineUtil.getEngine(this.ctx).getProcessInst(opObject);
                opObject = procInst.getProcessMeta().getInstTopic();
            }
            if (opObject.indexOf("WFPRCDEF") >= 0) {
                String sql = "select FProcCode as code from T_WFR_ProcDef ";
                sql = opObject.startsWith("'") && opObject.endsWith("'") ? sql + " where FPROCDEFID in (" + opObject + ") group by FProcCode" : sql + " where FPROCDEFID in ('" + opObject + "') group by FProcCode";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                opObject = "\u6d41\u7a0b\u5b9a\u4e49\u7f16\u7801\uff1a";
                while (rowSet.next()) {
                    String name = rowSet.getString("code");
                    name = name + ";";
                    opObject = opObject + name;
                }
            }
            String functionInfo = new String(op);
            String easInstName = System.getProperty("EAS_INSTANCE_HOME");
            if (!StringUtils.isEmpty((String)easInstName)) {
                String[] easInstNameArr = easInstName.split("/profiles/");
                op = op + "(" + (easInstNameArr.length >= 2 ? easInstNameArr[1] : easInstName) + ")";
            }
            String companyId = this.getCompanyId();
            pk = appLog.writeLog("Bos_Workflow_Option", BOSTYPE, null, opObject, "Bos_Workflow_Option", companyId, op);
            this.updateLogFunction(pk, functionInfo);
        }
        catch (Exception e) {
            log.error((Object)("\u5de5\u4f5c\u6d41\u4e0a\u673a\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25,\u64cd\u4f5c\uff1a" + wfItem.getAlias() + wfItem.getValue()), (Throwable)e);
        }
        return pk;
    }

    private String getCompanyId() {
        String companyId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        if (this.ctx.get((Object)"CurCompanyId") == null) {
            try {
                ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)this.ctx);
                CtrlUnitInfo ctrlUnitInfo = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
                this.ctx.put((Object)OrgType.ControlUnit, (Object)ctrlUnitInfo);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            companyId = this.ctx.get((Object)"CurCompanyId").toString();
        }
        return companyId;
    }

    private void updateLogFunction(IObjectPK pk, String functionInfo) throws BOSException {
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod("updateLogFunctionInner", Context.class, IObjectPK.class, String.class);
            Object[] params = new Object[]{this.ctx, pk, functionInfo};
            int transaction = 4;
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)((Object)this));
            txInvoker.invoke(method, params, transaction);
        }
        catch (Throwable t) {
            throw new BOSException(t);
        }
    }

    public void updateLogFunctionInner(Context ctx, IObjectPK pk, String functionInfo) throws BOSException {
        String sql = "update T_LOG_APP set FENTITYALIAS_L2 = ? where FID = ? ";
        SQL.executeUpdate((Context)ctx, (String)sql, (int[])new int[]{12, 12}, (Object[])new Object[]{functionInfo, String.valueOf(pk)});
    }

    private String getProcInstName(WorkflowLogItem wfItem, String opObject, String opContent) throws WfException {
        WfProcess procInst = null;
        WfActivity actInst = null;
        try {
            if (!StringUtils.isEmpty((String)opContent) && opContent.endsWith("WFPCINST")) {
                procInst = EngineUtil.getEngine(this.ctx).getProcessInst(opContent);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u5de5\u4f5c\u6d41\u4e0a\u673a\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\uff1a\u5b9e\u4f8bID\uff1a" + opContent + ",\u64cd\u4f5c\uff1a" + wfItem.getAlias() + wfItem.getValue()), (Throwable)e);
        }
        try {
            if (!StringUtils.isEmpty((String)opContent) && opContent.endsWith("WFATINST")) {
                actInst = EngineUtil.getEngine(this.ctx).getActivityInst(opContent);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u5de5\u4f5c\u6d41\u4e0a\u673a\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff1a\u83b7\u53d6\u6d3b\u52a8\u5b9e\u4f8b\u5931\u8d25\uff1a\u5b9e\u4f8bID\uff1a" + opContent + ",\u64cd\u4f5c\uff1a" + wfItem.getAlias() + wfItem.getValue()), (Throwable)e);
        }
        if (null != procInst) {
            opObject = procInst.getProcessMeta().getInstTopic();
        }
        if (null != actInst) {
            procInst = EngineUtil.getEngine(this.ctx).getProcessInst(actInst.getProcInstId());
            opObject = procInst.getProcessMeta().getInstTopic() + ":" + actInst.getName();
        }
        return opObject;
    }

    public void setRemoteCallIP(String ip) throws WfException {
        this.ctx.setClientHostIP(ip);
    }

    public void endLogByLocal(IObjectPK logPk) throws WfException {
        try {
            IAppLog appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
            appLog.upateLogStatus(logPk);
        }
        catch (BOSException e) {
            log.error((Object)e);
        }
    }

    public IObjectPK beginLogByLocal(IWFLogProcessor logProcessor) {
        IObjectPK pk = null;
        try {
            IAppLog appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
            boolean isRecode = logProcessor.process();
            if (!isRecode) {
                return null;
            }
            pk = appLog.writeLog("Bos_Workflow_Option", BOSTYPE, null, logProcessor.getOperateObject(), "Bos_Workflow_Option", this.getCompanyId(), logProcessor.getOperate());
            this.updateLogFunction(pk, logProcessor.getFunction());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return pk;
    }
}

