/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.store.listener.AbstractDataProvider;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.transaction.IBatchPersistence;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultBatchPersistence
extends AbstractDataProvider
implements IBatchPersistence {
    private static final Logger logger = Logger.getLogger(DefaultBatchPersistence.class);
    protected final BOSObjectType bosObjectType;

    public DefaultBatchPersistence(Context ctx, BOSObjectType bosObjectType) {
        super(ctx);
        this.bosObjectType = bosObjectType;
    }

    @Override
    public BOSObjectType getBOSObjectType() {
        return this.bosObjectType;
    }

    @Override
    public void executeBatch(List newObjects, List changedObjects) throws WfException {
        LowTimer lowTimer = new LowTimer();
        Connection cn = null;
        try {
            IObjectValue objectValue;
            int i;
            int size;
            cn = this.getConnection();
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)this.bosObjectType, (Context)this.innerContext, (Connection)cn);
            if (newObjects != null) {
                size = newObjects.size();
                for (i = 0; i < size; ++i) {
                    objectValue = (IObjectValue)newObjects.get(i);
                    dao.addNewBatch(objectValue);
                }
            }
            if (changedObjects != null) {
                size = changedObjects.size();
                for (i = 0; i < size; ++i) {
                    objectValue = (IObjectValue)changedObjects.get(i);
                    ObjectUuidPK pk = new ObjectUuidPK(objectValue.getBOSUuid(objectValue.getPKField()));
                    dao.updateBatch((IObjectPK)pk, objectValue);
                }
            }
            dao.executeBatch();
            this.dataSync(newObjects, changedObjects);
        }
        catch (DataAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DefaultBatchPersistence.executeBatch:" + lowTimer.msValue() + " bosObjectType:" + this.bosObjectType));
        }
    }

    private void dataSync(List newObjects, List changedObjects) {
        if (this.isEnableListen()) {
            List objects;
            String procInstId = null;
            List list = objects = newObjects != null ? newObjects : changedObjects;
            if (objects.size() <= 0) {
                return;
            }
            if (this.bosObjectType.equals((Object)WfBOSObjectTypeUtil.PROCESSINSTBOT)) {
                ProcInstInfo info = (ProcInstInfo)objects.get(0);
                procInstId = info.getProcInstID().toString();
            } else if (this.bosObjectType.equals((Object)WfBOSObjectTypeUtil.PROCINSTDATABOT)) {
                ProcInstDataInfo info = (ProcInstDataInfo)objects.get(0);
                procInstId = info.getProcInstID().toString();
            }
            this.notifyDataChangeByProcInstIdAndBOSType(procInstId, "executeBatch", new Class[]{List.class, List.class}, new Object[]{newObjects, changedObjects}, this.bosObjectType);
        }
    }
}

