/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.md5;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.TransBoxInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizProcInfo;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleUtils;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.LimitDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.cache.EffectRegion;
import com.kingdee.bos.workflow.enactment.cache.IIdentifiableObject;
import com.kingdee.bos.workflow.enactment.cache.IWfCacheManager;
import com.kingdee.bos.workflow.exception.CannotDeleteException;
import com.kingdee.bos.workflow.metas.BizProcMetaCollection;
import com.kingdee.bos.workflow.metas.BizProcMetaInfo;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.ProcDefCollection;
import com.kingdee.bos.workflow.metas.ProcDefFactory;
import com.kingdee.bos.workflow.metas.ProcDefInfo;
import com.kingdee.bos.workflow.metas.ProcInstBizObjCollection;
import com.kingdee.bos.workflow.metas.ProcInstBizObjInfo;
import com.kingdee.bos.workflow.metas.ProcInstCollection;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.metas.ProcInstFactory;
import com.kingdee.bos.workflow.metas.ProcInstHstCollection;
import com.kingdee.bos.workflow.metas.ProcInstHstInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.metas.TransBoxMetaCollection;
import com.kingdee.bos.workflow.metas.TransBoxMetaInfo;
import com.kingdee.bos.workflow.metas.WfEnable;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.store.AbstractBaseStorer;
import com.kingdee.bos.workflow.store.MutexStorer;
import com.kingdee.bos.workflow.store.StoreManager;
import com.kingdee.bos.workflow.store.util.ApproveRuleUtils;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.ConvertUtils;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ProcessStorer
extends AbstractBaseStorer
implements IIdentifiableObject {
    public static final String DATAFIELD_ORGID = "$BIZ_ORG_ID$";
    private static final Logger log = Logger.getLogger(ProcessStorer.class);
    private long deleteTime = 0L;
    private final String PROCDEF_FIELDS = " procdefID,innerVersion,name,procCode,description,createdTime,author,responsibleID,responsibleName,validFrom,validTo,verDesc,startActID,md5Hash,packageName,enable,procdefType,iconName,bizPackage,clientStart,duration,workingTime,waitingTime ";

    public ProcessStorer(Context context) {
        super(context);
    }

    public ProcessDefInfo[] getProcDefInfoArrayAll() throws SQLException, DataAccessException {
        ProcInstCollection pic = this.getProcInstInfoCollection("");
        return (ProcessDefInfo[])pic.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcInstCollection getProcInstInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            ProcInstCollection pic;
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCESSINSTBOT, cn);
            IObjectCollection oc = oql == null || oql.length() == 0 ? ormdao.getCollection() : ormdao.getCollection(oql);
            ProcInstCollection procInstCollection = pic = (ProcInstCollection)oc;
            return procInstCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private ProcessInstInfo[] getProcessInstInfoArray(String oql) throws SQLException, DataAccessException {
        ProcInstCollection pic = this.getProcInstInfoCollection(oql);
        if (pic != null && pic.size() > 0) {
            return StoreUtils.toProcessInstInfoArray((Object[])pic.toArray());
        }
        return new ProcessInstInfo[0];
    }

    private ProcessInstInfo getProcessInstInfo(String oql) throws SQLException, DataAccessException {
        ProcInstCollection pic = this.getProcInstInfoCollection(oql);
        if (pic != null && pic.size() > 0) {
            return new ProcessInstInfo(pic.get(0));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcDefCollection getProcDefInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            ProcDefCollection pc;
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCESSDEFBOT, cn);
            IObjectCollection oc = oql == null || oql.length() == 0 ? ormdao.getCollection() : ormdao.getCollection(oql);
            ProcDefCollection procDefCollection = pc = (ProcDefCollection)oc;
            return procDefCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private ProcessDefInfo[] getProcDefInfoArray(String oql) throws SQLException, DataAccessException {
        ProcDefCollection pdc = this.getProcDefInfoCollection(oql);
        if (pdc != null && pdc.size() > 0) {
            return this.toProcDefInfoArray(pdc.toArray());
        }
        return new ProcessDefInfo[0];
    }

    private ProcessDefInfo[] toProcDefInfoArray(Object[] oa) {
        if (oa == null || oa.length == 0) {
            return new ProcessDefInfo[0];
        }
        int count = oa.length;
        ProcessDefInfo[] pdia = new ProcessDefInfo[count];
        for (int i = 0; i <= count - 1; ++i) {
            pdia[i] = new ProcessDefInfo((ProcDefInfo)oa[i]);
        }
        return pdia;
    }

    public ProcessDefInfo getProcDefInfo(String oql) throws SQLException, DataAccessException {
        ProcDefInfo procDef = this.getProcDef(oql);
        if (procDef != null) {
            return new ProcessDefInfo(procDef);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BizProcMetaCollection getBizProcInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.BIZPROCBOT, cn);
            IObjectCollection oc = ormdao.getCollection(oql);
            BizProcMetaCollection bpc = (BizProcMetaCollection)oc;
            if (bpc != null && bpc.size() > 0) {
                BizProcMetaCollection bizProcMetaCollection = bpc;
                return bizProcMetaCollection;
            }
            BizProcMetaCollection bizProcMetaCollection = null;
            return bizProcMetaCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private BizProcInfo getBizProcInfo(String oql) throws SQLException, DataAccessException {
        BizProcMetaCollection bpc = this.getBizProcInfoCollection(oql);
        if (bpc != null && bpc.size() > 0) {
            return new BizProcInfo(bpc.get(0));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransBoxMetaCollection getTransBoxInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            TransBoxMetaCollection tbic;
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.TRANSBOXBOT, cn);
            IObjectCollection oc = oql == null || oql.length() == 0 ? ormdao.getCollection() : ormdao.getCollection(oql);
            TransBoxMetaCollection transBoxMetaCollection = tbic = (TransBoxMetaCollection)oc;
            return transBoxMetaCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private TransBoxMetaInfo getTransBoxInfo(String oql) throws SQLException, DataAccessException {
        TransBoxMetaCollection tbic = this.getTransBoxInfoCollection(oql);
        if (tbic != null && tbic.size() > 0) {
            return tbic.get(0);
        }
        return null;
    }

    public ProcInstBizObjInfo getProcInstBizObjInfoByBoId(String boId) {
        ProcInstBizObjCollection procBizobjInfos = null;
        try {
            long time = System.currentTimeMillis();
            procBizobjInfos = this.getProcInstBizObjInfoCollection(" where bizObjID='" + boId + "'");
            if (log.isDebugEnabled()) {
                log.debug((Object)("procStorer getProcInstBizObjInfoByBoId cost: " + (System.currentTimeMillis() - time)));
            }
        }
        catch (DataAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (procBizobjInfos != null && procBizobjInfos.size() > 0) {
            return procBizobjInfos.get(0);
        }
        return null;
    }

    public ProcInstBizObjCollection getProcInstBizObjInfoByProcInstId(String procInstId) throws WfException {
        ProcInstBizObjCollection procBizobjInfos = null;
        try {
            long time = System.currentTimeMillis();
            procBizobjInfos = this.getProcInstBizObjInfoCollection(" where procInstID='" + procInstId + "'");
            if (log.isDebugEnabled()) {
                log.debug((Object)("procStorer getProcInstBizObjInfoByProcInstId cost: " + (System.currentTimeMillis() - time)));
            }
        }
        catch (DataAccessException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new WfException(e.getMessage(), (Throwable)e);
        }
        return procBizobjInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcInstBizObjCollection getProcInstBizObjInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            ProcInstBizObjCollection piboic;
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCINSTBIZOBJBOT, cn);
            IObjectCollection oc = oql == null || oql.length() == 0 ? ormdao.getCollection() : ormdao.getCollection(oql);
            ProcInstBizObjCollection procInstBizObjCollection = piboic = (ProcInstBizObjCollection)oc;
            return procInstBizObjCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcInstHstCollection getProcInstHstInfoCollection(String oql) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            ProcInstHstCollection pic;
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCESSINSTHSTBOT, cn);
            IObjectCollection oc = oql == null || oql.length() == 0 ? ormdao.getCollection() : ormdao.getCollection(oql);
            ProcInstHstCollection procInstHstCollection = pic = (ProcInstHstCollection)oc;
            return procInstHstCollection;
        }
        finally {
            this.cleanup(cn);
        }
    }

    private ProcessInstInfo[] getProcessInstInfoArray_Hst(String oql) throws SQLException, DataAccessException {
        ProcInstHstCollection pic = this.getProcInstHstInfoCollection(oql);
        if (pic != null && pic.size() > 0) {
            return StoreUtils.toProcessInstInfoArray((Object[])pic.toArray());
        }
        return new ProcessInstInfo[0];
    }

    private ProcessInstInfo getProcessInstInfo_Hst(String oql) throws SQLException, DataAccessException {
        ProcInstHstCollection pic = this.getProcInstHstInfoCollection(oql);
        if (pic != null && pic.size() > 0) {
            ProcInstHstInfo pii_hst = pic.get(0);
            ProcInstInfo pii = new ProcInstInfo(pii_hst.getValues());
            ProcessInstInfo pii_ex = new ProcessInstInfo(pii);
            return pii_ex;
        }
        return null;
    }

    private ProcessInstInfo[] getProcessInstanceByHoldedObjectId(String bizObjId, DataTypeEnum dataType) throws SQLException, DataAccessException {
        int vctrsz;
        if (bizObjId == null || bizObjId.length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"bizObjId is null");
            }
            return new ProcessInstInfo[0];
        }
        Vector<ProcessInstInfo> vctr = new Vector<ProcessInstInfo>();
        List<String> procIds = this.getProcinstIdList(bizObjId);
        if (procIds != null && procIds.size() > 0) {
            for (int i = 0; i <= procIds.size() - 1; ++i) {
                String cndtn1 = "(procinstID = '" + procIds.get(i) + "')";
                String oql1 = "where " + cndtn1;
                ProcessInstInfo[] processInstInfoArray = null;
                processInstInfoArray = DataTypeEnum.RUNTIME.equals((Object)dataType) ? this.getProcessInstInfoArray(oql1) : this.getProcessInstInfoArray_Hst(oql1);
                if (processInstInfoArray == null || processInstInfoArray.length <= 0) continue;
                for (int j = 0; j <= processInstInfoArray.length - 1; ++j) {
                    vctr.add(processInstInfoArray[j]);
                }
            }
        } else {
            String tProInstId = this.getProcInstId(bizObjId);
            if (!StringUtils.isEmpty((String)tProInstId)) {
                String oql1 = "where (procinstID = '" + tProInstId + "') and state = 'open.running' ";
                ProcessInstInfo[] processInstInfoArray = null;
                if (DataTypeEnum.RUNTIME.equals((Object)dataType)) {
                    processInstInfoArray = this.getProcessInstInfoArray(oql1);
                }
                if (processInstInfoArray != null && processInstInfoArray.length > 0) {
                    for (int j = 0; j <= processInstInfoArray.length - 1; ++j) {
                        vctr.add(processInstInfoArray[j]);
                    }
                }
            }
        }
        if ((vctrsz = vctr.size()) > 0) {
            return StoreUtils.toProcessInstInfoArray((Object[])vctr.toArray());
        }
        return new ProcessInstInfo[0];
    }

    private List<String> getProcinstIdList(String bizObjId) throws SQLException, DataAccessException {
        List<String> procinstIds = this.getProcInstIdbyPIBIZOBJ(bizObjId);
        return procinstIds;
    }

    private List<String> getProcInstIdbyPIREF(String bizObjId) throws SQLException {
        String sql = null;
        sql = bizObjId.indexOf(",") > 0 ? "select FPROCINSTID  FROM t_wfr_procinstref where frefid in(" + bizObjId + ")" : "select FPROCINSTID  FROM t_wfr_procinstref where frefid ='" + bizObjId + "'";
        ArrayList<String> procinstIds = new ArrayList<String>();
        PreparedStatement psmt = this.getConnection().prepareStatement(sql);
        ResultSet rs = psmt.executeQuery();
        while (rs.next()) {
            procinstIds.add(rs.getString(1));
        }
        return procinstIds;
    }

    private List<String> getProcInstIdbyPIBIZOBJ(String bizObjId) throws SQLException, DataAccessException {
        String cndtn = null;
        if (bizObjId.indexOf(",") > 0) {
            String[] ids = StringUtils.split((String)bizObjId, (String)",");
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                cndtn = i == 0 ? "(bizObjID = '" + ids[i] + "' " : cndtn + "or bizObjID = '" + ids[i] + "' ";
            }
            cndtn = cndtn + ")";
        } else {
            cndtn = "(bizObjID = '" + bizObjId + "')";
        }
        String oql = "where " + cndtn;
        ArrayList<String> list = new ArrayList<String>();
        ProcInstBizObjCollection piboc = this.getProcInstBizObjInfoCollection(oql);
        if (piboc != null) {
            for (int i = 0; i < piboc.size(); ++i) {
                list.add(piboc.get(i).getProcInstID().toString());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProcInstId(String tBillId) throws SQLException {
        String tProcInstId = "";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            String sql = "select fprocinstid from t_wfr_assign  where fbizobjid = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, tBillId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                tProcInstId = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            StoreManager.cleanup(rs, stmt, conn);
            throw throwable;
        }
        StoreManager.cleanup(rs, stmt, conn);
        return tProcInstId;
    }

    private ProcessInstInfo[] getAllProcessInstances(int maxReturn, String procInstState, DataTypeEnum dataType) throws SQLException, DataAccessException {
        String cndtn = "(state like '" + procInstState + "%')";
        String oql = "";
        oql = procInstState != null && procInstState.length() != 0 ? "where " + cndtn + " ORDER BY createdTime" : "ORDER BY createdTime";
        ProcessInstInfo[] piia = null;
        piia = DataTypeEnum.RUNTIME.equals((Object)dataType) ? this.getProcessInstInfoArray(oql) : this.getProcessInstInfoArray_Hst(oql);
        if (maxReturn > 0) {
            int count = piia.length;
            if (maxReturn >= count) {
                return piia;
            }
            ProcessInstInfo[] piia1 = new ProcessInstInfo[maxReturn];
            System.arraycopy(piia, 0, piia1, 0, maxReturn);
            return piia1;
        }
        return piia;
    }

    public static ProcInstInfo buildNewProcInstInfo(Context context, WfProcessMgr procMgr, WfActivity parentActInst, Person person) throws WfException {
        Locale lcl;
        ProcInstInfo procInstInfo = new ProcInstInfo();
        Locale[] lcla = ApplicationUtil.getContextLocales((Context)context);
        Timestamp ct = new Timestamp(System.currentTimeMillis());
        ProcDefInfo pdefi = procMgr.getData().getMeta();
        StringBuffer code = new StringBuffer();
        if (StringUtils.isEmpty((String)procMgr.getProcessDef().getCode())) {
            if (procMgr.getProcessDef().getNameResource() == null) {
                log.error((Object)("process name is null. process id" + procMgr.getProcessDef().getID()));
            } else {
                code.append(procMgr.getProcessDef().getNameResource().getPossibleValue(null));
            }
        } else {
            code.append(procMgr.getProcessDef().getCode());
        }
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        int day = calendar.get(7);
        int minutes = calendar.get(12);
        code.append('_');
        code.append(month);
        code.append(day);
        code.append(minutes);
        Random random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            random = new Random();
        }
        code.append((random.nextInt(100) + 1) * (random.nextInt(100) + 1));
        procInstInfo.setCode(code.toString());
        for (int i = 0; i < lcla.length; ++i) {
            lcl = lcla[i];
            procInstInfo.setProcdefName(pdefi.getName(lcl), lcl);
        }
        procInstInfo.setProcInstID(BOSUuid.create((BOSObjectType)WfBOSObjectTypeUtil.PROCESSINSTBOT));
        procInstInfo.setState(WfState.NOT_STARTED);
        procInstInfo.setProcdefID(pdefi.getProcdefID());
        procInstInfo.setProcdefVer(pdefi.getInnerVersion());
        procInstInfo.setProcdefHash(pdefi.getMd5Hash());
        procInstInfo.setLastStateTime(ct);
        procInstInfo.setCreatedTime(ct);
        procInstInfo.setProcdefXpdl(null);
        if (parentActInst != null) {
            ActivityDef adef = parentActInst.getDefinition();
            ProcessDef papdef = parentActInst.container().getDefinition();
            for (int i = 0; i <= lcla.length - 1; ++i) {
                Locale lcl2 = lcla[i];
                String pdn = adef != null ? adef.getName(lcl2) : null;
                String ppdefName = papdef.getName(lcl2);
                procInstInfo.setPactdefName(pdn, lcl2);
                procInstInfo.setPprocdefName(ppdefName, lcl2);
            }
            procInstInfo.setParentActInstID(BOSUuid.read((String)parentActInst.getId()));
            String sactdefID = parentActInst.getDefinition().getID();
            BOSUuid actdefID = BOSUuid.read((String)sactdefID);
            procInstInfo.setParentActdefID(actdefID);
            String sppinstID = parentActInst.container().getId();
            BOSUuid ppinstID = BOSUuid.read((String)sppinstID);
            procInstInfo.setParentProcInstID(ppinstID);
            String sppdefID = parentActInst.container().getDefinition().getID();
            BOSUuid ppdefID = BOSUuid.read((String)sppdefID);
            procInstInfo.setParentProcdefID(ppdefID);
            try {
                ProcInstInfo parentProcInstInfo = ProcInstFactory.getLocalInstance((Context)context).getValue((IObjectPK)new ObjectUuidPK(ppinstID));
                procInstInfo.setControlUnitID(parentProcInstInfo.getControlUnitID());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (procMgr.getProcessDef().getProcessHeader().getLimit() != null) {
            ProcessDef pdef = procMgr.getProcessDef();
            LimitDef ldef = pdef.getProcessHeader().getLimit();
            int itu = ldef.getDurationUnit().getValue();
            procInstInfo.setTimeUnit(itu);
        }
        if (person != null) {
            procInstInfo.setInitiatorID(person.getUserId());
            for (int i = 0; i < lcla.length; ++i) {
                lcl = lcla[i];
                procInstInfo.setInitiatorName(person.getEmployeeName(lcl), lcl);
            }
        }
        procInstInfo.setProcdefType(pdefi.getProcdefType());
        procInstInfo.setLimit(0);
        String procDefType = procMgr.getProcessDef().getType().getName();
        procInstInfo.setProcdefType(procDefType);
        return procInstInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTransBox(TransBoxMetaInfo transBox) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.TRANSBOXBOT, cn);
            ormdao.addnew((IObjectValue)transBox);
        }
        finally {
            this.cleanup(cn);
        }
        this.notifyDataChangedByProcInstId(transBox.getProcInstID() != null ? transBox.getProcInstID().toString() : "", "createTransBox", new Class[]{TransBoxMetaInfo.class}, new Object[]{transBox});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTransBox(String procInstId, String toActDefId) throws SQLException, DataAccessException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "deleteTransBox", null);
        }
        try {
            Connection cn = null;
            try {
                cn = this.getConnection();
                IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.TRANSBOXBOT, cn);
                ObjectMultiPK ompk = new ObjectMultiPK();
                ompk.setKeyValue("procinstID", (Object)procInstId);
                ompk.setKeyValue("toactdefID", (Object)toActDefId);
                ormdao.delete((IObjectPK)ompk);
            }
            finally {
                this.cleanup(cn);
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
        this.notifyDataChangedByProcInstId(procInstId != null ? procInstId : "", "deleteTransBox", new Class[]{String.class, String.class}, new Object[]{procInstId, toActDefId});
    }

    public ProcessDefInfo[] getProcDefInfoArrayDistinct() throws SQLException, DataAccessException {
        ProcessDefInfo[] pdiary = this.getProcDefInfoArray("");
        Arrays.sort(pdiary, new ComparatorPdi0());
        ProcessDefInfo cpdi = null;
        ProcessDefInfo fpdi = null;
        Vector<ProcessDefInfo> vctr = new Vector<ProcessDefInfo>();
        for (int i = 0; i <= pdiary.length - 1; ++i) {
            ProcessDefInfo pdi = pdiary[i];
            if (pdi == null) continue;
            fpdi = pdi;
            if (cpdi == null) {
                cpdi = fpdi;
                continue;
            }
            if (cpdi.getProcDefId().equals(fpdi.getProcDefId()) || !cpdi.getProcDefId().equals(fpdi.getProcDefId())) continue;
            vctr.add(cpdi);
            cpdi = fpdi;
        }
        return this.toProcDefInfoArray(vctr.toArray());
    }

    public ProcessDefInfo getProcessDefInfoLastVersion(String procDefId) throws SQLException, DataAccessException {
        String hash = this.getProcessDefInfoLastVersionHash(procDefId);
        return this.getProcessDefInfoByHash(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProcessDefInfoLastVersionHash(String procDefId) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            String string;
            conn = null;
            stmt = null;
            rs = null;
            try {
                String procDefHash;
                conn = this.getConnection();
                String sql = "SELECT TOP 1 FMD5HASH FROM T_WFR_PROCDEF WHERE (FPROCDEFID = ?)ORDER BY FINNERVERSION DESC";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, procDefId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                string = procDefHash = rs.getString(1);
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(rs, stmt, conn);
                throw throwable;
            }
            StoreManager.cleanup(rs, stmt, conn);
            return string;
        }
        String string = null;
        StoreManager.cleanup(rs, stmt, conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProcessDefInfoLastVersionNumber(String procDefId) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            int n;
            conn = null;
            stmt = null;
            rs = null;
            try {
                int procDefVer;
                conn = this.getConnection();
                String sql = "SELECT MAX(FINNERVERSION) FROM T_WFR_PROCDEF WHERE FPROCDEFID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, procDefId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                n = procDefVer = rs.getInt(1);
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(rs, stmt, conn);
                throw throwable;
            }
            StoreManager.cleanup(rs, stmt, conn);
            return n;
        }
        int n = -1;
        StoreManager.cleanup(rs, stmt, conn);
        return n;
    }

    public ProcessDefInfo getProcessDefInfo(String procDefId, int innerVersion) throws SQLException, DataAccessException {
        String cndtn0 = "(procdefID = '" + procDefId + "')";
        String cndtn1 = "(innerVersion = " + innerVersion + ")";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select  procdefID,innerVersion,name,procCode,description,createdTime,author,responsibleID,responsibleName,validFrom,validTo,verDesc,startActID,md5Hash,packageName,enable,procdefType,iconName,bizPackage,clientStart,duration,workingTime,waitingTime  where " + cndtn + " order by innerVersion DESC ";
        return this.getProcDefInfo(oql);
    }

    public ProcessDefInfo getProcessDefInfoByHash(String procDefHash) throws SQLException, DataAccessException {
        if (procDefHash != null) {
            procDefHash = procDefHash.trim();
        }
        String cndtn = "(md5Hash = '" + procDefHash + "')";
        String oql = "select  procdefID,innerVersion,name,procCode,description,createdTime,author,responsibleID,responsibleName,validFrom,validTo,verDesc,startActID,md5Hash,packageName,enable,procdefType,iconName,bizPackage,clientStart,duration,workingTime,waitingTime  WHERE " + cndtn + " ORDER BY innerVersion DESC";
        return this.getProcDefInfo(oql);
    }

    public ProcessInstInfo[] getAllProcessInstances() throws SQLException, DataAccessException {
        ProcessInstInfo[] processInstInfoArray = this.getProcessInstInfoArray("");
        return processInstInfoArray;
    }

    public ProcessInstInfo[] getAllProcessInstances(int maxReturn, String procInstState) throws SQLException, DataAccessException {
        ProcessInstInfo[] result = this.getAllProcessInstances(maxReturn, procInstState, DataTypeEnum.RUNTIME);
        return result;
    }

    public ProcessInstInfo[] getProcessInstancesByProcDefId(String procDefId) throws SQLException, DataAccessException {
        String cndtn = "(procdefID='" + procDefId + "')";
        String oql = "where " + cndtn + " ORDER BY createdTime";
        ProcessInstInfo[] result = this.getProcessInstInfoArray(oql);
        return result;
    }

    public ProcessInstInfo[] getProcessInstancesByParentProcInstId(String topParentProcInstId) throws DataAccessException, SQLException {
        String cndtn = "(parentProcInstID='" + topParentProcInstId + "')";
        String oql = "where " + cndtn + " ORDER BY createdTime";
        ProcessInstInfo[] result = this.getProcessInstInfoArray(oql);
        return result;
    }

    public ProcessInstInfo[] getProcessInstancesByProcDefId(String procDefId, String[] selectors) throws SQLException, DataAccessException {
        StringBuffer sql = new StringBuffer();
        if (selectors != null && selectors.length > 0 && selectors[0] != null) {
            sql.append(" SELECT ");
            sql.append(StringUtils.arrayToString((Object[])selectors, (String)","));
        }
        String cndtn = "(procdefID='" + procDefId + "')";
        sql.append("where " + cndtn + " ORDER BY createdTime");
        ProcessInstInfo[] result = this.getProcessInstInfoArray(sql.toString());
        return result;
    }

    public ProcessInstInfo getProcessInstance(String procInstId) throws SQLException, DataAccessException {
        String oql = "WHERE procinstID = '" + procInstId + "' ";
        return this.getProcessInstInfo(oql);
    }

    public ProcessInstInfo getProcessInstance(String procInstId, boolean queryHistory) throws SQLException, DataAccessException {
        ProcessInstInfo result = this.getProcessInstance(procInstId);
        if (queryHistory && result == null) {
            String oql = "WHERE procinstID = '" + procInstId + "' ";
            result = this.getProcessInstInfo_Hst(oql);
        }
        return result;
    }

    public ProcessInstInfo[] getProcessInstance(String[] procInstIds, boolean queryHistory) throws SQLException, DataAccessException {
        if (procInstIds == null || procInstIds.length == 0) {
            return new ProcessInstInfo[0];
        }
        ProcessInstInfo[] processInsts = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" WHERE (");
        sql.append("(procinstID = '" + procInstIds[0] + "')");
        for (int i = 1; i < procInstIds.length; ++i) {
            sql.append(" OR (procinstID = '" + procInstIds[i] + "')");
        }
        sql.append(')');
        String oql = sql.toString();
        ProcInstCollection result = this.getProcInstInfoCollection(oql);
        ProcInstHstCollection hstCollection = null;
        if (queryHistory && result.size() == 0) {
            hstCollection = this.getProcInstHstInfoCollection(oql);
            if (hstCollection != null && hstCollection.size() >= 0) {
                processInsts = new ProcessInstInfo[hstCollection.size()];
                for (int i = 0; i < hstCollection.size(); ++i) {
                    ProcInstHstInfo hstInfo = hstCollection.get(i);
                    ProcInstInfo pii = new ProcInstInfo(hstInfo.getValues());
                    processInsts[i] = new ProcessInstInfo(pii);
                }
            } else {
                processInsts = new ProcessInstInfo[]{};
            }
        } else {
            processInsts = new ProcessInstInfo[result.size()];
            for (int i = 0; i < result.size(); ++i) {
                ProcInstInfo info = result.get(i);
                processInsts[i] = new ProcessInstInfo(info);
            }
        }
        return processInsts;
    }

    public TransBoxInfo getTransBox(String procInstId, String actDefId) throws SQLException, DataAccessException {
        String cndtn0 = "(procinstID = '" + procInstId + "')";
        String cndtn1 = "(toactdefID = '" + actDefId + "')";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "WHERE " + cndtn;
        TransBoxMetaInfo transBoxMetaInfo = this.getTransBoxInfo(oql);
        if (transBoxMetaInfo == null) {
            return null;
        }
        return new TransBoxInfo(transBoxMetaInfo);
    }

    public BizProcInfo getBizProcRelation(String performerId, String bizFunc, String bizPackage, String bizOperation) throws SQLException, DataAccessException {
        String cndtn0 = "(performerID = '" + performerId + "')";
        String cndtn1 = "(bizfunc = '" + bizFunc + "')";
        String cndtn2 = "(bizpackage = '" + bizPackage + "')";
        String cndtn3 = "(bizOperation = '" + bizOperation + "')";
        String cndtn = cndtn0;
        if (bizFunc != null && bizFunc.length() != 0) {
            cndtn = cndtn + " AND " + cndtn1;
        }
        if (bizPackage != null && bizPackage.length() != 0) {
            cndtn = cndtn + " AND " + cndtn2;
        }
        if (bizOperation != null && bizOperation.length() != 0) {
            cndtn = cndtn + " AND " + cndtn3;
        }
        String oql = "WHERE " + cndtn;
        return this.getBizProcInfo(oql);
    }

    public void storeDef(ProcessDef processDef, String oldHashValue) throws WfException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "UPDATE T_WFR_PROCDEF SET FKPDL = ? , FMD5HASH  = ? WHERE FMD5HASH = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, processDef.toXml());
            stmt.setString(2, processDef.getHashValue());
            stmt.setString(3, oldHashValue);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                StoreManager.cleanup(stmt, conn);
                throw throwable;
            }
        }
        StoreManager.cleanup(stmt, conn);
        WfEngine.getEngine(this.innerContext).getCacheManager().removeInvocationResult(EffectRegion.create(new ProcDefInfo().getBOSType()));
    }

    public int getMinimalVersion(String procDefId) throws WfException {
        String sql = "select min(finnerversion) from t_wfr_procdef where fprocdefid='" + procDefId + "'";
        Connection cn = null;
        Statement smt = null;
        int version = 0;
        try {
            Object o;
            cn = WfDbUtil.getConnection((Context)this.getContext());
            smt = cn.createStatement();
            ResultSet rs = this.executeQuery(smt, sql);
            if (rs.next() && (o = rs.getObject(1)) != null) {
                version = Integer.parseInt(o.toString());
            }
        }
        catch (SQLException e) {
            try {
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                WfDbUtil.cleanup(smt, (Connection)cn);
                throw throwable;
            }
        }
        WfDbUtil.cleanup((Statement)smt, (Connection)cn);
        if (version > 0) {
            version = 0;
        }
        return version;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updateDynamicFlowDef(String userId, String procInstId, String oldHashValue, ProcessDef newDef) throws WfException {
        boolean isDuplicated = newDef.isDuplicated();
        newDef.getProcessHeader().setAuthor(userId);
        newDef.getProcessHeader().setValidFrom(new Date(System.currentTimeMillis() - 60000L));
        if (!isDuplicated) {
            newDef.setDuplicated(true);
        }
        String kpdl = newDef.toXml();
        md5 md = new md5(kpdl);
        md.processString();
        String newHashValue = md.getStringDigest();
        Connection cn = null;
        PreparedStatement smt = null;
        IWfCacheManager cache = WfEngine.getEngine(this.getContext()).getCacheManager();
        try {
            String sql;
            cn = WfDbUtil.getConnection((Context)this.getContext());
            if (!isDuplicated) {
                int version = this.getMinimalVersion(newDef.getID()) - 1;
                this.storeDefOnly(newDef, version, kpdl, newHashValue, true);
                sql = "update t_wfr_procinst set fprocdefver=?, fprocdefhash=? where fprocinstid=?";
                smt = cn.prepareStatement(sql);
                smt.setInt(1, version);
                smt.setString(2, newHashValue);
                smt.setString(3, procInstId);
                smt.executeUpdate();
                smt.close();
            } else {
                sql = "update t_wfr_procdef set fkpdl=?, fmd5hash=? where fmd5hash=?";
                smt = cn.prepareStatement(sql);
                smt.setString(1, kpdl);
                smt.setString(2, newHashValue);
                smt.setString(3, oldHashValue);
                smt.executeUpdate();
                smt.close();
                cache.removeProcessDef(oldHashValue);
                ProcessInstInfo info = cache.getProcessInst(procInstId).getData();
                int version = info.getProcDefInnerVersion();
                cache.removeProcessMgr(info.getProcDefId(), version);
                sql = "update t_wfr_procinst set fprocdefhash=? where fprocinstid=?";
                smt = cn.prepareStatement(sql);
                smt.setString(1, newHashValue);
                smt.setString(2, procInstId);
                smt.executeUpdate();
                smt.close();
            }
            cache.removeProcRefInsts(procInstId);
            sql = "update t_wfr_actinst set fprocdefhash=? where fprocinstid=?";
            smt = cn.prepareStatement(sql);
            smt.setString(1, newHashValue);
            smt.setString(2, procInstId);
            smt.executeUpdate();
            smt.close();
            sql = "select factinstid from t_wfr_actinst where fprocinstid=?";
            smt = cn.prepareStatement(sql);
            smt.setString(1, procInstId);
            ResultSet rs = smt.executeQuery();
            while (rs.next()) {
                String actInstId = rs.getString(1);
                cache.removeActivityInst(actInstId);
            }
            smt.close();
            sql = "update t_wfr_assign set fprocdefhash=? where fprocinstid=?";
            smt = cn.prepareStatement(sql);
            smt.setString(1, newHashValue);
            smt.setString(2, procInstId);
            smt.executeUpdate();
            smt.close();
            sql = "select fassignid from t_wfr_assign where fprocinstid=?";
            smt = cn.prepareStatement(sql);
            smt.setString(1, procInstId);
            rs = smt.executeQuery();
            while (rs.next()) {
                String assignId = rs.getString(1);
                cache.removeAssignment(assignId);
            }
            smt.close();
            sql = "update t_wfr_assigndetail set fprocdefhash=? where fprocinstid=?";
            smt = cn.prepareStatement(sql);
            smt.setString(1, newHashValue);
            smt.setString(2, procInstId);
            smt.executeUpdate();
            smt.close();
            cache.removeProcessInst(procInstId);
        }
        catch (SQLException e) {
            try {
                throw new WfException((Throwable)e);
                catch (DataAccessException e2) {
                    throw new WfException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                WfDbUtil.cleanup(smt, (Connection)cn);
                throw throwable;
            }
        }
        WfDbUtil.cleanup((Statement)smt, (Connection)cn);
        return newHashValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDefOnly(ProcessDef prcsdef, int innerVersion, String kpdl, String hash, boolean enable) throws SQLException, DataAccessException, WfException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            Locale[] lcla = this.getLocales();
            ProcDefInfo pdefi = ProcDefInfo.convertFromWfModel((ProcessDef)prcsdef, (Locale[])lcla);
            pdefi.setIconName(prcsdef.getProcessHeader().getIcon());
            pdefi.setInnerVersion(innerVersion);
            pdefi.setKpdl(kpdl);
            pdefi.setMd5Hash(hash);
            pdefi.setBillBostype(prcsdef.getBillBostype());
            pdefi.setEnable(WfEnable.getEnum((int)ConvertUtils.toInt((boolean)enable)));
            boolean enableClientStart = prcsdef.getProcessHeader().isEnableClientStart();
            pdefi.setClientStart(ConvertUtils.toInt((boolean)enableClientStart));
            this.procAdminIds(this.getContext(), pdefi);
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCESSDEFBOT, cn);
            ormdao.addnew((IObjectValue)pdefi);
            WfRoleUtils.updateProcessRoledata((Context)this.getContext(), (ProcessDef)prcsdef, (boolean)true);
            ApproveRuleUtils.updateRuleRelation(this.innerContext, prcsdef);
            WfEngine.getEngine(this.innerContext).getCacheManager().removeInvocationResult(EffectRegion.create(pdefi.getBOSType()));
        }
        finally {
            this.cleanup(cn);
        }
    }

    private void procAdminIds(Context ctx, ProcDefInfo pdefi) {
        if (pdefi.getAdminIds() != null && pdefi.getAdminIds().trim().length() > 0) {
            return;
        }
        if (pdefi.getInnerVersion() == 0) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("procdefID", (Object)pdefi.getProcdefID(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("innerVersion", (Object)(pdefi.getInnerVersion() - 1), CompareType.EQUALS));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        try {
            ProcDefCollection cols = ProcDefFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
            if (cols.size() > 0) {
                String ids = cols.get(0).getAdminIds();
                String names = cols.get(0).getAdminNames();
                if (ids != null) {
                    pdefi.setAdminIds(ids);
                    pdefi.setAdminNames(names);
                }
            }
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void storeDef(ProcessDef prcsdef, int innerVersion, String kpdl, String hash, boolean enable) throws SQLException, DataAccessException, WfException {
        this.storeDefOnly(prcsdef, innerVersion, kpdl, hash, enable);
        this.notifyDataChangedByProcDefId(prcsdef.getID(), "storeDef", new Class[]{ProcessDef.class, Integer.TYPE, String.class, String.class, Boolean.TYPE}, new Object[]{prcsdef, new Integer(innerVersion), kpdl, hash, enable});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransBox(TransBoxInfo transBox) throws SQLException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "setTransBox", null);
        }
        try {
            PreparedStatement stmt;
            Connection conn;
            block7: {
                conn = null;
                stmt = null;
                try {
                    conn = this.getConnection();
                    String sql = "UPDATE T_WFR_TRANSBOX SET FTRANSCOUNT = ?, FTRANSRECORD = ? WHERE (FPROCTINSTID = ?) AND (FTOACTDEFID = ?)";
                    stmt = conn.prepareStatement(sql);
                    stmt.setInt(1, transBox.getTransCount());
                    stmt.setString(2, StringUtils.arrayToString((Object[])transBox.getTransRecord(), (String)","));
                    stmt.setString(3, transBox.getProcInstId());
                    stmt.setString(4, transBox.getToActDefId());
                    int updateCount = stmt.executeUpdate();
                    if (updateCount == 1) break block7;
                    throw new SQLException("not such transbox, transBox '" + transBox.toString() + "'");
                }
                catch (Throwable throwable) {
                    StoreManager.cleanup(stmt, conn);
                    throw throwable;
                }
            }
            StoreManager.cleanup(stmt, conn);
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
        this.notifyDataChangedByProcInstId(transBox.getProcInstId() != null ? transBox.getProcInstId().toString() : "", "setTransBox", new Class[]{TransBoxInfo.class}, new Object[]{transBox});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBizProcRelation(BizProcInfo bizProcInfo) throws SQLException, DataAccessException, WfException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            BizProcMetaInfo bpmi = bizProcInfo.getMeta();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.BIZPROCBOT, cn);
            ormdao.addnew((IObjectValue)bpmi);
            WfEngine.getEngine(this.innerContext).getCacheManager().removeInvocationResult(EffectRegion.create(bpmi.getBOSType()));
        }
        finally {
            this.cleanup(cn);
        }
        this.notifyDataChangedByProcDefId(bizProcInfo.getProcDefId(), "createBizProcRelation", new Class[]{BizProcInfo.class}, new Object[]{bizProcInfo});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBizProcRelation(String procDefId) throws SQLException, WfException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "DELETE T_WFR_BIZPROC WHERE (FPROCDEFID = ?)";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, procDefId);
            stmt.execute();
            WfEngine.getEngine(this.innerContext).getCacheManager().removeInvocationResult(EffectRegion.create(new BizProcMetaInfo().getBOSType()));
        }
        catch (Throwable throwable) {
            StoreManager.cleanup(stmt, conn);
            throw throwable;
        }
        StoreManager.cleanup(stmt, conn);
        this.notifyDataChangedByProcDefId(procDefId, "clearBizProcRelation", new Class[]{String.class}, new Object[]{procDefId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getBizProcRelationVector(String bizFunc, String bizPackage, String bizOperation) throws SQLException {
        Vector<BizProcInfo> vector;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Vector<BizProcInfo> result = new Vector<BizProcInfo>();
        try {
            conn = this.getConnection();
            String sql = "SELECT FPERFORMERID, FBIZFUNC, FBIZPACKAGE, FBIZOPERATION, FPROCDEFID, FACTDEFID, FPERFORMERTYPE, FPERFORMERCODE, FIHERITPARENT,FExceptPerformerID , FExceptPerformerType FROM T_WFR_BIZPROC ";
            boolean flag = false;
            if (bizFunc != null && bizFunc.length() != 0) {
                sql = sql + "WHERE (FBIZFUNC = ?)";
                flag = true;
            }
            if (bizPackage != null && bizPackage.length() != 0) {
                sql = flag ? sql + " AND (FBIZPACKAGE = ?)" : sql + " WHERE (FBIZPACKAGE = ?)";
            }
            if (bizOperation != null && bizOperation.length() != 0) {
                sql = flag ? sql + " AND (FBIZOPERATION = ?)" : sql + " WHERE (FBIZOPERATION = ?)";
            }
            stmt = conn.prepareStatement(sql);
            int paramIndex = 1;
            if (bizFunc != null && bizFunc.length() != 0) {
                stmt.setString(paramIndex++, bizFunc);
            }
            if (bizPackage != null && bizPackage.length() != 0) {
                stmt.setString(paramIndex++, bizPackage);
            }
            if (bizOperation != null && bizOperation.length() != 0) {
                stmt.setString(paramIndex++, bizOperation);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                BizProcMetaInfo bizProcMetaInfo = new BizProcMetaInfo();
                bizProcMetaInfo.setPerformerID(rs.getString(1));
                bizProcMetaInfo.setBizFunc(rs.getString(2));
                bizProcMetaInfo.setBizPackage(rs.getString(3));
                bizProcMetaInfo.setBizOperation(rs.getString(4));
                bizProcMetaInfo.setProcDefID(BOSUuid.read((String)rs.getString(5)));
                bizProcMetaInfo.setActDefID(BOSUuid.read((String)rs.getString(6)));
                bizProcMetaInfo.setPerformerType(rs.getInt(7));
                bizProcMetaInfo.setPerformerCode(rs.getString(8));
                bizProcMetaInfo.setIheritParent(rs.getInt(9));
                bizProcMetaInfo.setExceptPerformerID(rs.getString(10));
                bizProcMetaInfo.setExceptPerformerType(rs.getInt(11));
                BizProcInfo rtnObj = new BizProcInfo(bizProcMetaInfo);
                result.add(rtnObj);
            }
            vector = result;
        }
        catch (Throwable throwable) {
            StoreManager.cleanup(rs, stmt, conn);
            throw throwable;
        }
        StoreManager.cleanup(rs, stmt, conn);
        return vector;
    }

    public BizProcInfo[] getBizProcList(String performerId, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        if (bizFunc == null || bizFunc.length() == 0) {
            return null;
        }
        if (bizPackage == null || bizPackage.length() == 0) {
            return null;
        }
        if (bizOperation == null || bizOperation.length() == 0) {
            return null;
        }
        ArrayList<BizProcInfo> bizProcInfoList = new ArrayList<BizProcInfo>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT DISTINCT A.FPERFORMERID, A.FBIZFUNC, A.FBIZPACKAGE, ").append("A.FBIZOPERATION, A.FPROCDEFID, A.FACTDEFID, ").append("A.FPERFORMERTYPE, A.FPERFORMERCODE, A.FIHERITPARENT ,A.FExceptPerformerID,A.FExceptPerformerType,A.FPROCDEFPRIORITY,B.FCREATEDTIME ").append(",A.FBIZPROCID,A.FSTARTCONDITION,A.FSTARTROLEID,A.FApplierPropName,FStartRoleInclude,B.FINNERVERSION,A.FOrgStartRoleId,A.FOrgPropName,A.FOrgStartRoleInclude ").append(" ,A.FisFromRole,A.ForgPropIsFromRole ").append("FROM T_WFR_BIZPROC AS A ").append("JOIN T_WFR_PROCDEF AS B ON  A.FPROCDEFID = B.FPROCDEFID ").append("WHERE B.FENABLE = 1 ").append("AND (A.FPERFORMERID = ? or A.FPERFORMERTYPE = 7)").append("AND (A.FBIZFUNC = ?) ").append("AND (A.FBIZPACKAGE = ?) ").append("AND (A.FBIZOPERATION = ?) ").append("and  b.FINNERVERSION = ( select max(c.FINNERVERSION) from t_wfr_procdef c where c.FPROCDEFID = b.FPROCDEFID  )").append("order by A.FPERFORMERTYPE ASC, B.FCREATEDTIME DESC , A.FPROCDEFPRIORITY DESC ");
            Object[] params = new Object[]{performerId, bizFunc, bizPackage, bizOperation};
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])params);
            if (rs != null) {
                while (rs.next()) {
                    BizProcMetaInfo bizProcMetaInfo = new BizProcMetaInfo();
                    bizProcMetaInfo.setPerformerID(rs.getString(1));
                    bizProcMetaInfo.setBizFunc(rs.getString(2));
                    bizProcMetaInfo.setBizPackage(rs.getString(3));
                    bizProcMetaInfo.setBizOperation(rs.getString(4));
                    bizProcMetaInfo.setProcDefID(BOSUuid.read((String)rs.getString(5)));
                    bizProcMetaInfo.setActDefID(BOSUuid.read((String)rs.getString(6)));
                    bizProcMetaInfo.setPerformerType(rs.getInt(7));
                    bizProcMetaInfo.setPerformerCode(rs.getString(8));
                    bizProcMetaInfo.setIheritParent(rs.getInt(9));
                    bizProcMetaInfo.setExceptPerformerID(rs.getString(10));
                    bizProcMetaInfo.setExceptPerformerType(rs.getInt(11));
                    bizProcMetaInfo.setProcDefPriority(rs.getInt(12));
                    bizProcMetaInfo.setStartCondition(rs.getString("FSTARTCONDITION"));
                    bizProcMetaInfo.setApplierPropName(rs.getString("FApplierPropName"));
                    bizProcMetaInfo.setStartRoleInclude(rs.getString("FStartRoleInclude"));
                    bizProcMetaInfo.setStartRoleId(rs.getString("FSTARTROLEID"));
                    bizProcMetaInfo.setOrgPropName(rs.getString("FOrgPropName"));
                    bizProcMetaInfo.setOrgStartRoleInclude(rs.getString("FOrgStartRoleInclude"));
                    bizProcMetaInfo.setOrgStartRoleId(rs.getString("FOrgStartRoleId"));
                    bizProcMetaInfo.setIsFromRole(Integer.parseInt(rs.getString("FisFromRole")));
                    bizProcMetaInfo.setOrgPropIsFromRole(Integer.parseInt(rs.getString("ForgPropIsFromRole")));
                    bizProcMetaInfo.setBizProcID(BOSUuid.read((String)rs.getString("FBIZPROCID")));
                    BizProcInfo rtnObj = new BizProcInfo(bizProcMetaInfo);
                    rtnObj.setInnerVersion(rs.getInt("FINNERVERSION"));
                    bizProcInfoList.add(rtnObj);
                }
            }
        }
        catch (Exception e) {
            throw new WfException(e.getMessage(), (Throwable)e, true);
        }
        if (bizProcInfoList == null || bizProcInfoList.size() <= 0) {
            return null;
        }
        BizProcInfo[] returnBizProcInfoArray = new BizProcInfo[bizProcInfoList.size()];
        bizProcInfoList.toArray(returnBizProcInfoArray);
        return returnBizProcInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getBizProcRelationMap(String bizFunc, String bizPackage, String bizOperation) throws SQLException {
        StringBuffer sql;
        LinkedHashMap rtnMap;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block15: {
            block14: {
                block13: {
                    conn = null;
                    stmt = null;
                    rs = null;
                    rtnMap = new LinkedHashMap();
                    conn = this.getConnection();
                    sql = new StringBuffer(300);
                    sql.append("SELECT DISTINCT A.FPERFORMERID, A.FBIZFUNC, A.FBIZPACKAGE, ").append("A.FBIZOPERATION, A.FPROCDEFID, A.FACTDEFID, ").append("A.FPERFORMERTYPE, A.FPERFORMERCODE, A.FIHERITPARENT ,A.FExceptPerformerID,A.FExceptPerformerType,A.FPROCDEFPRIORITY,B.FCREATEDTIME ").append(",A.FBIZPROCID,A.FSTARTCONDITION,A.FSTARTROLEID,A.FApplierPropName,FStartRoleInclude,B.FINNERVERSION,A.FOrgStartRoleId,A.FOrgPropName,A.FOrgStartRoleInclude ").append(" ,A.FisFromRole,A.ForgPropIsFromRole,A.FMANPOWERORGPROP ").append("FROM T_WFR_BIZPROC AS A ").append("JOIN T_WFR_PROCDEF AS B ON  A.FPROCDEFID = B.FPROCDEFID").append(" WHERE B.FENABLE = 1 ");
                    if (bizFunc != null && bizFunc.length() != 0) {
                        sql.append("AND (A.FBIZFUNC = ?)");
                        break block13;
                    }
                    HashMap hashMap = new HashMap();
                    StoreManager.cleanup(rs, stmt, conn);
                    return hashMap;
                }
                if (bizPackage != null && bizPackage.length() != 0) {
                    sql.append(" AND (A.FBIZPACKAGE = ?)");
                    break block14;
                }
                HashMap hashMap = new HashMap();
                StoreManager.cleanup(rs, stmt, conn);
                return hashMap;
            }
            if (bizOperation != null && bizOperation.length() != 0) {
                sql.append(" AND (A.FBIZOPERATION = ?)");
                break block15;
            }
            HashMap hashMap = new HashMap();
            StoreManager.cleanup(rs, stmt, conn);
            return hashMap;
        }
        try {
            sql.append(" ORDER BY A.FPERFORMERTYPE ASC, B.FCREATEDTIME DESC , A.FPROCDEFPRIORITY DESC");
            stmt = conn.prepareStatement(sql.toString());
            int paramIndex = 1;
            if (bizFunc != null && bizFunc.length() != 0) {
                stmt.setString(paramIndex++, bizFunc);
            }
            if (bizPackage != null && bizPackage.length() != 0) {
                stmt.setString(paramIndex++, bizPackage);
            }
            if (bizOperation != null && bizOperation.length() != 0) {
                stmt.setString(paramIndex++, bizOperation);
            }
            HashSet<String> bizProcs = new HashSet<String>();
            rs = stmt.executeQuery();
            while (rs.next()) {
                String bizProcId = rs.getString("FBIZPROCID");
                if (bizProcs.contains(bizProcId)) continue;
                bizProcs.add(bizProcId);
                BizProcMetaInfo bizProcMetaInfo = new BizProcMetaInfo();
                bizProcMetaInfo.setPerformerID(rs.getString(1));
                bizProcMetaInfo.setBizFunc(rs.getString(2));
                bizProcMetaInfo.setBizPackage(rs.getString(3));
                bizProcMetaInfo.setBizOperation(rs.getString(4));
                bizProcMetaInfo.setProcDefID(BOSUuid.read((String)rs.getString(5)));
                bizProcMetaInfo.setActDefID(BOSUuid.read((String)rs.getString(6)));
                bizProcMetaInfo.setPerformerType(rs.getInt(7));
                bizProcMetaInfo.setPerformerCode(rs.getString(8));
                bizProcMetaInfo.setIheritParent(rs.getInt(9));
                bizProcMetaInfo.setExceptPerformerID(rs.getString(10));
                bizProcMetaInfo.setExceptPerformerType(rs.getInt(11));
                bizProcMetaInfo.setProcDefPriority(rs.getInt(12));
                bizProcMetaInfo.setStartCondition(rs.getString("FSTARTCONDITION"));
                bizProcMetaInfo.setApplierPropName(rs.getString("FApplierPropName"));
                bizProcMetaInfo.setStartRoleInclude(rs.getString("FStartRoleInclude"));
                bizProcMetaInfo.setStartRoleId(rs.getString("FSTARTROLEID"));
                bizProcMetaInfo.setOrgPropName(rs.getString("FOrgPropName"));
                bizProcMetaInfo.setOrgStartRoleInclude(rs.getString("FOrgStartRoleInclude"));
                bizProcMetaInfo.setOrgStartRoleId(rs.getString("FOrgStartRoleId"));
                bizProcMetaInfo.setIsFromRole(Integer.parseInt(rs.getString("FisFromRole")));
                bizProcMetaInfo.setOrgPropIsFromRole(Integer.parseInt(rs.getString("ForgPropIsFromRole")));
                bizProcMetaInfo.setManpowerOrgprop(rs.getString("FMANPOWERORGPROP"));
                bizProcMetaInfo.setBizProcID(BOSUuid.read((String)bizProcId));
                BizProcInfo rtnObj = new BizProcInfo(bizProcMetaInfo);
                rtnObj.setInnerVersion(rs.getInt("FINNERVERSION"));
                if (rtnMap.get(rtnObj.getPerformerId()) != null) {
                    ((ArrayList)rtnMap.get(rtnObj.getPerformerId())).add(rtnObj);
                    continue;
                }
                ArrayList<BizProcInfo> bizprocInfos = new ArrayList<BizProcInfo>();
                bizprocInfos.add(rtnObj);
                rtnMap.put(rtnObj.getPerformerId(), bizprocInfos);
            }
        }
        catch (Throwable throwable) {
            StoreManager.cleanup(rs, stmt, conn);
            throw throwable;
        }
        StoreManager.cleanup(rs, stmt, conn);
        return rtnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessDefEnable(String procDefId, boolean enable) throws SQLException, DataAccessException, WfException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "UPDATE T_WFR_PROCDEF SET FENABLE = ? WHERE (FPROCDEFID = ?)";
            stmt = conn.prepareStatement(sql);
            stmt.setBoolean(1, enable);
            stmt.setString(2, procDefId);
            int updateCount = stmt.executeUpdate();
            if (updateCount == 0) {
                throw new SQLException("not such process definition, procDef id '" + procDefId + "'");
            }
            WfEngine.getEngine(this.innerContext).getCacheManager().removeInvocationResult(EffectRegion.create(new ProcDefInfo().getBOSType()));
        }
        catch (Throwable throwable) {
            StoreManager.cleanup(stmt, conn);
            throw throwable;
        }
        StoreManager.cleanup(stmt, conn);
        this.notifyDataChangedByProcDefId(procDefId, "setProcessDefEnable", new Class[]{String.class, Boolean.TYPE}, new Object[]{procDefId, enable});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessBizObj(String procInstId, String bizObjId, String orgId) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            ProcInstBizObjInfo piboi = new ProcInstBizObjInfo();
            piboi.setProcInstID(BOSUuid.read((String)procInstId));
            piboi.setBizObjID(BOSUuid.read((String)bizObjId));
            try {
                BOSUuid.read((String)orgId);
                piboi.setOrgId(orgId);
            }
            catch (Throwable _) {
                piboi.setOrgId("");
                orgId = null;
                log.debug((Object)("OrgId is not boid:" + orgId));
            }
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCINSTBIZOBJBOT, cn);
            if (!ormdao.exists("where procinstid ='" + procInstId + "' and bizObjId='" + bizObjId + "'")) {
                ormdao.addnew((IObjectValue)piboi);
            }
            if (orgId != null) {
                String sql = "select 1 from T_WFR_ProcInstRef where fprocInstId= ? and frefId=? ";
                try (PreparedStatement psmt = cn.prepareStatement(sql);){
                    psmt.setString(1, procInstId);
                    psmt.setString(2, orgId);
                    if (!psmt.executeQuery().next()) {
                        sql = "insert into T_WFR_ProcInstRef(fprocInstId, frefId, ftype) values( ?,?,?)";
                        psmt = cn.prepareStatement(sql);
                        psmt.setString(1, procInstId);
                        psmt.setString(2, orgId);
                        psmt.setInt(3, 0);
                        psmt.executeUpdate();
                    }
                }
            }
            boolean ignore = false;
            try {
                String bosType = BOSUuid.read((String)bizObjId).getType().toString();
                ignore = bosType.equals("63D30103");
            }
            catch (Throwable bosType) {
                // empty catch block
            }
            if (!ignore) {
                String sql = "select 1 from T_WFR_ProcInstRef where fprocInstId=? and frefId=?";
                try (PreparedStatement psmt = cn.prepareStatement(sql);){
                    psmt.setString(1, procInstId);
                    psmt.setString(2, bizObjId);
                    if (!psmt.executeQuery().next()) {
                        sql = "insert into T_WFR_ProcInstRef(fprocInstId, frefId, ftype) values (?,?,?)";
                        psmt = cn.prepareStatement(sql);
                        psmt.setString(1, procInstId);
                        psmt.setString(2, bizObjId);
                        psmt.setInt(3, 1);
                        psmt.executeUpdate();
                    }
                }
            }
            this.getContext();
        }
        finally {
            this.cleanup(cn);
        }
        this.notifyDataChangedByProcInstId(procInstId, "addProcessBizObj", new Class[]{String.class, String.class, String.class}, new Object[]{procInstId, bizObjId, orgId});
    }

    private ResultSet executeQuery(Statement smt, String sql) throws SQLException {
        return smt.executeQuery(sql);
    }

    public void addProcessBizObj(String procInstId, Map bizObjIds) throws SQLException, DataAccessException {
        LowTimer lowTimer = new LowTimer();
        if ((procInstId == null || bizObjIds == null || bizObjIds.size() == 0) && log.isDebugEnabled()) {
            log.debug((Object)("bizObjIds is null," + procInstId));
        }
        assert (bizObjIds != null);
        for (Map.Entry entry : bizObjIds.entrySet()) {
            if (entry.getKey() == null) continue;
            this.addProcessBizObj(procInstId, entry.getKey().toString(), entry.getValue() == null ? "" : entry.getValue().toString());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessStoter.addProcessBizObj() cost:" + lowTimer.msValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessBizObj(String procInstId) throws SQLException, DataAccessException {
        LowTimer lowTimer = new LowTimer();
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection();
            String sql = "delete from t_wfr_procinstbizobj where fprocinstid = ? ";
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, procInstId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.cleanup(stmt, cn);
            throw throwable;
        }
        this.cleanup(stmt, cn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessStorer.removeProcessBizObj() cost:" + lowTimer.msValue()));
        }
        this.notifyDataChangedByProcInstId(procInstId, "removeProcessBizObj", new Class[]{String.class}, new Object[]{procInstId});
    }

    private int executeUpdate(Statement stmt, String sql) throws SQLException {
        return stmt.executeUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleteProcessRecord(String procInstId, String[] bizObjIds) throws SQLException, DataAccessException {
        PreparedStatement statement;
        Connection cn;
        LowTimer lowTimer;
        block10: {
            lowTimer = new LowTimer();
            cn = null;
            statement = null;
            int outminute = EngineConfig.getInstance().getRecordTimeOut();
            if (this.deleteTime == 0L) {
                this.deleteTime = System.currentTimeMillis();
            }
            Date date = new Date();
            Calendar c = Calendar.getInstance();
            Timestamp createTime = new Timestamp(date.getTime());
            c.add(12, -outminute);
            Timestamp time2 = new Timestamp(c.getTime().getTime());
            try {
                cn = this.getConnection();
                statement = cn.prepareStatement("insert  into  T_WFR_proinstBizObjRelation (FPROCINSTID,FBizObjID,FCreatedTime) values (?,?,?)");
                for (int j = 0; j < bizObjIds.length; ++j) {
                    statement.setString(1, procInstId);
                    statement.setString(2, bizObjIds[j]);
                    statement.setTimestamp(3, createTime);
                    statement.addBatch();
                }
                statement.executeBatch();
                statement.clearBatch();
                try {
                    statement.close();
                }
                catch (Exception j) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - this.deleteTime <= 60000L) break block10;
                this.deleteTime = System.currentTimeMillis();
                String selectSql = "select FPROCINSTID from T_WFR_proinstBizObjRelation where FCreatedTime < ?";
                statement = cn.prepareStatement(selectSql);
                statement.setTimestamp(1, time2);
                ResultSet rs = statement.executeQuery();
                PreparedStatement statement2 = cn.prepareStatement("delete from T_WFR_proinstBizObjRelation where FPROCINSTID=?");
                int i = 0;
                while (rs.next()) {
                    String pbID = rs.getString("FPROCINSTID");
                    statement2.setString(1, pbID);
                    statement2.addBatch();
                    if (++i <= 50) continue;
                }
                statement2.executeBatch();
                statement2.clearBatch();
                try {
                    statement2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                this.cleanup(statement, cn);
                throw throwable;
            }
        }
        this.cleanup(statement, cn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessStorer.addDeleteProcessRecord() cost:" + lowTimer.msValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregistProcessBizObj(String bizObjId) throws SQLException, DataAccessException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            String cndtn = "(bizObjID ='" + bizObjId + "')";
            String oql = "WHERE " + cndtn;
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.PROCINSTBIZOBJBOT, cn);
            ormdao.delete(oql);
        }
        finally {
            this.cleanup(cn);
        }
        this.notifyDataChangedByProcDefId("", "unregistProcessBizObj", new Class[]{String.class}, new Object[]{bizObjId});
    }

    public ProcessInstInfo[] getProcessInstanceByHoldedObjectId(String bizObjId) throws SQLException, DataAccessException {
        ProcessInstInfo[] result = this.getProcessInstanceByHoldedObjectId(bizObjId, DataTypeEnum.RUNTIME);
        return result;
    }

    public ProcessInstInfo[] getProcessInstInfoByInitiator(String initiatorUserID) throws SQLException, DataAccessException {
        if (initiatorUserID == null || initiatorUserID.length() == 0) {
            throw new IllegalArgumentException();
        }
        String cndtn = "(initiatorID = '" + initiatorUserID + "')";
        String oql = "where " + cndtn;
        ProcessInstInfo[] processInstInfoArray = this.getProcessInstInfoArray(oql);
        return processInstInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBackWfData(String procInstID) throws SQLException, DataAccessException {
        if (procInstID == null || procInstID.length() == 0) {
            throw new IllegalArgumentException();
        }
        Connection cn = null;
        try {
            cn = this.getConnection();
            String procInstIDSet = "(" + procInstID + ")";
            String sql = "";
            sql = sql + "INSERT INTO T_WFR_ProcInst ";
            sql = sql + "SELECT * FROM T_WFR_ProcInstHst ";
            sql = sql + "WHERE ";
            sql = sql + "(FPROCINSTID IN " + procInstIDSet + ")";
            this.executeSql(cn, sql);
            sql = "";
            sql = sql + "INSERT INTO T_WFR_ProcInstData ";
            sql = sql + "SELECT * FROM T_WFR_ProcInstDataHst ";
            sql = sql + "WHERE ";
            sql = sql + "(FPROCINSTID IN " + procInstIDSet + ")";
            this.executeSql(cn, sql);
            sql = "";
            sql = sql + "INSERT INTO T_WFR_ActInst ";
            sql = sql + "SELECT * FROM T_WFR_ActInstHst ";
            sql = sql + "WHERE ";
            sql = sql + "(FPROCINSTID IN " + procInstIDSet + ")";
            this.executeSql(cn, sql);
            sql = "";
            sql = sql + "INSERT INTO T_WFR_Assign ";
            sql = sql + "SELECT * FROM T_WFR_AssignHst ";
            sql = sql + "WHERE ";
            sql = sql + "(FPROCINSTID IN " + procInstIDSet + ")";
            this.executeSql(cn, sql);
            sql = "";
            sql = sql + "DELETE T_WFR_AssignHst ";
            sql = sql + "WHERE (FPROCINSTID IN " + procInstIDSet + ")";
            this.executeSql(cn, sql);
            sql = "";
            sql = sql + "DELETE T_WFR_ActInstHst ";
            sql = sql + "WHERE (FPROCINSTID IN " + procInstIDSet + ")";
            this.executeSql(cn, sql);
            sql = "";
            sql = sql + "DELETE T_WFR_ProcInstDataHst ";
            sql = sql + "WHERE (FPROCINSTID IN " + procInstIDSet + ")";
            this.executeSql(cn, sql);
            sql = "";
            sql = sql + "DELETE T_WFR_ProcInstHst ";
            sql = sql + "WHERE (FPROCINSTID IN " + procInstIDSet + ")";
            this.executeSql(cn, sql);
        }
        finally {
            this.cleanup(cn);
        }
    }

    public void executeSQL(String sql) throws SQLException, DataAccessException {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException();
        }
        Connection cn = null;
        try {
            cn = this.getConnection();
            this.executeSql(cn, sql);
        }
        finally {
            this.cleanup(cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProcessDefine(String processDefineId, int innerVersion) throws DataAccessException, SQLException, WfException {
        Connection conn = null;
        if (innerVersion > 0) {
            ProcessDefInfo procDefInfo = this.getProcessDefInfo(processDefineId, innerVersion);
            int count = this.procInstCount(procDefInfo.getProcDefId(), procDefInfo.getInnerVersion());
            if (count == 0) {
                try {
                    conn = this.getConnection();
                    String sql = "delete from T_WFR_ProcDef where fprocdefid='" + processDefineId + "' and FINNERVERSION=" + Integer.toString(innerVersion);
                    this.executeSql(conn, sql);
                }
                finally {
                    this.cleanup(conn);
                }
            }
        } else {
            String oql = "select procdefid where procdefID='" + processDefineId + "'";
            ProcessDefInfo[] procDefInfos = this.getProcDefInfoArray(oql);
            boolean hasInstances = false;
            for (int i = 0; i < procDefInfos.length; ++i) {
                int count = this.procInstCount(procDefInfos[i].getProcDefId(), procDefInfos[i].getInnerVersion());
                if (count <= 0) continue;
                hasInstances = true;
                break;
            }
            if (!hasInstances) {
                try {
                    conn = this.getConnection();
                    String sql = "delete from T_WFR_ProcDef where fprocdefid='" + processDefineId + "'";
                    this.executeSql(conn, sql);
                }
                finally {
                    this.cleanup(conn);
                }
            }
            if (hasInstances) {
                throw new CannotDeleteException("can not delete this process define,because the process define has Instances process.");
            }
        }
        WfEngine.getEngine(this.innerContext).getCacheManager().removeInvocationResult(EffectRegion.create(new ProcDefInfo().getBOSType()));
        this.notifyDataChangedByProcDefId(processDefineId, "deleteProcessDefine", new Class[]{String.class, Integer.TYPE}, new Object[]{processDefineId, new Integer(innerVersion)});
    }

    private boolean executeSql(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql).execute();
    }

    public void deleteProcessInst(String procInstId) throws SQLException, WfException {
        this.deleteProcessInst(procInstId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProcessInst(String procInstId, boolean all) throws SQLException, WfException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.createStatement();
            String delAssign_sql = "delete from T_WFR_Assign where FPROCINSTID ='" + procInstId + "'";
            statement.addBatch(delAssign_sql);
            String delActInst_sql = "delete from T_WFR_ActInst where FPROCINSTID='" + procInstId + "'";
            statement.addBatch(delActInst_sql);
            String delProcInstData_sql = "delete from T_WFR_ProcInstData where FPROCINSTID='" + procInstId + "'";
            statement.addBatch(delProcInstData_sql);
            if (all) {
                String sql = "delete from T_WFR_PassComment where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_ProcInstBizObj where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_ASSIGNHST where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_ACTINSTHST where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_ASSIGNDETAIL where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_PROCINSTREF where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_PROCINSTREFHST where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_PROCINSTDATAHST where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_PROCINSTHST where FPROCINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
                sql = "delete from T_WFR_PROCESSINSTLOG where FPROCESSINSTID ='" + procInstId + "'";
                statement.addBatch(sql);
            }
            String delProcInst_sql = "delete from T_WFR_ProcInst where FPROCINSTID='" + procInstId + "'";
            statement.addBatch(delProcInst_sql);
            statement.executeBatch();
            this.deleteMutex(procInstId);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(statement, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
        this.notifyDataChangedByProcInstId(procInstId, "deleteProcessInst", new Class[]{String.class}, new Object[]{procInstId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProcessInst(String processDefId, String procInstId) throws SQLException, WfException {
        if (StringUtils.isEmpty((String)processDefId)) {
            String message = "\"processDefId\" is null!";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        if (StringUtils.isEmpty((String)procInstId)) {
            String message = "\"procInstId\" is null!";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.createStatement();
            String delAssign_sql = "delete from T_WFR_Assign where FPROCINSTID ='" + procInstId + "'";
            statement.addBatch(delAssign_sql);
            String delActInst_sql = "delete from T_WFR_ActInst where FPROCINSTID='" + procInstId + "'";
            statement.addBatch(delActInst_sql);
            String delProcInstData_sql = "delete from T_WFR_ProcInstData where FPROCINSTID='" + procInstId + "'";
            statement.addBatch(delProcInstData_sql);
            String delProcInst_sql = "delete from T_WFR_ProcInst where FPROCINSTID='" + procInstId + "'";
            statement.addBatch(delProcInst_sql);
            String delProcInstBizObj_sql = "delete from T_WFR_ProcInstBizObj where FProcInstId='" + procInstId + "'";
            statement.addBatch(delProcInstBizObj_sql);
            statement.executeBatch();
            this.deleteMutex(procInstId);
        }
        catch (Throwable throwable) {
            StoreManager.cleanup(statement, conn);
            throw throwable;
        }
        StoreManager.cleanup(statement, conn);
        this.notifyDataChangedByProcDefId(processDefId, "deleteProcessInst", new Class[]{String.class, String.class}, new Object[]{processDefId, procInstId});
    }

    private ProcDefInfo getProcDef(String oql) throws SQLException, DataAccessException {
        ProcDefCollection pdc = this.getProcDefInfoCollection(oql);
        if (pdc != null && pdc.size() > 0) {
            return pdc.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int procInstCount(String procDefId, int version) throws SQLException {
        int n;
        Connection conn = this.getConnection();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer sql;
            if (procDefId == null || procDefId.length() == 0) {
                sql = new StringBuffer();
                sql.append("select count(fprocinstid) ProcInstCount from T_WFR_ProcInst");
                sql.append(" union ");
                sql.append("select count(fprocinstid) ProcInstCount from T_WFR_ProcInstHst");
                statement = conn.prepareStatement(sql.toString());
                resultSet = statement.executeQuery();
            } else {
                sql = new StringBuffer();
                sql.append("select count(fprocinstid) ProcInstCount from T_WFR_ProcInst where (FPROCDEFID=?) AND (FPROCDEFVER=?)");
                sql.append(" union ");
                sql.append("select count(fprocinstid) ProcInstCount from T_WFR_ProcInstHst where (FPROCDEFID=?) AND (FPROCDEFVER=?)");
                statement = conn.prepareStatement(sql.toString());
                statement.setString(1, procDefId);
                statement.setInt(2, version);
                statement.setString(3, procDefId);
                statement.setInt(4, version);
                resultSet = statement.executeQuery();
            }
            int count = 0;
            while (resultSet.next()) {
                count += resultSet.getInt("ProcInstCount");
            }
            n = count;
        }
        catch (Throwable throwable) {
            StoreManager.cleanup(resultSet, statement, conn);
            throw throwable;
        }
        StoreManager.cleanup(resultSet, statement, conn);
        return n;
    }

    public String getKpdlById(String id) {
        String hash;
        try {
            hash = this.getProcessDefInfoLastVersionHash(id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this.getKpdlByHash(hash);
    }

    public String getKpdlByHash(String hash) {
        String kpdl = "";
        try {
            String sql = "select FKPDL  from t_wfr_procdef  where FMD5HASH  = ? order by finnerVersion DESC ";
            int[] types = new int[]{12};
            Object[] values = new Object[]{hash};
            ArrayList rs = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])types, (Object[])values);
            if (rs.size() == 0) {
                sql = "select FKPDL  from t_wfr_procdef  where FPROCDEFID  in (select distinct FPROCDEFID  from t_wfr_procinsthst where FPROCDEFHASH  = ?)order by finnerVersion DESC ";
                rs = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])types, (Object[])values);
                if (rs.size() != 0) {
                    kpdl = (String)((Map)rs.get(0)).get("fkpdl");
                } else {
                    sql = "select FKPDL  from t_wfr_procdef  where FPROCDEFID  in (select distinct FPROCDEFID  from t_wfr_procinst where FPROCDEFHASH  = ?)order by finnerVersion DESC ";
                    rs = SQL.executeQuery((Context)this.getContext(), (String)sql, (int[])types, (Object[])values);
                    if (rs.size() != 0) {
                        kpdl = (String)((Map)rs.get(0)).get("fkpdl");
                    }
                }
            } else {
                kpdl = (String)((Map)rs.get(0)).get("fkpdl");
            }
        }
        catch (BOSException e1) {
            log.error((Object)"\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u51fa\u9519", (Throwable)e1);
        }
        return kpdl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchTerminate(String[] procInstIds) throws SQLException, WfException {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            String procSQL = "update t_wfr_procinst set fstate = 'closed.terminated' where fprocinstId = ?";
            try {
                cn = this.getConnection();
                stmt = cn.prepareStatement(procSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stmt);
            String actSQL = "update t_wfr_actInst set fstate = 'closed.terminated' where fprocinstId = ?";
            try {
                stmt = cn.prepareStatement(actSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String assignSQL = "update t_wfr_assign set fstate = 4 where fprocinstId = ?";
            try {
                stmt = cn.prepareStatement(assignSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String assignDumpSQL = "insert into t_wfr_assigndetail (FASSIGNID,FSUBJECT_L1,FSUBJECT_L2,FSUBJECT_L3,FBODY_L1,FBODY_L2,FBODY_L3,FSTATE,FPERSONUSERID,FPERSONUSERNAME_L1,FPERSONUSERNAME_L2,FPERSONUSERNAME_L3,FPERSONEMPID,FPERSONEMPNAME_L1,FPERSONEMPNAME_L2,FPERSONEMPNAME_L3,FPERFORMERUID,FPERFORMERUNAME_L1,FPERFORMERUNAME_L2,FPERFORMERUNAME_L3,FPERFORMEREID,FPERFORMERENAME_L1,FPERFORMERENAME_L2,FPERFORMERENAME_L3,FACTINSTID,FACTDEFID,FACTDEFNAME_L1,FACTDEFNAME_L2,FACTDEFNAME_L3,FPROCDEFHASH,FPROCDEFID,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCINSTID,FENDTIME,FLASTSTATETIME,FCREATEDTIME,FFORWARDPATH,FEXTATTR,FACCEPTTIME,FBIZPACKAGE,FBIZFUNCTION,FBIZOPERATION,FBIZOBJID,FAPPDEFID,FPRIORITY,FDURATION,FWORKINGTIME,FWAITINGTIME,FIsSendMsg,FPRIORPERFORMER, FPRIORPERFORMERNAME_l1, FPRIORPERFORMERNAME_l2, FPRIORPERFORMERNAME_l3, FBILLENTITY) select FASSIGNID,FSUBJECT_L1,FSUBJECT_L2,FSUBJECT_L3,FBODY_L1,FBODY_L2,FBODY_L3,FSTATE,FPERSONUSERID,FPERSONUSERNAME_L1,FPERSONUSERNAME_L2,FPERSONUSERNAME_L3,FPERSONEMPID,FPERSONEMPNAME_L1,FPERSONEMPNAME_L2,FPERSONEMPNAME_L3,FPERFORMERUID,FPERFORMERUNAME_L1,FPERFORMERUNAME_L2,FPERFORMERUNAME_L3,FPERFORMEREID,FPERFORMERENAME_L1,FPERFORMERENAME_L2,FPERFORMERENAME_L3,FACTINSTID,FACTDEFID,FACTDEFNAME_L1,FACTDEFNAME_L2,FACTDEFNAME_L3,FPROCDEFHASH,FPROCDEFID,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCINSTID,FENDTIME,FLASTSTATETIME,FCREATEDTIME,FFORWARDPATH,FEXTATTR,FACCEPTTIME,FBIZPACKAGE,FBIZFUNCTION,FBIZOPERATION,FBIZOBJID,FAPPDEFID,FPRIORITY,FDURATION,FWORKINGTIME,FWAITINGTIME,FIsSendMsg,FPRIORPERFORMER, FPRIORPERFORMERNAME_l1, FPRIORPERFORMERNAME_l2, FPRIORPERFORMERNAME_l3, FBILLENTITY from t_wfr_assign where fprocinstid=?";
            try {
                stmt = cn.prepareStatement(assignDumpSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String assignDeleteSQL = "delete from t_wfr_assign where fprocinstid=?";
            try {
                stmt = cn.prepareStatement(assignDeleteSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String procBizDeleteSQL = "delete from t_wfr_procinstbizobj where fprocinstid= ?";
            try {
                stmt = cn.prepareStatement(procBizDeleteSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            this.deleteMutexes(procInstIds);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
        this.notifyDataChangedByProcInstId(procInstIds[0], "batchTerminate", new Class[]{String[].class}, new Object[]{procInstIds});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchPhysicsDelete(String[] procInstIds) throws SQLException, WfException {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            String procSQL = "delete from t_wfr_procinst where fprocinstId = ?";
            cn = this.getConnection();
            try {
                stmt = cn.prepareStatement(procSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String procHstSQL = "delete from t_wfr_procinsthst where fprocinstId = ?";
            try {
                stmt = cn.prepareStatement(procHstSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String procInstSQL = "delete from T_WFR_ProcInstData where FPROCINSTID= ?";
            try {
                stmt = cn.prepareStatement(procInstSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String actSQL = "delete from t_wfr_actInst where fprocinstId = ?";
            try {
                stmt = cn.prepareStatement(actSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String assignSQL = "delete from t_wfr_assign where fprocinstId = ?";
            try {
                stmt = cn.prepareStatement(assignSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String assignDumpSQL = "delete from t_wfr_assigndetail where fprocinstId = ?";
            try {
                stmt = cn.prepareStatement(assignDumpSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            String procBizDeleteSQL = "delete from t_wfr_procinstbizobj where fprocinstid= ?";
            try {
                stmt = cn.prepareStatement(procBizDeleteSQL);
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setString(1, procInstIds[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
            this.deleteMutexes(procInstIds);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
        this.notifyDataChangedByProcInstId(procInstIds[0], "batchPhysicsDelete", new Class[]{String[].class}, new Object[]{procInstIds});
    }

    private void deleteMutexes(String[] procInstIds) throws SQLException, WfException {
        WfEngine engine = WfEngine.getEngine(this.innerContext);
        MutexStorer mutexStorer = engine.getStoreManager().getMutexStorer();
        mutexStorer.deleteBatch(procInstIds);
    }

    private void deleteMutex(String procInstId) throws SQLException, WfException {
        WfEngine engine = WfEngine.getEngine(this.innerContext);
        MutexStorer mutexStorer = engine.getStoreManager().getMutexStorer();
        mutexStorer.delete(procInstId);
    }

    public boolean existProcessBizObject(String bizObjId) throws WfException {
        boolean bl;
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT TOP 1 FBizObjId FROM T_WFR_ProcInstBizObj WHERE FBizObjId = ?";
            cn = this.getConnection();
            ps = cn.prepareStatement(sql);
            ps.setString(1, bizObjId);
            rs = ps.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return bl;
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.hashCode());
    }

    public ProcessDefInfo[] getProcessDefInfos(String bizPackage, String bizFunc, String bizOperation, int performerType) throws WfException {
        ProcessDefInfo[] processDefInfoArray;
        assert (StringUtils.isEmpty((String)bizFunc) && StringUtils.isEmpty((String)bizPackage) && StringUtils.isEmpty((String)bizOperation));
        ArrayList<ProcessDefInfo> list = new ArrayList<ProcessDefInfo>();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Locale l1 = new Locale("l1");
        Locale l2 = new Locale("l2");
        Locale l3 = new Locale("l3");
        try {
            cn = this.getConnection();
            StringBuffer sql = new StringBuffer(300);
            sql.append("SELECT PROCDEF.FPROCDEFID, PROCDEF.FNAME_L1, PROCDEF.FNAME_L2,  PROCDEF.FNAME_L3, ").append("PROCDEF.FProcCode,PROCDEF.FCREATEDTIME FROM T_WFR_PROCDEF PROCDEF ").append(" INNER JOIN (SELECT FPROCDEFID TARGETPROCDEFID, MAX(FINNERVERSION) TARGETINNERVERSION ").append(" FROM T_WFR_PROCDEF GROUP BY FPROCDEFID) PROCDEF1 ").append(" ON PROCDEF.FPROCDEFID = PROCDEF1.TARGETPROCDEFID AND PROCDEF.FINNERVERSION = PROCDEF1.TARGETINNERVERSION ").append(" INNER JOIN T_WFR_BIZPROC BIZPROC ON BIZPROC.FPROCDEFID = PROCDEF.FPROCDEFID ").append(" WHERE PROCDEF.FENABLE = 1 AND BIZPROC.FBIZFUNC = ? AND BIZPROC.FBIZPACKAGE = ? ").append(" AND BIZPROC.FBIZOPERATION = ? AND BIZPROC.FPERFORMERTYPE = ? ").append(" ORDER BY PROCDEF.FCREATEDTIME DESC ");
            ps = cn.prepareStatement(sql.toString());
            ps.setString(1, bizFunc);
            ps.setString(2, bizPackage);
            ps.setString(3, bizOperation);
            ps.setInt(4, performerType);
            rs = ps.executeQuery();
            while (rs.next()) {
                ProcessDefInfo processDefInfo = new ProcessDefInfo();
                processDefInfo.setProcDefId(rs.getString("FPROCDEFID"));
                processDefInfo.setProcDefName(l1, rs.getString("FNAME_L1"));
                processDefInfo.setProcDefName(l2, rs.getString("FNAME_L2"));
                processDefInfo.setProcDefName(l3, rs.getString("FNAME_L3"));
                processDefInfo.getMeta().setProcCode(rs.getString("FProcCode"));
                list.add(processDefInfo);
            }
            processDefInfoArray = list.toArray(new ProcessDefInfo[list.size()]);
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return processDefInfoArray;
    }

    public void cleanTempBizProcRelation(String bizObjID) throws WfException {
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection();
            String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM T_WFR_TempBizProcRelation WHERE FBizObjID = ?)";
            ps = cn.prepareStatement(sql);
            ps.setString(1, bizObjID);
            rs = ps.executeQuery();
            if (rs.next()) {
                sql = "DELETE FROM T_WFR_TempBizProcRelation WHERE FBizObjID = ? ";
                ps = cn.prepareStatement(sql);
                ps.setString(1, bizObjID);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    public void addNewProcInstBatch(List procInstInfos) throws WfException {
        Connection cn = null;
        PreparedStatement ps = null;
        StringBuffer SQL2 = new StringBuffer();
        SQL2.append("INSERT \n");
        SQL2.append("INTO    T_WFR_PROCINST \n");
        SQL2.append("        ( \n");
        SQL2.append("                FPROCINSTID      , \n");
        SQL2.append("                FSTATE           , \n");
        SQL2.append("                FPROCDEFID       , \n");
        SQL2.append("                FPROCDEFVER      , \n");
        SQL2.append("                FPROCDEFNAME_L1  , \n");
        SQL2.append("                FPROCDEFNAME_L2  , \n");
        SQL2.append("                FPROCDEFNAME_L3  , \n");
        SQL2.append("                FPROCDEFXPDL     , \n");
        SQL2.append("                FPROCDEFHASH     , \n");
        SQL2.append("                FCOMLETETIME     , \n");
        SQL2.append("                FLASTSTATETIME   , \n");
        SQL2.append("                FCREATEDTIME     , \n");
        SQL2.append("                FPARENTACTINSTID , \n");
        SQL2.append("                FPARENTACTDEFID  , \n");
        SQL2.append("                FPACTDEFNAME_L1  , \n");
        SQL2.append("                FPACTDEFNAME_L2  , \n");
        SQL2.append("                FPACTDEFNAME_L3  , \n");
        SQL2.append("                FPARENTPROCINSTID, \n");
        SQL2.append("                FPARENTPROCDEFID , \n");
        SQL2.append("                FPPROCDEFNAME_L1 , \n");
        SQL2.append("                FPPROCDEFNAME_L2 , \n");
        SQL2.append("                FPPROCDEFNAME_L3 , \n");
        SQL2.append("                FTIMEUNIT        , \n");
        SQL2.append("                FLIMIT           , \n");
        SQL2.append("                FINITIATORID     , \n");
        SQL2.append("                FINITIATORNAME_L1, \n");
        SQL2.append("                FINITIATORNAME_L2, \n");
        SQL2.append("                FINITIATORNAME_L3, \n");
        SQL2.append("                FSTARTACTINSTID  , \n");
        SQL2.append("                FPROCDEFTYPE     , \n");
        SQL2.append("                FCODE            , \n");
        SQL2.append("                FWAITINGTIME     , \n");
        SQL2.append("                FDURATION        , \n");
        SQL2.append("                FWORKINGTIME     , \n");
        SQL2.append("                FPROCINSTTOPIC_L1, \n");
        SQL2.append("                FPROCINSTTOPIC_L2, \n");
        SQL2.append("                FPROCINSTTOPIC_L3, \n");
        SQL2.append("                FControlUnitID \n");
        SQL2.append("        ) \n");
        SQL2.append("        VALUES \n");
        SQL2.append("        ( \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ? \n");
        SQL2.append("        )");
        try {
            cn = this.getConnection();
            ps = cn.prepareStatement(SQL2.toString());
            Locale l1 = new Locale("L1");
            Locale l2 = new Locale("L2");
            Locale l3 = new Locale("L3");
            int size = procInstInfos.size();
            for (int i = 0; i < size; ++i) {
                String controlUnitID;
                String startActInstID;
                String parentProcDefID;
                String parentProcInstID;
                String parentActDefID;
                String parentActInstID;
                ProcInstInfo procInstInfo = (ProcInstInfo)procInstInfos.get(i);
                String procInstID = procInstInfo.getProcInstID().toString();
                ps.setString(1, procInstID);
                WfState wfState = procInstInfo.getState();
                ps.setString(2, wfState.getValue());
                String procDefID = procInstInfo.getProcdefID().toString();
                ps.setString(3, procDefID);
                int procDefVer = procInstInfo.getProcdefVer();
                ps.setInt(4, procDefVer);
                String procDefName_l1 = procInstInfo.getProcdefName(l1);
                if (procDefName_l1 == null) {
                    ps.setNull(5, 12);
                } else {
                    ps.setString(5, procDefName_l1);
                }
                String procDefName_l2 = procInstInfo.getProcdefName(l2);
                if (procDefName_l2 == null) {
                    ps.setNull(6, 12);
                } else {
                    ps.setString(6, procDefName_l2);
                }
                String procDefName_l3 = procInstInfo.getProcdefName(l3);
                if (procDefName_l3 == null) {
                    ps.setNull(7, 12);
                } else {
                    ps.setString(7, procDefName_l3);
                }
                String procDefXpdl = procInstInfo.getProcdefXpdl();
                if (procDefXpdl == null) {
                    ps.setNull(8, 12);
                } else {
                    ps.setString(8, procDefXpdl);
                }
                String procDefHash = procInstInfo.getProcdefHash();
                ps.setString(9, procDefHash);
                Timestamp completeTime = procInstInfo.getComleteTime();
                if (completeTime == null) {
                    ps.setNull(10, 93);
                } else {
                    ps.setTimestamp(10, completeTime);
                }
                Timestamp lastStateTime = procInstInfo.getLastStateTime();
                ps.setTimestamp(11, lastStateTime);
                Timestamp createdTime = procInstInfo.getCreatedTime();
                ps.setTimestamp(12, createdTime);
                String string = parentActInstID = procInstInfo.getParentActInstID() != null ? procInstInfo.getParentActInstID().toString() : null;
                if (parentActInstID == null) {
                    ps.setNull(13, 12);
                } else {
                    ps.setString(13, parentActInstID);
                }
                String string2 = parentActDefID = procInstInfo.getParentActdefID() != null ? procInstInfo.getParentActdefID().toString() : null;
                if (parentActDefID == null) {
                    ps.setNull(14, 12);
                } else {
                    ps.setString(14, parentActDefID);
                }
                String pactDefName_l1 = procInstInfo.getPactdefName(l1);
                if (pactDefName_l1 == null) {
                    ps.setNull(15, 12);
                } else {
                    ps.setString(15, pactDefName_l1);
                }
                String pactDefName_l2 = procInstInfo.getPactdefName(l2);
                if (pactDefName_l2 == null) {
                    ps.setNull(16, 12);
                } else {
                    ps.setString(16, pactDefName_l2);
                }
                String pactDefName_l3 = procInstInfo.getPactdefName(l3);
                if (pactDefName_l3 == null) {
                    ps.setNull(17, 12);
                } else {
                    ps.setString(17, pactDefName_l3);
                }
                String string3 = parentProcInstID = procInstInfo.getParentProcInstID() != null ? procInstInfo.getParentProcInstID().toString() : null;
                if (parentProcInstID == null) {
                    ps.setNull(18, 12);
                } else {
                    ps.setString(18, parentProcInstID);
                }
                String string4 = parentProcDefID = procInstInfo.getParentProcdefID() != null ? procInstInfo.getParentProcdefID().toString() : null;
                if (parentProcDefID == null) {
                    ps.setNull(19, 12);
                } else {
                    ps.setString(19, parentProcDefID);
                }
                String pprocDefName_l1 = procInstInfo.getProcdefName(l1);
                if (pprocDefName_l1 == null) {
                    ps.setNull(20, 12);
                } else {
                    ps.setString(20, pprocDefName_l1);
                }
                String pprocDefName_l2 = procInstInfo.getProcdefName(l2);
                if (pprocDefName_l2 == null) {
                    ps.setNull(21, 12);
                } else {
                    ps.setString(21, pprocDefName_l2);
                }
                String pprocDefName_l3 = procInstInfo.getProcdefName(l3);
                if (pprocDefName_l3 == null) {
                    ps.setNull(22, 12);
                } else {
                    ps.setString(22, pprocDefName_l3);
                }
                int timeUnit = procInstInfo.getTimeUnit();
                ps.setInt(23, timeUnit);
                int limit = procInstInfo.getLimit();
                ps.setInt(24, limit);
                String initiatorID = procInstInfo.getInitiatorID();
                if (initiatorID == null) {
                    ps.setNull(25, 12);
                } else {
                    ps.setString(25, initiatorID);
                }
                String initiatorName_l1 = procInstInfo.getInitiatorName(l1);
                if (initiatorName_l1 == null) {
                    ps.setNull(26, 12);
                } else {
                    ps.setString(26, initiatorName_l1);
                }
                String initiatorName_l2 = procInstInfo.getInitiatorName(l2);
                if (initiatorName_l2 == null) {
                    ps.setNull(27, 12);
                } else {
                    ps.setString(27, initiatorName_l2);
                }
                String initiatorName_l3 = procInstInfo.getInitiatorName(l3);
                if (initiatorName_l3 == null) {
                    ps.setNull(28, 12);
                } else {
                    ps.setString(28, initiatorName_l3);
                }
                String string5 = startActInstID = procInstInfo.getStartActinstID() != null ? procInstInfo.getStartActinstID().toString() : null;
                if (startActInstID == null) {
                    ps.setNull(29, 12);
                } else {
                    ps.setString(29, startActInstID);
                }
                String procDefType = procInstInfo.getProcdefType();
                if (procDefType == null) {
                    ps.setNull(30, 12);
                } else {
                    ps.setString(30, procDefType);
                }
                String code = procInstInfo.getCode();
                if (code == null) {
                    ps.setNull(31, 12);
                } else {
                    ps.setString(31, code);
                }
                int waitingTime = procInstInfo.getWaitingTime();
                ps.setInt(32, waitingTime);
                int duration = procInstInfo.getDuration();
                ps.setInt(33, duration);
                int workingTime = procInstInfo.getWorkingTime();
                ps.setInt(34, workingTime);
                String procInstTopic_l1 = procInstInfo.getProcInstTopic(l1);
                if (procInstTopic_l1 == null) {
                    ps.setNull(35, 12);
                } else {
                    ps.setString(35, procInstTopic_l1);
                }
                String procInstTopic_l2 = procInstInfo.getProcInstTopic(l2);
                if (procInstTopic_l2 == null) {
                    ps.setNull(36, 12);
                } else {
                    ps.setString(36, procInstTopic_l2);
                }
                String procInstTopic_l3 = procInstInfo.getProcInstTopic(l3);
                if (procInstTopic_l3 == null) {
                    ps.setNull(37, 12);
                } else {
                    ps.setString(37, procInstTopic_l3);
                }
                String string6 = controlUnitID = procInstInfo.getControlUnitID() != null ? procInstInfo.getControlUnitID().toString() : null;
                if (controlUnitID == null) {
                    ps.setNull(38, 12);
                } else {
                    ps.setString(38, controlUnitID);
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    public void addNewProcInstDataBatch(List procInstDataInfos) throws WfException {
        Connection cn = null;
        PreparedStatement ps = null;
        StringBuffer SQL2 = new StringBuffer();
        SQL2.append("INSERT \n");
        SQL2.append("INTO    T_WFR_PROCINSTDATA \n");
        SQL2.append("        ( \n");
        SQL2.append("                FPROCINSTID    , \n");
        SQL2.append("                FTIME          , \n");
        SQL2.append("                FPROCDEFID     , \n");
        SQL2.append("                FPROCDEFHASH   , \n");
        SQL2.append("                FPROCDEFNAME_L1, \n");
        SQL2.append("                FPROCDEFNAME_L2, \n");
        SQL2.append("                FPROCDEFNAME_L3, \n");
        SQL2.append("                FPROCDEFVER    , \n");
        SQL2.append("                FDATAVALUE     , \n");
        SQL2.append("                FACTINSTID     , \n");
        SQL2.append("                FISCURRENT     , \n");
        SQL2.append("                FISROLLBACK \n");
        SQL2.append("        ) \n");
        SQL2.append("        VALUES \n");
        SQL2.append("        ( \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ?, \n");
        SQL2.append("                ? \n");
        SQL2.append("        )");
        try {
            cn = this.getConnection();
            ps = cn.prepareStatement(SQL2.toString());
            Locale l1 = new Locale("L1");
            Locale l2 = new Locale("L2");
            Locale l3 = new Locale("L3");
            int size = procInstDataInfos.size();
            for (int i = 0; i < size; ++i) {
                String actInstID;
                String procDefID;
                ProcInstDataInfo procInstDataInfo = (ProcInstDataInfo)procInstDataInfos.get(i);
                String procInstID = procInstDataInfo.getProcInstID().toString();
                ps.setString(1, procInstID);
                Timestamp time = procInstDataInfo.getTime();
                ps.setTimestamp(2, time);
                String string = procDefID = procInstDataInfo.getProcDefID() != null ? procInstDataInfo.getProcDefID().toString() : null;
                if (procDefID == null) {
                    ps.setNull(3, 12);
                } else {
                    ps.setString(3, procDefID);
                }
                String procDefHash = procInstDataInfo.getProcDefHash();
                if (procDefHash == null) {
                    ps.setNull(4, 12);
                } else {
                    ps.setString(4, procDefHash);
                }
                String procDefName_l1 = procInstDataInfo.getProcDefName(l1);
                if (procDefName_l1 == null) {
                    ps.setNull(5, 12);
                } else {
                    ps.setString(5, procDefName_l1);
                }
                String procDefName_l2 = procInstDataInfo.getProcDefName(l2);
                if (procDefName_l2 == null) {
                    ps.setNull(6, 12);
                } else {
                    ps.setString(6, procDefName_l2);
                }
                String procDefName_l3 = procInstDataInfo.getProcDefName(l3);
                if (procDefName_l3 == null) {
                    ps.setNull(7, 12);
                } else {
                    ps.setString(7, procDefName_l3);
                }
                int procDefVer = procInstDataInfo.getProcDefVer();
                ps.setInt(8, procDefVer);
                String dataValue = procInstDataInfo.getDataValue();
                if (dataValue == null) {
                    ps.setNull(9, 12);
                } else {
                    ps.setString(9, dataValue);
                }
                String string2 = actInstID = procInstDataInfo.getActInstID() != null ? procInstDataInfo.getActInstID().toString() : null;
                if (actInstID == null) {
                    ps.setNull(10, 12);
                } else {
                    ps.setString(10, actInstID);
                }
                int isCurrent = procInstDataInfo.getIsCurrent();
                ps.setInt(11, isCurrent);
                int isRollback = procInstDataInfo.getIsRollback();
                ps.setInt(12, isRollback);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    private class ComparatorPdi0
    implements Comparator {
        private ComparatorPdi0() {
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int compare(Object o1, Object o2) {
            ProcessDefInfo pdi1 = (ProcessDefInfo)o1;
            ProcessDefInfo pdi2 = (ProcessDefInfo)o2;
            String pdi1ID = pdi1.getProcDefId().toString();
            int pdi1Vi = pdi1.getInnerVersion();
            String pdi2ID = pdi2.getProcDefId().toString();
            int pdi2Vi = pdi2.getInnerVersion();
            int resultID = pdi1ID.compareTo(pdi2ID);
            int resultVi = pdi1Vi - pdi2Vi;
            if (resultID == 0) {
                if (resultVi == 0) {
                    return 0;
                }
                return resultVi;
            }
            return resultID;
        }
    }
}

