/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.store.ActivityStorer;
import com.kingdee.bos.workflow.store.CorrMatchDataFieldStorer;
import com.kingdee.bos.workflow.store.CorrelationMatchStorer;
import com.kingdee.bos.workflow.store.DataFieldStorer;
import com.kingdee.bos.workflow.store.EventStorer;
import com.kingdee.bos.workflow.store.LogStorer;
import com.kingdee.bos.workflow.store.MutexStorer;
import com.kingdee.bos.workflow.store.ProcImportDefStorer;
import com.kingdee.bos.workflow.store.ProcImportObjStorer;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import com.kingdee.bos.workflow.util.WfDbUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class StoreManager {
    public static int connCount = 0;
    private static final Logger logger = Logger.getLogger(Logger.class);
    private final WfEngine engine;
    private ProcessStorer processStorer;
    private ActivityStorer activityStorer;
    private DataFieldStorer dataFieldStorer;
    private WorkItemStorer workItemStorer;
    private LogStorer logStorer;
    private MutexStorer mutexStorer;
    private EventStorer eventStorer;
    private CorrelationMatchStorer correlationMatchStorer;
    private ProcImportDefStorer procImportDefStorer;
    private ProcImportObjStorer procImportObjStorer;
    private CorrMatchDataFieldStorer corrMatchDataFieldStorer;

    public StoreManager(WfEngine engine) {
        this.engine = engine;
        this.initStorers();
    }

    private void initStorers() {
        Context context = this.engine.context();
        this.logStorer = new LogStorer(context);
        this.correlationMatchStorer = new CorrelationMatchStorer(context);
        this.procImportDefStorer = new ProcImportDefStorer(context);
        this.procImportObjStorer = new ProcImportObjStorer(context);
        this.mutexStorer = new MutexStorer(context);
        this.processStorer = new ProcessStorer(context);
        this.eventStorer = new EventStorer(context);
        this.activityStorer = new ActivityStorer(context);
        this.dataFieldStorer = new DataFieldStorer(context);
        this.workItemStorer = new WorkItemStorer(context);
        this.corrMatchDataFieldStorer = new CorrMatchDataFieldStorer(context);
    }

    public LogStorer getLogStorer() {
        return this.logStorer;
    }

    public CorrelationMatchStorer getCorrelationMatchStorer() {
        return this.correlationMatchStorer;
    }

    public ProcImportDefStorer getProcImportDefStorer() {
        return this.procImportDefStorer;
    }

    public ProcImportObjStorer getProcImportObjStorer() {
        return this.procImportObjStorer;
    }

    public MutexStorer getMutexStorer() {
        return this.mutexStorer;
    }

    public WfEngine getWfEngine() {
        return this.engine;
    }

    public Connection getConnection() throws SQLException {
        ++connCount;
        Connection rtnVal = WfDbUtil.getConnection((Context)this.getWfEngine().context());
        return rtnVal;
    }

    public ProcessStorer getProcessStorer() {
        return this.processStorer;
    }

    public EventStorer getEventStorer() {
        return this.eventStorer;
    }

    public ActivityStorer getActivityStorer() {
        return this.activityStorer;
    }

    public DataFieldStorer getDataFieldStorer() {
        return this.dataFieldStorer;
    }

    public WorkItemStorer getWorkItemStorer() {
        return this.workItemStorer;
    }

    public CorrMatchDataFieldStorer getCorrMatchDataFieldStorer() {
        return this.corrMatchDataFieldStorer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        try {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
        }
        catch (SQLException e) {
            logger.warn((Object)("cleanup connection error. " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (cn != null) {
                --connCount;
                try {
                    cn.close();
                }
                catch (SQLException e) {
                    logger.warn((Object)("cleanup connection error. " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public static void cleanup(Statement stmt, Connection conn) {
        StoreManager.cleanup(null, stmt, conn);
    }
}

