/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.listener.DataChangeObjectValue;
import com.kingdee.bos.workflow.store.listener.IDataProvider;
import java.util.List;
import org.apache.log4j.Logger;

public class StoreUtil {
    private static Logger log = Logger.getLogger((String)StoreUtil.class.getName());

    public static IObjectValue generateTransDataByProcessDefInfo(IDataProvider provider, Context context, String method, Class[] paramTypes, Object[] params, ProcessDefInfo def) {
        String flowName = "";
        String flowPackage = "";
        if (def != null) {
            flowName = def.getMeta().getName(context.getLocale());
            flowPackage = def.getMeta().getPackageName();
        }
        return StoreUtil.generateTransData(provider, method, paramTypes, params, flowName, flowPackage, context.getSolution(), context.getAIS());
    }

    public static IObjectValue generateTransDataByProcessDef(IDataProvider provider, Context context, String method, Class[] paramTypes, Object[] params, ProcessDef def) {
        String flowName = "";
        String flowPackage = "";
        if (def != null) {
            flowName = def.getName(context.getLocale());
            flowPackage = def.getProcessHeader().getPackageName();
        }
        return StoreUtil.generateTransData(provider, method, paramTypes, params, flowName, flowPackage, context.getSolution(), context.getAIS());
    }

    public static IObjectValue generateTransData(IDataProvider provider, String method, Class[] paramTypes, Object[] params, String flowName, String flowPackage, String solution, String ais) {
        DataChangeObjectValue transObj = new DataChangeObjectValue();
        transObj.setProviderName(provider.getClass().getName());
        transObj.setProviderMethodName(method);
        transObj.setProviderMethodParametersType(paramTypes);
        transObj.setProviderMethodParameters(params);
        transObj.setFlowName(flowName);
        transObj.setFlowPackage(flowPackage);
        transObj.setProviderSolution(solution);
        transObj.setProviderAis(ais);
        return transObj;
    }

    public static ProcessDefInfo getProcessDefInfo(List actInsts, Context context) {
        if (null == actInsts || actInsts.size() <= 0) {
            return null;
        }
        ActInstInfo info = (ActInstInfo)actInsts.get(0);
        if (null == info.getProcDefID() || info.getProcDefID().toString().equals("")) {
            return null;
        }
        return StoreUtil.getProcessDefInfoByID(info.getProcDefID().toString(), context);
    }

    public static ProcessDef getProcessDefByActInstID(String actInstId, Context context) {
        if (actInstId == null || actInstId.equals("")) {
            return null;
        }
        ProcessDef def = null;
        try {
            WfActivity act = WfEngine.getEngine(context).getActivityInst(actInstId);
            def = act.container().getDefinition();
        }
        catch (Exception e) {
            log.error((Object)"getProcessDefByActInstID", (Throwable)e);
        }
        return def;
    }

    public static ProcessDefInfo getProcessDefInfoByID(String procdefId, Context context) {
        ProcessDefInfo defInfo = null;
        if (null == procdefId || procdefId.equals("")) {
            return defInfo;
        }
        try {
            ProcessStorer ps = WfEngine.getEngine(context).getStoreManager().getProcessStorer();
            defInfo = ps.getProcessDefInfoLastVersion(procdefId);
        }
        catch (Exception e) {
            log.error((Object)"getProcessDefInfoByID", (Throwable)e);
        }
        return defInfo;
    }

    public static ProcessDef getProcessDefByProcInstId(String procInstId, Context context) {
        ProcessDef def = null;
        try {
            def = WfEngine.getEngine(context).getProcessInst(procInstId).getDefinition();
        }
        catch (WfException e) {
            log.error((Object)"getProcessDefByProcInstId", (Throwable)e);
        }
        return def;
    }

    public static String getProcInstIdByAssign(String assignmentId, Context context) {
        String result = "";
        try {
            result = WfEngine.getEngine(context).getAssignment(assignmentId).getProcInstId();
        }
        catch (Exception e) {
            log.error((Object)"getProcInstIdByAssign", (Throwable)e);
        }
        return result;
    }

    public static IObjectValue generateDaoDataByProcessDef(IDataProvider storer, Context context, String methodName, BOSObjectType processinstbot, Object[] params, ProcessDef processDef) {
        String flowName = "";
        String flowPackage = "";
        if (processDef != null) {
            flowName = processDef.getName(context.getLocale());
            flowPackage = processDef.getProcessHeader().getPackageName();
        }
        DataChangeObjectValue transObj = new DataChangeObjectValue();
        transObj.setFlowName(flowName);
        transObj.setFlowPackage(flowPackage);
        transObj.setProviderName(storer.getClass().getName());
        transObj.setProviderMethodName(methodName);
        transObj.setDirectInvokeDAO(true);
        transObj.setDAOType(processinstbot);
        transObj.setProviderMethodParameters(params);
        transObj.setProviderSolution(context.getSolution());
        transObj.setProviderAis(context.getAIS());
        return transObj;
    }

    public static IObjectValue generateDaoDataByProcDef(IDataProvider storer, Context context, String methodName, BOSObjectType processinstbot, Object[] params, ProcessDefInfo def) {
        String flowName = "";
        String flowPackage = "";
        if (def != null) {
            flowName = def.getMeta().getName(context.getLocale());
            flowPackage = def.getMeta().getPackageName();
        }
        DataChangeObjectValue transObj = new DataChangeObjectValue();
        transObj.setFlowName(flowName);
        transObj.setFlowPackage(flowPackage);
        transObj.setProviderName(storer.getClass().getName());
        transObj.setProviderMethodName(methodName);
        transObj.setDirectInvokeDAO(true);
        transObj.setDAOType(processinstbot);
        transObj.setProviderMethodParameters(params);
        transObj.setProviderSolution(context.getSolution());
        transObj.setProviderAis(context.getAIS());
        return transObj;
    }

    public static IObjectValue generateTransDataByProcessDefAndBOSType(IDataProvider storer, Context context, String methodName, Class[] paramTypes, Object[] params, ProcessDef def, BOSObjectType type) {
        String flowName = "";
        String flowPackage = "";
        if (def != null) {
            flowName = def.getName(context.getLocale());
            flowPackage = def.getProcessHeader().getPackageName();
        }
        DataChangeObjectValue transObj = new DataChangeObjectValue();
        transObj.setFlowName(flowName);
        transObj.setFlowPackage(flowPackage);
        transObj.setProviderName(storer.getClass().getName());
        transObj.setProviderMethodName(methodName);
        transObj.setDirectInvokeDAO(false);
        transObj.setDAOType(type);
        transObj.setProviderMethodParametersType(paramTypes);
        transObj.setProviderMethodParameters(params);
        transObj.setProviderSolution(context.getSolution());
        transObj.setProviderAis(context.getAIS());
        return transObj;
    }
}

